/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.actions;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.requests.NoDiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.testframework.stacktrace.DiffHyperlink;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestDiffRequestProcessor
extends DiffRequestProcessor {
    @NotNull
    private final List<DiffHyperlink> myRequests;
    private int myIndex;

    public TestDiffRequestProcessor(@Nullable Project project, @NotNull List<DiffHyperlink> requests, int index) {
        if (requests == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requests", "com/intellij/execution/testframework/actions/TestDiffRequestProcessor", "<init>"));
        }
        super(project);
        this.myRequests = requests;
        this.myIndex = index;
        this.putContextUserData(DiffUserDataKeys.DO_NOT_IGNORE_WHITESPACES, true);
        this.putContextUserData(DiffUserDataKeysEx.PLACE, "TestsFiledAssertions");
    }

    @Override
    public void updateRequest(boolean force, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
        this.applyRequest(this.loadRequest(), force, scrollToChangePolicy);
    }

    @NotNull
    private DiffRequest loadRequest() {
        SimpleDiffRequest simpleDiffRequest;
        block7: {
            if (this.myIndex < 0 || this.myIndex >= this.myRequests.size()) {
                NoDiffRequest noDiffRequest = NoDiffRequest.INSTANCE;
                if (noDiffRequest == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/actions/TestDiffRequestProcessor", "loadRequest"));
                }
                return noDiffRequest;
            }
            DiffHyperlink hyperlink = this.myRequests.get(this.myIndex);
            try {
                DocumentContent content1;
                String title1;
                VirtualFile vFile;
                String title = hyperlink.getDiffTitle();
                String title2 = ExecutionBundle.message((String)"diff.content.actual.title", (Object[])new Object[0]);
                DocumentContent content2 = DiffContentFactory.getInstance().create(hyperlink.getRight(), null);
                String filePath = hyperlink.getFilePath();
                if (filePath != null && (vFile = LocalFileSystem.getInstance().findFileByPath(filePath)) != null) {
                    title1 = ExecutionBundle.message((String)"diff.content.expected.title", (Object[])new Object[0]) + " (" + vFile.getPresentableUrl() + ")";
                    content1 = DiffContentFactory.getInstance().create(this.getProject(), vFile);
                } else {
                    title1 = ExecutionBundle.message((String)"diff.content.expected.title", (Object[])new Object[0]);
                    content1 = DiffContentFactory.getInstance().create(hyperlink.getLeft(), null);
                }
                if ((simpleDiffRequest = new SimpleDiffRequest(title, (DiffContent)content1, (DiffContent)content2, title1, title2)) != null) break block7;
            }
            catch (Exception e) {
                ErrorDiffRequest errorDiffRequest = new ErrorDiffRequest((Throwable)e);
                if (errorDiffRequest == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/actions/TestDiffRequestProcessor", "loadRequest"));
                }
                return errorDiffRequest;
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/actions/TestDiffRequestProcessor", "loadRequest"));
        }
        return simpleDiffRequest;
    }

    @Override
    protected boolean hasNextChange() {
        return true;
    }

    @Override
    protected boolean hasPrevChange() {
        return true;
    }

    @Override
    protected void goToNextChange(boolean fromDifferences) {
        ++this.myIndex;
        if (this.myIndex >= this.myRequests.size()) {
            this.myIndex = 0;
        }
        this.updateRequest(false, fromDifferences ? DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE : null);
    }

    @Override
    protected void goToPrevChange(boolean fromDifferences) {
        --this.myIndex;
        if (this.myIndex < 0) {
            this.myIndex = this.myRequests.size() - 1;
        }
        this.updateRequest(false, fromDifferences ? DiffUserDataKeysEx.ScrollToPolicy.LAST_CHANGE : null);
    }

    @Override
    protected boolean isNavigationEnabled() {
        return this.myRequests.size() > 1;
    }
}

