/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.states;

import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.states.TestInProgressState;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class SuiteInProgressState
extends TestInProgressState {
    private final SMTestProxy mySuiteProxy;
    private boolean myDefectFound;

    public SuiteInProgressState(@NotNull SMTestProxy suiteProxy) {
        if (suiteProxy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suiteProxy", "com/intellij/execution/testframework/sm/runner/states/SuiteInProgressState", "<init>"));
        }
        this.myDefectFound = false;
        this.mySuiteProxy = suiteProxy;
    }

    @Override
    public boolean isDefect() {
        if (this.myDefectFound) {
            return true;
        }
        ArrayList<? extends SMTestProxy> children = new ArrayList<SMTestProxy>(this.mySuiteProxy.getChildren());
        for (SMTestProxy sMTestProxy : children) {
            if (!sMTestProxy.isDefect()) continue;
            this.myDefectFound = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean wasTerminated() {
        return false;
    }

    @Override
    public TestStateInfo.Magnitude getMagnitude() {
        return TestStateInfo.Magnitude.RUNNING_INDEX;
    }

    @Override
    public String toString() {
        return "SUITE PROGRESS";
    }
}

