/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.stacktrace;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.actions.ViewAssertEqualsDiffAction;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.diff.DiffToolbar;
import com.intellij.openapi.diff.DiffViewer;
import com.intellij.openapi.diff.SimpleContent;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffHyperlink
implements Printable {
    private static final String NEW_LINE = "\n";
    private static final Logger LOG = Logger.getInstance((String)("#" + DiffHyperlink.class.getName()));
    protected final String myExpected;
    protected final String myActual;
    protected final String myFilePath;
    private boolean myPrintOneLine;
    private final HyperlinkInfo myDiffHyperlink = new DiffHyperlinkInfo();

    public DiffHyperlink(String expected, String actual, String filePath) {
        this(expected, actual, filePath, true);
    }

    public DiffHyperlink(String expected, String actual, String filePath, boolean printOneLine) {
        this.myExpected = expected;
        this.myActual = actual;
        this.myFilePath = filePath == null ? null : filePath.replace(File.separatorChar, '/');
        this.myPrintOneLine = printOneLine;
    }

    public void openDiff(Project project) {
        this.openMultiDiff(project, null);
    }

    public void openMultiDiff(Project project, AbstractTestProxy.AssertEqualsDiffChain chain) {
        SimpleDiffRequest diffData = this.createRequest(project, chain, this.myFilePath, this.myExpected, this.myActual);
        DiffManager.getInstance().getIdeaDiffTool().show((DiffRequest)diffData);
    }

    private SimpleDiffRequest createRequest(Project project, final AbstractTestProxy.AssertEqualsDiffChain chain, String filePath, String expected, String actual) {
        SimpleContent expectedContent;
        VirtualFile vFile;
        String expectedTitle = ExecutionBundle.message((String)"diff.content.expected.title", (Object[])new Object[0]);
        if (filePath != null && (vFile = LocalFileSystem.getInstance().findFileByPath(filePath)) != null) {
            expectedContent = DiffContent.fromFile((Project)project, (VirtualFile)vFile);
            expectedTitle = expectedTitle + " (" + vFile.getPresentableUrl() + ")";
        } else {
            expectedContent = new SimpleContent(expected);
        }
        SimpleDiffRequest diffData = new SimpleDiffRequest(project, this.getTitle());
        if (chain != null) {
            diffData.setToolbarAddons(new DiffRequest.ToolbarAddons(){

                public void customize(DiffToolbar toolbar) {
                    toolbar.addAction((AnAction)new NextPrevAction("Compare Previous Failure", AllIcons.Actions.Prevfile, chain){
                        {
                            this.registerCustomShortcutSet(ActionManager.getInstance().getAction("PreviousTab").getShortcutSet(), null);
                        }

                        @Override
                        protected DiffHyperlink getNextId() {
                            return chain.getPrevious();
                        }
                    });
                    toolbar.addAction((AnAction)new NextPrevAction("Compare Next Failure", AllIcons.Actions.Nextfile, chain){
                        {
                            this.registerCustomShortcutSet(ActionManager.getInstance().getAction("NextTab").getShortcutSet(), null);
                        }

                        @Override
                        protected DiffHyperlink getNextId() {
                            return chain.getNext();
                        }
                    });
                }
            });
        }
        diffData.setContents((DiffContent)expectedContent, (DiffContent)new SimpleContent(actual));
        diffData.setContentTitles(expectedTitle, ExecutionBundle.message((String)"diff.content.actual.title", (Object[])new Object[0]));
        diffData.addHint(DiffTool.HINT_SHOW_FRAME);
        diffData.addHint(DiffTool.HINT_DO_NOT_IGNORE_WHITESPACES);
        diffData.setGroupKey("#com.intellij.execution.junit2.states.ComparisonFailureState$DiffDialog");
        return diffData;
    }

    protected String getTitle() {
        return ExecutionBundle.message((String)"strings.equal.failed.dialog.title", (Object[])new Object[0]);
    }

    public String getDiffTitle() {
        return this.getTitle();
    }

    public String getLeft() {
        return this.myExpected;
    }

    public String getRight() {
        return this.myActual;
    }

    public String getFilePath() {
        return this.myFilePath;
    }

    @Override
    public void printOn(Printer printer) {
        if (!DiffHyperlink.hasMoreThanOneLine(this.myActual) && !DiffHyperlink.hasMoreThanOneLine(this.myExpected) && this.myPrintOneLine) {
            printer.print(NEW_LINE, ConsoleViewContentType.ERROR_OUTPUT);
            printer.print(ExecutionBundle.message((String)"diff.content.expected.for.file.title", (Object[])new Object[0]), ConsoleViewContentType.SYSTEM_OUTPUT);
            printer.print(this.myExpected + NEW_LINE, ConsoleViewContentType.ERROR_OUTPUT);
            printer.print(ExecutionBundle.message((String)"junit.actual.text.label", (Object[])new Object[0]), ConsoleViewContentType.SYSTEM_OUTPUT);
            printer.print(this.myActual + NEW_LINE, ConsoleViewContentType.ERROR_OUTPUT);
        }
        printer.print(" ", ConsoleViewContentType.ERROR_OUTPUT);
        printer.printHyperlink(ExecutionBundle.message((String)"junit.click.to.see.diff.link", (Object[])new Object[0]), this.myDiffHyperlink);
        printer.print(NEW_LINE, ConsoleViewContentType.ERROR_OUTPUT);
    }

    private static boolean hasMoreThanOneLine(String string) {
        return string.indexOf(10) != -1 || string.indexOf(13) != -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DiffHyperlink)) {
            return false;
        }
        DiffHyperlink hyperlink = (DiffHyperlink)o;
        if (this.myActual != null ? !this.myActual.equals(hyperlink.myActual) : hyperlink.myActual != null) {
            return false;
        }
        if (this.myExpected != null ? !this.myExpected.equals(hyperlink.myExpected) : hyperlink.myExpected != null) {
            return false;
        }
        return !(this.myFilePath != null ? !this.myFilePath.equals(hyperlink.myFilePath) : hyperlink.myFilePath != null);
    }

    public int hashCode() {
        int result = this.myExpected != null ? this.myExpected.hashCode() : 0;
        result = 31 * result + (this.myActual != null ? this.myActual.hashCode() : 0);
        result = 31 * result + (this.myFilePath != null ? this.myFilePath.hashCode() : 0);
        return result;
    }

    public class DiffHyperlinkInfo
    implements HyperlinkInfo {
        public void navigate(Project project) {
            ViewAssertEqualsDiffAction.openDiff(DataManager.getInstance().getDataContext(), DiffHyperlink.this);
        }

        public DiffHyperlink getPrintable() {
            return DiffHyperlink.this;
        }
    }

    abstract class NextPrevAction
    extends AnAction {
        private final AbstractTestProxy.AssertEqualsDiffChain myChain;

        public NextPrevAction(@Nullable String text, Icon icon, AbstractTestProxy.AssertEqualsDiffChain chain) {
            super(text, text, icon);
            this.myChain = chain;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/testframework/stacktrace/DiffHyperlink$NextPrevAction", "actionPerformed"));
            }
            DiffViewer viewer = (DiffViewer)e.getData(PlatformDataKeys.DIFF_VIEWER);
            LOG.assertTrue(viewer != null);
            Project project = (Project)e.getData(CommonDataKeys.PROJECT);
            DiffHyperlink nextProvider = this.getNextId();
            this.myChain.setCurrent(nextProvider);
            SimpleDiffRequest nextRequest = DiffHyperlink.this.createRequest(project, this.myChain, nextProvider.getFilePath(), nextProvider.getLeft(), nextProvider.getRight());
            viewer.setDiffRequest((DiffRequest)nextRequest);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/testframework/stacktrace/DiffHyperlink$NextPrevAction", "update"));
            }
            DiffViewer viewer = (DiffViewer)e.getData(PlatformDataKeys.DIFF_VIEWER);
            Project project = (Project)e.getData(CommonDataKeys.PROJECT);
            e.getPresentation().setEnabled(project != null && viewer != null);
        }

        protected abstract DiffHyperlink getNextId();
    }
}

