/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.LafComboBoxRenderer;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.laf.darcula.DarculaInstaller;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppearanceConfigurable
extends BaseConfigurable
implements SearchableConfigurable {
    private MyComponent myComponent = new MyComponent();

    public String getDisplayName() {
        return IdeBundle.message((String)"title.appearance", (Object[])new Object[0]);
    }

    private void initComponent() {
        if (this.myComponent == null) {
            this.myComponent = new MyComponent();
        }
    }

    public JComponent createComponent() {
        this.initComponent();
        DefaultComboBoxModel<String> aModel = new DefaultComboBoxModel<String>(UIUtil.getValidFontNames((boolean)Registry.is((String)"ide.settings.appearance.font.family.only")));
        this.myComponent.myFontCombo.setModel(aModel);
        this.myComponent.myFontSizeCombo.setModel(new DefaultComboBoxModel<String>(UIUtil.getStandardFontSizes()));
        this.myComponent.myPresentationModeFontSize.setModel(new DefaultComboBoxModel<String>(UIUtil.getStandardFontSizes()));
        this.myComponent.myFontSizeCombo.setEditable(true);
        this.myComponent.myPresentationModeFontSize.setEditable(true);
        this.myComponent.myLafComboBox.setModel(new DefaultComboBoxModel<UIManager.LookAndFeelInfo>(LafManager.getInstance().getInstalledLookAndFeels()));
        this.myComponent.myLafComboBox.setRenderer(new LafComboBoxRenderer());
        Hashtable<Integer, JLabel> delayDictionary = new Hashtable<Integer, JLabel>();
        ((Dictionary)delayDictionary).put(new Integer(0), new JLabel("0"));
        ((Dictionary)delayDictionary).put(new Integer(1200), new JLabel("1200"));
        this.myComponent.myInitialTooltipDelaySlider.setLabelTable(delayDictionary);
        UIUtil.setSliderIsFilled((JSlider)this.myComponent.myInitialTooltipDelaySlider, (boolean)Boolean.TRUE);
        this.myComponent.myInitialTooltipDelaySlider.setMinimum(0);
        this.myComponent.myInitialTooltipDelaySlider.setMaximum(1200);
        this.myComponent.myInitialTooltipDelaySlider.setPaintLabels(true);
        this.myComponent.myInitialTooltipDelaySlider.setPaintTicks(true);
        this.myComponent.myInitialTooltipDelaySlider.setPaintTrack(true);
        this.myComponent.myInitialTooltipDelaySlider.setMajorTickSpacing(1200);
        this.myComponent.myInitialTooltipDelaySlider.setMinorTickSpacing(100);
        this.myComponent.myEnableAlphaModeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean state = AppearanceConfigurable.this.myComponent.myEnableAlphaModeCheckBox.isSelected();
                AppearanceConfigurable.this.myComponent.myAlphaModeDelayTextField.setEnabled(state);
                AppearanceConfigurable.this.myComponent.myAlphaModeRatioSlider.setEnabled(state);
            }
        });
        this.myComponent.myAlphaModeRatioSlider.setSize(100, 50);
        Hashtable<Integer, JLabel> dictionary = new Hashtable<Integer, JLabel>();
        ((Dictionary)dictionary).put(new Integer(0), new JLabel("0%"));
        ((Dictionary)dictionary).put(new Integer(50), new JLabel("50%"));
        ((Dictionary)dictionary).put(new Integer(100), new JLabel("100%"));
        this.myComponent.myAlphaModeRatioSlider.setLabelTable(dictionary);
        UIUtil.setSliderIsFilled((JSlider)this.myComponent.myAlphaModeRatioSlider, (boolean)Boolean.TRUE);
        this.myComponent.myAlphaModeRatioSlider.setPaintLabels(true);
        this.myComponent.myAlphaModeRatioSlider.setPaintTicks(true);
        this.myComponent.myAlphaModeRatioSlider.setPaintTrack(true);
        this.myComponent.myAlphaModeRatioSlider.setMajorTickSpacing(50);
        this.myComponent.myAlphaModeRatioSlider.setMinorTickSpacing(10);
        this.myComponent.myAlphaModeRatioSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AppearanceConfigurable.this.myComponent.myAlphaModeRatioSlider.setToolTipText(AppearanceConfigurable.this.myComponent.myAlphaModeRatioSlider.getValue() + "%");
            }
        });
        this.myComponent.myTransparencyPanel.setVisible(WindowManagerEx.getInstanceEx().isAlphaModeSupported());
        return this.myComponent.myPanel;
    }

    public void apply() {
        int tooltipDelay;
        UIManager.LookAndFeelInfo lafInfo;
        this.initComponent();
        UISettings settings = UISettings.getInstance();
        int _fontSize = AppearanceConfigurable.getIntValue(this.myComponent.myFontSizeCombo, settings.FONT_SIZE);
        int _presentationFontSize = AppearanceConfigurable.getIntValue((JComboBox)this.myComponent.myPresentationModeFontSize, settings.PRESENTATION_MODE_FONT_SIZE);
        boolean shouldUpdateUI = false;
        String _fontFace = (String)this.myComponent.myFontCombo.getSelectedItem();
        LafManager lafManager = LafManager.getInstance();
        if (_fontSize != settings.FONT_SIZE || !settings.FONT_FACE.equals(_fontFace)) {
            settings.FONT_SIZE = _fontSize;
            settings.FONT_FACE = _fontFace;
            shouldUpdateUI = true;
        }
        if (_presentationFontSize != settings.PRESENTATION_MODE_FONT_SIZE) {
            settings.PRESENTATION_MODE_FONT_SIZE = _presentationFontSize;
            shouldUpdateUI = true;
        }
        settings.ANIMATE_WINDOWS = this.myComponent.myAnimateWindowsCheckBox.isSelected();
        boolean update = settings.SHOW_TOOL_WINDOW_NUMBERS != this.myComponent.myWindowShortcutsCheckBox.isSelected();
        settings.SHOW_TOOL_WINDOW_NUMBERS = this.myComponent.myWindowShortcutsCheckBox.isSelected();
        update |= settings.HIDE_TOOL_STRIPES != !this.myComponent.myShowToolStripesCheckBox.isSelected();
        settings.HIDE_TOOL_STRIPES = !this.myComponent.myShowToolStripesCheckBox.isSelected();
        update |= settings.SHOW_ICONS_IN_MENUS != this.myComponent.myCbDisplayIconsInMenu.isSelected();
        settings.SHOW_ICONS_IN_MENUS = this.myComponent.myCbDisplayIconsInMenu.isSelected();
        update |= settings.SHOW_MEMORY_INDICATOR != this.myComponent.myShowMemoryIndicatorCheckBox.isSelected();
        settings.SHOW_MEMORY_INDICATOR = this.myComponent.myShowMemoryIndicatorCheckBox.isSelected();
        update |= settings.ALLOW_MERGE_BUTTONS != this.myComponent.myAllowMergeButtons.isSelected();
        settings.ALLOW_MERGE_BUTTONS = this.myComponent.myAllowMergeButtons.isSelected();
        update |= settings.CYCLE_SCROLLING != this.myComponent.myCycleScrollingCheckBox.isSelected();
        settings.CYCLE_SCROLLING = this.myComponent.myCycleScrollingCheckBox.isSelected();
        if (settings.OVERRIDE_NONIDEA_LAF_FONTS != this.myComponent.myOverrideLAFFonts.isSelected()) {
            shouldUpdateUI = true;
        }
        settings.OVERRIDE_NONIDEA_LAF_FONTS = this.myComponent.myOverrideLAFFonts.isSelected();
        settings.MOVE_MOUSE_ON_DEFAULT_BUTTON = this.myComponent.myMoveMouseOnDefaultButtonCheckBox.isSelected();
        settings.HIDE_NAVIGATION_ON_FOCUS_LOSS = this.myComponent.myHideNavigationPopupsCheckBox.isSelected();
        settings.DND_WITH_PRESSED_ALT_ONLY = this.myComponent.myAltDNDCheckBox.isSelected();
        update |= settings.DISABLE_MNEMONICS != this.myComponent.myDisableMnemonics.isSelected();
        settings.DISABLE_MNEMONICS = this.myComponent.myDisableMnemonics.isSelected();
        update |= settings.USE_SMALL_LABELS_ON_TABS != this.myComponent.myUseSmallLabelsOnTabs.isSelected();
        settings.USE_SMALL_LABELS_ON_TABS = this.myComponent.myUseSmallLabelsOnTabs.isSelected();
        update |= settings.WIDESCREEN_SUPPORT != this.myComponent.myWidescreenLayoutCheckBox.isSelected();
        settings.WIDESCREEN_SUPPORT = this.myComponent.myWidescreenLayoutCheckBox.isSelected();
        update |= settings.LEFT_HORIZONTAL_SPLIT != this.myComponent.myLeftLayoutCheckBox.isSelected();
        settings.LEFT_HORIZONTAL_SPLIT = this.myComponent.myLeftLayoutCheckBox.isSelected();
        update |= settings.RIGHT_HORIZONTAL_SPLIT != this.myComponent.myRightLayoutCheckBox.isSelected();
        settings.RIGHT_HORIZONTAL_SPLIT = this.myComponent.myRightLayoutCheckBox.isSelected();
        update |= settings.NAVIGATE_TO_PREVIEW != (this.myComponent.myNavigateToPreviewCheckBox.isVisible() && this.myComponent.myNavigateToPreviewCheckBox.isSelected());
        settings.NAVIGATE_TO_PREVIEW = this.myComponent.myNavigateToPreviewCheckBox.isSelected();
        update |= settings.DISABLE_MNEMONICS_IN_CONTROLS != this.myComponent.myDisableMnemonicInControlsCheckBox.isSelected();
        settings.DISABLE_MNEMONICS_IN_CONTROLS = this.myComponent.myDisableMnemonicInControlsCheckBox.isSelected();
        update |= settings.SHOW_ICONS_IN_QUICK_NAVIGATION != this.myComponent.myHideIconsInQuickNavigation.isSelected();
        settings.SHOW_ICONS_IN_QUICK_NAVIGATION = this.myComponent.myHideIconsInQuickNavigation.isSelected();
        if (!Comparing.equal((Object)this.myComponent.myLafComboBox.getSelectedItem(), (Object)lafManager.getCurrentLookAndFeel()) && lafManager.checkLookAndFeel(lafInfo = (UIManager.LookAndFeelInfo)this.myComponent.myLafComboBox.getSelectedItem())) {
            shouldUpdateUI = true;
            update = true;
            final boolean wasDarcula = UIUtil.isUnderDarcula();
            lafManager.setCurrentLookAndFeel(lafInfo);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (UIUtil.isUnderDarcula()) {
                        DarculaInstaller.install();
                    } else if (wasDarcula) {
                        DarculaInstaller.uninstall();
                    }
                }
            });
        }
        if (shouldUpdateUI) {
            lafManager.updateUI();
        }
        if (WindowManagerEx.getInstanceEx().isAlphaModeSupported()) {
            int delay = -1;
            try {
                delay = Integer.parseInt(this.myComponent.myAlphaModeDelayTextField.getText());
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
            float ratio = (float)this.myComponent.myAlphaModeRatioSlider.getValue() / 100.0f;
            if (this.myComponent.myEnableAlphaModeCheckBox.isSelected() != settings.ENABLE_ALPHA_MODE || delay != -1 && delay != settings.ALPHA_MODE_DELAY || ratio != settings.ALPHA_MODE_RATIO) {
                update = true;
                settings.ENABLE_ALPHA_MODE = this.myComponent.myEnableAlphaModeCheckBox.isSelected();
                settings.ALPHA_MODE_DELAY = delay;
                settings.ALPHA_MODE_RATIO = ratio;
            }
        }
        if ((tooltipDelay = Math.min(this.myComponent.myInitialTooltipDelaySlider.getValue(), 5000)) != Registry.intValue((String)"ide.tooltip.initialDelay")) {
            update = true;
            Registry.get((String)"ide.tooltip.initialDelay").setValue(tooltipDelay);
        }
        if (update) {
            settings.fireUISettingsChanged();
        }
        this.myComponent.updateCombo();
        EditorUtil.reinitSettings();
    }

    private static int getIntValue(JComboBox combo, int defaultValue) {
        String temp = (String)combo.getEditor().getItem();
        int value = -1;
        if (temp != null && temp.trim().length() > 0) {
            try {
                value = Integer.parseInt(temp);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
            if (value <= 0) {
                value = defaultValue;
            }
        } else {
            value = defaultValue;
        }
        return value;
    }

    public void reset() {
        this.initComponent();
        UISettings settings = UISettings.getInstance();
        this.myComponent.myFontCombo.setSelectedItem(settings.FONT_FACE);
        this.myComponent.myFontSizeCombo.setSelectedItem(Integer.toString(settings.FONT_SIZE));
        this.myComponent.myPresentationModeFontSize.setSelectedItem((Object)Integer.toString(settings.PRESENTATION_MODE_FONT_SIZE));
        this.myComponent.myAnimateWindowsCheckBox.setSelected(settings.ANIMATE_WINDOWS);
        this.myComponent.myWindowShortcutsCheckBox.setSelected(settings.SHOW_TOOL_WINDOW_NUMBERS);
        this.myComponent.myShowToolStripesCheckBox.setSelected(!settings.HIDE_TOOL_STRIPES);
        this.myComponent.myCbDisplayIconsInMenu.setSelected(settings.SHOW_ICONS_IN_MENUS);
        this.myComponent.myShowMemoryIndicatorCheckBox.setSelected(settings.SHOW_MEMORY_INDICATOR);
        this.myComponent.myAllowMergeButtons.setSelected(settings.ALLOW_MERGE_BUTTONS);
        this.myComponent.myCycleScrollingCheckBox.setSelected(settings.CYCLE_SCROLLING);
        this.myComponent.myHideIconsInQuickNavigation.setSelected(settings.SHOW_ICONS_IN_QUICK_NAVIGATION);
        this.myComponent.myMoveMouseOnDefaultButtonCheckBox.setSelected(settings.MOVE_MOUSE_ON_DEFAULT_BUTTON);
        this.myComponent.myHideNavigationPopupsCheckBox.setSelected(settings.HIDE_NAVIGATION_ON_FOCUS_LOSS);
        this.myComponent.myAltDNDCheckBox.setSelected(settings.DND_WITH_PRESSED_ALT_ONLY);
        this.myComponent.myLafComboBox.setSelectedItem(LafManager.getInstance().getCurrentLookAndFeel());
        this.myComponent.myOverrideLAFFonts.setSelected(settings.OVERRIDE_NONIDEA_LAF_FONTS);
        this.myComponent.myDisableMnemonics.setSelected(settings.DISABLE_MNEMONICS);
        this.myComponent.myUseSmallLabelsOnTabs.setSelected(settings.USE_SMALL_LABELS_ON_TABS);
        this.myComponent.myWidescreenLayoutCheckBox.setSelected(settings.WIDESCREEN_SUPPORT);
        this.myComponent.myLeftLayoutCheckBox.setSelected(settings.LEFT_HORIZONTAL_SPLIT);
        this.myComponent.myRightLayoutCheckBox.setSelected(settings.RIGHT_HORIZONTAL_SPLIT);
        this.myComponent.myNavigateToPreviewCheckBox.setSelected(settings.NAVIGATE_TO_PREVIEW);
        this.myComponent.myNavigateToPreviewCheckBox.setVisible(false);
        this.myComponent.myDisableMnemonicInControlsCheckBox.setSelected(settings.DISABLE_MNEMONICS_IN_CONTROLS);
        boolean alphaModeEnabled = WindowManagerEx.getInstanceEx().isAlphaModeSupported();
        if (alphaModeEnabled) {
            this.myComponent.myEnableAlphaModeCheckBox.setSelected(settings.ENABLE_ALPHA_MODE);
        } else {
            this.myComponent.myEnableAlphaModeCheckBox.setSelected(false);
        }
        this.myComponent.myEnableAlphaModeCheckBox.setEnabled(alphaModeEnabled);
        this.myComponent.myAlphaModeDelayTextField.setText(Integer.toString(settings.ALPHA_MODE_DELAY));
        this.myComponent.myAlphaModeDelayTextField.setEnabled(alphaModeEnabled && settings.ENABLE_ALPHA_MODE);
        int ratio = (int)(settings.ALPHA_MODE_RATIO * 100.0f);
        this.myComponent.myAlphaModeRatioSlider.setValue(ratio);
        this.myComponent.myAlphaModeRatioSlider.setToolTipText(ratio + "%");
        this.myComponent.myAlphaModeRatioSlider.setEnabled(alphaModeEnabled && settings.ENABLE_ALPHA_MODE);
        this.myComponent.myInitialTooltipDelaySlider.setValue(Registry.intValue((String)"ide.tooltip.initialDelay"));
        this.myComponent.updateCombo();
    }

    public boolean isModified() {
        this.initComponent();
        UISettings settings = UISettings.getInstance();
        boolean isModified = false;
        isModified |= !Comparing.equal((Object)this.myComponent.myFontCombo.getSelectedItem(), (Object)settings.FONT_FACE);
        isModified |= !Comparing.equal((Object)this.myComponent.myFontSizeCombo.getEditor().getItem(), (Object)Integer.toString(settings.FONT_SIZE));
        isModified |= this.myComponent.myAnimateWindowsCheckBox.isSelected() != settings.ANIMATE_WINDOWS;
        isModified |= this.myComponent.myWindowShortcutsCheckBox.isSelected() != settings.SHOW_TOOL_WINDOW_NUMBERS;
        isModified |= this.myComponent.myShowToolStripesCheckBox.isSelected() == settings.HIDE_TOOL_STRIPES;
        isModified |= this.myComponent.myCbDisplayIconsInMenu.isSelected() != settings.SHOW_ICONS_IN_MENUS;
        isModified |= this.myComponent.myShowMemoryIndicatorCheckBox.isSelected() != settings.SHOW_MEMORY_INDICATOR;
        isModified |= this.myComponent.myAllowMergeButtons.isSelected() != settings.ALLOW_MERGE_BUTTONS;
        isModified |= this.myComponent.myCycleScrollingCheckBox.isSelected() != settings.CYCLE_SCROLLING;
        isModified |= this.myComponent.myOverrideLAFFonts.isSelected() != settings.OVERRIDE_NONIDEA_LAF_FONTS;
        isModified |= this.myComponent.myDisableMnemonics.isSelected() != settings.DISABLE_MNEMONICS;
        isModified |= this.myComponent.myDisableMnemonicInControlsCheckBox.isSelected() != settings.DISABLE_MNEMONICS_IN_CONTROLS;
        isModified |= this.myComponent.myUseSmallLabelsOnTabs.isSelected() != settings.USE_SMALL_LABELS_ON_TABS;
        isModified |= this.myComponent.myWidescreenLayoutCheckBox.isSelected() != settings.WIDESCREEN_SUPPORT;
        isModified |= this.myComponent.myLeftLayoutCheckBox.isSelected() != settings.LEFT_HORIZONTAL_SPLIT;
        isModified |= this.myComponent.myRightLayoutCheckBox.isSelected() != settings.RIGHT_HORIZONTAL_SPLIT;
        isModified |= this.myComponent.myNavigateToPreviewCheckBox.isSelected() != settings.NAVIGATE_TO_PREVIEW;
        isModified |= this.myComponent.myHideIconsInQuickNavigation.isSelected() != settings.SHOW_ICONS_IN_QUICK_NAVIGATION;
        isModified |= !Comparing.equal((Object)this.myComponent.myPresentationModeFontSize.getEditor().getItem(), (Object)Integer.toString(settings.PRESENTATION_MODE_FONT_SIZE));
        isModified |= this.myComponent.myMoveMouseOnDefaultButtonCheckBox.isSelected() != settings.MOVE_MOUSE_ON_DEFAULT_BUTTON;
        isModified |= this.myComponent.myHideNavigationPopupsCheckBox.isSelected() != settings.HIDE_NAVIGATION_ON_FOCUS_LOSS;
        isModified |= this.myComponent.myAltDNDCheckBox.isSelected() != settings.DND_WITH_PRESSED_ALT_ONLY;
        isModified |= !Comparing.equal((Object)this.myComponent.myLafComboBox.getSelectedItem(), (Object)LafManager.getInstance().getCurrentLookAndFeel());
        if (WindowManagerEx.getInstanceEx().isAlphaModeSupported()) {
            float ratio;
            isModified |= this.myComponent.myEnableAlphaModeCheckBox.isSelected() != settings.ENABLE_ALPHA_MODE;
            int delay = -1;
            try {
                delay = Integer.parseInt(this.myComponent.myAlphaModeDelayTextField.getText());
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
            if (delay != -1) {
                isModified |= delay != settings.ALPHA_MODE_DELAY;
            }
            isModified |= (ratio = (float)this.myComponent.myAlphaModeRatioSlider.getValue() / 100.0f) != settings.ALPHA_MODE_RATIO;
        }
        int tooltipDelay = -1;
        tooltipDelay = this.myComponent.myInitialTooltipDelaySlider.getValue();
        return isModified |= tooltipDelay != Registry.intValue((String)"ide.tooltip.initialDelay");
    }

    public void disposeUIResources() {
        this.myComponent = null;
    }

    public String getHelpTopic() {
        return "preferences.lookFeel";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/AppearanceConfigurable", "getId"));
        }
        return string;
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    private static class MyComponent {
        private JPanel myPanel;
        private JComboBox myFontCombo;
        private JComboBox myFontSizeCombo;
        private JCheckBox myAnimateWindowsCheckBox;
        private JCheckBox myWindowShortcutsCheckBox;
        private JCheckBox myShowToolStripesCheckBox;
        private JCheckBox myShowMemoryIndicatorCheckBox;
        private JComboBox myLafComboBox;
        private JCheckBox myCycleScrollingCheckBox;
        private JCheckBox myMoveMouseOnDefaultButtonCheckBox;
        private JCheckBox myEnableAlphaModeCheckBox;
        private JTextField myAlphaModeDelayTextField;
        private JSlider myAlphaModeRatioSlider;
        private JLabel myFontSizeLabel;
        private JLabel myFontNameLabel;
        private JPanel myTransparencyPanel;
        private JCheckBox myOverrideLAFFonts;
        private JCheckBox myHideIconsInQuickNavigation;
        private JCheckBox myCbDisplayIconsInMenu;
        private JCheckBox myDisableMnemonics;
        private JCheckBox myDisableMnemonicInControlsCheckBox;
        private JCheckBox myHideNavigationPopupsCheckBox;
        private JCheckBox myAltDNDCheckBox;
        private JCheckBox myAllowMergeButtons;
        private JBCheckBox myUseSmallLabelsOnTabs;
        private JBCheckBox myWidescreenLayoutCheckBox;
        private JCheckBox myLeftLayoutCheckBox;
        private JCheckBox myRightLayoutCheckBox;
        private JSlider myInitialTooltipDelaySlider;
        private ComboBox myPresentationModeFontSize;
        private JCheckBox myNavigateToPreviewCheckBox;
        private JCheckBox myAllowStatusBar;
        private JCheckBox myAllowLineNumbers;
        private JCheckBox myAllowAnnotations;

        public MyComponent() {
            this.$$$setupUI$$$();
            this.myOverrideLAFFonts.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MyComponent.this.updateCombo();
                }
            });
            if (!Registry.is((String)"ide.transparency.mode.for.windows")) {
                this.myTransparencyPanel.getParent().remove(this.myTransparencyPanel);
            }
        }

        public void updateCombo() {
            boolean enableChooser = this.myOverrideLAFFonts.isSelected();
            this.myFontCombo.setEnabled(enableChooser);
            this.myFontSizeCombo.setEnabled(enableChooser);
            this.myFontNameLabel.setEnabled(enableChooser);
            this.myFontSizeLabel.setEnabled(enableChooser);
        }

        private void createUIComponents() {
            this.myFontSizeCombo = new ComboBox();
            this.myPresentationModeFontSize = new ComboBox();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JCheckBox jCheckBox2;
            JCheckBox jCheckBox3;
            JBCheckBox jBCheckBox;
            JBCheckBox jBCheckBox2;
            JCheckBox jCheckBox4;
            JCheckBox jCheckBox5;
            JCheckBox jCheckBox6;
            JCheckBox jCheckBox7;
            JCheckBox jCheckBox8;
            JCheckBox jCheckBox9;
            JCheckBox jCheckBox10;
            JCheckBox jCheckBox11;
            JTextField jTextField;
            JSlider jSlider;
            JCheckBox jCheckBox12;
            JPanel jPanel;
            JCheckBox jCheckBox13;
            JSlider jSlider2;
            JCheckBox jCheckBox14;
            JCheckBox jCheckBox15;
            JCheckBox jCheckBox16;
            JLabel jLabel;
            JLabel jLabel2;
            JComboBox jComboBox;
            JComboBox jComboBox2;
            JCheckBox jCheckBox17;
            JCheckBox jCheckBox18;
            JPanel jPanel2;
            this.createUIComponents();
            this.myPanel = jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 3, null, null, null));
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout((LayoutManager)new GridLayoutManager(9, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 1, 3, 3, 3, null, null, null));
            jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/IdeBundle").getString("group.ui.options"), (int)0, (int)0, null, null));
            this.myMoveMouseOnDefaultButtonCheckBox = jCheckBox18 = new JCheckBox();
            jCheckBox18.setMargin(new Insets(2, 0, 2, 2));
            this.$$$loadButtonText$$$(jCheckBox18, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.position.cursor.on.default.button"));
            jPanel4.add((Component)jCheckBox18, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myCycleScrollingCheckBox = jCheckBox17 = new JCheckBox();
            jCheckBox17.setMargin(new Insets(2, 0, 2, 2));
            this.$$$loadButtonText$$$(jCheckBox17, ResourceBundle.getBundle("messages/IdeBundle").getString("checkboox.cyclic.scrolling.in.lists"));
            jCheckBox17.setSelected(true);
            jPanel4.add((Component)jCheckBox17, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 8, 2, 3, 3, null, null, null));
            JLabel jLabel3 = new JLabel();
            jLabel3.setHorizontalTextPosition(2);
            this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/IdeBundle").getString("combobox.look.and.feel"));
            jLabel3.setHorizontalAlignment(2);
            jLabel3.setVerifyInputWhenFocusTarget(false);
            jPanel5.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myLafComboBox = jComboBox2 = new JComboBox();
            jPanel5.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 8, 1, 7, 0, null, null, null));
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel4.add((Component)jPanel6, new GridConstraints(2, 0, 1, 1, 8, 2, 3, 3, null, null, null));
            this.myFontCombo = jComboBox = new JComboBox();
            ((Component)jComboBox).setEnabled(true);
            jComboBox.setEditable(false);
            jComboBox.setAutoscrolls(true);
            jComboBox.setName("");
            jComboBox.setPopupVisible(false);
            jComboBox.setDoubleBuffered(false);
            jComboBox.setRequestFocusEnabled(true);
            jPanel6.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
            this.myFontNameLabel = jLabel2 = new JLabel();
            this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/IdeBundle").getString("label.font.name"));
            jLabel2.setHorizontalAlignment(10);
            jPanel6.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 1, 0, 0, null, null, null, 3));
            this.myFontSizeLabel = jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/IdeBundle").getString("label.font.size"));
            jLabel.setHorizontalAlignment(10);
            jPanel6.add((Component)jLabel, new GridConstraints(0, 2, 1, 1, 8, 1, 0, 0, null, null, null));
            JComboBox jComboBox3 = this.myFontSizeCombo;
            jComboBox3.setEditable(true);
            jPanel6.add((Component)jComboBox3, new GridConstraints(0, 3, 1, 1, 8, 1, 2, 0, null, new Dimension(40, -1), null));
            JPanel jPanel7 = new JPanel();
            jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel4.add((Component)jPanel7, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myOverrideLAFFonts = jCheckBox16 = new JCheckBox();
            jCheckBox16.setMargin(new Insets(2, 0, 2, 2));
            this.$$$loadButtonText$$$(jCheckBox16, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.override.default.laf.fonts"));
            jPanel7.add((Component)jCheckBox16, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myHideIconsInQuickNavigation = jCheckBox15 = new JCheckBox();
            jCheckBox15.setMargin(new Insets(2, 0, 2, 2));
            this.$$$loadButtonText$$$(jCheckBox15, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.show.icons.in.quick.navigation"));
            jPanel4.add((Component)jCheckBox15, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myHideNavigationPopupsCheckBox = jCheckBox14 = new JCheckBox();
            jCheckBox14.setMargin(new Insets(2, 0, 2, 2));
            jCheckBox14.setText("Hide navigation popups on focus loss");
            jPanel4.add((Component)jCheckBox14, new GridConstraints(6, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(271, 29), null));
            JPanel jPanel8 = new JPanel();
            jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel4.add((Component)jPanel8, new GridConstraints(8, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            JLabel jLabel4 = new JLabel();
            jLabel4.setText("Tooltip initial delay (ms):");
            jPanel8.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myInitialTooltipDelaySlider = jSlider2 = new JSlider();
            jSlider2.setPaintTrack(true);
            jSlider2.setValue(100);
            jPanel8.add((Component)jSlider2, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
            this.myAltDNDCheckBox = jCheckBox13 = new JCheckBox();
            jCheckBox13.setText("Drag-n-Drop with ALT pressed only");
            jPanel4.add((Component)jCheckBox13, new GridConstraints(7, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myTransparencyPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 1, 3, 3, 3, null, null, null));
            jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/IdeBundle").getString("group.transparency"), (int)0, (int)0, null, null));
            JLabel jLabel5 = new JLabel();
            this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("messages/IdeBundle").getString("label.transparency.delay.ms"));
            jPanel.add((Component)jLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            JLabel jLabel6 = new JLabel();
            this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("messages/IdeBundle").getString("label.transparency.ratio"));
            jPanel.add((Component)jLabel6, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myEnableAlphaModeCheckBox = jCheckBox12 = new JCheckBox();
            jCheckBox12.setMargin(new Insets(0, 0, 0, 0));
            this.$$$loadButtonText$$$(jCheckBox12, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.use.transparent.mode.for.floating.windows"));
            jPanel.add((Component)jCheckBox12, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
            this.myAlphaModeRatioSlider = jSlider = new JSlider();
            jPanel.add((Component)jSlider, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
            this.myAlphaModeDelayTextField = jTextField = new JTextField();
            jTextField.setText("1500");
            jTextField.setHorizontalAlignment(2);
            jTextField.setMargin(new Insets(0, 0, 0, 0));
            jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 0, 6, 0, null, new Dimension(50, -1), null));
            JPanel jPanel9 = new JPanel();
            jPanel9.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel9.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel3.add((Component)jPanel9, new GridConstraints(2, 0, 1, 1, 1, 3, 0, 0, null, null, null));
            jPanel9.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/IdeBundle").getString("group.window.options"), (int)0, (int)0, null, null));
            this.myShowToolStripesCheckBox = jCheckBox11 = new JCheckBox();
            jCheckBox11.setMargin(new Insets(2, 2, 2, 2));
            this.$$$loadButtonText$$$(jCheckBox11, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.show.tool.window.bars"));
            jCheckBox11.setSelected(true);
            jPanel9.add((Component)jCheckBox11, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myCbDisplayIconsInMenu = jCheckBox10 = new JCheckBox();
            jCheckBox10.setMargin(new Insets(2, 2, 2, 2));
            this.$$$loadButtonText$$$(jCheckBox10, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.show.icons.in.menu.items"));
            jCheckBox10.setSelected(true);
            jPanel9.add((Component)jCheckBox10, new GridConstraints(4, 0, 1, 1, 9, 0, 3, 0, null, new Dimension(153, 20), null));
            this.myDisableMnemonics = jCheckBox9 = new JCheckBox();
            jCheckBox9.setMargin(new Insets(2, 2, 2, 2));
            this.$$$loadButtonText$$$(jCheckBox9, ResourceBundle.getBundle("messages/KeyMapBundle").getString("disable.mnemonic.in.menu.check.box"));
            jPanel9.add((Component)jCheckBox9, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myDisableMnemonicInControlsCheckBox = jCheckBox8 = new JCheckBox();
            jCheckBox8.setMargin(new Insets(2, 2, 2, 2));
            this.$$$loadButtonText$$$(jCheckBox8, ResourceBundle.getBundle("messages/KeyMapBundle").getString("disable.mnemonic.in.controls.check.box"));
            jPanel9.add((Component)jCheckBox8, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myWindowShortcutsCheckBox = jCheckBox7 = new JCheckBox();
            jCheckBox7.setMargin(new Insets(2, 2, 2, 2));
            this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.show.tool.window.numbers"));
            jCheckBox7.setSelected(true);
            jPanel9.add((Component)jCheckBox7, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myShowMemoryIndicatorCheckBox = jCheckBox6 = new JCheckBox();
            jCheckBox6.setMargin(new Insets(2, 2, 2, 2));
            this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.show.memory.indicator"));
            jCheckBox6.setSelected(true);
            jPanel9.add((Component)jCheckBox6, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myAnimateWindowsCheckBox = jCheckBox5 = new JCheckBox();
            jCheckBox5.setMargin(new Insets(2, 2, 2, 2));
            this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.animate.windows"));
            jCheckBox5.setSelected(true);
            jPanel9.add((Component)jCheckBox5, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myAllowMergeButtons = jCheckBox4 = new JCheckBox();
            jCheckBox4.setText("Allow merging buttons on dialogs");
            jCheckBox4.setSelected(true);
            jPanel9.add((Component)jCheckBox4, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myUseSmallLabelsOnTabs = jBCheckBox2 = new JBCheckBox();
            jBCheckBox2.setText("Small labels in editor tabs");
            jPanel9.add((Component)jBCheckBox2, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myWidescreenLayoutCheckBox = jBCheckBox = new JBCheckBox();
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.widescreen.tool.window.layout"));
            jPanel9.add((Component)jBCheckBox, new GridConstraints(4, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(175, 20), null));
            this.myLeftLayoutCheckBox = jCheckBox3 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.left.toolwindow.layout"));
            jPanel9.add((Component)jCheckBox3, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(171, 20), null));
            this.myRightLayoutCheckBox = jCheckBox2 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.right.toolwindow.layout"));
            jPanel9.add((Component)jCheckBox2, new GridConstraints(5, 1, 1, 1, 8, 0, 3, 0, null, new Dimension(177, 20), null));
            this.myNavigateToPreviewCheckBox = jCheckBox = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.use.preview.window"));
            jPanel9.add((Component)jCheckBox, new GridConstraints(6, 1, 1, 1, 8, 0, 3, 0, null, null, null));
            JPanel jPanel10 = new JPanel();
            jPanel10.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel10.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel3.add((Component)jPanel10, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            jPanel10.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/IdeBundle").getString("group.presentation.mode"), (int)0, (int)0, null, null));
            Spacer spacer = new Spacer();
            jPanel10.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel10.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            JBLabel jBLabel = new JBLabel();
            this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/IdeBundle").getString("presentation.mode.fon.size"));
            jPanel10.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
            ComboBox comboBox = this.myPresentationModeFontSize;
            jPanel10.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 0, 0, 2, 0, null, null, null));
            jLabel3.setLabelFor(jComboBox2);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

