/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.ClassMemberWithElement;
import com.intellij.codeInsight.generation.MemberChooserObject;
import com.intellij.codeInsight.generation.MemberChooserObjectBase;
import com.intellij.codeInsight.generation.PsiElementMemberChooserObject;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemberChooser<T extends ClassMember>
extends DialogWrapper
implements TypeSafeDataProvider {
    protected Tree myTree;
    private DefaultTreeModel myTreeModel;
    protected JComponent[] myOptionControls;
    private JCheckBox myCopyJavadocCheckbox;
    private JCheckBox myInsertOverrideAnnotationCheckbox;
    private final ArrayList<MemberNode> mySelectedNodes;
    private final SortEmAction mySortAction;
    private boolean myAlphabeticallySorted;
    private boolean myShowClasses;
    protected boolean myAllowEmptySelection;
    private final boolean myAllowMultiSelection;
    private final Project myProject;
    private final boolean myIsInsertOverrideVisible;
    private final JComponent myHeaderPanel;
    protected T[] myElements;
    protected Comparator<ElementNode> myComparator;
    protected final HashMap<MemberNode, ParentNode> myNodeToParentMap;
    protected final HashMap<ClassMember, MemberNode> myElementToNodeMap;
    protected final ArrayList<ContainerNode> myContainerNodes;
    protected LinkedHashSet<T> mySelectedElements;
    @NonNls
    private static final String PROP_SORTED = "MemberChooser.sorted";
    @NonNls
    private static final String PROP_SHOWCLASSES = "MemberChooser.showClasses";
    @NonNls
    private static final String PROP_COPYJAVADOC = "MemberChooser.copyJavadoc";

    public MemberChooser(T[] elements, boolean allowEmptySelection, boolean allowMultiSelection, @NotNull Project project, @Nullable JComponent headerPanel, JComponent[] optionControls) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/util/MemberChooser", "<init>"));
        }
        this(allowEmptySelection, allowMultiSelection, project, false, headerPanel, optionControls);
        this.resetElements((ClassMember[])elements);
        this.init();
    }

    public MemberChooser(T[] elements, boolean allowEmptySelection, boolean allowMultiSelection, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/util/MemberChooser", "<init>"));
        }
        this((ClassMember[])elements, allowEmptySelection, allowMultiSelection, project, false);
    }

    public MemberChooser(T[] elements, boolean allowEmptySelection, boolean allowMultiSelection, @NotNull Project project, boolean isInsertOverrideVisible) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/util/MemberChooser", "<init>"));
        }
        this((ClassMember[])elements, allowEmptySelection, allowMultiSelection, project, isInsertOverrideVisible, null);
    }

    public MemberChooser(T[] elements, boolean allowEmptySelection, boolean allowMultiSelection, @NotNull Project project, boolean isInsertOverrideVisible, @Nullable JComponent headerPanel) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/util/MemberChooser", "<init>"));
        }
        this(allowEmptySelection, allowMultiSelection, project, isInsertOverrideVisible, headerPanel, null);
        this.resetElements((ClassMember[])elements);
        this.init();
    }

    protected MemberChooser(boolean allowEmptySelection, boolean allowMultiSelection, @NotNull Project project, boolean isInsertOverrideVisible, @Nullable JComponent headerPanel, @Nullable JComponent[] optionControls) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/util/MemberChooser", "<init>"));
        }
        super(project, true);
        this.mySelectedNodes = new ArrayList();
        this.myAlphabeticallySorted = false;
        this.myShowClasses = true;
        this.myAllowEmptySelection = false;
        this.myComparator = new OrderComparator();
        this.myNodeToParentMap = new HashMap();
        this.myElementToNodeMap = new HashMap();
        this.myContainerNodes = new ArrayList();
        this.myAllowEmptySelection = allowEmptySelection;
        this.myAllowMultiSelection = allowMultiSelection;
        this.myProject = project;
        this.myIsInsertOverrideVisible = isInsertOverrideVisible;
        this.myHeaderPanel = headerPanel;
        this.myTree = this.createTree();
        this.myOptionControls = optionControls;
        this.mySortAction = new SortEmAction();
        this.mySortAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(65, 8)), (JComponent)this.myTree);
    }

    protected void resetElementsWithDefaultComparator(T[] elements, boolean restoreSelectedElements) {
        this.myComparator = this.myAlphabeticallySorted ? new AlphaComparator() : new OrderComparator();
        this.resetElements((ClassMember[])elements, null, restoreSelectedElements);
    }

    public void resetElements(T[] elements) {
        this.resetElements((ClassMember[])elements, null, false);
    }

    public void resetElements(T[] elements, @Nullable Comparator<T> sortComparator, boolean restoreSelectedElements) {
        ArrayList<ClassMember> selectedElements = restoreSelectedElements && this.mySelectedElements != null ? new ArrayList<ClassMember>(this.mySelectedElements) : null;
        this.myElements = elements;
        if (sortComparator != null) {
            this.myComparator = new ElementNodeComparatorWrapper<T>(sortComparator);
        }
        this.mySelectedNodes.clear();
        this.myNodeToParentMap.clear();
        this.myElementToNodeMap.clear();
        this.myContainerNodes.clear();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                MemberChooser.this.myTreeModel = MemberChooser.this.buildModel();
            }
        });
        this.myTree.setModel((TreeModel)this.myTreeModel);
        this.myTree.setRootVisible(false);
        this.doSort();
        this.defaultExpandTree();
        if (this.myOptionControls == null) {
            this.myCopyJavadocCheckbox = new NonFocusableCheckBox(IdeBundle.message((String)"checkbox.copy.javadoc", (Object[])new Object[0]));
            if (this.myIsInsertOverrideVisible) {
                this.myInsertOverrideAnnotationCheckbox = new NonFocusableCheckBox(IdeBundle.message((String)"checkbox.insert.at.override", (Object[])new Object[0]));
                this.myOptionControls = new JCheckBox[]{this.myCopyJavadocCheckbox, this.myInsertOverrideAnnotationCheckbox};
            } else {
                this.myOptionControls = new JCheckBox[]{this.myCopyJavadocCheckbox};
            }
        }
        this.myTree.doLayout();
        this.setOKActionEnabled(this.myAllowEmptySelection || this.myElements != null && this.myElements.length > 0);
        if (selectedElements != null) {
            this.selectElements(selectedElements.toArray(new ClassMember[selectedElements.size()]));
        }
        if (this.mySelectedElements == null || this.mySelectedElements.isEmpty()) {
            this.expandFirst();
        }
    }

    private DefaultTreeModel buildModel() {
        final DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        final Ref count = new Ref((Object)0);
        FactoryMap<MemberChooserObject, ParentNode> map = new FactoryMap<MemberChooserObject, ParentNode>(){

            protected ParentNode create(MemberChooserObject key) {
                MemberChooserObject parentNodeDelegate;
                ParentNode node = null;
                DefaultMutableTreeNode parentNode = rootNode;
                if (MemberChooser.this.supportsNestedContainers() && key instanceof ClassMember && (parentNodeDelegate = ((ClassMember)key).getParentNodeDelegate()) != null) {
                    parentNode = (DefaultMutableTreeNode)this.get(parentNodeDelegate);
                }
                if (MemberChooser.this.isContainerNode(key)) {
                    ContainerNode containerNode;
                    node = containerNode = new ContainerNode(parentNode, key, (Ref<Integer>)count);
                    MemberChooser.this.myContainerNodes.add(containerNode);
                }
                if (node == null) {
                    node = new ParentNode(parentNode, key, (Ref<Integer>)count);
                }
                return node;
            }
        };
        for (T object : this.myElements) {
            ParentNode parentNode = (ParentNode)map.get((Object)object.getParentNodeDelegate());
            MemberNode elementNode = this.createMemberNode((Ref<Integer>)count, object, parentNode);
            this.myNodeToParentMap.put((Object)elementNode, (Object)parentNode);
            this.myElementToNodeMap.put(object, (Object)elementNode);
        }
        return new DefaultTreeModel(rootNode);
    }

    protected MemberNode createMemberNode(Ref<Integer> count, T object, ParentNode parentNode) {
        return new MemberNodeImpl(parentNode, (ClassMember)object, count);
    }

    protected boolean supportsNestedContainers() {
        return false;
    }

    protected void defaultExpandTree() {
        TreeUtil.expandAll((JTree)this.myTree);
    }

    protected boolean isContainerNode(MemberChooserObject key) {
        return key instanceof PsiElementMemberChooserObject;
    }

    public void selectElements(ClassMember[] elements) {
        ArrayList<TreePath> selectionPaths = new ArrayList<TreePath>();
        for (ClassMember element : elements) {
            MemberNode treeNode = (MemberNode)this.myElementToNodeMap.get((Object)element);
            if (treeNode == null) continue;
            selectionPaths.add(new TreePath(((DefaultMutableTreeNode)((Object)treeNode)).getPath()));
        }
        this.myTree.setSelectionPaths(selectionPaths.toArray(new TreePath[selectionPaths.size()]));
    }

    @NotNull
    protected Action[] createActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(this.getOKAction());
        if (this.myAllowEmptySelection) {
            actions.add(new SelectNoneAction());
        }
        actions.add(this.getCancelAction());
        if (this.getHelpId() != null) {
            actions.add(this.getHelpAction());
        }
        Action[] actionArray = actions.toArray(new Action[actions.size()]);
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/MemberChooser", "createActions"));
        }
        return actionArray;
    }

    protected void doHelpAction() {
        if (this.getHelpId() == null) {
            return;
        }
        super.doHelpAction();
    }

    protected void customizeOptionsPanel() {
        if (this.myInsertOverrideAnnotationCheckbox != null && this.myIsInsertOverrideVisible) {
            CodeStyleSettings styleSettings = CodeStyleSettingsManager.getInstance((Project)this.myProject).getCurrentSettings();
            this.myInsertOverrideAnnotationCheckbox.setSelected(styleSettings.INSERT_OVERRIDE_ANNOTATION);
        }
        if (this.myCopyJavadocCheckbox != null) {
            this.myCopyJavadocCheckbox.setSelected(PropertiesComponent.getInstance().isTrueValue(PROP_COPYJAVADOC));
        }
    }

    protected JComponent createSouthPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.customizeOptionsPanel();
        JPanel optionsPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        for (JComponent component : this.myOptionControls) {
            optionsPanel.add(component);
        }
        panel.add((Component)optionsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        if (!(this.myAllowEmptySelection || this.myElements != null && this.myElements.length != 0)) {
            this.setOKActionEnabled(false);
        }
        panel.add((Component)super.createSouthPanel(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 15, 0, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    protected JComponent createNorthPanel() {
        return this.myHeaderPanel;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        DefaultActionGroup group = new DefaultActionGroup();
        this.fillToolbarActions(group);
        group.addSeparator();
        ExpandAllAction expandAllAction = new ExpandAllAction();
        expandAllAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeymapManager.getInstance().getActiveKeymap().getShortcuts("ExpandAll")), (JComponent)this.myTree);
        group.add((AnAction)expandAllAction);
        CollapseAllAction collapseAllAction = new CollapseAllAction();
        collapseAllAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeymapManager.getInstance().getActiveKeymap().getShortcuts("CollapseAll")), (JComponent)this.myTree);
        group.add((AnAction)collapseAllAction);
        panel.add((Component)ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true).getComponent(), "North");
        this.expandFirst();
        this.defaultExpandTree();
        this.installSpeedSearch();
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTree);
        scrollPane.setPreferredSize((Dimension)JBUI.size((int)350, (int)450));
        panel.add((Component)scrollPane, "Center");
        return panel;
    }

    private void expandFirst() {
        if (this.getRootNode().getChildCount() > 0) {
            this.myTree.expandRow(0);
            this.myTree.setSelectionRow(1);
        }
    }

    protected Tree createTree() {
        final Tree tree = new Tree((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
        tree.setCellRenderer(this.getTreeCellRenderer());
        UIUtil.setLineStyleAngled((JTree)tree);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.addKeyListener((KeyListener)new TreeKeyListener());
        tree.addTreeSelectionListener((TreeSelectionListener)new MyTreeSelectionListener());
        if (!this.myAllowMultiSelection) {
            tree.getSelectionModel().setSelectionMode(1);
        }
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                if (tree.getPathForLocation(e.getX(), e.getY()) != null) {
                    MemberChooser.this.doOKAction();
                    return true;
                }
                return false;
            }
        }.installOn((Component)tree);
        TreeUtil.installActions((JTree)tree);
        return tree;
    }

    protected TreeCellRenderer getTreeCellRenderer() {
        return new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value instanceof ElementNode) {
                    ((ElementNode)value).getDelegate().renderTreeNode((SimpleColoredComponent)this, tree);
                }
            }
        };
    }

    @NotNull
    protected String convertElementText(@NotNull String originalElementText) {
        if (originalElementText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalElementText", "com/intellij/ide/util/MemberChooser", "convertElementText"));
        }
        String res = originalElementText;
        int i = res.indexOf(58);
        if (i >= 0) {
            res = res.substring(0, i);
        }
        if ((i = res.indexOf(40)) >= 0) {
            res = res.substring(0, i);
        }
        String string = res;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/MemberChooser", "convertElementText"));
        }
        return string;
    }

    protected void installSpeedSearch() {
        TreeSpeedSearch treeSpeedSearch = new TreeSpeedSearch(this.myTree, new Convertor<TreePath, String>(){

            @Nullable
            public String convert(TreePath path) {
                ElementNode lastPathComponent = (ElementNode)path.getLastPathComponent();
                if (lastPathComponent == null) {
                    return null;
                }
                String text = lastPathComponent.getDelegate().getText();
                if (text != null) {
                    text = MemberChooser.this.convertElementText(text);
                }
                return text;
            }
        });
        treeSpeedSearch.setComparator(this.getSpeedSearchComparator());
    }

    protected SpeedSearchComparator getSpeedSearchComparator() {
        return new SpeedSearchComparator(false);
    }

    protected void disableAlphabeticalSorting(AnActionEvent event) {
        this.mySortAction.setSelected(event, false);
    }

    protected void onAlphabeticalSortingEnabled(AnActionEvent event) {
    }

    protected void fillToolbarActions(DefaultActionGroup group) {
        boolean alphabeticallySorted = PropertiesComponent.getInstance().isTrueValue(PROP_SORTED);
        if (alphabeticallySorted) {
            this.setSortComparator(new AlphaComparator());
        }
        this.myAlphabeticallySorted = alphabeticallySorted;
        group.add((AnAction)this.mySortAction);
        if (!this.supportsNestedContainers()) {
            ShowContainersAction showContainersAction = this.getShowContainersAction();
            showContainersAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(67, 8)), (JComponent)this.myTree);
            this.setShowClasses(PropertiesComponent.getInstance().getBoolean(PROP_SHOWCLASSES, true));
            group.add((AnAction)showContainersAction);
        }
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.ide.util.MemberChooser";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    public JComponent[] getOptionControls() {
        return this.myOptionControls;
    }

    @Nullable
    private LinkedHashSet<T> getSelectedElementsList() {
        return this.getExitCode() == 0 ? this.mySelectedElements : null;
    }

    @Nullable
    public List<T> getSelectedElements() {
        LinkedHashSet<T> list = this.getSelectedElementsList();
        return list == null ? null : new ArrayList<T>(list);
    }

    @Nullable
    public T[] getSelectedElements(T[] a) {
        LinkedHashSet<T> list = this.getSelectedElementsList();
        if (list == null) {
            return null;
        }
        return (ClassMember[])list.toArray(a);
    }

    protected final boolean areElementsSelected() {
        return this.mySelectedElements != null && !this.mySelectedElements.isEmpty();
    }

    public void setCopyJavadocVisible(boolean state) {
        if (this.myCopyJavadocCheckbox != null) {
            this.myCopyJavadocCheckbox.setVisible(state);
        }
    }

    public boolean isCopyJavadoc() {
        return this.myCopyJavadocCheckbox.isSelected();
    }

    public boolean isInsertOverrideAnnotation() {
        return this.myIsInsertOverrideVisible && this.myInsertOverrideAnnotationCheckbox.isSelected();
    }

    private boolean isAlphabeticallySorted() {
        return this.myAlphabeticallySorted;
    }

    protected void changeSortComparator(Comparator<T> comparator) {
        this.setSortComparator(new ElementNodeComparatorWrapper<T>(comparator));
    }

    private void setSortComparator(Comparator<ElementNode> sortComparator) {
        if (((Object)this.myComparator).equals(sortComparator)) {
            return;
        }
        this.myComparator = sortComparator;
        this.doSort();
    }

    protected void doSort() {
        Pair<ElementNode, List<ElementNode>> pair = this.storeSelection();
        Enumeration<TreeNode> children = this.getRootNodeChildren();
        while (children.hasMoreElements()) {
            ParentNode classNode = (ParentNode)children.nextElement();
            MemberChooser.sortNode(classNode, this.myComparator);
            this.myTreeModel.nodeStructureChanged(classNode);
        }
        this.restoreSelection(pair);
    }

    private static void sortNode(ParentNode node, Comparator<ElementNode> sortComparator) {
        ArrayList<ElementNode> arrayList = new ArrayList<ElementNode>();
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            arrayList.add((ElementNode)children.nextElement());
        }
        Collections.sort(arrayList, sortComparator);
        MemberChooser.replaceChildren(node, arrayList);
    }

    private static void replaceChildren(DefaultMutableTreeNode node, Collection<? extends ElementNode> arrayList) {
        node.removeAllChildren();
        for (ElementNode elementNode : arrayList) {
            node.add(elementNode);
        }
    }

    protected void restoreTree() {
        Pair<ElementNode, List<ElementNode>> selection = this.storeSelection();
        DefaultMutableTreeNode root = this.getRootNode();
        if (!this.myShowClasses || this.myContainerNodes.isEmpty()) {
            ArrayList<ParentNode> otherObjects = new ArrayList<ParentNode>();
            Enumeration<TreeNode> children = this.getRootNodeChildren();
            ParentNode newRoot = new ParentNode(null, (MemberChooserObject)new MemberChooserObjectBase(this.getAllContainersNodeName()), (Ref<Integer>)new Ref((Object)0));
            while (children.hasMoreElements()) {
                ParentNode nextElement = (ParentNode)children.nextElement();
                if (nextElement instanceof ContainerNode) {
                    ContainerNode containerNode = (ContainerNode)nextElement;
                    Enumeration<TreeNode> memberNodes = containerNode.children();
                    ArrayList<MemberNode> memberNodesList = new ArrayList<MemberNode>();
                    while (memberNodes.hasMoreElements()) {
                        memberNodesList.add((MemberNode)memberNodes.nextElement());
                    }
                    for (MemberNode memberNode : memberNodesList) {
                        newRoot.add(memberNode);
                    }
                    continue;
                }
                otherObjects.add(nextElement);
            }
            MemberChooser.replaceChildren(root, otherObjects);
            MemberChooser.sortNode(newRoot, this.myComparator);
            if (newRoot.children().hasMoreElements()) {
                root.add(newRoot);
            }
        } else {
            Enumeration<TreeNode> children = this.getRootNodeChildren();
            while (children.hasMoreElements()) {
                ParentNode allClassesNode = (ParentNode)children.nextElement();
                Enumeration<TreeNode> memberNodes = allClassesNode.children();
                ArrayList<MemberNode> arrayList = new ArrayList<MemberNode>();
                while (memberNodes.hasMoreElements()) {
                    arrayList.add((MemberNode)memberNodes.nextElement());
                }
                Collections.sort(arrayList, this.myComparator);
                for (MemberNode memberNode : arrayList) {
                    ((ParentNode)this.myNodeToParentMap.get((Object)memberNode)).add(memberNode);
                }
            }
            MemberChooser.replaceChildren(root, this.myContainerNodes);
        }
        this.myTreeModel.nodeStructureChanged(root);
        this.defaultExpandTree();
        this.restoreSelection(selection);
    }

    private void setShowClasses(boolean showClasses) {
        this.myShowClasses = showClasses;
        this.restoreTree();
    }

    protected String getAllContainersNodeName() {
        return IdeBundle.message((String)"node.memberchooser.all.classes", (Object[])new Object[0]);
    }

    private Enumeration<TreeNode> getRootNodeChildren() {
        return this.getRootNode().children();
    }

    protected DefaultMutableTreeNode getRootNode() {
        return (DefaultMutableTreeNode)this.myTreeModel.getRoot();
    }

    private Pair<ElementNode, List<ElementNode>> storeSelection() {
        TreePath leadSelectionPath;
        ArrayList<ElementNode> selectedNodes = new ArrayList<ElementNode>();
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                selectedNodes.add((ElementNode)path.getLastPathComponent());
            }
        }
        return Pair.create((Object)((leadSelectionPath = this.myTree.getLeadSelectionPath()) != null ? (ElementNode)leadSelectionPath.getLastPathComponent() : null), selectedNodes);
    }

    private void restoreSelection(Pair<ElementNode, List<ElementNode>> pair) {
        ElementNode leadNode;
        List selectedNodes = (List)pair.second;
        DefaultMutableTreeNode root = this.getRootNode();
        ArrayList<TreePath> toSelect = new ArrayList<TreePath>();
        for (ElementNode node : selectedNodes) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)((Object)node);
            if (!root.isNodeDescendant(treeNode)) continue;
            toSelect.add(new TreePath(treeNode.getPath()));
        }
        if (!toSelect.isEmpty()) {
            this.myTree.setSelectionPaths(toSelect.toArray(new TreePath[toSelect.size()]));
        }
        if ((leadNode = (ElementNode)pair.first) != null) {
            this.myTree.setLeadSelectionPath(new TreePath(((DefaultMutableTreeNode)((Object)leadNode)).getPath()));
        }
    }

    public void dispose() {
        Container contentPane;
        PropertiesComponent instance = PropertiesComponent.getInstance();
        instance.setValue(PROP_SORTED, Boolean.toString(this.isAlphabeticallySorted()));
        instance.setValue(PROP_SHOWCLASSES, Boolean.toString(this.myShowClasses));
        if (this.myCopyJavadocCheckbox != null) {
            instance.setValue(PROP_COPYJAVADOC, Boolean.toString(this.myCopyJavadocCheckbox.isSelected()));
        }
        if ((contentPane = this.getContentPane()) != null) {
            contentPane.removeAll();
        }
        this.mySelectedNodes.clear();
        this.myElements = null;
        super.dispose();
    }

    public void calcData(DataKey key, DataSink sink) {
        ClassMember selectedElement;
        if (key.equals(CommonDataKeys.PSI_ELEMENT) && this.mySelectedElements != null && !this.mySelectedElements.isEmpty() && (selectedElement = (ClassMember)this.mySelectedElements.iterator().next()) instanceof ClassMemberWithElement) {
            sink.put(CommonDataKeys.PSI_ELEMENT, (Object)((ClassMemberWithElement)selectedElement).getElement());
        }
    }

    protected ShowContainersAction getShowContainersAction() {
        return new ShowContainersAction(IdeBundle.message((String)"action.show.classes", (Object[])new Object[0]), PlatformIcons.CLASS_ICON);
    }

    private static class ElementNodeComparatorWrapper<T>
    implements Comparator<ElementNode> {
        private final Comparator<T> myDelegate;

        public ElementNodeComparatorWrapper(Comparator<T> delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public int compare(ElementNode o1, ElementNode o2) {
            return this.myDelegate.compare(o1.getDelegate(), o2.getDelegate());
        }
    }

    protected static class OrderComparator
    implements Comparator<ElementNode> {
        @Override
        public int compare(ElementNode n1, ElementNode n2) {
            if (n1.getDelegate() instanceof ClassMemberWithElement && n2.getDelegate() instanceof ClassMemberWithElement) {
                PsiElement element1 = ((ClassMemberWithElement)n1.getDelegate()).getElement();
                PsiElement element2 = ((ClassMemberWithElement)n2.getDelegate()).getElement();
                if (!(element1 instanceof PsiCompiledElement) && !(element2 instanceof PsiCompiledElement)) {
                    return element1.getTextOffset() - element2.getTextOffset();
                }
            }
            return n1.getOrder() - n2.getOrder();
        }
    }

    private static class AlphaComparator
    implements Comparator<ElementNode> {
        private AlphaComparator() {
        }

        @Override
        public int compare(ElementNode n1, ElementNode n2) {
            return n1.getDelegate().getText().compareToIgnoreCase(n2.getDelegate().getText());
        }
    }

    private class CollapseAllAction
    extends AnAction {
        public CollapseAllAction() {
            super(IdeBundle.message((String)"action.collapse.all", (Object[])new Object[0]), IdeBundle.message((String)"action.collapse.all", (Object[])new Object[0]), AllIcons.Actions.Collapseall);
        }

        public void actionPerformed(AnActionEvent e) {
            TreeUtil.collapseAll((JTree)MemberChooser.this.myTree, (int)1);
        }
    }

    private class ExpandAllAction
    extends AnAction {
        public ExpandAllAction() {
            super(IdeBundle.message((String)"action.expand.all", (Object[])new Object[0]), IdeBundle.message((String)"action.expand.all", (Object[])new Object[0]), AllIcons.Actions.Expandall);
        }

        public void actionPerformed(AnActionEvent e) {
            TreeUtil.expandAll((JTree)MemberChooser.this.myTree);
        }
    }

    protected class ShowContainersAction
    extends ToggleAction {
        public ShowContainersAction(String text, Icon icon) {
            super(text, text, icon);
        }

        public boolean isSelected(AnActionEvent event) {
            return MemberChooser.this.myShowClasses;
        }

        public void setSelected(AnActionEvent event, boolean flag) {
            MemberChooser.this.setShowClasses(flag);
        }

        public void update(AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(MemberChooser.this.myContainerNodes.size() > 1);
        }
    }

    private class SortEmAction
    extends ToggleAction {
        public SortEmAction() {
            super(IdeBundle.message((String)"action.sort.alphabetically", (Object[])new Object[0]), IdeBundle.message((String)"action.sort.alphabetically", (Object[])new Object[0]), AllIcons.ObjectBrowser.Sorted);
        }

        public boolean isSelected(AnActionEvent event) {
            return MemberChooser.this.isAlphabeticallySorted();
        }

        public void setSelected(AnActionEvent event, boolean flag) {
            MemberChooser.this.myAlphabeticallySorted = flag;
            MemberChooser.this.setSortComparator(flag ? new AlphaComparator() : new OrderComparator());
            if (flag) {
                MemberChooser.this.onAlphabeticalSortingEnabled(event);
            }
        }
    }

    private class TreeKeyListener
    extends KeyAdapter {
        private TreeKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            TreePath path = MemberChooser.this.myTree.getLeadSelectionPath();
            if (path == null) {
                return;
            }
            Object lastComponent = path.getLastPathComponent();
            if (e.getKeyCode() == 10) {
                if (lastComponent instanceof ParentNode) {
                    return;
                }
                MemberChooser.this.doOKAction();
                e.consume();
            } else if (e.getKeyCode() == 155 && lastComponent instanceof ElementNode) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)lastComponent;
                if (!MemberChooser.this.mySelectedNodes.contains(node)) {
                    if (node.getNextNode() != null) {
                        MemberChooser.this.myTree.setSelectionPath(new TreePath(node.getNextNode().getPath()));
                    }
                } else if (node.getNextNode() != null) {
                    MemberChooser.this.myTree.removeSelectionPath(new TreePath(node.getPath()));
                    MemberChooser.this.myTree.setSelectionPath(new TreePath(node.getNextNode().getPath()));
                    MemberChooser.this.myTree.repaint();
                }
                e.consume();
            }
        }
    }

    private class SelectNoneAction
    extends AbstractAction {
        public SelectNoneAction() {
            super(IdeBundle.message((String)"action.select.none", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MemberChooser.this.myTree.clearSelection();
            MemberChooser.this.doOKAction();
        }
    }

    protected static class ContainerNode
    extends ParentNode {
        public ContainerNode(DefaultMutableTreeNode parent, MemberChooserObject delegate, Ref<Integer> order) {
            super(parent, delegate, order);
        }
    }

    protected static class ParentNode
    extends ElementNodeImpl {
        public ParentNode(@Nullable DefaultMutableTreeNode parent, MemberChooserObject delegate, Ref<Integer> order) {
            super(parent, delegate, order);
        }
    }

    protected static class MemberNodeImpl
    extends ElementNodeImpl
    implements MemberNode {
        public MemberNodeImpl(ParentNode parent, ClassMember delegate, Ref<Integer> order) {
            super(parent, (MemberChooserObject)delegate, order);
        }
    }

    protected static abstract class ElementNodeImpl
    extends DefaultMutableTreeNode
    implements ElementNode {
        private final int myOrder;
        private final MemberChooserObject myDelegate;

        public ElementNodeImpl(@Nullable DefaultMutableTreeNode parent, MemberChooserObject delegate, Ref<Integer> order) {
            this.myOrder = (Integer)order.get();
            order.set((Object)(this.myOrder + 1));
            this.myDelegate = delegate;
            if (parent != null) {
                parent.add(this);
            }
        }

        @Override
        public MemberChooserObject getDelegate() {
            return this.myDelegate;
        }

        @Override
        public int getOrder() {
            return this.myOrder;
        }
    }

    protected static interface MemberNode
    extends ElementNode {
    }

    protected static interface ElementNode
    extends MutableTreeNode {
        public MemberChooserObject getDelegate();

        public int getOrder();
    }

    private class MyTreeSelectionListener
    implements TreeSelectionListener {
        private MyTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath[] paths = e.getPaths();
            if (paths == null) {
                return;
            }
            for (int i = 0; i < paths.length; ++i) {
                Object node = paths[i].getLastPathComponent();
                if (!(node instanceof MemberNode)) continue;
                MemberNode memberNode = (MemberNode)node;
                if (e.isAddedPath(i)) {
                    if (MemberChooser.this.mySelectedNodes.contains(memberNode)) continue;
                    MemberChooser.this.mySelectedNodes.add(memberNode);
                    continue;
                }
                MemberChooser.this.mySelectedNodes.remove(memberNode);
            }
            MemberChooser.this.mySelectedElements = new LinkedHashSet();
            for (MemberNode selectedNode : MemberChooser.this.mySelectedNodes) {
                MemberChooser.this.mySelectedElements.add((ClassMember)selectedNode.getDelegate());
            }
        }
    }
}

