/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.moduleDependencies;

import com.intellij.CommonBundle;
import com.intellij.ProjectTopics;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.moduleDependencies.DependenciesAnalyzeManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.NavigatableWithText;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.content.Content;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Function;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.HashMap;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;

public class ModulesDependenciesPanel
extends JPanel
implements ModuleRootListener,
Disposable {
    @NonNls
    private static final String DIRECTION = "FORWARD_ANALIZER";
    private Content myContent;
    private final Project myProject;
    private Tree myLeftTree;
    private DefaultTreeModel myLeftTreeModel;
    private final Tree myRightTree;
    private final DefaultTreeModel myRightTreeModel;
    private Graph<Module> myModulesGraph;
    private final Module[] myModules;
    private final JTextField myPathField = new JTextField();
    private final Splitter mySplitter;
    @NonNls
    private static final String ourHelpID = "module.dependencies.tool.window";

    public ModulesDependenciesPanel(Project project, Module[] modules) {
        super(new BorderLayout());
        this.myProject = project;
        this.myModules = modules;
        this.myRightTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode("Root"));
        this.myRightTree = new Tree((TreeModel)this.myRightTreeModel);
        ModulesDependenciesPanel.initTree(this.myRightTree, true);
        this.initLeftTree();
        this.mySplitter = new Splitter();
        this.mySplitter.setFirstComponent((JComponent)new MyTreePanel(this.myLeftTree, this.myProject));
        this.mySplitter.setSecondComponent((JComponent)new MyTreePanel(this.myRightTree, this.myProject));
        this.setSplitterProportion();
        this.add((Component)this.mySplitter, "Center");
        this.add((Component)this.createNorthPanel(), "North");
        project.getMessageBus().connect((Disposable)this).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)this);
    }

    private void setSplitterProportion() {
        if (this.mySplitter == null) {
            return;
        }
        this.myModulesGraph = this.buildGraph();
        DFSTBuilder builder = new DFSTBuilder(this.myModulesGraph);
        builder.buildDFST();
        if (builder.isAcyclic()) {
            this.mySplitter.setProportion(1.0f);
        } else {
            this.mySplitter.setProportion(0.5f);
        }
    }

    public void dispose() {
    }

    public ModulesDependenciesPanel(Project project) {
        this(project, ModuleManager.getInstance((Project)project).getModules());
    }

    private JComponent createNorthPanel() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(new AnAction(CommonBundle.message((String)"action.close", (Object[])new Object[0]), AnalysisScopeBundle.message((String)"action.close.modules.dependencies.description", (Object[])new Object[0]), AllIcons.Actions.Cancel){

            public void actionPerformed(AnActionEvent e) {
                DependenciesAnalyzeManager.getInstance(ModulesDependenciesPanel.this.myProject).closeContent(ModulesDependenciesPanel.this.myContent);
            }
        });
        ModulesDependenciesPanel.appendDependenciesAction(group);
        group.add((AnAction)new ToggleAction(AnalysisScopeBundle.message((String)"action.module.dependencies.direction", (Object[])new Object[0]), "", this.isForwardDirection() ? AllIcons.Actions.SortAsc : AllIcons.Actions.SortDesc){

            public boolean isSelected(AnActionEvent e) {
                return ModulesDependenciesPanel.this.isForwardDirection();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                PropertiesComponent.getInstance((Project)ModulesDependenciesPanel.this.myProject).setValue(ModulesDependenciesPanel.DIRECTION, String.valueOf(state));
                ModulesDependenciesPanel.this.initLeftTreeModel();
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setIcon(ModulesDependenciesPanel.this.isForwardDirection() ? AllIcons.Actions.SortAsc : AllIcons.Actions.SortDesc);
            }
        });
        group.add((AnAction)new ContextHelpAction(ourHelpID));
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)toolbar.getComponent(), "North");
        panel.add((Component)this.myPathField, "South");
        this.myPathField.setEditable(false);
        return panel;
    }

    private boolean isForwardDirection() {
        String value = PropertiesComponent.getInstance((Project)this.myProject).getValue(DIRECTION);
        return value == null || Boolean.parseBoolean(value);
    }

    private static void appendDependenciesAction(DefaultActionGroup group) {
        final AnAction analyzeDepsAction = ActionManager.getInstance().getAction("ShowPackageDeps");
        group.add(new AnAction(analyzeDepsAction.getTemplatePresentation().getText(), analyzeDepsAction.getTemplatePresentation().getDescription(), AllIcons.Toolwindows.ToolWindowInspection){

            public void actionPerformed(AnActionEvent e) {
                analyzeDepsAction.actionPerformed(e);
            }

            public void update(AnActionEvent e) {
                analyzeDepsAction.update(e);
            }
        });
    }

    private void buildRightTree(Module module) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.myRightTreeModel.getRoot();
        root.removeAllChildren();
        Set cycles = GraphAlgorithms.getInstance().findCycles(this.myModulesGraph, (Object)module);
        int index = 1;
        for (List modules : cycles) {
            DefaultMutableTreeNode cycle = new DefaultMutableTreeNode(AnalysisScopeBundle.message((String)"module.dependencies.cycle.node.text", (Object[])new Object[]{Integer.toString(index++).toUpperCase()}));
            root.add(cycle);
            cycle.add(new DefaultMutableTreeNode(new MyUserObject(false, module)));
            for (Module moduleInCycle : modules) {
                cycle.add(new DefaultMutableTreeNode(new MyUserObject(false, moduleInCycle)));
            }
        }
        ((DefaultTreeModel)this.myRightTree.getModel()).reload();
        TreeUtil.expandAll((JTree)this.myRightTree);
    }

    private void initLeftTreeModel() {
        final DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.myLeftTreeModel.getRoot();
        root.removeAllChildren();
        this.myModulesGraph = this.buildGraph();
        this.setSplitterProportion();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                HashMap inCycle = new HashMap();
                for (Module module : ModulesDependenciesPanel.this.myModules) {
                    if (progressIndicator != null) {
                        if (progressIndicator.isCanceled()) {
                            return;
                        }
                        progressIndicator.setText(AnalysisScopeBundle.message((String)"update.module.tree.progress.text", (Object[])new Object[]{module.getName()}));
                    }
                    if (module.isDisposed()) continue;
                    Boolean isInCycle = (Boolean)inCycle.get(module);
                    if (isInCycle == null) {
                        isInCycle = !GraphAlgorithms.getInstance().findCycles(ModulesDependenciesPanel.this.myModulesGraph, (Object)module).isEmpty();
                        inCycle.put(module, isInCycle);
                    }
                    DefaultMutableTreeNode moduleNode = new DefaultMutableTreeNode(new MyUserObject(isInCycle, module));
                    root.add(moduleNode);
                    Iterator out = ModulesDependenciesPanel.this.myModulesGraph.getOut((Object)module);
                    while (out.hasNext()) {
                        moduleNode.add(new DefaultMutableTreeNode(new MyUserObject(false, (Module)out.next())));
                    }
                }
            }
        }, AnalysisScopeBundle.message((String)"update.module.tree.progress.title", (Object[])new Object[0]), true, this.myProject);
        ModulesDependenciesPanel.sortSubTree(root);
        this.myLeftTreeModel.reload();
    }

    private static void sortSubTree(DefaultMutableTreeNode root) {
        TreeUtil.sort((DefaultMutableTreeNode)root, (Comparator)new Comparator(){

            public int compare(Object o1, Object o2) {
                DefaultMutableTreeNode node1 = (DefaultMutableTreeNode)o1;
                DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)o2;
                if (!(node1.getUserObject() instanceof MyUserObject)) {
                    return 1;
                }
                if (!(node2.getUserObject() instanceof MyUserObject)) {
                    return -1;
                }
                return node1.getUserObject().toString().compareToIgnoreCase(node2.getUserObject().toString());
            }
        });
    }

    private void selectCycleUpward(DefaultMutableTreeNode selection) {
        DefaultMutableTreeNode current;
        ArrayList<DefaultMutableTreeNode> selectionNodes = new ArrayList<DefaultMutableTreeNode>();
        selectionNodes.add(selection);
        boolean flag = false;
        for (current = (DefaultMutableTreeNode)selection.getParent(); current != null && current.getUserObject() != null; current = (DefaultMutableTreeNode)current.getParent()) {
            if (current.getUserObject().equals(selection.getUserObject())) {
                flag = true;
                selectionNodes.add(current);
                break;
            }
            selectionNodes.add(current);
        }
        if (flag) {
            for (DefaultMutableTreeNode node : selectionNodes) {
                ((MyUserObject)node.getUserObject()).setInCycle(true);
            }
        }
        if (current != null) {
            current = (DefaultMutableTreeNode)current.getParent();
        }
        while (current != null) {
            Object userObject = current.getUserObject();
            if (userObject instanceof MyUserObject) {
                ((MyUserObject)userObject).setInCycle(false);
            }
            current = (DefaultMutableTreeNode)current.getParent();
        }
        this.myLeftTree.repaint();
    }

    private void initLeftTree() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Root");
        this.myLeftTreeModel = new DefaultTreeModel(root);
        this.initLeftTreeModel();
        this.myLeftTree = new Tree((TreeModel)this.myLeftTreeModel);
        ModulesDependenciesPanel.initTree(this.myLeftTree, false);
        this.myLeftTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                DefaultMutableTreeNode expandedNode = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
                for (int i = 0; i < expandedNode.getChildCount(); ++i) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)expandedNode.getChildAt(i);
                    if (child.getChildCount() != 0) continue;
                    Module module = ((MyUserObject)child.getUserObject()).getModule();
                    Iterator out = ModulesDependenciesPanel.this.myModulesGraph.getOut((Object)module);
                    while (out.hasNext()) {
                        Module nextModule = (Module)out.next();
                        child.add(new DefaultMutableTreeNode(new MyUserObject(false, nextModule)));
                    }
                    ModulesDependenciesPanel.sortSubTree(child);
                }
            }
        });
        this.myLeftTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath selectionPath = ModulesDependenciesPanel.this.myLeftTree.getSelectionPath();
                if (selectionPath != null) {
                    ModulesDependenciesPanel.this.myPathField.setText(StringUtil.join((Object[])selectionPath.getPath(), (Function)new Function<Object, String>(){

                        public String fun(Object o) {
                            Object userObject = ((DefaultMutableTreeNode)o).getUserObject();
                            if (userObject instanceof MyUserObject) {
                                return ((MyUserObject)userObject).getModule().getName();
                            }
                            return "";
                        }
                    }, (String)":"));
                    DefaultMutableTreeNode selection = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
                    if (selection != null) {
                        TreeUtil.traverseDepth((TreeNode)selection, (TreeUtil.Traverse)new TreeUtil.Traverse(){

                            public boolean accept(Object node) {
                                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
                                if (treeNode.getUserObject() instanceof MyUserObject) {
                                    ((MyUserObject)treeNode.getUserObject()).setInCycle(false);
                                }
                                return true;
                            }
                        });
                        ModulesDependenciesPanel.this.selectCycleUpward(selection);
                        ModulesDependenciesPanel.this.buildRightTree(((MyUserObject)selection.getUserObject()).getModule());
                    }
                }
            }
        });
        TreeUtil.selectFirstNode((JTree)this.myLeftTree);
    }

    private static ActionGroup createTreePopupActions(final boolean isRightTree, final Tree tree) {
        DefaultActionGroup group = new DefaultActionGroup();
        TreeExpander treeExpander = new TreeExpander(){

            public void expandAll() {
                TreeUtil.expandAll((JTree)tree);
            }

            public boolean canExpand() {
                return isRightTree;
            }

            public void collapseAll() {
                TreeUtil.collapseAll((JTree)tree, (int)3);
            }

            public boolean canCollapse() {
                return true;
            }
        };
        CommonActionsManager actionManager = CommonActionsManager.getInstance();
        if (isRightTree) {
            group.add(actionManager.createExpandAllAction(treeExpander, (JComponent)tree));
        }
        group.add(actionManager.createCollapseAllAction(treeExpander, (JComponent)tree));
        ActionManager globalActionManager = ActionManager.getInstance();
        group.add(globalActionManager.getAction("EditSource"));
        group.add((AnAction)Separator.getInstance());
        group.add(globalActionManager.getAction("ShowPackageDeps"));
        group.add(globalActionManager.getAction("ShowBackwardPackageDeps"));
        group.add(globalActionManager.getAction("ShowPackageCycles"));
        return group;
    }

    private static void initTree(Tree tree, boolean isRightTree) {
        tree.getSelectionModel().setSelectionMode(1);
        tree.setCellRenderer((TreeCellRenderer)((Object)new MyTreeCellRenderer()));
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        UIUtil.setLineStyleAngled((JTree)tree);
        TreeUtil.installActions((JTree)tree);
        new TreeSpeedSearch(tree, new Convertor<TreePath, String>(){

            public String convert(TreePath o) {
                return o.getLastPathComponent().toString();
            }
        }, true);
        PopupHandler.installUnknownPopupHandler((JComponent)tree, (ActionGroup)ModulesDependenciesPanel.createTreePopupActions(isRightTree, tree), (ActionManager)ActionManager.getInstance());
    }

    private Graph<Module> buildGraph() {
        Graph graph = ModuleManager.getInstance((Project)this.myProject).moduleGraph();
        if (this.isForwardDirection()) {
            return graph;
        }
        return GraphAlgorithms.getInstance().invertEdgeDirections(graph);
    }

    public void setContent(Content content) {
        this.myContent = content;
    }

    public void beforeRootsChange(ModuleRootEvent event) {
    }

    public void rootsChanged(ModuleRootEvent event) {
        this.initLeftTreeModel();
        TreeUtil.selectFirstNode((JTree)this.myLeftTree);
    }

    private static class MyTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private MyTreeCellRenderer() {
        }

        public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
            if (!(userObject instanceof MyUserObject)) {
                if (userObject != null) {
                    this.append(userObject.toString(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                }
                return;
            }
            MyUserObject node = (MyUserObject)userObject;
            Module module = node.getModule();
            this.setIcon(ModuleType.get((Module)module).getIcon());
            if (node.isInCycle()) {
                this.append(module.getName(), SimpleTextAttributes.ERROR_ATTRIBUTES);
            } else {
                this.append(module.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        }
    }

    private static class MyTreePanel
    extends JPanel
    implements DataProvider {
        private final Tree myTree;
        private final Project myProject;

        public MyTreePanel(Tree tree, Project project) {
            super(new BorderLayout());
            this.myTree = tree;
            this.myProject = project;
            this.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myTree), "Center");
        }

        public Object getData(String dataId) {
            DefaultMutableTreeNode node;
            TreePath selectionPath;
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return this.myProject;
            }
            if (LangDataKeys.MODULE_CONTEXT.is(dataId) && (selectionPath = this.myTree.getLeadSelectionPath()) != null && selectionPath.getLastPathComponent() instanceof DefaultMutableTreeNode && (node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent()).getUserObject() instanceof MyUserObject) {
                return ((MyUserObject)node.getUserObject()).getModule();
            }
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                return ModulesDependenciesPanel.ourHelpID;
            }
            if (CommonDataKeys.NAVIGATABLE.is(dataId) && (selectionPath = this.myTree.getLeadSelectionPath()) != null && selectionPath.getLastPathComponent() instanceof DefaultMutableTreeNode && (node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent()).getUserObject() instanceof MyUserObject) {
                return node.getUserObject();
            }
            return null;
        }
    }

    private static class MyUserObject
    implements NavigatableWithText {
        private boolean myInCycle;
        private final Module myModule;

        public MyUserObject(boolean inCycle, Module module) {
            this.myInCycle = inCycle;
            this.myModule = module;
        }

        public boolean isInCycle() {
            return this.myInCycle;
        }

        public void setInCycle(boolean inCycle) {
            this.myInCycle = inCycle;
        }

        public Module getModule() {
            return this.myModule;
        }

        public boolean equals(Object object) {
            return object instanceof MyUserObject && this.myModule.equals(((MyUserObject)object).getModule());
        }

        public int hashCode() {
            return this.myModule.hashCode();
        }

        public String toString() {
            return this.myModule.getName();
        }

        public void navigate(boolean requestFocus) {
            ProjectSettingsService.getInstance(this.myModule.getProject()).openModuleSettings(this.myModule);
        }

        public boolean canNavigate() {
            return this.myModule != null && !this.myModule.isDisposed();
        }

        public boolean canNavigateToSource() {
            return false;
        }

        public String getNavigateActionText(boolean focusEditor) {
            return "Open Module Settings";
        }
    }
}

