/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.service.project.ProjectStructureHelper;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractDependencyDataService;
import com.intellij.openapi.externalSystem.service.project.manage.ModuleDataService;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.Pair;
import com.intellij.util.BooleanFunction;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@Order(value=42)
public class ModuleDependencyDataService
extends AbstractDependencyDataService<ModuleDependencyData, ModuleOrderEntry> {
    private static final Logger LOG = Logger.getInstance((String)("#" + ModuleDependencyDataService.class.getName()));
    @NotNull
    private final ProjectStructureHelper myProjectStructureHelper;
    @NotNull
    private final ModuleDataService myModuleDataManager;

    public ModuleDependencyDataService(@NotNull ProjectStructureHelper projectStructureHelper, @NotNull ModuleDataService manager) {
        if (projectStructureHelper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectStructureHelper", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDependencyDataService", "<init>"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDependencyDataService", "<init>"));
        }
        this.myProjectStructureHelper = projectStructureHelper;
        this.myModuleDataManager = manager;
    }

    @NotNull
    public Key<ModuleDependencyData> getTargetDataKey() {
        Key key = ProjectKeys.MODULE_DEPENDENCY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDependencyDataService", "getTargetDataKey"));
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<ModuleDependencyData>> toImport, @NotNull Project project, boolean synchronous) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDependencyDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDependencyDataService", "importData"));
        }
        Map byModule = ExternalSystemApiUtil.groupBy(toImport, (Key)ProjectKeys.MODULE);
        for (Map.Entry entry : byModule.entrySet()) {
            Module ideModule = this.myProjectStructureHelper.findIdeModule((ModuleData)((DataNode)entry.getKey()).getData(), project);
            if (ideModule == null) {
                this.myModuleDataManager.importData(Collections.singleton(entry.getKey()), project, true);
                ideModule = this.myProjectStructureHelper.findIdeModule((ModuleData)((DataNode)entry.getKey()).getData(), project);
            }
            if (ideModule == null) {
                LOG.warn(String.format("Can't import module dependencies %s. Reason: target module (%s) is not found at the ide and can't be imported", entry.getValue(), entry.getKey()));
                continue;
            }
            this.importData((Collection<DataNode<ModuleDependencyData>>)((Collection)entry.getValue()), ideModule, synchronous);
        }
    }

    public void importData(final @NotNull Collection<DataNode<ModuleDependencyData>> toImport, final @NotNull Module module, final boolean synchronous) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDependencyDataService", "importData"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDependencyDataService", "importData"));
        }
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)synchronous, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)module){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute() {
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                HashMap toRemove = ContainerUtilRt.newHashMap();
                for (OrderEntry entry : moduleRootManager.getOrderEntries()) {
                    if (!(entry instanceof ModuleOrderEntry)) continue;
                    ModuleOrderEntry e = (ModuleOrderEntry)entry;
                    toRemove.put(Pair.create((Object)e.getModuleName(), (Object)e.getScope()), e);
                }
                ModifiableRootModel moduleRootModel = moduleRootManager.getModifiableModel();
                try {
                    for (DataNode dependencyNode : toImport) {
                        DataNode n;
                        DataNode projectNode;
                        final ModuleDependencyData dependencyData = (ModuleDependencyData)dependencyNode.getData();
                        toRemove.remove(Pair.create((Object)dependencyData.getInternalName(), (Object)dependencyData.getScope()));
                        String moduleName = dependencyData.getInternalName();
                        Module ideDependencyModule = ModuleDependencyDataService.this.myProjectStructureHelper.findIdeModule(moduleName, module.getProject());
                        if (ideDependencyModule == null && (projectNode = dependencyNode.getDataNode(ProjectKeys.PROJECT)) != null && (n = ExternalSystemApiUtil.find((DataNode)projectNode, (Key)ProjectKeys.MODULE, (BooleanFunction)new BooleanFunction<DataNode<ModuleData>>(){

                            public boolean fun(DataNode<ModuleData> node) {
                                return ((ModuleData)node.getData()).equals((Object)dependencyData.getTarget());
                            }
                        })) != null) {
                            ModuleDependencyDataService.this.myModuleDataManager.importData(Collections.singleton(n), module.getProject(), true);
                            ideDependencyModule = ModuleDependencyDataService.this.myProjectStructureHelper.findIdeModule(moduleName, module.getProject());
                        }
                        if (ideDependencyModule == null) {
                            assert (false);
                            return;
                        }
                        if (ideDependencyModule.equals(module)) continue;
                        ModuleOrderEntry orderEntry = ModuleDependencyDataService.this.myProjectStructureHelper.findIdeModuleDependency(dependencyData, moduleRootModel);
                        if (orderEntry == null) {
                            orderEntry = moduleRootModel.addModuleOrderEntry(ideDependencyModule);
                        }
                        orderEntry.setScope(dependencyData.getScope());
                        orderEntry.setExported(dependencyData.isExported());
                    }
                }
                finally {
                    moduleRootModel.commit();
                }
                if (!toRemove.isEmpty()) {
                    ModuleDependencyDataService.this.removeData(toRemove.values(), module, synchronous);
                }
            }
        });
    }
}

