/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsDataStorage;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectDataManager {
    private static final Logger LOG = Logger.getInstance((String)("#" + ProjectDataManager.class.getName()));
    @NotNull
    private final NotNullLazyValue<Map<Key<?>, List<ProjectDataService<?, ?>>>> myServices = new NotNullLazyValue<Map<Key<?>, List<ProjectDataService<?, ?>>>>(){

        @NotNull
        protected Map<Key<?>, List<ProjectDataService<?, ?>>> compute() {
            HashMap result = ContainerUtilRt.newHashMap();
            for (ProjectDataService service : (ProjectDataService[])ProjectDataService.EP_NAME.getExtensions()) {
                List services = (List)result.get(service.getTargetDataKey());
                if (services == null) {
                    services = ContainerUtilRt.newArrayList();
                    result.put(service.getTargetDataKey(), services);
                }
                services.add(service);
            }
            for (List services : result.values()) {
                ExternalSystemApiUtil.orderAwareSort((List)services);
            }
            HashMap hashMap = result;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager$1", "compute"));
            }
            return hashMap;
        }
    };

    public static ProjectDataManager getInstance() {
        return (ProjectDataManager)ServiceManager.getService(ProjectDataManager.class);
    }

    @Nullable
    public ProjectDataService<?, ?> getDataService(Key<?> key) {
        List dataServices = (List)((Map)this.myServices.getValue()).get(key);
        assert (dataServices == null || dataServices.isEmpty() || dataServices.size() == 1);
        return (ProjectDataService)ContainerUtil.getFirstItem((List)dataServices);
    }

    public <T> void importData(@NotNull Collection<DataNode<?>> nodes, @NotNull Project project, boolean synchronous) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "importData"));
        }
        if (project.isDisposed()) {
            return;
        }
        Map grouped = ExternalSystemApiUtil.group(nodes);
        for (Map.Entry entry : grouped.entrySet()) {
            ArrayList dummy = ContainerUtilRt.newArrayList();
            for (DataNode node : (List)entry.getValue()) {
                dummy.add(node);
            }
            this.importData((Key)entry.getKey(), dummy, project, synchronous);
        }
    }

    public <T> void importData(@NotNull Key<T> key, @NotNull Collection<DataNode<T>> nodes, @NotNull Project project, boolean synchronous) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "importData"));
        }
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "importData"));
        }
        if (project.isDisposed()) {
            return;
        }
        this.ensureTheDataIsReadyToUse(nodes);
        List services = (List)((Map)this.myServices.getValue()).get(key);
        if (services == null) {
            LOG.warn(String.format("Can't import data nodes '%s'. Reason: no service is registered for key %s. Available services for %s", nodes, key, ((Map)this.myServices.getValue()).keySet()));
        } else {
            for (ProjectDataService service : services) {
                service.importData(nodes, project, synchronous);
            }
        }
        ArrayList children = ContainerUtilRt.newArrayList();
        for (DataNode<?> node : nodes) {
            children.addAll(node.getChildren());
        }
        this.importData(children, project, synchronous);
    }

    public void ensureTheDataIsReadyToUse(DataNode dataNode) {
        final Map servicesByKey = (Map)this.myServices.getValue();
        ExternalSystemApiUtil.visit((DataNode)dataNode, (Consumer)new Consumer<DataNode>(){

            public void consume(DataNode dataNode) {
                List services = (List)servicesByKey.get(dataNode.getKey());
                if (services != null) {
                    try {
                        dataNode.prepareData((ClassLoader[])ContainerUtil.map2Array((Collection)services, ClassLoader.class, (Function)new Function<ProjectDataService<?, ?>, ClassLoader>(){

                            public ClassLoader fun(ProjectDataService<?, ?> service) {
                                return service.getClass().getClassLoader();
                            }
                        }));
                    }
                    catch (Exception e) {
                        LOG.debug((Throwable)e);
                        dataNode.clear(true);
                    }
                }
            }
        });
    }

    private void ensureTheDataIsReadyToUse(@NotNull Collection<DataNode<?>> nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "ensureTheDataIsReadyToUse"));
        }
        for (DataNode<?> node : nodes) {
            this.ensureTheDataIsReadyToUse(node);
        }
    }

    public <T> void removeData(@NotNull Key<?> key, @NotNull Collection<T> toRemove, @NotNull Project project, boolean synchronous) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "removeData"));
        }
        if (toRemove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRemove", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "removeData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "removeData"));
        }
        List services = (List)((Map)this.myServices.getValue()).get(key);
        for (ProjectDataService service : services) {
            service.removeData(toRemove, project, synchronous);
        }
    }

    public void updateExternalProjectData(@NotNull Project project, @NotNull ExternalProjectInfo externalProjectInfo) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "updateExternalProjectData"));
        }
        if (externalProjectInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProjectInfo", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "updateExternalProjectData"));
        }
        if (!project.isDisposed()) {
            ExternalProjectsManager.getInstance(project).updateExternalProjectData(externalProjectInfo);
        }
    }

    @Nullable
    public ExternalProjectInfo getExternalProjectData(@NotNull Project project, @NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "getExternalProjectData"));
        }
        if (projectSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSystemId", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "getExternalProjectData"));
        }
        if (externalProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProjectPath", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "getExternalProjectData"));
        }
        return !project.isDisposed() ? ExternalProjectsDataStorage.getInstance(project).get(projectSystemId, externalProjectPath) : null;
    }

    @NotNull
    public Collection<ExternalProjectInfo> getExternalProjectsData(@NotNull Project project, @NotNull ProjectSystemId projectSystemId) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "getExternalProjectsData"));
        }
        if (projectSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSystemId", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "getExternalProjectsData"));
        }
        Collection<Object> collection = !project.isDisposed() ? ExternalProjectsDataStorage.getInstance(project).list(projectSystemId) : ContainerUtil.emptyList();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "getExternalProjectsData"));
        }
        return collection;
    }
}

