/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.file.exclude.ui;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.file.exclude.EnforcedPlainTextFileTypeManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;

public class MarkAsOriginalTypeAction
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        VirtualFile[] selectedFiles = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (selectedFiles == null || selectedFiles.length == 0) {
            return;
        }
        ArrayList<VirtualFile> filesToUnmark = new ArrayList<VirtualFile>();
        for (VirtualFile file : selectedFiles) {
            if (file == null || file.isDirectory()) continue;
            filesToUnmark.add(file);
        }
        EnforcedPlainTextFileTypeManager typeManager = EnforcedPlainTextFileTypeManager.getInstance();
        assert (typeManager != null);
        if (project != null) {
            typeManager.resetOriginalFileType(project, filesToUnmark.toArray(new VirtualFile[filesToUnmark.size()]));
        }
    }

    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        VirtualFile[] selectedFiles = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        Presentation presentation = e.getPresentation();
        EnforcedPlainTextFileTypeManager typeManager = EnforcedPlainTextFileTypeManager.getInstance();
        presentation.setVisible(false);
        if (typeManager == null || selectedFiles == null || selectedFiles.length == 0) {
            return;
        }
        FileType originalType = null;
        for (VirtualFile file : selectedFiles) {
            if (typeManager.isMarkedAsPlainText(file)) {
                FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(file.getName());
                if (originalType == null) {
                    originalType = fileType;
                    continue;
                }
                if (fileType == originalType) continue;
                return;
            }
            return;
        }
        if (originalType == null) {
            return;
        }
        presentation.setVisible(true);
        presentation.setText(ActionsBundle.actionText((String)"MarkAsOriginalTypeAction") + " " + originalType.getName());
        presentation.setIcon(originalType.getIcon());
    }
}

