/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.updateSettings.impl.AbstractUpdateDialog;
import com.intellij.openapi.updateSettings.impl.DetectedPluginsPanel;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.TableUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;

class PluginUpdateInfoDialog
extends AbstractUpdateDialog {
    private final Collection<PluginDownloader> myUploadedPlugins;
    private final boolean myPlatformUpdate;

    public PluginUpdateInfoDialog(Collection<PluginDownloader> uploadedPlugins, boolean enableLink) {
        super(enableLink);
        this.myUploadedPlugins = uploadedPlugins;
        this.myPlatformUpdate = false;
        this.init();
    }

    PluginUpdateInfoDialog(Component parent, @NotNull Collection<PluginDownloader> updatePlugins) {
        if (updatePlugins == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updatePlugins", "com/intellij/openapi/updateSettings/impl/PluginUpdateInfoDialog", "<init>"));
        }
        super(parent, false);
        this.myUploadedPlugins = updatePlugins;
        this.myPlatformUpdate = true;
        this.init();
    }

    protected JComponent createCenterPanel() {
        return new PluginUpdateInfoPanel().myPanel;
    }

    @Override
    protected String getOkButtonText() {
        if (!this.myPlatformUpdate) {
            return IdeBundle.message((String)"update.plugins.update.action", (Object[])new Object[0]);
        }
        boolean canRestart = ApplicationManager.getApplication().isRestartCapable();
        return IdeBundle.message((String)(canRestart ? "update.restart.plugins.update.action" : "update.shutdown.plugins.update.action"), (Object[])new Object[0]);
    }

    protected void doOKAction() {
        super.doOKAction();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(null, IdeBundle.message((String)"progress.downloading.plugins", (Object[])new Object[0]), true, PerformInBackgroundOption.DEAF){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/updateSettings/impl/PluginUpdateInfoDialog$1", "run"));
                }
                UpdateChecker.saveDisabledToUpdatePlugins();
                boolean updated = UpdateChecker.installPluginUpdates(PluginUpdateInfoDialog.this.myUploadedPlugins, indicator);
                if (updated && !PluginUpdateInfoDialog.this.myPlatformUpdate) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PluginManagerMain.notifyPluginsUpdated(null);
                        }
                    }, ModalityState.NON_MODAL);
                }
            }
        });
    }

    private class PluginUpdateInfoPanel {
        private JPanel myPanel;
        private JLabel myPluginsToUpdateLabel;
        private JPanel myPluginsPanel;
        private JEditorPane myMessageArea;

        public PluginUpdateInfoPanel() {
            this.$$$setupUI$$$();
            this.myPluginsToUpdateLabel.setVisible(true);
            this.myPluginsPanel.setVisible(true);
            final DetectedPluginsPanel foundPluginsPanel = new DetectedPluginsPanel();
            foundPluginsPanel.addAll(PluginUpdateInfoDialog.this.myUploadedPlugins);
            TableUtil.ensureSelectionExists((JTable)foundPluginsPanel.getEntryTable());
            foundPluginsPanel.addStateListener(new DetectedPluginsPanel.Listener(){

                @Override
                public void stateChanged() {
                    final Set<String> skipped = foundPluginsPanel.getSkippedPlugins();
                    PluginDownloader any = (PluginDownloader)ContainerUtil.find((Iterable)PluginUpdateInfoDialog.this.myUploadedPlugins, (Condition)new Condition<PluginDownloader>(){

                        public boolean value(PluginDownloader plugin) {
                            return !skipped.contains(plugin.getPluginId());
                        }
                    });
                    PluginUpdateInfoDialog.this.getOKAction().setEnabled(any != null);
                }
            });
            this.myPluginsPanel.add((Component)((Object)foundPluginsPanel), "Center");
            PluginUpdateInfoDialog.this.configureMessageArea(this.myMessageArea);
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JEditorPane jEditorPane;
            JPanel jPanel;
            JLabel jLabel;
            JPanel jPanel2;
            this.myPanel = jPanel2 = new JPanel();
            jPanel2.setLayout(new GridBagLayout());
            this.myPluginsToUpdateLabel = jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.plugins.ready.header"));
            jLabel.setPreferredSize(new Dimension(268, 30));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.fill = 2;
            jPanel2.add((Component)jLabel, gridBagConstraints);
            this.myPluginsPanel = jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout(0, 0));
            jPanel.setPreferredSize(new Dimension(600, 400));
            jPanel.setAutoscrolls(false);
            jPanel.setMinimumSize(new Dimension(600, 400));
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.insets = new Insets(3, 0, 3, 0);
            jPanel2.add((Component)jPanel, gridBagConstraints2);
            this.myMessageArea = jEditorPane = new JEditorPane();
            jEditorPane.setContentType("text/html");
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.fill = 1;
            jPanel2.add((Component)jEditorPane, gridBagConstraints3);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

