/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDefaultExecutor;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDifferentiatedDialog;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchExecutor;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchMode;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collections;

public class UnshelveWithDialogAction
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        ShelvedChangeList[] changeLists = (ShelvedChangeList[])e.getData(ShelvedChangesViewManager.SHELVED_CHANGELIST_KEY);
        if (project == null || changeLists == null || changeLists.length != 1) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(changeLists[0].PATH));
        if (virtualFile == null) {
            VcsBalloonProblemNotifier.showOverChangesView(project, "Can not find path file", MessageType.ERROR, new NamedRunnable[0]);
            return;
        }
        if (!changeLists[0].getBinaryFiles().isEmpty()) {
            VcsBalloonProblemNotifier.showOverChangesView(project, "Binary file(s) would be skipped.", MessageType.WARNING, new NamedRunnable[0]);
        }
        ApplyPatchDifferentiatedDialog dialog = new ApplyPatchDifferentiatedDialog(project, new ApplyPatchDefaultExecutor(project), Collections.<ApplyPatchExecutor>emptyList(), ApplyPatchMode.UNSHELVE, virtualFile);
        dialog.setHelpId("reference.dialogs.vcs.unshelve");
        dialog.show();
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        ShelvedChangeList[] changes = (ShelvedChangeList[])e.getData(ShelvedChangesViewManager.SHELVED_CHANGELIST_KEY);
        e.getPresentation().setEnabled(project != null && changes != null && changes.length == 1);
    }
}

