/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.alignment.AlignmentStrategy;
import com.intellij.lang.ASTNode;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.formatter.java.SyntheticCodeBlock;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import java.util.ArrayList;
import java.util.List;

public class ExtendsListBlock
extends AbstractJavaBlock {
    public ExtendsListBlock(ASTNode node, Wrap wrap, Alignment alignment, CommonCodeStyleSettings settings, JavaCodeStyleSettings javaSettings) {
        super(node, wrap, alignment, Indent.getNoneIndent(), settings, javaSettings);
    }

    public ExtendsListBlock(ASTNode node, Wrap wrap, AlignmentStrategy alignmentStrategy, CommonCodeStyleSettings settings, JavaCodeStyleSettings javaSettings) {
        super(node, wrap, alignmentStrategy, Indent.getNoneIndent(), settings, javaSettings);
    }

    @Override
    protected List<Block> buildChildren() {
        Alignment alignment;
        ArrayList<Block> result = new ArrayList<Block>();
        ArrayList<Object> elementsExceptKeyword = new ArrayList<Block>();
        this.myChildAlignment = this.createChildAlignment();
        this.myChildIndent = Indent.getContinuationIndent((boolean)this.myIndentSettings.USE_RELATIVE_INDENTS);
        this.myUseChildAttributes = true;
        Wrap childWrap = this.createChildWrap();
        Object object = alignment = this.alignList() ? Alignment.createAlignment() : null;
        for (ASTNode child = this.myNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (FormatterUtil.containsWhiteSpacesOnly(child) || child.getTextLength() <= 0) continue;
            if (ElementType.KEYWORD_BIT_SET.contains(child.getElementType())) {
                if (!elementsExceptKeyword.isEmpty()) {
                    result.add(new SyntheticCodeBlock(elementsExceptKeyword, null, this.mySettings, this.myJavaSettings, Indent.getNoneIndent(), null));
                    elementsExceptKeyword = new ArrayList();
                }
                result.add(ExtendsListBlock.createJavaBlock(child, this.mySettings, this.myJavaSettings, this.myChildIndent, this.arrangeChildWrap(child, childWrap), alignment));
                continue;
            }
            Alignment candidate = this.myAlignmentStrategy.getAlignment(child.getElementType());
            if (candidate != null) {
                alignment = this.myChildAlignment = candidate;
            }
            this.processChild(elementsExceptKeyword, child, this.myChildAlignment, childWrap, this.myChildIndent);
        }
        if (!elementsExceptKeyword.isEmpty()) {
            result.add(new SyntheticCodeBlock(elementsExceptKeyword, alignment, this.mySettings, this.myJavaSettings, Indent.getNoneIndent(), null));
        }
        return result;
    }

    private boolean alignList() {
        if (this.myNode.getElementType() == JavaElementType.EXTENDS_LIST || this.myNode.getElementType() == JavaElementType.IMPLEMENTS_LIST) {
            return this.mySettings.ALIGN_MULTILINE_EXTENDS_LIST;
        }
        if (this.myNode.getElementType() == JavaElementType.THROWS_LIST) {
            return this.mySettings.ALIGN_MULTILINE_THROWS_LIST;
        }
        return false;
    }
}

