/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.changeSignature.LanguageChangeSignatureDetector;
import com.intellij.refactoring.changeSignature.LanguageChangeSignatureDetectors;

public abstract class MoveParameterAction
extends AnAction {
    private final boolean myLeft;
    private static final Logger LOG = Logger.getInstance((String)("#" + MoveParameterAction.class.getName()));

    public MoveParameterAction(boolean left) {
        this.myLeft = left;
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        PsiElement psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        LOG.assertTrue(psiElement != null);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        ((LanguageChangeSignatureDetector)LanguageChangeSignatureDetectors.INSTANCE.forLanguage(psiElement.getLanguage())).moveParameter(psiElement, editor, this.myLeft);
    }

    public void update(AnActionEvent e) {
        LanguageChangeSignatureDetector detector;
        PsiElement psiElement;
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(false);
        DataContext dataContext = e.getDataContext();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null && (psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext)) != null && (detector = (LanguageChangeSignatureDetector)LanguageChangeSignatureDetectors.INSTANCE.forLanguage(psiElement.getLanguage())) != null) {
            boolean available = detector.isMoveParameterAvailable(psiElement, this.myLeft);
            presentation.setEnabled(available);
            presentation.setVisible(available);
        }
    }
}

