/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DefaultScopesProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.TestsScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.tabs.FileColorConfiguration;
import com.intellij.ui.tabs.FileColorManagerImpl;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileColorsModel
implements Cloneable {
    public static final String FILE_COLOR = "fileColor";
    private final List<FileColorConfiguration> myConfigurations;
    private final List<FileColorConfiguration> mySharedConfigurations;
    private static final Map<String, String> globalScopes = new HashMap<String, String>();
    private static final Map<String, String> globalScopesColors;
    @NotNull
    private final Project myProject;

    FileColorsModel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ui/tabs/FileColorsModel", "<init>"));
        }
        this.myProject = project;
        this.myConfigurations = new ArrayList<FileColorConfiguration>();
        this.mySharedConfigurations = new ArrayList<FileColorConfiguration>();
        if (globalScopesColors.size() < globalScopes.size()) {
            DefaultScopesProvider defaultScopesProvider = DefaultScopesProvider.getInstance(project);
            for (String scopeName : globalScopes.keySet()) {
                NamedScope scope = defaultScopesProvider.findCustomScope(scopeName);
                assert (scope != null) : "There is no custom scope with name " + scopeName;
                Color color = ColorUtil.getColor(scope.getClass());
                assert (color != null) : scope.getClass().getName() + " is not annotated with @Colored";
                String colorName = FileColorManagerImpl.getColorName(color);
                globalScopesColors.put(scopeName, colorName == null ? ColorUtil.toHex((Color)color) : colorName);
            }
        }
        this.initGlobalScopes();
    }

    private FileColorsModel(@NotNull Project project, @NotNull List<FileColorConfiguration> regular, @NotNull List<FileColorConfiguration> shared) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ui/tabs/FileColorsModel", "<init>"));
        }
        if (regular == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regular", "com/intellij/ui/tabs/FileColorsModel", "<init>"));
        }
        if (shared == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shared", "com/intellij/ui/tabs/FileColorsModel", "<init>"));
        }
        this.myProject = project;
        this.myConfigurations = new ArrayList<FileColorConfiguration>();
        this.mySharedConfigurations = new ArrayList<FileColorConfiguration>();
        this.myConfigurations.addAll(regular);
        this.mySharedConfigurations.addAll(shared);
        this.initGlobalScopes();
    }

    private void initGlobalScopes() {
        for (String scopeName : globalScopes.keySet()) {
            String color;
            if (this.findConfiguration(scopeName, false) != null || (color = PropertiesComponent.getInstance().getOrInit(globalScopes.get(scopeName), globalScopesColors.get(scopeName))).length() == 0) continue;
            Color col = ColorUtil.fromHex((String)color, null);
            String name = col == null ? null : FileColorManagerImpl.getColorName(col);
            this.myConfigurations.add(new FileColorConfiguration(scopeName, name == null ? color : name));
        }
    }

    public void save(Element e, boolean shared) {
        List<FileColorConfiguration> configurations = shared ? this.mySharedConfigurations : this.myConfigurations;
        for (FileColorConfiguration configuration : configurations) {
            String name = configuration.getScopeName();
            if (!shared && globalScopes.containsKey(name)) {
                PropertiesComponent.getInstance().setValue(name, configuration.getColorName());
                continue;
            }
            configuration.save(e);
        }
    }

    public void load(Element e, boolean shared) {
        List<FileColorConfiguration> configurations = shared ? this.mySharedConfigurations : this.myConfigurations;
        configurations.clear();
        List list = e.getChildren(FILE_COLOR);
        HashMap<String, String> global = new HashMap<String, String>(globalScopes);
        for (Element child : list) {
            String name;
            FileColorConfiguration configuration = FileColorConfiguration.load(child);
            if (configuration == null) continue;
            if (!shared && globalScopes.get(name = configuration.getScopeName()) != null) {
                global.remove(name);
            }
            configurations.add(configuration);
        }
        if (!shared) {
            PropertiesComponent properties = PropertiesComponent.getInstance();
            for (String scope : global.keySet()) {
                String colorName = properties.getValue(scope);
                if (colorName == null) continue;
                configurations.add(new FileColorConfiguration(scope, colorName));
            }
        }
    }

    public FileColorsModel clone() throws CloneNotSupportedException {
        ArrayList<FileColorConfiguration> regular = new ArrayList<FileColorConfiguration>();
        for (FileColorConfiguration configuration : this.myConfigurations) {
            regular.add(configuration.clone());
        }
        ArrayList<FileColorConfiguration> shared = new ArrayList<FileColorConfiguration>();
        for (FileColorConfiguration sharedConfiguration : this.mySharedConfigurations) {
            shared.add(sharedConfiguration.clone());
        }
        return new FileColorsModel(this.myProject, regular, shared);
    }

    public void add(@NotNull FileColorConfiguration configuration, boolean shared) {
        List<FileColorConfiguration> configurations;
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/ui/tabs/FileColorsModel", "add"));
        }
        List<FileColorConfiguration> list = configurations = shared ? this.mySharedConfigurations : this.myConfigurations;
        if (!configurations.contains(configuration)) {
            configurations.add(configuration);
        }
    }

    public void add(@NotNull String scopeName, @NotNull String colorName, boolean shared) {
        if (scopeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeName", "com/intellij/ui/tabs/FileColorsModel", "add"));
        }
        if (colorName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorName", "com/intellij/ui/tabs/FileColorsModel", "add"));
        }
        FileColorConfiguration configuration = new FileColorConfiguration();
        configuration.setScopeName(scopeName);
        configuration.setColorName(colorName);
        this.add(configuration, shared);
    }

    @Nullable
    private FileColorConfiguration findConfiguration(String scopeName, boolean shared) {
        List<FileColorConfiguration> configurations = shared ? this.mySharedConfigurations : this.myConfigurations;
        for (FileColorConfiguration configuration : configurations) {
            if (!scopeName.equals(configuration.getScopeName())) continue;
            return configuration;
        }
        return null;
    }

    public boolean isShared(@NotNull String scopeName) {
        if (scopeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeName", "com/intellij/ui/tabs/FileColorsModel", "isShared"));
        }
        return this.findConfiguration(scopeName, true) != null;
    }

    @Nullable
    public String getColor(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/ui/tabs/FileColorsModel", "getColor"));
        }
        if (!psiFile.isValid()) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        return virtualFile == null ? null : this.getColor(virtualFile, psiFile.getProject());
    }

    @Nullable
    public String getColor(@NotNull VirtualFile file, Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ui/tabs/FileColorsModel", "getColor"));
        }
        if (!file.isValid()) {
            return null;
        }
        FileColorConfiguration configuration = this.findConfiguration(file);
        if (configuration != null && configuration.isValid(project)) {
            return configuration.getColorName();
        }
        return null;
    }

    @Nullable
    private FileColorConfiguration findConfiguration(@NotNull VirtualFile colored) {
        if (colored == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colored", "com/intellij/ui/tabs/FileColorsModel", "findConfiguration"));
        }
        for (FileColorConfiguration configuration : ContainerUtil.concat(this.myConfigurations, this.mySharedConfigurations)) {
            NamedScope scope = NamedScopesHolder.getScope((Project)this.myProject, (String)configuration.getScopeName());
            if (scope == null) continue;
            NamedScopesHolder namedScopesHolder = NamedScopesHolder.getHolder((Project)this.myProject, (String)configuration.getScopeName(), null);
            PackageSet packageSet = scope.getValue();
            if (!(packageSet instanceof PackageSetBase) || namedScopesHolder == null || !((PackageSetBase)packageSet).contains(colored, this.myProject, namedScopesHolder)) continue;
            return configuration;
        }
        return null;
    }

    public boolean isShared(FileColorConfiguration configuration) {
        return this.mySharedConfigurations.contains(configuration);
    }

    public void setConfigurations(List<FileColorConfiguration> configurations, boolean shared) {
        if (shared) {
            this.mySharedConfigurations.clear();
            this.mySharedConfigurations.addAll(configurations);
        } else {
            this.myConfigurations.clear();
            HashMap<String, String> global = new HashMap<String, String>(globalScopes);
            for (FileColorConfiguration configuration : configurations) {
                this.myConfigurations.add(configuration);
                String name = configuration.getScopeName();
                if (!global.containsKey(name)) continue;
                PropertiesComponent.getInstance().setValue(global.get(name), configuration.getColorName());
                global.remove(name);
            }
            for (String name : global.keySet()) {
                PropertiesComponent.getInstance().setValue(global.get(name), "");
            }
        }
    }

    public boolean isColored(String scopeName, boolean shared) {
        return this.findConfiguration(scopeName, shared) != null;
    }

    public List<FileColorConfiguration> getLocalConfigurations() {
        return this.myConfigurations;
    }

    public List<FileColorConfiguration> getSharedConfigurations() {
        return this.mySharedConfigurations;
    }

    static {
        globalScopes.put("Non-Project Files", "file.colors.enable.non.project");
        if (PlatformUtils.isIntelliJ() || PlatformUtils.isRubyMine()) {
            globalScopes.put(TestsScope.NAME, "file.colors.enable.tests");
        }
        globalScopesColors = new HashMap<String, String>();
    }
}

