/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.FormatUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class StringConcatenationInFormatCallInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("string.concatenation.in.format.call.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/StringConcatenationInFormatCallInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("string.concatenation.in.format.call.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/StringConcatenationInFormatCallInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new StringConcatenationInFormatCallFix((Boolean)infos[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringConcatenationInFormatCallVisitor();
    }

    private static class StringConcatenationInFormatCallVisitor
    extends BaseInspectionVisitor {
        private StringConcatenationInFormatCallVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            PsiExpression operand;
            super.visitMethodCallExpression(expression);
            if (!FormatUtils.isFormatCall(expression)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression formatArgument = FormatUtils.getFormatArgument(argumentList);
            if (!ExpressionUtils.hasStringType(formatArgument)) {
                return;
            }
            if (!(formatArgument instanceof PsiPolyadicExpression)) {
                return;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)formatArgument;
            PsiExpression[] operands = polyadicExpression.getOperands();
            int count = 0;
            PsiExpression[] arr$ = operands;
            int len$ = arr$.length;
            for (int i$ = 0; !(i$ >= len$ || (operand = arr$[i$]) instanceof PsiReferenceExpression && ++count > 1); ++i$) {
            }
            if (count == 0) {
                return;
            }
            this.registerMethodCallError(expression, count > 1);
        }
    }

    private static class StringConcatenationInFormatCallFix
    extends InspectionGadgetsFix {
        private final boolean myPlural;

        public StringConcatenationInFormatCallFix(boolean plural) {
            this.myPlural = plural;
        }

        @NotNull
        public String getName() {
            if (this.myPlural) {
                String string = InspectionGadgetsBundle.message("string.concatenation.in.format.call.plural.quickfix", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/StringConcatenationInFormatCallInspection$StringConcatenationInFormatCallFix", "getName"));
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("string.concatenation.in.format.call.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/StringConcatenationInFormatCallInspection$StringConcatenationInFormatCallFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("string.concatenation.in.format.call.plural.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/StringConcatenationInFormatCallInspection$StringConcatenationInFormatCallFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiExpression[] operands;
            PsiElement element = descriptor.getPsiElement().getParent().getParent();
            if (!(element instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression formatArgument = FormatUtils.getFormatArgument(argumentList);
            if (!(formatArgument instanceof PsiPolyadicExpression)) {
                return;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)formatArgument;
            StringBuilder newExpression = new StringBuilder();
            for (PsiExpression operand : operands = polyadicExpression.getOperands()) {
                if (operand instanceof PsiReferenceExpression) {
                    argumentList.add((PsiElement)operand);
                    continue;
                }
                PsiJavaToken token = polyadicExpression.getTokenBeforeOperand(operand);
                if (token != null) {
                    newExpression.append(token.getText());
                }
                newExpression.append(operand.getText());
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)polyadicExpression, newExpression.toString());
        }
    }
}

