/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ui.CheckBox;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.SwitchUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IfCanBeSwitchInspection
extends BaseInspection {
    @NonNls
    private static final String ONLY_SAFE = "onlySuggestNullSafe";
    public int minimumBranches = 3;
    public boolean suggestIntSwitches = false;
    public boolean suggestEnumSwitches = false;
    private boolean onlySuggestNullSafe = true;

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("if.can.be.switch.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/IfCanBeSwitchInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("if.can.be.switch.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/IfCanBeSwitchInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new IfCanBeSwitchFix(this.minimumBranches);
    }

    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel label = new JLabel(InspectionGadgetsBundle.message("if.can.be.switch.minimum.branch.option", new Object[0]));
        NumberFormat formatter = NumberFormat.getIntegerInstance();
        formatter.setParseIntegerOnly(true);
        final JFormattedTextField valueField = new JFormattedTextField(formatter);
        valueField.setValue(this.minimumBranches);
        valueField.setColumns(2);
        Document document = valueField.getDocument();
        document.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(DocumentEvent e) {
                try {
                    valueField.commitEdit();
                    IfCanBeSwitchInspection.this.minimumBranches = ((Number)valueField.getValue()).intValue();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        });
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets.bottom = 4;
        constraints.weightx = 0.0;
        constraints.anchor = 512;
        constraints.fill = 0;
        constraints.insets.right = 10;
        panel.add((Component)label, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.insets.right = 0;
        panel.add((Component)valueField, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        CheckBox checkBox1 = new CheckBox(InspectionGadgetsBundle.message("if.can.be.switch.int.option", new Object[0]), (InspectionProfileEntry)this, "suggestIntSwitches");
        panel.add((Component)checkBox1, constraints);
        constraints.gridy = 2;
        CheckBox checkBox2 = new CheckBox(InspectionGadgetsBundle.message("if.can.be.switch.enum.option", new Object[0]), (InspectionProfileEntry)this, "suggestEnumSwitches");
        panel.add((Component)checkBox2, constraints);
        constraints.gridy = 3;
        constraints.weighty = 1.0;
        CheckBox checkBox3 = new CheckBox(InspectionGadgetsBundle.message("if.can.be.switch.null.safe.option", new Object[0]), (InspectionProfileEntry)this, ONLY_SAFE);
        panel.add((Component)checkBox3, constraints);
        return panel;
    }

    public void setOnlySuggestNullSafe(boolean onlySuggestNullSafe) {
        this.onlySuggestNullSafe = onlySuggestNullSafe;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IfCanBeSwitchVisitor();
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/siyeh/ig/migration/IfCanBeSwitchInspection", "writeSettings"));
        }
        super.writeSettings(node);
        if (!this.onlySuggestNullSafe) {
            Element e = new Element("option");
            e.setAttribute("name", ONLY_SAFE);
            e.setAttribute("value", Boolean.toString(this.onlySuggestNullSafe));
            node.addContent(e);
        }
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/siyeh/ig/migration/IfCanBeSwitchInspection", "readSettings"));
        }
        super.readSettings(node);
        for (Element child : node.getChildren("option")) {
            if (!Comparing.strEqual((String)child.getAttributeValue("name"), (String)ONLY_SAFE)) continue;
            String value = child.getAttributeValue("value");
            if (value == null) break;
            this.onlySuggestNullSafe = Boolean.parseBoolean(value);
            break;
        }
    }

    private class IfCanBeSwitchVisitor
    extends BaseInspectionVisitor {
        private IfCanBeSwitchVisitor() {
        }

        public void visitIfStatement(PsiIfStatement statement) {
            PsiClassType classType;
            PsiClass aClass;
            super.visitIfStatement(statement);
            PsiElement parent = statement.getParent();
            if (parent instanceof PsiIfStatement) {
                return;
            }
            PsiExpression switchExpression = SwitchUtils.getSwitchExpression(statement, IfCanBeSwitchInspection.this.minimumBranches, IfCanBeSwitchInspection.this.onlySuggestNullSafe);
            if (switchExpression == null) {
                return;
            }
            PsiType type = switchExpression.getType();
            if (!IfCanBeSwitchInspection.this.suggestIntSwitches && (type instanceof PsiClassType ? type.equalsToText("java.lang.Integer") || type.equalsToText("java.lang.Short") || type.equalsToText("java.lang.Byte") || type.equalsToText("java.lang.Character") : PsiType.INT.equals((Object)type) || PsiType.SHORT.equals((Object)type) || PsiType.BYTE.equals((Object)type) || PsiType.CHAR.equals((Object)type))) {
                return;
            }
            if (!IfCanBeSwitchInspection.this.suggestEnumSwitches && type instanceof PsiClassType && ((aClass = (classType = (PsiClassType)type).resolve()) == null || aClass.isEnum())) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, switchExpression);
        }
    }

    private static class IfCanBeSwitchFix
    extends InspectionGadgetsFix {
        private final int myMinimumBranches;

        public IfCanBeSwitchFix(int minimumBranches) {
            this.myMinimumBranches = minimumBranches;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/IfCanBeSwitchInspection$IfCanBeSwitchFix", "getFamilyName"));
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("if.can.be.switch.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/IfCanBeSwitchInspection$IfCanBeSwitchFix", "getName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiStatement elseBranch;
            PsiElement element = descriptor.getPsiElement().getParent();
            if (!(element instanceof PsiIfStatement)) {
                return;
            }
            PsiIfStatement ifStatement = (PsiIfStatement)element;
            boolean breaksNeedRelabeled = false;
            PsiStatement breakTarget = null;
            String labelString = "";
            if (ControlFlowUtils.statementContainsNakedBreak((PsiStatement)ifStatement) && (breakTarget = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)ifStatement, (Class[])new Class[]{PsiLoopStatement.class, PsiSwitchStatement.class})) != null) {
                PsiElement parent = breakTarget.getParent();
                if (parent instanceof PsiLabeledStatement) {
                    PsiLabeledStatement labeledStatement = (PsiLabeledStatement)parent;
                    labelString = labeledStatement.getLabelIdentifier().getText();
                    breakTarget = labeledStatement;
                    breaksNeedRelabeled = true;
                } else {
                    labelString = SwitchUtils.findUniqueLabelName((PsiStatement)ifStatement, "label");
                    breaksNeedRelabeled = true;
                }
            }
            PsiIfStatement statementToReplace = ifStatement;
            PsiExpression switchExpression = SwitchUtils.getSwitchExpression(ifStatement, this.myMinimumBranches);
            if (switchExpression == null) {
                return;
            }
            ArrayList<SwitchUtils.IfStatementBranch> branches = new ArrayList<SwitchUtils.IfStatementBranch>(20);
            while (true) {
                PsiExpression condition = ifStatement.getCondition();
                PsiStatement thenBranch = ifStatement.getThenBranch();
                SwitchUtils.IfStatementBranch ifBranch = new SwitchUtils.IfStatementBranch(thenBranch, false);
                IfCanBeSwitchFix.extractCaseExpressions(condition, switchExpression, ifBranch);
                if (!branches.isEmpty()) {
                    IfCanBeSwitchFix.extractIfComments((PsiElement)ifStatement, ifBranch);
                }
                IfCanBeSwitchFix.extractStatementComments((PsiElement)thenBranch, ifBranch);
                branches.add(ifBranch);
                elseBranch = ifStatement.getElseBranch();
                if (!(elseBranch instanceof PsiIfStatement)) break;
                ifStatement = (PsiIfStatement)elseBranch;
            }
            if (elseBranch != null) {
                SwitchUtils.IfStatementBranch elseIfBranch = new SwitchUtils.IfStatementBranch(elseBranch, true);
                PsiKeyword elseKeyword = ifStatement.getElseElement();
                IfCanBeSwitchFix.extractIfComments((PsiElement)elseKeyword, elseIfBranch);
                IfCanBeSwitchFix.extractStatementComments((PsiElement)elseBranch, elseIfBranch);
                branches.add(elseIfBranch);
            }
            StringBuilder switchStatementText = new StringBuilder();
            switchStatementText.append("switch(").append(switchExpression.getText()).append("){");
            PsiType type = switchExpression.getType();
            boolean castToInt = type != null && type.equalsToText("java.lang.Integer");
            for (SwitchUtils.IfStatementBranch branch : branches) {
                boolean hasConflicts = false;
                for (SwitchUtils.IfStatementBranch testBranch : branches) {
                    if (branch == testBranch || !branch.topLevelDeclarationsConflictWith(testBranch)) continue;
                    hasConflicts = true;
                }
                IfCanBeSwitchFix.dumpBranch(branch, castToInt, hasConflicts, breaksNeedRelabeled, labelString, switchStatementText);
            }
            switchStatementText.append('}');
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)element.getProject());
            PsiElementFactory factory = psiFacade.getElementFactory();
            if (breaksNeedRelabeled) {
                StringBuilder out = new StringBuilder();
                if (!(breakTarget instanceof PsiLabeledStatement)) {
                    out.append(labelString).append(':');
                }
                IfCanBeSwitchFix.termReplace((PsiElement)breakTarget, (PsiElement)statementToReplace, switchStatementText, out);
                String newStatementText = out.toString();
                PsiStatement newStatement = factory.createStatementFromText(newStatementText, element);
                breakTarget.replace((PsiElement)newStatement);
            } else {
                PsiStatement newStatement = factory.createStatementFromText(switchStatementText.toString(), element);
                statementToReplace.replace((PsiElement)newStatement);
            }
        }

        @Nullable
        public static <T extends PsiElement> T getPrevSiblingOfType(@Nullable PsiElement element, @NotNull Class<T> aClass, Class<? extends PsiElement> ... stopAt) {
            PsiElement sibling;
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/migration/IfCanBeSwitchInspection$IfCanBeSwitchFix", "getPrevSiblingOfType"));
            }
            if (stopAt == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stopAt", "com/siyeh/ig/migration/IfCanBeSwitchInspection$IfCanBeSwitchFix", "getPrevSiblingOfType"));
            }
            if (element == null) {
                return null;
            }
            for (sibling = element.getPrevSibling(); sibling != null && !aClass.isInstance(sibling); sibling = sibling.getPrevSibling()) {
                for (Class<? extends PsiElement> stopClass : stopAt) {
                    if (!stopClass.isInstance(sibling)) continue;
                    return null;
                }
            }
            return (T)sibling;
        }

        private static void extractIfComments(PsiElement element, SwitchUtils.IfStatementBranch out) {
            PsiComment comment = IfCanBeSwitchFix.getPrevSiblingOfType(element, PsiComment.class, PsiStatement.class);
            while (comment != null) {
                String whiteSpaceText;
                PsiElement sibling = comment.getPrevSibling();
                String commentText = sibling instanceof PsiWhiteSpace ? ((whiteSpaceText = sibling.getText()).startsWith("\n") ? whiteSpaceText.substring(1) + comment.getText() : comment.getText()) : comment.getText();
                out.addComment(commentText);
                comment = IfCanBeSwitchFix.getPrevSiblingOfType((PsiElement)comment, PsiComment.class, PsiStatement.class);
            }
        }

        private static void extractStatementComments(PsiElement element, SwitchUtils.IfStatementBranch out) {
            PsiComment comment = IfCanBeSwitchFix.getPrevSiblingOfType(element, PsiComment.class, PsiStatement.class, PsiKeyword.class);
            while (comment != null) {
                String whiteSpaceText;
                PsiElement sibling = comment.getPrevSibling();
                String commentText = sibling instanceof PsiWhiteSpace ? ((whiteSpaceText = sibling.getText()).startsWith("\n") ? whiteSpaceText.substring(1) + comment.getText() : comment.getText()) : comment.getText();
                out.addStatementComment(commentText);
                comment = IfCanBeSwitchFix.getPrevSiblingOfType((PsiElement)comment, PsiComment.class, PsiStatement.class, PsiKeyword.class);
            }
        }

        private static void termReplace(PsiElement target, PsiElement replace, StringBuilder stringToReplaceWith, StringBuilder out) {
            if (target.equals(replace)) {
                out.append((CharSequence)stringToReplaceWith);
            } else if (target.getChildren().length == 0) {
                out.append(target.getText());
            } else {
                PsiElement[] children;
                for (PsiElement child : children = target.getChildren()) {
                    IfCanBeSwitchFix.termReplace(child, replace, stringToReplaceWith, out);
                }
            }
        }

        private static void extractCaseExpressions(PsiExpression expression, PsiExpression switchExpression, SwitchUtils.IfStatementBranch branch) {
            if (expression instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
                PsiExpressionList argumentList = methodCallExpression.getArgumentList();
                PsiExpression[] arguments = argumentList.getExpressions();
                PsiExpression argument = arguments[0];
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
                if (EquivalenceChecker.expressionsAreEquivalent(switchExpression, argument)) {
                    branch.addCaseExpression(qualifierExpression);
                } else {
                    branch.addCaseExpression(argument);
                }
            } else if (expression instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
                PsiExpression[] operands = polyadicExpression.getOperands();
                IElementType tokenType = polyadicExpression.getOperationTokenType();
                if (JavaTokenType.OROR.equals(tokenType)) {
                    for (PsiExpression operand : operands) {
                        IfCanBeSwitchFix.extractCaseExpressions(operand, switchExpression, branch);
                    }
                } else if (operands.length == 2) {
                    PsiExpression lhs = operands[0];
                    PsiExpression rhs = operands[1];
                    if (EquivalenceChecker.expressionsAreEquivalent(switchExpression, rhs)) {
                        branch.addCaseExpression(lhs);
                    } else {
                        branch.addCaseExpression(rhs);
                    }
                }
            } else if (expression instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
                PsiExpression contents = parenthesizedExpression.getExpression();
                IfCanBeSwitchFix.extractCaseExpressions(contents, switchExpression, branch);
            }
        }

        private static void dumpBranch(SwitchUtils.IfStatementBranch branch, boolean castToInt, boolean wrap, boolean renameBreaks, String breakLabelName, @NonNls StringBuilder switchStatementText) {
            IfCanBeSwitchFix.dumpComments(branch.getComments(), switchStatementText);
            if (branch.isElse()) {
                switchStatementText.append("default: ");
            } else {
                for (PsiExpression caseExpression : branch.getCaseExpressions()) {
                    switchStatementText.append("case ").append(IfCanBeSwitchFix.getCaseLabelText(caseExpression, castToInt)).append(": ");
                }
            }
            IfCanBeSwitchFix.dumpComments(branch.getStatementComments(), switchStatementText);
            IfCanBeSwitchFix.dumpBody(branch.getStatement(), wrap, renameBreaks, breakLabelName, switchStatementText);
        }

        @NonNls
        private static String getCaseLabelText(PsiExpression expression, boolean castToInt) {
            PsiType type;
            PsiReferenceExpression referenceExpression;
            PsiElement target;
            if (expression instanceof PsiReferenceExpression && (target = (referenceExpression = (PsiReferenceExpression)expression).resolve()) instanceof PsiEnumConstant) {
                PsiEnumConstant enumConstant = (PsiEnumConstant)target;
                return enumConstant.getName();
            }
            if (castToInt && !PsiType.INT.equals((Object)(type = expression.getType()))) {
                return "(int)" + expression.getText();
            }
            return expression.getText();
        }

        private static void dumpComments(List<String> comments, StringBuilder switchStatementText) {
            if (comments.isEmpty()) {
                return;
            }
            switchStatementText.append('\n');
            for (String comment : comments) {
                switchStatementText.append(comment).append('\n');
            }
        }

        private static void dumpBody(PsiStatement bodyStatement, boolean wrap, boolean renameBreaks, String breakLabelName, @NonNls StringBuilder switchStatementText) {
            if (wrap) {
                switchStatementText.append('{');
            }
            if (bodyStatement instanceof PsiBlockStatement) {
                PsiCodeBlock codeBlock = ((PsiBlockStatement)bodyStatement).getCodeBlock();
                PsiElement[] children = codeBlock.getChildren();
                for (int i = 1; i < children.length - 1; ++i) {
                    PsiElement child = children[i];
                    IfCanBeSwitchFix.appendElement(child, renameBreaks, breakLabelName, switchStatementText);
                }
            } else {
                IfCanBeSwitchFix.appendElement((PsiElement)bodyStatement, renameBreaks, breakLabelName, switchStatementText);
            }
            if (ControlFlowUtils.statementMayCompleteNormally(bodyStatement)) {
                switchStatementText.append("break;");
            }
            if (wrap) {
                switchStatementText.append('}');
            }
        }

        private static void appendElement(PsiElement element, boolean renameBreakElements, String breakLabelString, @NonNls StringBuilder switchStatementText) {
            String text = element.getText();
            if (!renameBreakElements) {
                switchStatementText.append(text);
            } else if (element instanceof PsiBreakStatement) {
                PsiBreakStatement breakStatement = (PsiBreakStatement)element;
                PsiIdentifier identifier = breakStatement.getLabelIdentifier();
                if (identifier == null) {
                    switchStatementText.append("break ").append(breakLabelString).append(';');
                } else {
                    switchStatementText.append(text);
                }
            } else if (element instanceof PsiBlockStatement || element instanceof PsiCodeBlock || element instanceof PsiIfStatement) {
                PsiElement[] children;
                for (PsiElement child : children = element.getChildren()) {
                    IfCanBeSwitchFix.appendElement(child, renameBreakElements, breakLabelString, switchStatementText);
                }
            } else {
                switchStatementText.append(text);
            }
            PsiElement lastChild = element.getLastChild();
            if (IfCanBeSwitchFix.isEndOfLineComment(lastChild)) {
                switchStatementText.append('\n');
            }
        }

        private static boolean isEndOfLineComment(PsiElement element) {
            if (!(element instanceof PsiComment)) {
                return false;
            }
            PsiComment comment = (PsiComment)element;
            IElementType tokenType = comment.getTokenType();
            return JavaTokenType.END_OF_LINE_COMMENT.equals(tokenType);
        }
    }
}

