/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer.ssi;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import gnu.trove.THashMap;
import io.netty.handler.codec.http.HttpRequest;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;

public final class SsiExternalResolver {
    private final String[] VARIABLE_NAMES;
    private final Project project;
    private final HttpRequest request;
    private Map<String, String> variables;
    private final String parentPath;
    @NotNull
    private final VirtualFile parentFile;

    public SsiExternalResolver(@NotNull Project project, @NotNull HttpRequest request, @NotNull String parentPath, @NotNull VirtualFile parentFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/builtInWebServer/ssi/SsiExternalResolver", "<init>"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/builtInWebServer/ssi/SsiExternalResolver", "<init>"));
        }
        if (parentPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentPath", "org/jetbrains/builtInWebServer/ssi/SsiExternalResolver", "<init>"));
        }
        if (parentFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFile", "org/jetbrains/builtInWebServer/ssi/SsiExternalResolver", "<init>"));
        }
        this.VARIABLE_NAMES = new String[]{"AUTH_TYPE", "CONTENT_LENGTH", "CONTENT_TYPE", "DOCUMENT_NAME", "DOCUMENT_URI", "GATEWAY_INTERFACE", "HTTP_ACCEPT", "HTTP_ACCEPT_ENCODING", "HTTP_ACCEPT_LANGUAGE", "HTTP_CONNECTION", "HTTP_HOST", "HTTP_REFERER", "HTTP_USER_AGENT", "PATH_INFO", "PATH_TRANSLATED", "QUERY_STRING", "QUERY_STRING_UNESCAPED", "REMOTE_ADDR", "REMOTE_HOST", "REMOTE_PORT", "REMOTE_USER", "REQUEST_METHOD", "REQUEST_URI", "SCRIPT_FILENAME", "SCRIPT_NAME", "SERVER_ADDR", "SERVER_NAME", "SERVER_PORT", "SERVER_PROTOCOL", "SERVER_SOFTWARE", "UNIQUE_ID"};
        this.variables = new THashMap();
        this.project = project;
        this.request = request;
        this.parentPath = parentPath;
        this.parentFile = parentFile;
    }

    public void addVariableNames(@NotNull Collection<String> variableNames) {
        if (variableNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableNames", "org/jetbrains/builtInWebServer/ssi/SsiExternalResolver", "addVariableNames"));
        }
        for (String variableName : this.VARIABLE_NAMES) {
            String variableValue = this.getVariableValue(variableName);
            if (variableValue == null) continue;
            variableNames.add(variableName);
        }
    }

    public void setVariableValue(@NotNull String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/builtInWebServer/ssi/SsiExternalResolver", "setVariableValue"));
        }
        this.variables.put(name, value);
    }

    public String getVariableValue(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/builtInWebServer/ssi/SsiExternalResolver", "getVariableValue"));
        }
        String value = this.variables.get(name);
        return value == null ? this.request.headers().get(name) : value;
    }

    @Nullable
    public VirtualFile findFile(@NotNull String originalPath, boolean virtual) {
        if (originalPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalPath", "org/jetbrains/builtInWebServer/ssi/SsiExternalResolver", "findFile"));
        }
        String path = FileUtil.toCanonicalPath((String)originalPath, (char)'/');
        if (!virtual) {
            return this.parentFile.findFileByRelativePath(path);
        }
        path = path.charAt(0) == '/' ? path : this.parentPath + '/' + path;
        return WebServerPathToFileManager.getInstance(this.project).get(path);
    }

    public long getFileLastModified(String path, boolean virtual) {
        VirtualFile file = this.findFile(path, virtual);
        return file == null ? 0L : file.getTimeStamp();
    }

    public long getFileSize(@NotNull String path, boolean virtual) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/builtInWebServer/ssi/SsiExternalResolver", "getFileSize"));
        }
        VirtualFile file = this.findFile(path, virtual);
        return file == null ? -1L : file.getLength();
    }
}

