/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Url;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.intellij.util.io.socketConnection.SocketConnectionListener;
import com.intellij.xdebugger.DefaultDebugProcessHandler;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.ContextDependentAsyncResultConsumer;
import org.jetbrains.debugger.RejectErrorReporter;
import org.jetbrains.debugger.StepAction;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.SuspendContextManager;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.debugger.frame.SuspendContextImpl;

public abstract class DebugProcessImpl<C extends VmConnection>
extends XDebugProcess {
    protected final AtomicBoolean repeatStepInto;
    protected volatile StepAction lastStep;
    protected volatile CallFrame lastCallFrame;
    protected volatile boolean isForceStep;
    protected final ConcurrentMap<Url, VirtualFile> urlToFileCache;
    protected final C connection;
    private boolean processBreakpointConditionsAtIdeSide;
    private final XDebuggerEditorsProvider editorsProvider;
    private final XSmartStepIntoHandler<?> smartStepIntoHandler;
    protected XBreakpointHandler<?>[] breakpointHandlers;
    protected final ExecutionResult executionResult;

    protected DebugProcessImpl(@NotNull XDebugSession session, @NotNull C connection, @NotNull XDebuggerEditorsProvider editorsProvider, @Nullable XSmartStepIntoHandler<?> smartStepIntoHandler, @Nullable ExecutionResult executionResult) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "org/jetbrains/debugger/DebugProcessImpl", "<init>"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/debugger/DebugProcessImpl", "<init>"));
        }
        if (editorsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorsProvider", "org/jetbrains/debugger/DebugProcessImpl", "<init>"));
        }
        super(session);
        this.repeatStepInto = new AtomicBoolean();
        this.urlToFileCache = ContainerUtil.newConcurrentMap();
        this.executionResult = executionResult;
        this.connection = connection;
        this.editorsProvider = editorsProvider;
        this.smartStepIntoHandler = smartStepIntoHandler;
        ((VmConnection)connection).addListener(new SocketConnectionListener(){

            @Override
            public void statusChanged(@NotNull ConnectionStatus status) {
                if (status == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "org/jetbrains/debugger/DebugProcessImpl$1", "statusChanged"));
                }
                if (status == ConnectionStatus.DISCONNECTED || status == ConnectionStatus.DETACHED) {
                    if (status == ConnectionStatus.DETACHED && DebugProcessImpl.this.getRealProcessHandler() != null) {
                        DebugProcessImpl.this.getProcessHandler().detachProcess();
                    }
                    DebugProcessImpl.this.getSession().stop();
                } else {
                    DebugProcessImpl.this.getSession().rebuildViews();
                }
            }
        });
    }

    @Nullable
    protected final ProcessHandler getRealProcessHandler() {
        return this.executionResult == null ? null : this.executionResult.getProcessHandler();
    }

    @NotNull
    public final C getConnection() {
        C c = this.connection;
        if (c == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/DebugProcessImpl", "getConnection"));
        }
        return c;
    }

    @Nullable
    public final XSmartStepIntoHandler<?> getSmartStepIntoHandler() {
        return this.smartStepIntoHandler;
    }

    @NotNull
    public final XBreakpointHandler<?>[] getBreakpointHandlers() {
        if (this.breakpointHandlers == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/DebugProcessImpl", "getBreakpointHandlers"));
        }
        return this.breakpointHandlers;
    }

    @NotNull
    public final XDebuggerEditorsProvider getEditorsProvider() {
        XDebuggerEditorsProvider xDebuggerEditorsProvider = this.editorsProvider;
        if (xDebuggerEditorsProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/DebugProcessImpl", "getEditorsProvider"));
        }
        return xDebuggerEditorsProvider;
    }

    public void setProcessBreakpointConditionsAtIdeSide(boolean processBreakpointConditionsAtIdeSide) {
        this.processBreakpointConditionsAtIdeSide = processBreakpointConditionsAtIdeSide;
    }

    public final Vm getVm() {
        return ((VmConnection)this.connection).getVm();
    }

    private void updateLastCallFrame() {
        SuspendContext context;
        Vm vm = this.getVm();
        if (vm != null && (context = vm.getSuspendContextManager().getContext()) != null) {
            this.lastCallFrame = context.getTopFrame();
            return;
        }
        this.lastCallFrame = null;
    }

    public boolean checkCanPerformCommands() {
        return this.getVm() != null;
    }

    public boolean isValuesCustomSorted() {
        return true;
    }

    public void startStepOver() {
        this.updateLastCallFrame();
        this.continueVm(StepAction.OVER);
    }

    public void startForceStepInto() {
        this.isForceStep = true;
        this.startStepInto();
    }

    public void startStepInto() {
        this.updateLastCallFrame();
        this.continueVm(StepAction.IN);
    }

    public void startStepOut() {
        if (this.isVmStepOutCorrect()) {
            this.lastCallFrame = null;
        } else {
            this.updateLastCallFrame();
        }
        this.continueVm(StepAction.OUT);
    }

    protected boolean isVmStepOutCorrect() {
        return true;
    }

    protected void continueVm(@NotNull StepAction stepAction) {
        if (stepAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stepAction", "org/jetbrains/debugger/DebugProcessImpl", "continueVm"));
        }
        SuspendContextManager suspendContextManager = this.getVm().getSuspendContextManager();
        if (stepAction == StepAction.CONTINUE) {
            if (suspendContextManager.getContext() == null) {
                return;
            }
            this.lastStep = null;
            this.lastCallFrame = null;
            this.urlToFileCache.clear();
        } else {
            this.lastStep = stepAction;
        }
        suspendContextManager.continueVm(stepAction, 1);
    }

    protected final void setOverlay() {
        this.getVm().getSuspendContextManager().setOverlayMessage("Paused in debugger");
    }

    protected final void processBreakpoint(final @NotNull SuspendContext suspendContext, final @NotNull XBreakpoint<?> breakpoint, final @NotNull SuspendContextImpl xSuspendContext) {
        String condition;
        if (suspendContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "org/jetbrains/debugger/DebugProcessImpl", "processBreakpoint"));
        }
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "org/jetbrains/debugger/DebugProcessImpl", "processBreakpoint"));
        }
        if (xSuspendContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xSuspendContext", "org/jetbrains/debugger/DebugProcessImpl", "processBreakpoint"));
        }
        XExpression conditionExpression = breakpoint.getConditionExpression();
        String string = condition = conditionExpression == null ? null : conditionExpression.getExpression();
        if (!this.processBreakpointConditionsAtIdeSide || condition == null) {
            this.processBreakpointLogExpressionAndSuspend(breakpoint, xSuspendContext, suspendContext);
        } else {
            xSuspendContext.evaluateExpression(condition).done((Consumer)new ContextDependentAsyncResultConsumer<String>(suspendContext){

                @Override
                public void consume(String evaluationResult, @NotNull Vm vm) {
                    if (vm == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vm", "org/jetbrains/debugger/DebugProcessImpl$3", "consume"));
                    }
                    if ("false".equals(evaluationResult)) {
                        DebugProcessImpl.this.resume();
                    } else {
                        DebugProcessImpl.this.processBreakpointLogExpressionAndSuspend(breakpoint, xSuspendContext, suspendContext);
                    }
                }
            }).rejected((Consumer)new ContextDependentAsyncResultConsumer<Throwable>(suspendContext){

                @Override
                public void consume(Throwable failure, @NotNull Vm vm) {
                    if (vm == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vm", "org/jetbrains/debugger/DebugProcessImpl$2", "consume"));
                    }
                    DebugProcessImpl.this.processBreakpointLogExpressionAndSuspend(breakpoint, xSuspendContext, suspendContext);
                }
            });
        }
    }

    private void processBreakpointLogExpressionAndSuspend(final @NotNull XBreakpoint<?> breakpoint, final @NotNull SuspendContextImpl xSuspendContext, @NotNull SuspendContext suspendContext) {
        String logExpression;
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "org/jetbrains/debugger/DebugProcessImpl", "processBreakpointLogExpressionAndSuspend"));
        }
        if (xSuspendContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xSuspendContext", "org/jetbrains/debugger/DebugProcessImpl", "processBreakpointLogExpressionAndSuspend"));
        }
        if (suspendContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "org/jetbrains/debugger/DebugProcessImpl", "processBreakpointLogExpressionAndSuspend"));
        }
        XExpression logExpressionObject = breakpoint.getLogExpressionObject();
        String string = logExpression = logExpressionObject == null ? null : logExpressionObject.getExpression();
        if (logExpression == null) {
            this.breakpointReached(breakpoint, null, xSuspendContext);
        } else {
            xSuspendContext.evaluateExpression(logExpression).done((Consumer)new ContextDependentAsyncResultConsumer<String>(suspendContext){

                @Override
                public void consume(String logResult, @NotNull Vm vm) {
                    if (vm == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vm", "org/jetbrains/debugger/DebugProcessImpl$5", "consume"));
                    }
                    DebugProcessImpl.this.breakpointReached(breakpoint, logResult, xSuspendContext);
                }
            }).rejected((Consumer)new ContextDependentAsyncResultConsumer<Throwable>(suspendContext){

                @Override
                public void consume(Throwable logResult, @NotNull Vm vm) {
                    if (vm == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vm", "org/jetbrains/debugger/DebugProcessImpl$4", "consume"));
                    }
                    DebugProcessImpl.this.breakpointReached(breakpoint, "Failed to evaluate expression: " + logExpression, xSuspendContext);
                }
            });
        }
    }

    private void breakpointReached(@NotNull XBreakpoint<?> breakpoint, @Nullable String evaluatedLogExpression, @NotNull XSuspendContext suspendContext) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "org/jetbrains/debugger/DebugProcessImpl", "breakpointReached"));
        }
        if (suspendContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "org/jetbrains/debugger/DebugProcessImpl", "breakpointReached"));
        }
        if (this.getSession().breakpointReached(breakpoint, evaluatedLogExpression, suspendContext)) {
            this.setOverlay();
        } else {
            this.resume();
        }
    }

    public final void startPausing() {
        ((VmConnection)this.connection).getVm().getSuspendContextManager().suspend().rejected((Consumer)new RejectErrorReporter(this.getSession(), "Cannot pause"));
    }

    public final String getCurrentStateMessage() {
        return ((VmConnection)this.connection).getState().getMessage();
    }

    @Nullable
    public final HyperlinkListener getCurrentStateHyperlinkListener() {
        return ((VmConnection)this.getConnection()).getState().getMessageLinkListener();
    }

    @NotNull
    protected ProcessHandler doGetProcessHandler() {
        SilentDestroyDebugProcessHandler silentDestroyDebugProcessHandler = this.executionResult == null ? new SilentDestroyDebugProcessHandler() : this.executionResult.getProcessHandler();
        if (silentDestroyDebugProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/DebugProcessImpl", "doGetProcessHandler"));
        }
        return silentDestroyDebugProcessHandler;
    }

    private static final class SilentDestroyDebugProcessHandler
    extends DefaultDebugProcessHandler {
        private SilentDestroyDebugProcessHandler() {
        }

        public boolean isSilentlyDestroyOnClose() {
            return true;
        }
    }
}

