/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.info;

import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.LineCommandAdapter;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.commandLine.SvnExceptionWrapper;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.info.InfoClient;
import org.jetbrains.idea.svn.info.InfoConsumer;
import org.jetbrains.idea.svn.info.SvnInfoHandler;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CmdInfoClient
extends BaseSvnClient
implements InfoClient {
    private static final Logger LOG = Logger.getInstance(CmdInfoClient.class);

    private String execute(@NotNull List<String> parameters, @NotNull File path) throws SvnBindException {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/idea/svn/info/CmdInfoClient", "execute"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/info/CmdInfoClient", "execute"));
        }
        final ProcessOutput output = new ProcessOutput();
        LineCommandAdapter listener = new LineCommandAdapter(){

            @Override
            public void onLineAvailable(String line, Key outputType) {
                if (outputType == ProcessOutputTypes.STDOUT) {
                    output.appendStdout(line);
                }
            }
        };
        try {
            CommandExecutor command = this.execute(this.myVcs, SvnTarget.fromFile((File)path), SvnCommandName.info, parameters, listener);
            return command.getOutput();
        }
        catch (SvnBindException e) {
            String text = StringUtil.notNullize((String)e.getMessage());
            if (text.contains("W155010")) {
                return output.getStdout();
            }
            if (text.contains("is not a working copy") && StringUtil.isNotEmpty((String)output.getStdout())) {
                return output.getStdout() + "</info>";
            }
            throw e;
        }
    }

    @Nullable
    private static Info parseResult(@Nullable File base, @Nullable String result) throws SvnBindException {
        CollectInfoHandler handler = new CollectInfoHandler();
        CmdInfoClient.parseResult(handler, base, result);
        return handler.getInfo();
    }

    private static void parseResult(final @NotNull InfoConsumer handler, @Nullable File base, @Nullable String result) throws SvnBindException {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "org/jetbrains/idea/svn/info/CmdInfoClient", "parseResult"));
        }
        if (StringUtil.isEmptyOrSpaces((String)result)) {
            return;
        }
        SvnInfoHandler infoHandler = new SvnInfoHandler(base, new Consumer<Info>(){

            public void consume(Info info) {
                try {
                    handler.consume(info);
                }
                catch (SVNException e) {
                    throw new SvnExceptionWrapper(e);
                }
            }
        });
        CmdInfoClient.parseResult(result, infoHandler);
    }

    private static void parseResult(@NotNull String result, @NotNull SvnInfoHandler handler) throws SvnBindException {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/idea/svn/info/CmdInfoClient", "parseResult"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "org/jetbrains/idea/svn/info/CmdInfoClient", "parseResult"));
        }
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse((InputStream)new ByteArrayInputStream(result.trim().getBytes(CharsetToolkit.UTF8_CHARSET)), (DefaultHandler)handler);
        }
        catch (SvnExceptionWrapper e) {
            LOG.info("info output " + result);
            throw new SvnBindException(e.getCause());
        }
        catch (IOException e) {
            LOG.info("info output " + result);
            throw new SvnBindException(e);
        }
        catch (ParserConfigurationException e) {
            LOG.info("info output " + result);
            throw new SvnBindException(e);
        }
        catch (SAXException e) {
            LOG.info("info output " + result);
            throw new SvnBindException(e);
        }
    }

    @NotNull
    private static List<String> buildParameters(@NotNull String path, @Nullable SVNRevision pegRevision, @Nullable SVNRevision revision, @Nullable Depth depth) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/info/CmdInfoClient", "buildParameters"));
        }
        ArrayList parameters = ContainerUtil.newArrayList();
        CommandUtil.put((List<String>)parameters, depth);
        CommandUtil.put((List<String>)parameters, revision);
        CommandUtil.put((List<String>)parameters, path, pegRevision);
        parameters.add("--xml");
        ArrayList arrayList = parameters;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/info/CmdInfoClient", "buildParameters"));
        }
        return arrayList;
    }

    @Override
    public Info doInfo(File path, SVNRevision revision) throws SvnBindException {
        File base = path.isDirectory() ? path : path.getParentFile();
        if ((base = CommandUtil.correctUpToExistingParent(base)) == null) {
            throw new SvnBindException("Can not find existing parent file");
        }
        return CmdInfoClient.parseResult(base, this.execute(CmdInfoClient.buildParameters(path.getAbsolutePath(), SVNRevision.UNDEFINED, revision, Depth.EMPTY), path));
    }

    @Override
    public Info doInfo(SVNURL url, SVNRevision pegRevision, SVNRevision revision) throws SvnBindException {
        CommandExecutor command = this.execute(this.myVcs, SvnTarget.fromURL((SVNURL)url), SvnCommandName.info, CmdInfoClient.buildParameters(url.toString(), pegRevision, revision, Depth.EMPTY), null);
        return CmdInfoClient.parseResult(null, command.getOutput());
    }

    @Override
    public void doInfo(@NotNull Collection<File> paths, @Nullable InfoConsumer handler) throws SvnBindException {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "org/jetbrains/idea/svn/info/CmdInfoClient", "doInfo"));
        }
        File base = (File)ContainerUtil.getFirstItem(paths);
        if (base != null) {
            base = CommandUtil.correctUpToExistingParent(base);
            ArrayList parameters = ContainerUtil.newArrayList();
            for (File file : paths) {
                CommandUtil.put((List<String>)parameters, file);
            }
            parameters.add("--xml");
            String result = this.execute(parameters, base);
            if (handler != null) {
                CmdInfoClient.parseResult(handler, base, result);
            }
        }
    }

    private static class CollectInfoHandler
    implements InfoConsumer {
        @Nullable
        private Info myInfo;

        private CollectInfoHandler() {
        }

        public void consume(Info info) throws SVNException {
            this.myInfo = info;
        }

        @Nullable
        public Info getInfo() {
            return this.myInfo;
        }
    }
}

