/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertySuppressableInspectionBase;
import com.intellij.lang.properties.psi.codeStyle.PropertiesCodeStyleSettings;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class WrongPropertyKeyValueDelimiterInspection
extends PropertySuppressableInspectionBase {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/WrongPropertyKeyValueDelimiterInspection", "buildVisitor"));
        }
        if (!(holder.getFile() instanceof PropertiesFileImpl)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/WrongPropertyKeyValueDelimiterInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        PropertiesCodeStyleSettings codeStyleSettings = PropertiesCodeStyleSettings.getInstance(holder.getProject());
        final char codeStyleKeyValueDelimiter = codeStyleSettings.KEY_VALUE_DELIMITER;
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                Character delimiter;
                if (element instanceof PropertyImpl && (delimiter = ((PropertyImpl)element).getKeyValueDelimiter()) != null && !delimiter.equals(Character.valueOf(codeStyleKeyValueDelimiter))) {
                    holder.registerProblem(element, PropertiesBundle.message("wrong.property.key.value.delimiter.inspection.display.name", new Object[0]), new LocalQuickFix[]{new ReplaceKeyValueDelimiterQuickFix(element)});
                }
            }
        };
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/WrongPropertyKeyValueDelimiterInspection", "buildVisitor"));
        }
        return psiElementVisitor;
    }

    private static final class ReplaceKeyValueDelimiterQuickFix
    extends LocalQuickFixOnPsiElement
    implements HighPriorityAction {
        public ReplaceKeyValueDelimiterQuickFix(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/WrongPropertyKeyValueDelimiterInspection$ReplaceKeyValueDelimiterQuickFix", "<init>"));
            }
            super(element);
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/WrongPropertyKeyValueDelimiterInspection$ReplaceKeyValueDelimiterQuickFix", "getText"));
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement element, @NotNull PsiElement endElement) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/WrongPropertyKeyValueDelimiterInspection$ReplaceKeyValueDelimiterQuickFix", "invoke"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/WrongPropertyKeyValueDelimiterInspection$ReplaceKeyValueDelimiterQuickFix", "invoke"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/WrongPropertyKeyValueDelimiterInspection$ReplaceKeyValueDelimiterQuickFix", "invoke"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInspection/WrongPropertyKeyValueDelimiterInspection$ReplaceKeyValueDelimiterQuickFix", "invoke"));
            }
            ((PropertyImpl)element).replaceKeyValueDelimiterWithDefault();
        }

        @NotNull
        public String getFamilyName() {
            if ("Replace Property Key/Value Delimiter According Code Style" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/WrongPropertyKeyValueDelimiterInspection$ReplaceKeyValueDelimiterQuickFix", "getFamilyName"));
            }
            return "Replace Property Key/Value Delimiter According Code Style";
        }
    }
}

