/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.annotations.NonNull;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Field;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.StackTrace;
import com.android.tools.perflib.heap.Type;
import com.android.tools.perflib.heap.Visitor;
import java.util.HashMap;
import java.util.Map;

public class ClassInstance
extends Instance {
    private final long mValuesOffset;

    public ClassInstance(long id, @NonNull StackTrace stack, long valuesOffset) {
        super(id, stack);
        this.mValuesOffset = valuesOffset;
    }

    Object getField(Type type, String name) {
        return this.getValues().get(new Field(type, name));
    }

    @NonNull
    public Map<Field, Object> getValues() {
        HashMap<Field, Object> result = new HashMap<Field, Object>();
        this.getBuffer().setPosition(this.mValuesOffset);
        for (ClassObj clazz = this.getClassObj(); clazz != null; clazz = clazz.getSuperClassObj()) {
            for (Field field : clazz.getFields()) {
                result.put(field, this.readValue(field.getType()));
            }
        }
        return result;
    }

    @Override
    public final void accept(@NonNull Visitor visitor) {
        if (visitor.visitEnter(this)) {
            for (Object value : this.getValues().values()) {
                if (!(value instanceof Instance)) continue;
                ((Instance)value).accept(visitor);
            }
            visitor.visitLeave(this);
        }
    }

    public final String toString() {
        return String.format("%s@0x%08x", this.getClassObj().getClassName(), this.mId);
    }
}

