/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.perflib.heap.ClassInstance;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Field;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.RootObj;
import com.android.tools.perflib.heap.RootType;
import com.android.tools.perflib.heap.StackFrame;
import com.android.tools.perflib.heap.StackTrace;
import com.android.tools.perflib.heap.ThreadObj;
import com.android.tools.perflib.heap.analysis.Dominators;
import com.android.tools.perflib.heap.analysis.TopologicalSort;
import com.android.tools.perflib.heap.io.HprofBuffer;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Snapshot {
    private static final String JAVA_LANG_CLASS = "java.lang.Class";
    public static final Instance SENTINEL_ROOT = new RootObj(RootType.UNKNOWN);
    private static final int DEFAULT_HEAP_ID = 0;
    @NonNull
    final HprofBuffer mBuffer;
    @NonNull
    ArrayList<Heap> mHeaps = new ArrayList();
    @NonNull
    Heap mCurrentHeap;
    private ImmutableList<Instance> mTopSort;
    private Dominators mDominators;

    public Snapshot(@NonNull HprofBuffer buffer) {
        this.mBuffer = buffer;
        this.setToDefaultHeap();
    }

    @NonNull
    public Heap setToDefaultHeap() {
        return this.setHeapTo(0, "default");
    }

    @NonNull
    public Heap setHeapTo(int id, @NonNull String name) {
        Heap heap = this.getHeap(id);
        if (heap == null) {
            heap = new Heap(id, name);
            heap.mSnapshot = this;
            this.mHeaps.add(heap);
        }
        this.mCurrentHeap = heap;
        return this.mCurrentHeap;
    }

    public int getHeapIndex(@NonNull Heap heap) {
        return this.mHeaps.indexOf(heap);
    }

    @Nullable
    public Heap getHeap(int id) {
        for (int i = 0; i < this.mHeaps.size(); ++i) {
            if (this.mHeaps.get(i).getId() != id) continue;
            return this.mHeaps.get(i);
        }
        return null;
    }

    @Nullable
    public Heap getHeap(@NonNull String name) {
        for (int i = 0; i < this.mHeaps.size(); ++i) {
            if (!name.equals(this.mHeaps.get(i).getName())) continue;
            return this.mHeaps.get(i);
        }
        return null;
    }

    @NonNull
    public Collection<Heap> getHeaps() {
        return this.mHeaps;
    }

    @NonNull
    public Collection<RootObj> getGCRoots() {
        return this.mHeaps.get((int)0).mRoots;
    }

    public final void addStackFrame(@NonNull StackFrame theFrame) {
        this.mCurrentHeap.addStackFrame(theFrame);
    }

    public final StackFrame getStackFrame(long id) {
        return this.mCurrentHeap.getStackFrame(id);
    }

    public final void addStackTrace(@NonNull StackTrace theTrace) {
        this.mCurrentHeap.addStackTrace(theTrace);
    }

    public final StackTrace getStackTrace(int traceSerialNumber) {
        return this.mCurrentHeap.getStackTrace(traceSerialNumber);
    }

    public final StackTrace getStackTraceAtDepth(int traceSerialNumber, int depth) {
        return this.mCurrentHeap.getStackTraceAtDepth(traceSerialNumber, depth);
    }

    public final void addRoot(@NonNull RootObj root) {
        this.mCurrentHeap.addRoot(root);
        root.setHeap(this.mCurrentHeap);
    }

    public final void addThread(ThreadObj thread, int serialNumber) {
        this.mCurrentHeap.addThread(thread, serialNumber);
    }

    public final ThreadObj getThread(int serialNumber) {
        return this.mCurrentHeap.getThread(serialNumber);
    }

    public final void addInstance(long id, @NonNull Instance instance) {
        this.mCurrentHeap.addInstance(id, instance);
        instance.setHeap(this.mCurrentHeap);
    }

    public final void addClass(long id, @NonNull ClassObj theClass) {
        this.mCurrentHeap.addClass(id, theClass);
        theClass.setHeap(this.mCurrentHeap);
    }

    @Nullable
    public final Instance findReference(long id) {
        for (int i = 0; i < this.mHeaps.size(); ++i) {
            Instance instance = this.mHeaps.get(i).getInstance(id);
            if (instance == null) continue;
            return instance;
        }
        return this.findClass(id);
    }

    @Nullable
    public final ClassObj findClass(long id) {
        for (int i = 0; i < this.mHeaps.size(); ++i) {
            ClassObj theClass = this.mHeaps.get(i).getClass(id);
            if (theClass == null) continue;
            return theClass;
        }
        return null;
    }

    @Nullable
    public final ClassObj findClass(String name) {
        for (int i = 0; i < this.mHeaps.size(); ++i) {
            ClassObj theClass = this.mHeaps.get(i).getClass(name);
            if (theClass == null) continue;
            return theClass;
        }
        return null;
    }

    public void resolveClasses() {
        ClassObj clazz = this.findClass(JAVA_LANG_CLASS);
        int javaLangClassSize = clazz != null ? clazz.getInstanceSize() : 0;
        for (Heap heap : this.mHeaps) {
            for (ClassObj classObj : heap.getClasses()) {
                ClassObj superClass = classObj.getSuperClassObj();
                if (superClass != null) {
                    superClass.addSubclass(classObj);
                }
                int classSize = javaLangClassSize;
                for (Field f : classObj.mStaticFields) {
                    classSize += f.getType().getSize();
                }
                classObj.setSize(classSize);
            }
            for (Instance instance : heap.getInstances()) {
                ClassObj classObj = instance.getClassObj();
                if (classObj == null) continue;
                classObj.addInstance(instance);
                if (!(instance instanceof ClassInstance)) continue;
                instance.setSize(classObj.getInstanceSize());
            }
        }
    }

    public void computeDominators() {
        if (this.mDominators == null) {
            this.mTopSort = TopologicalSort.compute(this.getGCRoots());
            this.mDominators = new Dominators(this, this.mTopSort);
            this.mDominators.computeRetainedSizes();
        }
    }

    @NonNull
    public List<Instance> getReachableInstances() {
        ArrayList<Instance> result = new ArrayList<Instance>(this.mTopSort.size());
        for (Instance node : this.mTopSort) {
            if (node.getImmediateDominator() == null) continue;
            result.add(node);
        }
        return result;
    }

    public final void dumpInstanceCounts() {
        for (Heap heap : this.mHeaps) {
            System.out.println("+------------------ instance counts for heap: " + heap.getName());
            heap.dumpInstanceCounts();
        }
    }

    public final void dumpSizes() {
        for (Heap heap : this.mHeaps) {
            System.out.println("+------------------ sizes for heap: " + heap.getName());
            heap.dumpSizes();
        }
    }

    public final void dumpSubclasses() {
        for (Heap heap : this.mHeaps) {
            System.out.println("+------------------ subclasses for heap: " + heap.getName());
            heap.dumpSubclasses();
        }
    }
}

