/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.admin;

import com.intellij.openapi.util.io.FileUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NonNls;
import org.netbeans.lib.cvsclient.CvsRoot;
import org.netbeans.lib.cvsclient.IClientEnvironment;
import org.netbeans.lib.cvsclient.SmartCvsSrcBundle;
import org.netbeans.lib.cvsclient.admin.AdminUtils;
import org.netbeans.lib.cvsclient.admin.Entries;
import org.netbeans.lib.cvsclient.admin.EntriesHandler;
import org.netbeans.lib.cvsclient.admin.EntriesWriter;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.admin.IAdminWriter;
import org.netbeans.lib.cvsclient.file.AbstractFileObject;
import org.netbeans.lib.cvsclient.file.DirectoryObject;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.file.FileUtils;
import org.netbeans.lib.cvsclient.file.ICvsFileSystem;
import org.netbeans.lib.cvsclient.file.IFileReadOnlyHandler;
import org.netbeans.lib.cvsclient.file.IFileSystem;
import org.netbeans.lib.cvsclient.file.IReaderFactory;
import org.netbeans.lib.cvsclient.util.BugLog;

public final class AdminWriter
implements IAdminWriter {
    private final String myLineSeparator;
    protected final String myCharset;
    private final EntriesWriter myEntriesWriter;
    public static boolean WRITE_RELATIVE_PATHS = true;
    @NonNls
    private static final String CVS_DIR_NAME = "CVS";
    @NonNls
    private static final String TAG_FILE_NAME = "Tag";
    @NonNls
    private static final String ENTRIES_STATIC_FILE_NAME = "Entries.Static";
    @NonNls
    private static final String CVS_TEMPLATE_FILE_PATH = "CVS/Template";
    @NonNls
    private static final String ROOT_FILE_NAME = "Root";
    @NonNls
    private static final String REPOSITORY_FILE_NAME = "Repository";
    @NonNls
    private static final String ENTRIES_FILE_NAME = "Entries";
    @NonNls
    private static final String CVS_ROOT_FILE_PATH = "CVS/Root";
    @NonNls
    private static final String CVS_REPOSITORY_FILE_PATH = "CVS/Repository";
    @NonNls
    private static final String CVS_BASE_FILE_PATH = "CVS/Base/";
    @NonNls
    private static final String CVS_BASEREV_FILE_PATH = "CVS/Baserev";

    public AdminWriter(String lineSeparator, String charset, EntriesWriter creator) {
        this.myLineSeparator = lineSeparator;
        this.myCharset = charset;
        this.myEntriesWriter = creator;
    }

    public AdminWriter(String lineSeparator, String charset) {
        this(lineSeparator, charset, new SimpleEntriesWriter(charset, lineSeparator));
    }

    public void ensureCvsDirectory(DirectoryObject directoryObject, String repositoryPath, CvsRoot cvsRoot, ICvsFileSystem cvsFileSystem) throws IOException {
        File cvsDirectory = this.ensureCvsDirectory(directoryObject, cvsFileSystem);
        this.ensureExistingRootFile(cvsDirectory, cvsRoot);
        this.ensureRepositoryFile(cvsDirectory, WRITE_RELATIVE_PATHS ? cvsFileSystem.getRelativeRepositoryPath(repositoryPath) : repositoryPath);
        this.ensureExistingEntriesFile(cvsDirectory);
    }

    public void removeEntryForFile(AbstractFileObject fileObject, ICvsFileSystem cvsFileSystem) throws IOException {
        File file = cvsFileSystem.getAdminFileSystem().getFile(fileObject);
        File directory = file.getParentFile();
        if (directory == null) {
            throw new IOException(SmartCvsSrcBundle.message("file.does.not.have.a.parent.directory.error.message", file));
        }
        EntriesHandler entriesHandler = new EntriesHandler(directory);
        boolean entriesUpdated = entriesHandler.read(this.myCharset);
        boolean entryRemoved = entriesHandler.getEntries().removeEntry(file.getName());
        if (entriesUpdated || entryRemoved) {
            entriesHandler.write(this.myLineSeparator, this.myCharset);
        }
    }

    public void pruneDirectory(DirectoryObject directoryObject, ICvsFileSystem cvsFileSystem) {
        this.deleteDirectoryRecursively(cvsFileSystem.getLocalFileSystem().getFile((AbstractFileObject)directoryObject));
        this.deleteDirectoryRecursively(cvsFileSystem.getAdminFileSystem().getFile((AbstractFileObject)directoryObject));
    }

    public void setStickyTagForDirectory(DirectoryObject directoryObject, String tag, ICvsFileSystem cvsFileSystem) throws IOException {
        File cvsDirectory = new File(cvsFileSystem.getAdminFileSystem().getFile((AbstractFileObject)directoryObject), CVS_DIR_NAME);
        if (!cvsDirectory.isDirectory()) {
            return;
        }
        File tagFile = new File(cvsDirectory, TAG_FILE_NAME);
        if (tag != null) {
            FileUtils.writeLine((File)tagFile, (String)tag);
        } else {
            FileUtil.delete((File)tagFile);
        }
    }

    public void editFile(FileObject fileObject, Entry entry, ICvsFileSystem cvsFileSystem, IFileReadOnlyHandler fileReadOnlyHandler) throws IOException {
        this.createBaserevEntry(fileObject, cvsFileSystem, entry);
        File localFile = cvsFileSystem.getLocalFileSystem().getFile((AbstractFileObject)fileObject);
        FileUtils.copyFile((File)localFile, (File)this.getEditBackupFile(fileObject, cvsFileSystem));
        fileReadOnlyHandler.setFileReadOnly(localFile, false);
    }

    public void uneditFile(FileObject fileObject, ICvsFileSystem cvsFileSystem, IFileReadOnlyHandler fileReadOnlyHandler) throws IOException {
        File editBackupFile = this.getEditBackupFile(fileObject, cvsFileSystem);
        if (!editBackupFile.isFile()) {
            return;
        }
        FileUtil.delete((File)editBackupFile);
        this.removeBaserevEntry(fileObject, cvsFileSystem);
        fileReadOnlyHandler.setFileReadOnly(cvsFileSystem.getLocalFileSystem().getFile((AbstractFileObject)fileObject), true);
    }

    public void setEntriesDotStatic(DirectoryObject directoryObject, boolean set, ICvsFileSystem cvsFileSystem) throws IOException {
        File localDirectory = cvsFileSystem.getAdminFileSystem().getFile((AbstractFileObject)directoryObject);
        if (set) {
            File cvsDirectory = this.getCvsDirectoryForLocalDirectory(localDirectory);
            if (cvsDirectory.exists()) {
                File staticFile = new File(cvsDirectory, ENTRIES_STATIC_FILE_NAME);
                FileUtil.createIfDoesntExist((File)staticFile);
            }
        } else {
            File entriesDotStaticFile = new File(this.getCvsDirectoryForLocalDirectory(localDirectory), ENTRIES_STATIC_FILE_NAME);
            if (entriesDotStaticFile.exists()) {
                FileUtil.delete((File)entriesDotStaticFile);
            }
        }
    }

    public void setEntry(DirectoryObject directoryObject, Entry entry, ICvsFileSystem cvsFileSystem) throws IOException {
        BugLog.getInstance().assertNotNull((Object)entry);
        File directory = cvsFileSystem.getAdminFileSystem().getFile((AbstractFileObject)directoryObject);
        this.myEntriesWriter.addEntry(directory, entry);
    }

    public void writeTemplateFile(DirectoryObject directoryObject, int fileLength, InputStream inputStream, IReaderFactory readerFactory, IClientEnvironment clientEnvironment) throws IOException {
        FileObject fileObject = FileObject.createInstance((DirectoryObject)directoryObject, (String)CVS_TEMPLATE_FILE_PATH);
        IFileSystem adminFileSystem = clientEnvironment.getCvsFileSystem().getAdminFileSystem();
        if (fileLength == 0) {
            FileUtil.delete((File)adminFileSystem.getFile((AbstractFileObject)fileObject));
            return;
        }
        clientEnvironment.getLocalFileWriter().writeTextFile(fileObject, fileLength, inputStream, false, readerFactory, clientEnvironment.getFileReadOnlyHandler(), adminFileSystem, null);
    }

    public void directoryAdded(DirectoryObject directoryObject, ICvsFileSystem cvsFileSystem) throws IOException {
        DirectoryObject parent = directoryObject.getParent();
        String cvsRoot = this.getCvsRoot(parent, cvsFileSystem);
        String repositoryPath = this.getRepository(parent, cvsFileSystem) + '/' + directoryObject.getName();
        String stickyTag = AdminUtils.getStickyTagForDirectory(parent, cvsFileSystem);
        File cvsDirectory = this.ensureCvsDirectory(directoryObject, cvsFileSystem);
        FileUtils.writeLine((File)new File(cvsDirectory, ROOT_FILE_NAME), (String)cvsRoot);
        FileUtils.writeLine((File)new File(cvsDirectory, REPOSITORY_FILE_NAME), (String)repositoryPath);
        new Entries().write(new File(cvsDirectory, ENTRIES_FILE_NAME), this.myLineSeparator, this.myCharset);
        this.setStickyTagForDirectory(directoryObject, stickyTag, cvsFileSystem);
        this.addDirectoryToParentEntriesFile(cvsDirectory.getParentFile());
    }

    private String getCvsRoot(DirectoryObject directoryObject, ICvsFileSystem cvsFileSystem) throws IOException {
        File cvsRootFile = cvsFileSystem.getAdminFileSystem().getFile((AbstractFileObject)FileObject.createInstance((DirectoryObject)directoryObject, (String)CVS_ROOT_FILE_PATH));
        return FileUtils.readLineFromFile((File)cvsRootFile);
    }

    private String getRepository(DirectoryObject directoryObject, ICvsFileSystem cvsFileSystem) throws IOException {
        File cvsRootFile = cvsFileSystem.getAdminFileSystem().getFile((AbstractFileObject)FileObject.createInstance((DirectoryObject)directoryObject, (String)CVS_REPOSITORY_FILE_PATH));
        return FileUtils.readLineFromFile((File)cvsRootFile);
    }

    private File getCvsDirectoryForLocalDirectory(File directory) {
        return new File(directory, CVS_DIR_NAME);
    }

    private void deleteDirectoryRecursively(File directory) {
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                this.deleteDirectoryRecursively(file);
                continue;
            }
            FileUtil.delete((File)file);
        }
        FileUtil.delete((File)directory);
    }

    private File ensureCvsDirectory(DirectoryObject directoryObject, ICvsFileSystem cvsFileSystem) {
        File cvsDirectory = new File(cvsFileSystem.getAdminFileSystem().getFile((AbstractFileObject)directoryObject), CVS_DIR_NAME);
        cvsDirectory.mkdirs();
        return cvsDirectory;
    }

    private void ensureExistingRootFile(File cvsDirectory, CvsRoot cvsRoot) throws IOException {
        File rootFile = new File(cvsDirectory, ROOT_FILE_NAME);
        if (rootFile.exists()) {
            return;
        }
        FileUtils.writeLine((File)rootFile, (String)cvsRoot.getCvsRoot());
    }

    private void ensureRepositoryFile(File cvsDirectory, String repositoryPath) throws IOException {
        File repositoryFile = new File(cvsDirectory, REPOSITORY_FILE_NAME);
        if (repositoryFile.exists()) {
            return;
        }
        FileUtils.writeLine((File)repositoryFile, (String)repositoryPath);
    }

    private void ensureExistingEntriesFile(File cvsDirectory) throws IOException {
        File entriesFile = new File(cvsDirectory, ENTRIES_FILE_NAME);
        if (entriesFile.exists()) {
            return;
        }
        new Entries().write(entriesFile, this.myLineSeparator, this.myCharset);
        this.addDirectoryToParentEntriesFile(cvsDirectory.getParentFile());
    }

    private void addDirectoryToParentEntriesFile(File directory) throws IOException {
        try {
            this.myEntriesWriter.addEntry(directory.getParentFile(), Entry.createDirectoryEntry((String)directory.getName()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBaserevEntry(FileObject fileObject, ICvsFileSystem cvsFileSystem, Entry entry) throws IOException {
        if (entry == null || entry.getRevision() == null || entry.isAddedFile() || entry.isRemoved()) {
            throw new IllegalArgumentException("File does not have an Entry or Entry is invalid!");
        }
        File file = cvsFileSystem.getAdminFileSystem().getFile((AbstractFileObject)fileObject);
        File baserevFile = new File(file.getParentFile(), CVS_BASEREV_FILE_PATH);
        File backupFile = new File(baserevFile.getAbsolutePath() + '~');
        BufferedReader reader = null;
        BufferedWriter writer = null;
        boolean append = true;
        boolean writeFailed = true;
        String entryStart = 'B' + file.getName() + '/';
        try {
            writer = new BufferedWriter(new FileWriter(backupFile));
            writeFailed = false;
            reader = new BufferedReader(new FileReader(baserevFile));
            String line = reader.readLine();
            while (line != null) {
                if (line.startsWith(entryStart)) {
                    append = false;
                }
                writeFailed = true;
                writer.write(line);
                writer.newLine();
                writeFailed = false;
                line = reader.readLine();
            }
        }
        catch (IOException ex) {
            if (writeFailed) {
                throw ex;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {}
            }
            if (writer != null) {
                if (append && !writeFailed) {
                    writer.write(entryStart + entry.getRevision() + '/');
                    writer.newLine();
                }
                try {
                    writer.close();
                }
                catch (IOException ex) {}
            }
        }
        FileUtil.delete((File)baserevFile);
        FileUtil.rename((File)backupFile, (File)baserevFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBaserevEntry(FileObject fileObject, ICvsFileSystem cvsFileSystem) throws IOException {
        File file = cvsFileSystem.getAdminFileSystem().getFile((AbstractFileObject)fileObject);
        File baserevFile = new File(file.getParentFile(), CVS_BASEREV_FILE_PATH);
        File backupFile = new File(baserevFile.getAbsolutePath() + '~');
        BufferedReader reader = null;
        BufferedWriter writer = null;
        String entryStart = 'B' + file.getName() + '/';
        try {
            writer = new BufferedWriter(new FileWriter(backupFile));
            reader = new BufferedReader(new FileReader(baserevFile));
            String line = reader.readLine();
            while (line != null) {
                if (!line.startsWith(entryStart)) {
                    writer.write(line);
                    writer.newLine();
                }
                line = reader.readLine();
            }
        }
        catch (FileNotFoundException ex) {
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ex) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {}
            }
        }
        FileUtil.delete((File)baserevFile);
        if (backupFile.length() > 0L) {
            FileUtil.rename((File)backupFile, (File)baserevFile);
        } else {
            FileUtil.delete((File)backupFile);
        }
    }

    private File getEditBackupFile(FileObject fileObject, ICvsFileSystem cvsFileSystem) {
        File file = cvsFileSystem.getAdminFileSystem().getFile((AbstractFileObject)fileObject);
        return new File(file.getParentFile(), CVS_BASE_FILE_PATH + file.getName());
    }

    private static class SimpleEntriesWriter
    implements EntriesWriter {
        private final String myCharset;
        private final String myLineSeparator;

        private SimpleEntriesWriter(String charset, String lineSeparator) {
            this.myCharset = charset;
            this.myLineSeparator = lineSeparator;
        }

        @Override
        public void addEntry(File directory, Entry entry) throws IOException {
            EntriesHandler entriesHandler = new EntriesHandler(directory);
            entriesHandler.read(this.myCharset);
            entriesHandler.getEntries().addEntry(entry);
            entriesHandler.write(this.myLineSeparator, this.myCharset);
        }
    }
}

