/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.dsl.internal.transform;

import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.SyntaxException;
import org.gradle.groovy.scripts.internal.AbstractScriptTransformer;
import org.gradle.groovy.scripts.internal.AstUtils;
import org.gradle.groovy.scripts.internal.ScriptBlock;
import org.gradle.model.dsl.internal.transform.RuleVisitor;
import org.gradle.model.dsl.internal.transform.RulesVisitor;

public class ModelBlockTransformer
extends AbstractScriptTransformer {
    private static final String MODEL = "model";
    private static final List<String> SCRIPT_BLOCK_NAMES = Collections.singletonList("model");
    public static final String NON_LITERAL_CLOSURE_TO_TOP_LEVEL_MODEL_MESSAGE = "The top level model() method can only be called with a literal closure argument";

    private static boolean isEnabled() {
        return Boolean.getBoolean("org.gradle.model.dsl");
    }

    protected int getPhase() {
        return 5;
    }

    public String getId() {
        return MODEL;
    }

    public void call(SourceUnit source) throws CompilationFailedException {
        if (!ModelBlockTransformer.isEnabled()) {
            return;
        }
        List statements = source.getAST().getStatementBlock().getStatements();
        for (Statement statement : statements) {
            ScriptBlock scriptBlock = AstUtils.detectScriptBlock((Statement)statement, SCRIPT_BLOCK_NAMES);
            if (scriptBlock == null) {
                String methodName;
                MethodCallExpression methodCall = AstUtils.extractBareMethodCall((Statement)statement);
                if (methodCall == null || (methodName = AstUtils.extractConstantMethodName((MethodCallExpression)methodCall)) == null || !methodName.equals(MODEL)) continue;
                source.getErrorCollector().addError(new SyntaxException(NON_LITERAL_CLOSURE_TO_TOP_LEVEL_MODEL_MESSAGE, statement.getLineNumber(), statement.getColumnNumber()), source);
                continue;
            }
            RuleVisitor ruleVisitor = new RuleVisitor(source);
            RulesVisitor rulesVisitor = new RulesVisitor(source, ruleVisitor);
            scriptBlock.getClosureExpression().getCode().visit((GroovyCodeVisitor)rulesVisitor);
        }
    }
}

