/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator.actions;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.execution.MavenExecuteGoalDialog;
import org.jetbrains.idea.maven.execution.MavenRunConfigurationType;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.navigator.actions.ExecuteMavenGoalHistoryService;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenExecuteGoalAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/maven/navigator/actions/MavenExecuteGoalAction", "actionPerformed"));
        }
        final Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        ExecuteMavenGoalHistoryService historyService = ExecuteMavenGoalHistoryService.getInstance(project);
        MavenExecuteGoalDialog dialog = new MavenExecuteGoalDialog(project, historyService.getHistory());
        String lastWorkingDirectory = historyService.getWorkDirectory();
        if (lastWorkingDirectory.length() == 0) {
            lastWorkingDirectory = MavenExecuteGoalAction.obtainAppropriateWorkingDirectory(project);
        }
        dialog.setWorkDirectory(lastWorkingDirectory);
        if (StringUtil.isEmptyOrSpaces((String)historyService.getCanceledCommand())) {
            if (historyService.getHistory().size() > 0) {
                dialog.setGoals(historyService.getHistory().get(0));
            }
        } else {
            dialog.setGoals(historyService.getCanceledCommand());
        }
        if (!dialog.showAndGet()) {
            historyService.setCanceledCommand(dialog.getGoals());
            return;
        }
        historyService.setCanceledCommand(null);
        String goals = dialog.getGoals();
        goals = goals.trim();
        if (goals.startsWith("mvn ")) {
            goals = goals.substring("mvn ".length()).trim();
        }
        String workDirectory = dialog.getWorkDirectory();
        historyService.addCommand(goals, workDirectory);
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(project);
        File mavenHome = MavenUtil.resolveMavenHomeDirectory(projectsManager.getGeneralSettings().getMavenHome());
        if (mavenHome == null) {
            Notification notification = new Notification("Maven", "Failed to execute goal", RunnerBundle.message("external.maven.home.no.default.with.fix", new Object[0]), NotificationType.ERROR, (NotificationListener)new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                    if (notification == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "org/jetbrains/idea/maven/navigator/actions/MavenExecuteGoalAction$1", "hyperlinkActivated"));
                    }
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/maven/navigator/actions/MavenExecuteGoalAction$1", "hyperlinkActivated"));
                    }
                    ShowSettingsUtil.getInstance().showSettingsDialog(project, "Maven");
                }
            });
            Notifications.Bus.notify((Notification)notification, (Project)project);
            return;
        }
        MavenRunnerParameters parameters = new MavenRunnerParameters(true, workDirectory, Arrays.asList(ParametersList.parse((String)goals)), Collections.<String>emptyList());
        MavenGeneralSettings generalSettings = new MavenGeneralSettings();
        generalSettings.setMavenHome(mavenHome.getPath());
        MavenRunnerSettings runnerSettings = MavenRunner.getInstance(project).getSettings().clone();
        runnerSettings.setMavenProperties(new LinkedHashMap<String, String>());
        runnerSettings.setSkipTests(false);
        MavenRunConfigurationType.runConfiguration(project, parameters, generalSettings, runnerSettings, null);
    }

    private static String obtainAppropriateWorkingDirectory(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/navigator/actions/MavenExecuteGoalAction", "obtainAppropriateWorkingDirectory"));
        }
        List<MavenProject> rootProjects = MavenProjectsManager.getInstance(project).getRootProjects();
        if (rootProjects.isEmpty()) {
            return "";
        }
        return rootProjects.get(0).getDirectory();
    }
}

