/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.parameter;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.lang.Language;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.ExpressionConverter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduceParameter.ChangedMethodCallInfo;
import com.intellij.refactoring.introduceParameter.ExternalUsageInfo;
import com.intellij.refactoring.introduceParameter.InternalUsageInfo;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TIntProcedure;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLoopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;
import org.jetbrains.plugins.groovy.refactoring.introduce.StringPartInfo;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GrExpressionWrapper;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GrIntroduceParameterSettings;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GroovyIntroduceParameterUtil;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.java2groovy.FieldConflictsResolver;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.java2groovy.OldReferencesResolver;
import org.jetbrains.plugins.groovy.refactoring.util.AnySupers;

public class GrIntroduceClosureParameterProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(GrIntroduceClosureParameterProcessor.class);
    private final GrIntroduceParameterSettings mySettings;
    private final GrClosableBlock toReplaceIn;
    private final PsiElement toSearchFor;
    private final GrExpressionWrapper myParameterInitializer;
    private final GroovyPsiElementFactory myFactory;

    public GrIntroduceClosureParameterProcessor(@NotNull GrIntroduceParameterSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/GrIntroduceClosureParameterProcessor", "<init>"));
        }
        super(settings.getProject(), null);
        this.myFactory = GroovyPsiElementFactory.getInstance(this.myProject);
        this.mySettings = settings;
        this.toReplaceIn = (GrClosableBlock)this.mySettings.getToReplaceIn();
        this.toSearchFor = this.mySettings.getToSearchFor();
        StringPartInfo info = settings.getStringPartInfo();
        GrExpression expression = info != null ? info.createLiteralFromSelected() : this.mySettings.getExpression();
        this.myParameterInitializer = new GrExpressionWrapper(expression);
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usages) {
        UsageViewDescriptorAdapter usageViewDescriptorAdapter = new UsageViewDescriptorAdapter(){

            @NotNull
            public PsiElement[] getElements() {
                PsiElement[] psiElementArray = new PsiElement[1];
                Object object = psiElementArray[0] = GrIntroduceClosureParameterProcessor.this.toSearchFor != null ? GrIntroduceClosureParameterProcessor.this.toSearchFor : GrIntroduceClosureParameterProcessor.this.toReplaceIn;
                if (psiElementArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/GrIntroduceClosureParameterProcessor$1", "getElements"));
                }
                return psiElementArray;
            }

            public String getProcessedElementsHeader() {
                return GroovyRefactoringBundle.message("introduce.closure.parameter.elements.header", new Object[0]);
            }
        };
        if (usageViewDescriptorAdapter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/GrIntroduceClosureParameterProcessor", "createUsageViewDescriptor"));
        }
        return usageViewDescriptorAdapter;
    }

    protected boolean preprocessUsages(Ref<UsageInfo[]> refUsages) {
        GrExpression expression;
        UsageInfo[] usagesIn = (UsageInfo[])refUsages.get();
        MultiMap conflicts = new MultiMap();
        if (!this.mySettings.generateDelegate()) {
            this.detectAccessibilityConflicts(usagesIn, (MultiMap<PsiElement, String>)conflicts);
        }
        if ((expression = this.mySettings.getExpression()) != null && this.toSearchFor instanceof PsiMember) {
            AnySupers anySupers = new AnySupers();
            expression.accept(anySupers);
            if (anySupers.containsSupers()) {
                GroovyPsiElement containingClass = PsiUtil.getFileOrClassContext(this.toReplaceIn);
                for (UsageInfo usageInfo : usagesIn) {
                    if (usageInfo.getElement() instanceof PsiMethod || usageInfo instanceof InternalUsageInfo || PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)usageInfo.getElement(), (boolean)false)) continue;
                    conflicts.putValue((Object)expression, (Object)RefactoringBundle.message((String)"parameter.initializer.contains.0.but.not.all.calls.to.method.are.in.its.class", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)"super")}));
                    break;
                }
            }
        }
        return this.showConflicts(conflicts, usagesIn);
    }

    private void detectAccessibilityConflicts(UsageInfo[] usageArray, MultiMap<PsiElement, String> conflicts) {
        GrExpression expression = this.mySettings.getExpression();
        if (expression == null) {
            return;
        }
        GroovyIntroduceParameterUtil.detectAccessibilityConflicts(expression, usageArray, conflicts, this.mySettings.replaceFieldsWithGetters() != 0, this.myProject);
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        ArrayList<Object> result = new ArrayList<Object>();
        if (!this.mySettings.generateDelegate() && this.toSearchFor != null) {
            Collection<Object> refs;
            if (this.toSearchFor instanceof GrField) {
                GrAccessorMethod[] getters;
                refs = ReferencesSearch.search((PsiElement)this.toSearchFor).findAll();
                for (GrAccessorMethod getter : getters = ((GrField)this.toSearchFor).getGetters()) {
                    refs.addAll(MethodReferencesSearch.search((PsiMethod)getter, (SearchScope)getter.getResolveScope(), (boolean)true).findAll());
                }
            } else {
                refs = this.toSearchFor instanceof GrVariable ? GrIntroduceClosureParameterProcessor.findUsagesForLocal(this.toReplaceIn, (GrVariable)this.toSearchFor) : ReferencesSearch.search((PsiElement)this.toSearchFor).findAll();
            }
            for (PsiReference ref1 : refs) {
                PsiElement ref = ref1.getElement();
                if (!PsiTreeUtil.isAncestor((PsiElement)this.toReplaceIn, (PsiElement)ref, (boolean)false)) {
                    result.add(new ExternalUsageInfo(ref));
                    continue;
                }
                result.add(new ChangedMethodCallInfo(ref));
            }
            if (this.toSearchFor instanceof GrVariable && !((GrVariable)this.toSearchFor).hasModifierProperty("final")) {
                this.setPreviewUsages(true);
            }
        }
        if (this.mySettings.replaceAllOccurrences()) {
            PsiElement[] exprs;
            for (PsiElement expr : exprs = GroovyIntroduceParameterUtil.getOccurrences(this.mySettings)) {
                result.add(new InternalUsageInfo(expr));
            }
        } else if (this.mySettings.getExpression() != null) {
            result.add(new InternalUsageInfo((PsiElement)this.mySettings.getExpression()));
        }
        UsageInfo[] usageInfos = result.toArray(new UsageInfo[result.size()]);
        UsageInfo[] usageInfoArray = UsageViewUtil.removeDuplicatedUsages((UsageInfo[])usageInfos);
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/GrIntroduceClosureParameterProcessor", "findUsages"));
        }
        return usageInfoArray;
    }

    private static Collection<PsiReference> findUsagesForLocal(GrClosableBlock initializer, final GrVariable var) {
        Object[] flow = ControlFlowUtils.findControlFlowOwner(initializer).getControlFlow();
        ArrayList<BitSet> writes = ControlFlowUtils.inferWriteAccessMap((Instruction[])flow, var);
        Object writeInstr = null;
        PsiElement parent = initializer.getParent();
        if (parent instanceof GrVariable) {
            writeInstr = (Instruction)ContainerUtil.find((Object[])flow, (Condition)new Condition<Instruction>(){

                public boolean value(Instruction instruction) {
                    return instruction.getElement() == var;
                }
            });
        } else if (parent instanceof GrAssignmentExpression) {
            final GrReferenceExpression refExpr = (GrReferenceExpression)((GrAssignmentExpression)parent).getLValue();
            Instruction instruction = (Instruction)ContainerUtil.find((Object[])flow, (Condition)new Condition<Instruction>(){

                public boolean value(Instruction instruction) {
                    return instruction.getElement() == refExpr;
                }
            });
            LOG.assertTrue(instruction != null);
            BitSet prev = writes.get(instruction.num());
            if (prev.cardinality() == 1) {
                writeInstr = flow[prev.nextSetBit(0)];
            }
        }
        LOG.assertTrue(writeInstr != null);
        ArrayList<PsiReference> result = new ArrayList<PsiReference>();
        for (Object instruction : flow) {
            BitSet prev;
            GrReferenceExpression ref;
            PsiElement element;
            if (!(instruction instanceof ReadWriteVariableInstruction) || ((ReadWriteVariableInstruction)instruction).isWrite() || (element = instruction.getElement()) instanceof GrVariable && element != var || !(element instanceof GrReferenceExpression) || (ref = (GrReferenceExpression)element).isQualified() || ref.resolve() != var || (prev = writes.get(instruction.num())).cardinality() != 1 || !prev.get(writeInstr.num())) continue;
            result.add((PsiReference)ref);
        }
        return result;
    }

    protected void performRefactoring(UsageInfo[] usages) {
        GrIntroduceClosureParameterProcessor.processExternalUsages(usages, this.mySettings, this.myParameterInitializer.getExpression());
        GrIntroduceClosureParameterProcessor.processClosure(usages, this.mySettings);
        GrVariable var = this.mySettings.getVar();
        if (var != null && this.mySettings.removeLocalVariable()) {
            var.delete();
        }
    }

    public static void processClosure(UsageInfo[] usages, GrIntroduceParameterSettings settings) {
        GrIntroduceClosureParameterProcessor.changeSignature((GrClosableBlock)settings.getToReplaceIn(), settings);
        GrIntroduceClosureParameterProcessor.processInternalUsages(usages, settings);
    }

    private static void processInternalUsages(UsageInfo[] usages, GrIntroduceParameterSettings settings) {
        GrExpression expr;
        Editor editor;
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(settings.getProject());
        for (UsageInfo usage : usages) {
            PsiElement element;
            if (usage instanceof ChangedMethodCallInfo) {
                element = usage.getElement();
                GrIntroduceClosureParameterProcessor.processChangedMethodCall(element, settings);
                continue;
            }
            if (!(usage instanceof InternalUsageInfo) || (element = usage.getElement()) == null) continue;
            GrExpression newExpr = factory.createExpressionFromText(settings.getName());
            if (element instanceof GrExpression) {
                ((GrExpression)element).replaceWithExpression(newExpr, true);
                continue;
            }
            element.replace((PsiElement)newExpr);
        }
        StringPartInfo info = settings.getStringPartInfo();
        if (info != null && (editor = PsiUtilBase.findEditor((PsiElement)(expr = info.replaceLiteralWithConcatenation(settings.getName())))) != null) {
            editor.getSelectionModel().removeSelection();
            editor.getCaretModel().moveToOffset(expr.getTextRange().getEndOffset());
        }
    }

    public static void processExternalUsages(UsageInfo[] usages, GrIntroduceParameterSettings settings, PsiElement expression) {
        for (UsageInfo usage : usages) {
            if (!(usage instanceof ExternalUsageInfo)) continue;
            GrIntroduceClosureParameterProcessor.processExternalUsage(usage, settings, expression);
        }
    }

    private static void changeSignature(GrClosableBlock block, GrIntroduceParameterSettings settings) {
        String name = settings.getName();
        FieldConflictsResolver fieldConflictsResolver = new FieldConflictsResolver(name, block);
        final GrParameter[] parameters = block.getParameters();
        settings.parametersToRemove().forEachDescending(new TIntProcedure(){

            public boolean execute(int paramNum) {
                try {
                    GrParameter param = parameters[paramNum];
                    param.delete();
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
                return true;
            }
        });
        PsiType type = settings.getSelectedType();
        String typeText = type == null ? null : type.getCanonicalText();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(settings.getProject());
        GrParameter parameter = factory.createParameter(name, typeText, block);
        parameter.getModifierList().setModifierProperty("final", settings.declareFinal());
        GrParameterList parameterList = block.getParameterList();
        PsiParameter anchorParameter = GroovyIntroduceParameterUtil.getAnchorParameter(parameterList, block.isVarArgs());
        parameter = (GrParameter)parameterList.addAfter(parameter, (PsiElement)anchorParameter);
        if (block.getArrow() == null) {
            PsiElement arrow = block.addAfter(factory.createClosureFromText("{->}").getArrow().copy(), parameterList);
            PsiElement child = block.getFirstChild().getNextSibling();
            if (PsiImplUtil.isWhiteSpaceOrNls(child)) {
                String text = child.getText();
                child.delete();
                block.addAfter(factory.createLineTerminator(text), arrow);
            }
        }
        JavaCodeStyleManager.getInstance((Project)parameter.getProject()).shortenClassReferences((PsiElement)parameter);
        fieldConflictsResolver.fix();
    }

    private static void processExternalUsage(UsageInfo usage, GrIntroduceParameterSettings settings, PsiElement expression) {
        GrArgumentList argList;
        PsiElement actualCallExpression;
        GroovyResolveResult result;
        PsiElement resolved;
        GrExpression invoked;
        PsiElement parent;
        PsiElement element = usage.getElement();
        GrCall callExpression = GroovyRefactoringUtil.getCallExpressionByMethodReference(element);
        if (callExpression == null && (parent = element.getParent()) instanceof GrReferenceExpression && element == ((GrReferenceExpression)parent).getQualifier() && "call".equals(((GrReferenceExpression)parent).getReferenceName())) {
            callExpression = GroovyRefactoringUtil.getCallExpressionByMethodReference(parent);
        }
        if (callExpression == null) {
            return;
        }
        if (callExpression instanceof GrMethodCall && (invoked = ((GrMethodCall)callExpression).getInvokedExpression()) instanceof GrReferenceExpression && (resolved = (result = ((GrReferenceExpression)invoked).advancedResolve()).getElement()) instanceof GrAccessorMethod && !result.isInvokedOnProperty() && (actualCallExpression = callExpression.getParent()) instanceof GrCall) {
            callExpression = (GrCall)actualCallExpression;
        }
        LOG.assertTrue((argList = callExpression.getArgumentList()) != null);
        GrExpression[] oldArgs = argList.getExpressionArguments();
        GrClosableBlock toReplaceIn = (GrClosableBlock)settings.getToReplaceIn();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(settings.getProject());
        GrExpression anchor = GrIntroduceClosureParameterProcessor.getAnchorForArgument(oldArgs, toReplaceIn.isVarArgs(), toReplaceIn.getParameterList());
        GrClosureSignature signature = GrClosureSignatureUtil.createSignature(callExpression);
        if (signature == null) {
            signature = GrClosureSignatureUtil.createSignature(toReplaceIn);
        }
        GrClosureSignatureUtil.ArgInfo<PsiElement>[] actualArgs = GrClosureSignatureUtil.mapParametersToArguments(signature, callExpression.getNamedArguments(), callExpression.getExpressionArguments(), callExpression.getClosureArguments(), callExpression, true, true);
        if (PsiTreeUtil.isAncestor((PsiElement)toReplaceIn, (PsiElement)callExpression, (boolean)false)) {
            argList.addAfter(factory.createExpressionFromText(settings.getName()), anchor);
        } else {
            PsiElement initializer = ExpressionConverter.getExpression((PsiElement)expression, (Language)GroovyLanguage.INSTANCE, (Project)settings.getProject());
            LOG.assertTrue(initializer instanceof GrExpression);
            GrExpression newArg = GroovyIntroduceParameterUtil.addClosureToCall(initializer, argList);
            if (newArg == null) {
                PsiElement dummy = argList.addAfter(factory.createExpressionFromText("1"), anchor);
                newArg = ((GrExpression)dummy).replaceWithExpression((GrExpression)initializer, true);
            }
            new OldReferencesResolver(callExpression, newArg, toReplaceIn, settings.replaceFieldsWithGetters(), initializer, signature, actualArgs, toReplaceIn.getParameters()).resolve();
            ChangeContextUtil.clearContextInfo((PsiElement)initializer);
            if (newArg.isValid()) {
                JavaCodeStyleManager.getInstance((Project)newArg.getProject()).shortenClassReferences((PsiElement)newArg);
                CodeStyleManager.getInstance((Project)settings.getProject()).reformat((PsiElement)newArg);
            }
        }
        if (actualArgs == null) {
            GroovyIntroduceParameterUtil.removeParamsFromUnresolvedCall(callExpression, toReplaceIn.getParameters(), settings.parametersToRemove());
        } else {
            GroovyIntroduceParameterUtil.removeParametersFromCall(actualArgs, settings.parametersToRemove());
        }
        if (argList.getAllArguments().length == 0 && PsiImplUtil.hasClosureArguments(callExpression)) {
            GrArgumentList emptyArgList = ((GrMethodCallExpression)factory.createExpressionFromText("foo{}")).getArgumentList();
            LOG.assertTrue(emptyArgList != null);
            argList.replace(emptyArgList);
        }
    }

    @Nullable
    private static GrExpression getAnchorForArgument(GrExpression[] oldArgs, boolean isVarArg, PsiParameterList parameterList) {
        if (!isVarArg) {
            return (GrExpression)ArrayUtil.getLastElement((Object[])oldArgs);
        }
        PsiParameter[] parameters = parameterList.getParameters();
        if (parameters.length > oldArgs.length) {
            return (GrExpression)ArrayUtil.getLastElement((Object[])oldArgs);
        }
        int lastNonVararg = parameters.length - 2;
        return lastNonVararg >= 0 ? oldArgs[lastNonVararg] : null;
    }

    private GrClosableBlock generateDelegateClosure(GrClosableBlock originalClosure, GrVariable anchor, String newName) {
        GrClosableBlock result;
        if (originalClosure.hasParametersSection()) {
            result = this.myFactory.createClosureFromText("{->}", anchor);
            GrParameterList parameterList = (GrParameterList)originalClosure.getParameterList().copy();
            result.getParameterList().replace(parameterList);
        } else {
            result = this.myFactory.createClosureFromText("{}", anchor);
        }
        StringBuilder call = new StringBuilder();
        call.append(newName).append('(');
        GrParameter[] parameters = result.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (this.mySettings.parametersToRemove().contains(i)) continue;
            call.append(parameters[i].getName()).append(", ");
        }
        call.append(this.myParameterInitializer.getText());
        call.append(")");
        GrStatement statement = this.myFactory.createStatementFromText(call.toString());
        result.addStatementBefore(statement, null);
        return result;
    }

    private GrVariableDeclaration insertDeclaration(GrVariable original, GrVariableDeclaration declaration) {
        GrStatementOwner block;
        if (original instanceof GrField) {
            PsiClass containingClass = ((GrField)original).getContainingClass();
            LOG.assertTrue(containingClass != null);
            return (GrVariableDeclaration)containingClass.addBefore((PsiElement)declaration, original.getParent());
        }
        if (original instanceof PsiParameter) {
            GrCodeBlock block2;
            PsiElement container = original.getParent().getParent();
            if (container instanceof GrMethod) {
                block2 = ((GrMethod)container).getBlock();
            } else if (container instanceof GrClosableBlock) {
                block2 = (GrCodeBlock)container;
            } else if (container instanceof GrForStatement) {
                GrStatement body = ((GrForStatement)container).getBody();
                if (body instanceof GrBlockStatement) {
                    block2 = ((GrBlockStatement)body).getBlock();
                } else {
                    GrBlockStatement blockStatement = this.myFactory.createBlockStatement(new GrStatement[0]);
                    LOG.assertTrue(blockStatement != null);
                    if (body != null) {
                        blockStatement.getBlock().addStatementBefore((GrStatement)body.copy(), null);
                        blockStatement = (GrBlockStatement)body.replace(blockStatement);
                    } else {
                        blockStatement = (GrBlockStatement)container.add((PsiElement)blockStatement);
                    }
                    block2 = blockStatement.getBlock();
                }
            } else {
                throw new IncorrectOperationException();
            }
            LOG.assertTrue(block2 != null);
            return (GrVariableDeclaration)block2.addStatementBefore(declaration, null);
        }
        PsiElement parent = original.getParent();
        LOG.assertTrue(parent instanceof GrVariableDeclaration);
        PsiElement pparent = parent.getParent();
        if (pparent instanceof GrIfStatement) {
            block = ((GrIfStatement)pparent).getThenBranch() == parent ? ((GrIfStatement)pparent).replaceThenBranch(this.myFactory.createBlockStatement(new GrStatement[0])).getBlock() : ((GrIfStatement)pparent).replaceElseBranch(this.myFactory.createBlockStatement(new GrStatement[0])).getBlock();
            parent = block.addStatementBefore((GrVariableDeclaration)parent, null);
        } else if (pparent instanceof GrLoopStatement) {
            block = ((GrLoopStatement)pparent).replaceBody(this.myFactory.createBlockStatement(new GrStatement[0])).getBlock();
            parent = block.addStatementBefore((GrVariableDeclaration)parent, null);
        } else {
            LOG.assertTrue(pparent instanceof GrStatementOwner);
            block = (GrStatementOwner)pparent;
        }
        return (GrVariableDeclaration)block.addStatementBefore(declaration, (GrStatement)parent);
    }

    private static void processChangedMethodCall(PsiElement element, GrIntroduceParameterSettings settings) {
        if (element.getParent() instanceof GrMethodCallExpression) {
            GrMethodCallExpression methodCall = (GrMethodCallExpression)element.getParent();
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(settings.getProject());
            GrExpression expression = factory.createExpressionFromText(settings.getName(), null);
            GrArgumentList argList = methodCall.getArgumentList();
            GroovyPsiElement[] exprs = argList.getAllArguments();
            if (exprs.length > 0) {
                argList.addAfter(expression, exprs[exprs.length - 1]);
            } else {
                argList.add(expression);
            }
            GrIntroduceClosureParameterProcessor.removeParametersFromCall(methodCall, settings);
        } else {
            LOG.error((Object)element.getParent());
        }
    }

    private static void removeParametersFromCall(GrMethodCallExpression methodCall, GrIntroduceParameterSettings settings) {
        GroovyResolveResult resolveResult = methodCall.advancedResolve();
        PsiElement resolved = resolveResult.getElement();
        LOG.assertTrue(resolved instanceof PsiMethod);
        GrClosureSignature signature = GrClosureSignatureUtil.createSignature((PsiMethod)resolved, resolveResult.getSubstitutor());
        final GrClosureSignatureUtil.ArgInfo[] argInfos = GrClosureSignatureUtil.mapParametersToArguments(signature, methodCall);
        LOG.assertTrue(argInfos != null);
        settings.parametersToRemove().forEach(new TIntProcedure(){

            public boolean execute(int value) {
                List args = argInfos[value].args;
                for (PsiElement arg : args) {
                    arg.delete();
                }
                return true;
            }
        });
    }

    protected String getCommandName() {
        return RefactoringBundle.message((String)"introduce.parameter.command", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)this.mySettings.getToReplaceIn())});
    }
}

