/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository.updater;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.internal.repository.ITask;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.internal.repository.archives.Archive;
import com.android.sdklib.internal.repository.packages.AddonPackage;
import com.android.sdklib.internal.repository.packages.BuildToolPackage;
import com.android.sdklib.internal.repository.packages.DocPackage;
import com.android.sdklib.internal.repository.packages.ExtraPackage;
import com.android.sdklib.internal.repository.packages.IAndroidVersionProvider;
import com.android.sdklib.internal.repository.packages.IExactApiLevelDependency;
import com.android.sdklib.internal.repository.packages.IMinApiLevelDependency;
import com.android.sdklib.internal.repository.packages.IMinPlatformToolsDependency;
import com.android.sdklib.internal.repository.packages.IMinToolsDependency;
import com.android.sdklib.internal.repository.packages.IPlatformDependency;
import com.android.sdklib.internal.repository.packages.MinToolsPackage;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.internal.repository.packages.PlatformPackage;
import com.android.sdklib.internal.repository.packages.PlatformToolPackage;
import com.android.sdklib.internal.repository.packages.SamplePackage;
import com.android.sdklib.internal.repository.packages.SystemImagePackage;
import com.android.sdklib.internal.repository.packages.ToolPackage;
import com.android.sdklib.internal.repository.sources.SdkSource;
import com.android.sdklib.internal.repository.sources.SdkSources;
import com.android.sdklib.internal.repository.updater.ArchiveInfo;
import com.android.sdklib.internal.repository.updater.IUpdaterData;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.descriptors.IdDisplay;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class SdkUpdaterLogic {
    private final IUpdaterData mUpdaterData;

    public SdkUpdaterLogic(IUpdaterData updaterData) {
        this.mUpdaterData = updaterData;
    }

    public List<ArchiveInfo> getAllRemoteArchives(SdkSources sources, Package[] localPkgs, boolean includeAll) {
        ArrayList<Package> remotePkgs = new ArrayList<Package>();
        SdkSource[] remoteSources = sources.getAllSources();
        this.fetchRemotePackages(remotePkgs, remoteSources);
        ArrayList<Archive> archives = new ArrayList<Archive>();
        block0: for (Package remotePkg : remotePkgs) {
            if (!includeAll && remotePkg.isObsolete()) continue;
            for (Archive a : remotePkg.getArchives()) {
                if (!a.isCompatible()) continue;
                for (int i = archives.size() - 1; i >= 0; --i) {
                    Package pkgFound = archives.get(i).getParentPackage();
                    if (pkgFound.canBeUpdatedBy(remotePkg) == Package.UpdateInfo.UPDATE) {
                        archives.remove(i);
                        continue;
                    }
                    if (remotePkg.canBeUpdatedBy(pkgFound) == Package.UpdateInfo.UPDATE) continue block0;
                }
                archives.add(a);
                continue block0;
            }
        }
        ArrayList<ArchiveInfo> result = new ArrayList<ArchiveInfo>();
        ArchiveInfo[] localArchives = this.createLocalArchives(localPkgs);
        for (Archive a : archives) {
            this.insertArchive(a, result, archives, remotePkgs, remoteSources, localArchives, false);
        }
        return result;
    }

    public List<ArchiveInfo> computeUpdates(Collection<Archive> selectedArchives, SdkSources sources, Package[] localPkgs, boolean includeAll) {
        ArrayList<ArchiveInfo> archives = new ArrayList<ArchiveInfo>();
        ArrayList<Package> remotePkgs = new ArrayList<Package>();
        SdkSource[] remoteSources = sources.getAllSources();
        ArchiveInfo[] localArchives = this.createLocalArchives(localPkgs);
        if (selectedArchives == null) {
            selectedArchives = this.findUpdates(localArchives, remotePkgs, remoteSources, includeAll);
        }
        for (Archive a : selectedArchives) {
            this.insertArchive(a, archives, selectedArchives, remotePkgs, remoteSources, localArchives, false);
        }
        this.fixMissingLocalDependencies(archives, selectedArchives, remotePkgs, remoteSources, localArchives);
        return archives;
    }

    private double getRevisionRank(FullRevision rev) {
        int p = rev.isPreview() ? 999 : 999 - rev.getPreview();
        return (double)rev.getMajor() + (double)rev.getMinor() / 1000.0 + (double)rev.getMicro() / 1000000.0 + (double)p / 1.0E9;
    }

    public void addNewPlatforms(Collection<ArchiveInfo> archives, SdkSources sources, Package[] localPkgs, boolean includeAll) {
        ArchiveInfo[] localArchives = this.createLocalArchives(localPkgs);
        double currentBuildToolScore = 0.0;
        double currentPlatformScore = 0.0;
        double currentSampleScore = 0.0;
        double currentAddonScore = 0.0;
        double currentDocScore = 0.0;
        HashMap<String, Double> currentExtraScore = new HashMap<String, Double>();
        if (!includeAll && localPkgs != null) {
            for (Package p : localPkgs) {
                double rev = this.getRevisionRank(p.getRevision());
                int api = 0;
                boolean isPreview = false;
                if (p instanceof IAndroidVersionProvider) {
                    AndroidVersion vers = ((IAndroidVersionProvider)((Object)p)).getAndroidVersion();
                    api = vers.getApiLevel();
                    isPreview = vers.isPreview();
                }
                double score = (double)(api * 1000 + (isPreview ? 999 : 0)) + rev;
                if (p instanceof BuildToolPackage) {
                    currentBuildToolScore = Math.max(currentBuildToolScore, score);
                    continue;
                }
                if (p instanceof PlatformPackage) {
                    currentPlatformScore = Math.max(currentPlatformScore, score);
                    continue;
                }
                if (p instanceof SamplePackage) {
                    currentSampleScore = Math.max(currentSampleScore, score);
                    continue;
                }
                if (p instanceof AddonPackage) {
                    currentAddonScore = Math.max(currentAddonScore, score);
                    continue;
                }
                if (p instanceof ExtraPackage) {
                    currentExtraScore.put(((ExtraPackage)p).getPath(), score);
                    continue;
                }
                if (!(p instanceof DocPackage)) continue;
                currentDocScore = Math.max(currentDocScore, score);
            }
        }
        SdkSource[] remoteSources = sources.getAllSources();
        ArrayList<Package> remotePkgs = new ArrayList<Package>();
        this.fetchRemotePackages(remotePkgs, remoteSources);
        Package suggestedDoc = null;
        Package suggestedBuildTool = null;
        for (Package p : remotePkgs) {
            PlatformPackage pp;
            if (p.isObsolete() && !includeAll) continue;
            double rev = this.getRevisionRank(p.getRevision());
            int api = 0;
            boolean isPreview = false;
            if (p instanceof IAndroidVersionProvider) {
                AndroidVersion vers = ((IAndroidVersionProvider)((Object)p)).getAndroidVersion();
                api = vers.getApiLevel();
                isPreview = vers.isPreview();
            }
            double score = (double)(api * 1000 + (isPreview ? 999 : 0)) + rev;
            boolean shouldAdd = false;
            if (p instanceof BuildToolPackage) {
                if (currentBuildToolScore == 0.0 && score > currentBuildToolScore) {
                    suggestedBuildTool = p;
                    currentBuildToolScore = score;
                }
            } else if (p instanceof PlatformPackage) {
                shouldAdd = score > currentPlatformScore;
            } else if (p instanceof SamplePackage) {
                shouldAdd = score > currentSampleScore;
            } else if (p instanceof AddonPackage) {
                shouldAdd = score > currentAddonScore;
            } else if (p instanceof ExtraPackage) {
                String key = ((ExtraPackage)p).getPath();
                shouldAdd = !currentExtraScore.containsKey(key) || score > (Double)currentExtraScore.get(key);
            } else if (p instanceof DocPackage && score > currentDocScore) {
                suggestedDoc = p;
                currentDocScore = score;
            }
            if (shouldAdd) {
                for (Archive a : p.getArchives()) {
                    if (!a.isCompatible()) continue;
                    this.insertArchive(a, archives, null, remotePkgs, remoteSources, localArchives, true);
                }
            }
            if (!(p instanceof PlatformPackage) || !(score >= currentPlatformScore) || (pp = (PlatformPackage)p).getIncludedAbi() != null) continue;
            for (Package p2 : remotePkgs) {
                SystemImagePackage sip;
                if (!(p2 instanceof SystemImagePackage) || ((SystemImagePackage)p2).isPlatform() || p2.isObsolete() && !includeAll || !(sip = (SystemImagePackage)p2).getAndroidVersion().equals(pp.getAndroidVersion())) continue;
                for (Archive a : sip.getArchives()) {
                    if (!a.isCompatible()) continue;
                    this.insertArchive(a, archives, null, remotePkgs, remoteSources, localArchives, true);
                }
            }
        }
        if (suggestedDoc != null) {
            for (Archive a : suggestedDoc.getArchives()) {
                if (!a.isCompatible()) continue;
                this.insertArchive(a, archives, null, remotePkgs, remoteSources, localArchives, true);
            }
        }
        if (suggestedBuildTool != null) {
            for (Archive a : suggestedBuildTool.getArchives()) {
                if (!a.isCompatible()) continue;
                this.insertArchive(a, archives, null, remotePkgs, remoteSources, localArchives, true);
            }
        }
    }

    public ArchiveInfo[] createLocalArchives(Package[] localPkgs) {
        if (localPkgs != null) {
            ArrayList<LocalArchiveInfo> list = new ArrayList<LocalArchiveInfo>();
            for (Package p : localPkgs) {
                for (Archive a : p.getArchives()) {
                    if (a == null || !a.isCompatible()) continue;
                    list.add(new LocalArchiveInfo(a));
                }
            }
            return list.toArray(new ArchiveInfo[list.size()]);
        }
        return new ArchiveInfo[0];
    }

    private Collection<Archive> findUpdates(ArchiveInfo[] localArchives, Collection<Package> remotePkgs, SdkSource[] remoteSources, boolean includeAll) {
        ArrayList<Archive> updates = new ArrayList<Archive>();
        this.fetchRemotePackages(remotePkgs, remoteSources);
        for (ArchiveInfo ai : localArchives) {
            Archive na = ai.getNewArchive();
            if (na == null) continue;
            Package localPkg = na.getParentPackage();
            block1: for (Package remotePkg : remotePkgs) {
                if (!includeAll && remotePkg.isObsolete() || localPkg.canBeUpdatedBy(remotePkg) != Package.UpdateInfo.UPDATE) continue;
                for (Archive a : remotePkg.getArchives()) {
                    if (!a.isCompatible()) continue;
                    for (int i = updates.size() - 1; i >= 0; --i) {
                        Package pkgFound = updates.get(i).getParentPackage();
                        if (pkgFound.canBeUpdatedBy(remotePkg) == Package.UpdateInfo.UPDATE) {
                            updates.remove(i);
                            continue;
                        }
                        if (remotePkg.canBeUpdatedBy(pkgFound) == Package.UpdateInfo.UPDATE) continue block1;
                    }
                    updates.add(a);
                    continue block1;
                }
            }
        }
        return updates;
    }

    private void fixMissingLocalDependencies(Collection<ArchiveInfo> outArchives, Collection<Archive> selectedArchives, Collection<Package> remotePkgs, SdkSource[] remoteSources, ArchiveInfo[] localArchives) {
        block0: for (ArchiveInfo ai : localArchives) {
            Package p;
            Archive a = ai.getNewArchive();
            Package package_ = p = a == null ? null : a.getParentPackage();
            if (p == null) continue;
            for (ArchiveInfo ai2 : outArchives) {
                if (ai2.getReplaced() != a) continue;
                continue block0;
            }
            ArchiveInfo[] deps = this.findDependency(p, outArchives, selectedArchives, remotePkgs, remoteSources, localArchives);
            if (deps == null) continue;
            for (ArchiveInfo aid : deps) {
                aid.addDependencyFor(ai);
            }
        }
    }

    private ArchiveInfo insertArchive(Archive archive, Collection<ArchiveInfo> outArchives, Collection<Archive> selectedArchives, Collection<Package> remotePkgs, SdkSource[] remoteSources, ArchiveInfo[] localArchives, boolean automated) {
        Package p = archive.getParentPackage();
        Archive updatedArchive = null;
        for (ArchiveInfo ai : localArchives) {
            Package lp;
            Archive a = ai.getNewArchive();
            if (a == null || (lp = a.getParentPackage()).canBeUpdatedBy(p) != Package.UpdateInfo.UPDATE) continue;
            updatedArchive = a;
        }
        ArchiveInfo[] deps = this.findDependency(p, outArchives, selectedArchives, remotePkgs, remoteSources, localArchives);
        ArchiveInfo ai = null;
        for (ArchiveInfo ai2 : outArchives) {
            Archive a2 = ai2.getNewArchive();
            if (a2 == null || !a2.getParentPackage().sameItemAs(archive.getParentPackage())) continue;
            ai = ai2;
            break;
        }
        if (ai == null) {
            ai = new ArchiveInfo(archive, updatedArchive, deps);
            outArchives.add(ai);
        }
        if (deps != null) {
            for (ArchiveInfo d : deps) {
                d.addDependencyFor(ai);
            }
        }
        return ai;
    }

    private ArchiveInfo[] findDependency(Package pkg, Collection<ArchiveInfo> outArchives, Collection<Archive> selectedArchives, Collection<Package> remotePkgs, SdkSource[] remoteSources, ArchiveInfo[] localArchives) {
        ArchiveInfo ai;
        HashSet<ArchiveInfo> aiFound = new HashSet<ArchiveInfo>();
        if (pkg instanceof IPlatformDependency && (ai = this.findPlatformDependency((IPlatformDependency)((Object)pkg), outArchives, selectedArchives, remotePkgs, remoteSources, localArchives)) != null) {
            aiFound.add(ai);
        }
        if (pkg instanceof IMinToolsDependency && (ai = this.findToolsDependency((IMinToolsDependency)((Object)pkg), outArchives, selectedArchives, remotePkgs, remoteSources, localArchives)) != null) {
            aiFound.add(ai);
        }
        if (pkg instanceof IMinPlatformToolsDependency && (ai = this.findPlatformToolsDependency((IMinPlatformToolsDependency)((Object)pkg), outArchives, selectedArchives, remotePkgs, remoteSources, localArchives)) != null) {
            aiFound.add(ai);
        }
        if (pkg instanceof IMinApiLevelDependency && (ai = this.findMinApiLevelDependency((IMinApiLevelDependency)((Object)pkg), outArchives, selectedArchives, remotePkgs, remoteSources, localArchives)) != null) {
            aiFound.add(ai);
        }
        if (pkg instanceof IExactApiLevelDependency && (ai = this.findExactApiLevelDependency((IExactApiLevelDependency)((Object)pkg), outArchives, selectedArchives, remotePkgs, remoteSources, localArchives)) != null) {
            aiFound.add(ai);
        }
        if (aiFound.size() > 0) {
            Object[] result = aiFound.toArray(new ArchiveInfo[aiFound.size()]);
            Arrays.sort(result);
            return result;
        }
        return null;
    }

    public ArchiveInfo findToolsDependency(IMinToolsDependency pkg, Collection<ArchiveInfo> outArchives, Collection<Archive> selectedArchives, Collection<Package> remotePkgs, SdkSource[] remoteSources, ArchiveInfo[] localArchives) {
        FullRevision rev = pkg.getMinToolsRevision();
        if (rev.equals(MinToolsPackage.MIN_TOOLS_REV_NOT_SPECIFIED)) {
            return null;
        }
        for (ArchiveInfo ai : localArchives) {
            Package p;
            Archive a = ai.getNewArchive();
            if (a == null || !((p = a.getParentPackage()) instanceof ToolPackage) || ((ToolPackage)p).getRevision().compareTo(rev) < 0) continue;
            return null;
        }
        for (ArchiveInfo ai : outArchives) {
            Package p;
            Archive a = ai.getNewArchive();
            if (a == null || !((p = a.getParentPackage()) instanceof ToolPackage) || ((ToolPackage)p).getRevision().compareTo(rev) < 0) continue;
            return ai;
        }
        if (selectedArchives != null) {
            for (Archive a : selectedArchives) {
                Package p = a.getParentPackage();
                if (!(p instanceof ToolPackage) || ((ToolPackage)p).getRevision().compareTo(rev) < 0) continue;
                return this.insertArchive(a, outArchives, selectedArchives, remotePkgs, remoteSources, localArchives, true);
            }
        }
        this.fetchRemotePackages(remotePkgs, remoteSources);
        FullRevision localRev = rev;
        Archive localArch = null;
        block3: for (Package p : remotePkgs) {
            FullRevision r;
            if (!(p instanceof ToolPackage) || (r = ((ToolPackage)p).getRevision()).compareTo(localRev) < 0) continue;
            for (Archive a : p.getArchives()) {
                if (!a.isCompatible()) continue;
                localRev = r;
                localArch = a;
                continue block3;
            }
        }
        if (localArch != null) {
            return this.insertArchive(localArch, outArchives, selectedArchives, remotePkgs, remoteSources, localArchives, true);
        }
        return new MissingArchiveInfo("Tools", rev);
    }

    public ArchiveInfo findPlatformToolsDependency(IMinPlatformToolsDependency pkg, Collection<ArchiveInfo> outArchives, Collection<Archive> selectedArchives, Collection<Package> remotePkgs, SdkSource[] remoteSources, ArchiveInfo[] localArchives) {
        FullRevision r;
        Package p;
        Archive a2;
        FullRevision rev = pkg.getMinPlatformToolsRevision();
        boolean findMax = false;
        int compareThreshold = 0;
        ArchiveInfo aiMax = null;
        Archive aMax = null;
        if (rev.equals(IMinPlatformToolsDependency.MIN_PLATFORM_TOOLS_REV_INVALID)) {
            findMax = true;
            compareThreshold = 1;
        }
        for (ArchiveInfo ai : localArchives) {
            a2 = ai.getNewArchive();
            if (a2 == null || !((p = a2.getParentPackage()) instanceof PlatformToolPackage)) continue;
            r = ((PlatformToolPackage)p).getRevision();
            if (findMax && r.compareTo(rev) > compareThreshold) {
                rev = r;
                aiMax = ai;
                continue;
            }
            if (findMax || r.compareTo(rev) < compareThreshold) continue;
            return null;
        }
        FullRevision localRev = rev;
        ArchiveInfo localAiMax = null;
        for (ArchiveInfo ai : outArchives) {
            a2 = ai.getNewArchive();
            if (a2 == null || !((p = a2.getParentPackage()) instanceof PlatformToolPackage) || (r = ((PlatformToolPackage)p).getRevision()).compareTo(localRev) < compareThreshold) continue;
            localRev = r;
            localAiMax = ai;
        }
        if (localAiMax != null) {
            if (findMax) {
                rev = localRev;
                aiMax = localAiMax;
            } else {
                return localAiMax;
            }
        }
        localRev = rev;
        Archive localAMax = null;
        if (selectedArchives != null) {
            for (Archive a2 : selectedArchives) {
                p = a2.getParentPackage();
                if (!(p instanceof PlatformToolPackage) || (r = ((PlatformToolPackage)p).getRevision()).compareTo(localRev) < compareThreshold) continue;
                localRev = r;
                localAiMax = null;
                localAMax = a2;
            }
            if (localAMax != null) {
                if (findMax) {
                    rev = localRev;
                    aiMax = null;
                    aMax = localAMax;
                } else {
                    return this.insertArchive(localAMax, outArchives, selectedArchives, remotePkgs, remoteSources, localArchives, true);
                }
            }
        }
        this.fetchRemotePackages(remotePkgs, remoteSources);
        localRev = rev;
        localAMax = null;
        block3: for (Package p2 : remotePkgs) {
            FullRevision r2;
            if (!(p2 instanceof PlatformToolPackage) || (r2 = ((PlatformToolPackage)p2).getRevision()).compareTo(rev) < 0) continue;
            for (Archive a3 : p2.getArchives()) {
                if (!a3.isCompatible() || r2.compareTo(localRev) < compareThreshold) continue;
                localRev = r2;
                localAiMax = null;
                localAMax = a3;
                continue block3;
            }
        }
        if (localAMax != null) {
            if (findMax) {
                rev = localRev;
                aiMax = null;
                aMax = localAMax;
            } else {
                return this.insertArchive(localAMax, outArchives, selectedArchives, remotePkgs, remoteSources, localArchives, true);
            }
        }
        if (findMax) {
            if (aMax != null) {
                return this.insertArchive(aMax, outArchives, selectedArchives, remotePkgs, remoteSources, localArchives, true);
            }
            if (aiMax != null) {
                return aiMax;
            }
        }
        return new MissingArchiveInfo("Platform-tools", rev);
    }

    public ArchiveInfo findPlatformDependency(IPlatformDependency pkg, Collection<ArchiveInfo> outArchives, Collection<Archive> selectedArchives, Collection<Package> remotePkgs, SdkSource[] remoteSources, ArchiveInfo[] localArchives) {
        AndroidVersion v = pkg.getAndroidVersion();
        Class expectedClass = PlatformPackage.class;
        IdDisplay addonVendor = null;
        IdDisplay addonTag = null;
        if (pkg instanceof SystemImagePackage && !((SystemImagePackage)pkg).isPlatform()) {
            expectedClass = AddonPackage.class;
            addonVendor = ((SystemImagePackage)pkg).getAddonVendor();
            addonTag = ((SystemImagePackage)pkg).getTag();
        }
        for (ArchiveInfo ai : localArchives) {
            Package p;
            Archive a = ai.getNewArchive();
            if (a == null || !expectedClass.isInstance(p = a.getParentPackage()) || !v.equals(((IAndroidVersionProvider)((Object)p)).getAndroidVersion()) || addonVendor != null && addonTag != null && p instanceof AddonPackage && (!((AddonPackage)p).getVendorId().equals(addonVendor.getId()) || !((AddonPackage)p).getNameId().equals(addonTag.getId()))) continue;
            return null;
        }
        for (ArchiveInfo ai : outArchives) {
            Package p;
            Archive a = ai.getNewArchive();
            if (a == null || !expectedClass.isInstance(p = a.getParentPackage()) || !v.equals(((IAndroidVersionProvider)((Object)p)).getAndroidVersion()) || addonVendor != null && addonTag != null && p instanceof AddonPackage && (!((AddonPackage)p).getVendorId().equals(addonVendor.getId()) || !((AddonPackage)p).getNameId().equals(addonTag.getId()))) continue;
            return ai;
        }
        if (selectedArchives != null) {
            for (Archive a : selectedArchives) {
                Package p = a.getParentPackage();
                if (!expectedClass.isInstance(p) || !v.equals(((IAndroidVersionProvider)((Object)p)).getAndroidVersion()) || addonVendor != null && addonTag != null && p instanceof AddonPackage && (!((AddonPackage)p).getVendorId().equals(addonVendor.getId()) || !((AddonPackage)p).getNameId().equals(addonTag.getId()))) continue;
                return this.insertArchive(a, outArchives, selectedArchives, remotePkgs, remoteSources, localArchives, true);
            }
        }
        this.fetchRemotePackages(remotePkgs, remoteSources);
        for (Package p : remotePkgs) {
            if (!expectedClass.isInstance(p) || !v.equals(((IAndroidVersionProvider)((Object)p)).getAndroidVersion()) || addonVendor != null && addonTag != null && p instanceof AddonPackage && (!((AddonPackage)p).getVendorId().equals(addonVendor.getId()) || !((AddonPackage)p).getNameId().equals(addonTag.getId()))) continue;
            for (Archive a : p.getArchives()) {
                if (!a.isCompatible()) continue;
                return this.insertArchive(a, outArchives, selectedArchives, remotePkgs, remoteSources, localArchives, true);
            }
        }
        return new MissingPlatformArchiveInfo(pkg.getAndroidVersion());
    }

    protected ArchiveInfo findMinApiLevelDependency(IMinApiLevelDependency pkg, Collection<ArchiveInfo> outArchives, Collection<Archive> selectedArchives, Collection<Package> remotePkgs, SdkSource[] remoteSources, ArchiveInfo[] localArchives) {
        Package p;
        Archive a2;
        int api = pkg.getMinApiLevel();
        if (api == 0) {
            return null;
        }
        for (ArchiveInfo ai : localArchives) {
            a2 = ai.getNewArchive();
            if (a2 == null || !((p = a2.getParentPackage()) instanceof PlatformPackage) || !((PlatformPackage)p).getAndroidVersion().isGreaterOrEqualThan(api)) continue;
            return null;
        }
        int foundApi = 0;
        ArchiveInfo foundAi = null;
        for (ArchiveInfo ai : outArchives) {
            a2 = ai.getNewArchive();
            if (a2 == null || !((p = a2.getParentPackage()) instanceof PlatformPackage) || !((PlatformPackage)p).getAndroidVersion().isGreaterOrEqualThan(api) || api <= foundApi) continue;
            foundApi = api;
            foundAi = ai;
        }
        if (foundAi != null) {
            return foundAi;
        }
        foundApi = 0;
        Archive foundArchive = null;
        if (selectedArchives != null) {
            for (Archive a2 : selectedArchives) {
                p = a2.getParentPackage();
                if (!(p instanceof PlatformPackage) || !((PlatformPackage)p).getAndroidVersion().isGreaterOrEqualThan(api) || api <= foundApi) continue;
                foundApi = api;
                foundArchive = a2;
            }
        }
        this.fetchRemotePackages(remotePkgs, remoteSources);
        for (Package p2 : remotePkgs) {
            if (!(p2 instanceof PlatformPackage) || !((PlatformPackage)p2).getAndroidVersion().isGreaterOrEqualThan(api) || api <= foundApi) continue;
            for (Archive a3 : p2.getArchives()) {
                if (!a3.isCompatible()) continue;
                foundApi = api;
                foundArchive = a3;
            }
        }
        if (foundArchive != null) {
            return this.insertArchive(foundArchive, outArchives, selectedArchives, remotePkgs, remoteSources, localArchives, true);
        }
        return new MissingPlatformArchiveInfo(new AndroidVersion(api, null));
    }

    public ArchiveInfo findExactApiLevelDependency(IExactApiLevelDependency pkg, Collection<ArchiveInfo> outArchives, Collection<Archive> selectedArchives, Collection<Package> remotePkgs, SdkSource[] remoteSources, ArchiveInfo[] localArchives) {
        int api = pkg.getExactApiLevel();
        if (api == 0) {
            return null;
        }
        for (ArchiveInfo ai : localArchives) {
            Package p;
            Archive a = ai.getNewArchive();
            if (a == null || !((p = a.getParentPackage()) instanceof PlatformPackage) || !((PlatformPackage)p).getAndroidVersion().equals(api)) continue;
            return null;
        }
        for (ArchiveInfo ai : outArchives) {
            Package p;
            Archive a = ai.getNewArchive();
            if (a == null || !((p = a.getParentPackage()) instanceof PlatformPackage) || !((PlatformPackage)p).getAndroidVersion().equals(api)) continue;
            return ai;
        }
        if (selectedArchives != null) {
            for (Archive a : selectedArchives) {
                Package p = a.getParentPackage();
                if (!(p instanceof PlatformPackage) || !((PlatformPackage)p).getAndroidVersion().equals(api)) continue;
                return this.insertArchive(a, outArchives, selectedArchives, remotePkgs, remoteSources, localArchives, true);
            }
        }
        this.fetchRemotePackages(remotePkgs, remoteSources);
        for (Package p : remotePkgs) {
            if (!(p instanceof PlatformPackage) || !((PlatformPackage)p).getAndroidVersion().equals(api)) continue;
            for (Archive a : p.getArchives()) {
                if (!a.isCompatible()) continue;
                return this.insertArchive(a, outArchives, selectedArchives, remotePkgs, remoteSources, localArchives, true);
            }
        }
        return new MissingPlatformArchiveInfo(new AndroidVersion(api, null));
    }

    protected void fetchRemotePackages(final Collection<Package> remotePkgs, final SdkSource[] remoteSources) {
        if (remotePkgs.size() > 0) {
            return;
        }
        boolean needsFetch = false;
        for (SdkSource remoteSrc : remoteSources) {
            Package[] pkgs = remoteSrc.getPackages();
            if (pkgs == null) {
                needsFetch = true;
                continue;
            }
            block1: for (Package pkg : pkgs) {
                for (Archive a : pkg.getArchives()) {
                    if (!a.isCompatible() || remotePkgs.contains(pkg)) continue;
                    remotePkgs.add(pkg);
                    continue block1;
                }
            }
        }
        if (!needsFetch) {
            return;
        }
        final boolean forceHttp = this.mUpdaterData.getSettingsController().getSettings().getForceHttp();
        this.mUpdaterData.getTaskFactory().start("Refresh Sources", new ITask(){

            @Override
            public void run(ITaskMonitor monitor) {
                for (SdkSource remoteSrc : remoteSources) {
                    Package[] pkgs = remoteSrc.getPackages();
                    if (pkgs == null) {
                        remoteSrc.load(SdkUpdaterLogic.this.mUpdaterData.getDownloadCache(), monitor, forceHttp);
                        pkgs = remoteSrc.getPackages();
                    }
                    if (pkgs == null) continue;
                    block1: for (Package pkg : pkgs) {
                        for (Archive a : pkg.getArchives()) {
                            if (!a.isCompatible() || remotePkgs.contains(pkg)) continue;
                            remotePkgs.add(pkg);
                            continue block1;
                        }
                    }
                }
            }
        });
    }

    private static class MissingArchiveInfo
    extends ArchiveInfo {
        private final FullRevision mRevision;
        private final String mTitle;
        public static final String TITLE_TOOL = "Tools";
        public static final String TITLE_PLATFORM_TOOL = "Platform-tools";

        public MissingArchiveInfo(String title, FullRevision revision) {
            super(null, null, null);
            this.mTitle = title;
            this.mRevision = revision;
        }

        @Override
        public boolean isAccepted() {
            return false;
        }

        @Override
        public boolean isRejected() {
            return true;
        }

        @Override
        public String getShortDescription() {
            return String.format("Missing Android SDK %1$s, revision %2$s", this.mTitle, this.mRevision.toShortString());
        }
    }

    private static class MissingPlatformArchiveInfo
    extends ArchiveInfo {
        private final AndroidVersion mVersion;

        public MissingPlatformArchiveInfo(AndroidVersion version) {
            super(null, null, null);
            this.mVersion = version;
        }

        @Override
        public boolean isAccepted() {
            return false;
        }

        @Override
        public boolean isRejected() {
            return true;
        }

        @Override
        public String getShortDescription() {
            return String.format("Missing SDK Platform Android%1$s, API %2$d", this.mVersion.isPreview() ? " Preview" : "", this.mVersion.getApiLevel());
        }
    }

    private static class LocalArchiveInfo
    extends ArchiveInfo {
        public LocalArchiveInfo(Archive localArchive) {
            super(localArchive, null, null);
        }

        @Override
        public boolean isAccepted() {
            return true;
        }

        @Override
        public boolean isRejected() {
            return false;
        }
    }
}

