/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.android.refactoring.AndroidInlineTestConfig;
import org.jetbrains.android.refactoring.AndroidInlineUtil;
import org.jetbrains.android.refactoring.AndroidRefactoringErrorException;
import org.jetbrains.android.refactoring.LayoutUsageData;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidInlineLayoutProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.refactoring.AndroidInlineLayoutProcessor");
    private final XmlFile myLayoutFile;
    private final XmlTag myLayoutRootTag;
    private final PsiElement myUsageElement;
    private final AndroidInlineTestConfig myTestConfig;

    protected AndroidInlineLayoutProcessor(@NotNull Project project, @NotNull XmlFile file, @NotNull XmlTag rootTag, @Nullable PsiElement usageElement, @Nullable AndroidInlineTestConfig config) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/refactoring/AndroidInlineLayoutProcessor", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/refactoring/AndroidInlineLayoutProcessor", "<init>"));
        }
        if (rootTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootTag", "org/jetbrains/android/refactoring/AndroidInlineLayoutProcessor", "<init>"));
        }
        super(project);
        this.myLayoutFile = file;
        this.myLayoutRootTag = rootTag;
        this.myUsageElement = usageElement;
        this.myTestConfig = config;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usages) {
        UsageViewDescriptorAdapter usageViewDescriptorAdapter = new UsageViewDescriptorAdapter(){

            @NotNull
            public PsiElement[] getElements() {
                PsiElement[] psiElementArray = new PsiElement[]{AndroidInlineLayoutProcessor.this.myLayoutFile};
                if (psiElementArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/refactoring/AndroidInlineLayoutProcessor$1", "getElements"));
                }
                return psiElementArray;
            }

            public String getCodeReferencesText(int usagesCount, int filesCount) {
                return "References to be inlined" + UsageViewBundle.getReferencesString((int)usagesCount, (int)filesCount);
            }

            public String getProcessedElementsHeader() {
                return "Layout file to inline";
            }
        };
        if (usageViewDescriptorAdapter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/refactoring/AndroidInlineLayoutProcessor", "createUsageViewDescriptor"));
        }
        return usageViewDescriptorAdapter;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        if (this.myUsageElement != null) {
            UsageInfo[] usageInfoArray = new UsageInfo[]{new UsageInfo(this.myUsageElement)};
            if (usageInfoArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/refactoring/AndroidInlineLayoutProcessor", "findUsages"));
            }
            return usageInfoArray;
        }
        HashSet usages = new HashSet();
        AndroidInlineUtil.addReferences((PsiElement)this.myLayoutFile, (Collection<UsageInfo>)usages);
        for (PsiField field : AndroidResourceUtil.findResourceFieldsForFileResource((PsiFile)this.myLayoutFile, false)) {
            AndroidInlineUtil.addReferences((PsiElement)field, (Collection<UsageInfo>)usages);
        }
        UsageInfo[] usageInfoArray = usages.toArray(new UsageInfo[usages.size()]);
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/refactoring/AndroidInlineLayoutProcessor", "findUsages"));
        }
        return usageInfoArray;
    }

    protected void performRefactoring(UsageInfo[] usages) {
        ArrayList<LayoutUsageData> inlineInfos = new ArrayList<LayoutUsageData>();
        for (UsageInfo usage : usages) {
            LayoutUsageData usageData;
            PsiElement element = usage.getElement();
            if (element == null) continue;
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
            LayoutUsageData layoutUsageData = usageData = tag != null ? AndroidInlineUtil.getLayoutUsageData(tag) : null;
            if (usageData == null || usageData.getReference().computeTargetElements().length != 1) continue;
            inlineInfos.add(usageData);
        }
        for (LayoutUsageData info : inlineInfos) {
            try {
                info.inline(this.myLayoutRootTag);
            }
            catch (AndroidRefactoringErrorException e) {
                LOG.info((Throwable)e);
                String message = e.getMessage();
                if (message == null) {
                    message = "Refactoring was performed with errors";
                }
                AndroidUtils.reportError(this.myProject, message, AndroidBundle.message("android.inline.style.title", new Object[0]));
                return;
            }
        }
        if (this.myUsageElement == null) {
            try {
                this.myLayoutFile.delete();
            }
            catch (IncorrectOperationException e) {
                Throwable c = e.getCause();
                if (c instanceof IOException && c.getMessage() != null) {
                    AndroidUtils.reportError(this.myProject, c.getMessage(), AndroidBundle.message("android.inline.style.title", new Object[0]));
                    return;
                }
                throw e;
            }
        }
    }

    protected boolean preprocessUsages(Ref<UsageInfo[]> refUsages) {
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        MultiMap<PsiElement, String> conflicts = AndroidInlineLayoutProcessor.detectConflicts(usages);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myTestConfig.setConflicts(conflicts);
            return true;
        }
        return this.showConflicts(conflicts, usages);
    }

    private static MultiMap<PsiElement, String> detectConflicts(UsageInfo[] usages) {
        ArrayList<PsiElement> nonXmlUsages = new ArrayList<PsiElement>();
        ArrayList<PsiElement> unsupportedUsages = new ArrayList<PsiElement>();
        ArrayList<PsiElement> unambiguousUsages = new ArrayList<PsiElement>();
        for (UsageInfo usage : usages) {
            LayoutUsageData usageData;
            PsiElement element = usage.getElement();
            if (element == null) continue;
            if (element.getLanguage() != XMLLanguage.INSTANCE) {
                nonXmlUsages.add(element);
                continue;
            }
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
            LayoutUsageData layoutUsageData = usageData = tag != null ? AndroidInlineUtil.getLayoutUsageData(tag) : null;
            if (usageData == null) {
                unsupportedUsages.add(element);
                continue;
            }
            if (usageData.getReference().computeTargetElements().length <= 1) continue;
            unambiguousUsages.add(element);
        }
        return AndroidInlineUtil.buildConflicts(nonXmlUsages, unambiguousUsages, unsupportedUsages, Collections.<PsiElement>emptyList());
    }

    protected String getCommandName() {
        return AndroidBundle.message("android.inline.layout.command.name", this.myLayoutFile.getName());
    }

    protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
        return UndoConfirmationPolicy.REQUEST_CONFIRMATION;
    }
}

