/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.documentation.DockablePopupManager;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManagerProtocol;
import com.intellij.codeInsight.documentation.DocumentationManagerUtil;
import com.intellij.codeInsight.documentation.DocumentationPreviewPanelProvider;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.ParameterInfoController;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.BaseNavigateToSourceAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageDocumentation;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.DocumentationProviderEx;
import com.intellij.lang.documentation.ExternalDocumentationHandler;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.preview.PreviewManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ListScrollingUtil;
import com.intellij.ui.content.Content;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupPositionManager;
import com.intellij.ui.popup.PopupUpdateProcessor;
import com.intellij.util.Alarm;
import com.intellij.util.BooleanFunction;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentationManager
extends DockablePopupManager<DocumentationComponent>
implements DocumentationManagerProtocol {
    @NonNls
    public static final String JAVADOC_LOCATION_AND_SIZE = "javadoc.popup";
    public static final DataKey<String> SELECTED_QUICK_DOC_TEXT = DataKey.create((String)"QUICK_DOC.SELECTED_TEXT");
    private static final Logger LOG = Logger.getInstance((String)("#" + DocumentationManager.class.getName()));
    private static final String SHOW_DOCUMENTATION_IN_TOOL_WINDOW = "ShowDocumentationInToolWindow";
    private static final String DOCUMENTATION_AUTO_UPDATE_ENABLED = "DocumentationAutoUpdateEnabled";
    private Editor myEditor = null;
    private final Alarm myUpdateDocAlarm;
    private WeakReference<JBPopup> myDocInfoHintRef;
    private Component myPreviouslyFocused = null;
    public static final Key<SmartPsiElementPointer> ORIGINAL_ELEMENT_KEY = Key.create((String)"Original element");
    private final ActionManagerEx myActionManagerEx;
    private static final int ourFlagsForTargetElements = TargetElementUtilBase.getInstance().getAllAccepted();
    private boolean myCloseOnSneeze;
    private ActionCallback myLastAction;

    @Override
    protected String getToolwindowId() {
        return ToolWindowId.DOCUMENTATION;
    }

    @Override
    protected DocumentationComponent createComponent() {
        return new DocumentationComponent(this, this.createActions());
    }

    @Override
    protected String getRestorePopupDescription() {
        return "Restore popup view mode";
    }

    @Override
    protected String getAutoUpdateDescription() {
        return "Refresh documentation on selection change automatically";
    }

    @Override
    protected String getAutoUpdateTitle() {
        return "Auto-update from Source";
    }

    @Override
    @NotNull
    protected AnAction createRestorePopupAction() {
        AnAction restorePopupAction = super.createRestorePopupAction();
        ShortcutSet quickDocShortcut = ActionManager.getInstance().getAction("QuickJavaDoc").getShortcutSet();
        restorePopupAction.registerCustomShortcutSet(quickDocShortcut, null);
        AnAction anAction = restorePopupAction;
        if (anAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/documentation/DocumentationManager", "createRestorePopupAction"));
        }
        return anAction;
    }

    @Override
    protected void restorePopupBehavior() {
        if (this.myPreviouslyFocused != null) {
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus(this.myPreviouslyFocused, true);
        }
        super.restorePopupBehavior();
        this.updateComponent();
    }

    public boolean isCloseOnSneeze() {
        return this.myCloseOnSneeze;
    }

    public static DocumentationManager getInstance(Project project) {
        return (DocumentationManager)ServiceManager.getService((Project)project, DocumentationManager.class);
    }

    public DocumentationManager(Project project, ActionManagerEx managerEx) {
        super(project);
        this.myActionManagerEx = managerEx;
        AnActionListener actionListener = new AnActionListener(){

            public void beforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
                JBPopup hint = DocumentationManager.this.getDocInfoHint();
                if (hint != null) {
                    if (action instanceof HintManagerImpl.ActionToIgnore) {
                        ((AbstractPopup)hint).focusPreferredComponent();
                        return;
                    }
                    if (action instanceof ListScrollingUtil.ListScrollAction) {
                        return;
                    }
                    if (action == DocumentationManager.this.myActionManagerEx.getAction("EditorDown")) {
                        return;
                    }
                    if (action == DocumentationManager.this.myActionManagerEx.getAction("EditorUp")) {
                        return;
                    }
                    if (action == DocumentationManager.this.myActionManagerEx.getAction("EditorPageDown")) {
                        return;
                    }
                    if (action == DocumentationManager.this.myActionManagerEx.getAction("EditorPageUp")) {
                        return;
                    }
                    if (action == ActionManagerEx.getInstanceEx().getAction("EditorEscape")) {
                        return;
                    }
                    if ("JavadocInplaceSettings".equals(event.getPlace())) {
                        return;
                    }
                    if (action instanceof BaseNavigateToSourceAction) {
                        return;
                    }
                    DocumentationManager.this.closeDocHint();
                }
            }

            public void beforeEditorTyping(char c, DataContext dataContext) {
                JBPopup hint = DocumentationManager.this.getDocInfoHint();
                if (hint != null && LookupManager.getActiveLookup(DocumentationManager.this.myEditor) == null) {
                    hint.cancel();
                }
            }

            public void afterActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
            }
        };
        this.myActionManagerEx.addAnActionListener(actionListener, (Disposable)project);
        this.myUpdateDocAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this.myProject);
    }

    private void closeDocHint() {
        JBPopup hint = this.getDocInfoHint();
        if (hint == null) {
            return;
        }
        this.myCloseOnSneeze = false;
        hint.cancel();
        Component toFocus = this.myPreviouslyFocused;
        hint.cancel();
        if (toFocus != null) {
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus(toFocus, true);
        }
    }

    public void setAllowContentUpdateFromContext(boolean allow) {
        if (this.hasActiveDockedDocWindow()) {
            this.restartAutoUpdate(allow);
        }
    }

    public void updateToolwindowContext() {
        if (this.hasActiveDockedDocWindow()) {
            this.updateComponent();
        }
    }

    public void showJavaDocInfoAtToolWindow(@NotNull PsiElement element, @NotNull PsiElement original) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/documentation/DocumentationManager", "showJavaDocInfoAtToolWindow"));
        }
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/codeInsight/documentation/DocumentationManager", "showJavaDocInfoAtToolWindow"));
        }
        Content content = this.recreateToolWindow(element, original);
        if (content == null) {
            return;
        }
        this.fetchDocInfo(this.getDefaultCollector(element, original), (DocumentationComponent)content.getComponent(), true);
    }

    public void showJavaDocInfo(@NotNull PsiElement element, PsiElement original) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/documentation/DocumentationManager", "showJavaDocInfo"));
        }
        this.showJavaDocInfo(element, original, null);
    }

    public void showJavaDocInfo(@NotNull Editor editor, @NotNull PsiElement element, @NotNull PsiElement original, @Nullable Runnable closeCallback, boolean closeOnSneeze) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/documentation/DocumentationManager", "showJavaDocInfo"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/documentation/DocumentationManager", "showJavaDocInfo"));
        }
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/codeInsight/documentation/DocumentationManager", "showJavaDocInfo"));
        }
        this.myEditor = editor;
        this.myCloseOnSneeze = closeOnSneeze;
        this.showJavaDocInfo(element, original, closeCallback);
    }

    public void showJavaDocInfo(@NotNull PsiElement element, final PsiElement original, @Nullable Runnable closeCallback) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/documentation/DocumentationManager", "showJavaDocInfo"));
        }
        if (!element.isValid()) {
            return;
        }
        PopupUpdateProcessor updateProcessor = new PopupUpdateProcessor(element.getProject()){

            public void updatePopup(Object lookupItemObject) {
                if (lookupItemObject instanceof PsiElement) {
                    DocumentationManager.this.doShowJavaDocInfo((PsiElement)lookupItemObject, false, this, original, null);
                }
            }
        };
        this.doShowJavaDocInfo(element, false, updateProcessor, original, closeCallback);
    }

    public void showJavaDocInfo(Editor editor, @Nullable PsiFile file, boolean requestFocus) {
        this.showJavaDocInfo(editor, file, requestFocus, null);
    }

    public void showJavaDocInfo(Editor editor, final @Nullable PsiFile file, boolean requestFocus, final @Nullable Runnable closeCallback) {
        this.myEditor = editor;
        Project project = this.getProject((PsiElement)file);
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        Object list = ParameterInfoController.findArgumentList(file, editor.getCaretModel().getOffset(), -1);
        Object expressionList = null;
        if (list != null) {
            LookupEx lookup = LookupManager.getInstance(this.myProject).getActiveLookup();
            expressionList = lookup != null ? null : list;
        }
        final PsiElement originalElement = DocumentationManager.getContextElement(editor, file);
        PsiElement element = this.assertSameProject(this.findTargetElement(editor, file));
        if (element == null && expressionList != null) {
            element = expressionList;
        }
        if (element == null && file == null) {
            return;
        }
        if (element == null) {
            element = this.assertSameProject(originalElement);
            if (element == null) {
                return;
            }
            PsiComment comment = (PsiComment)PsiTreeUtil.getParentOfType((PsiElement)element, PsiComment.class);
            if (comment == null) {
                return;
            }
            PsiElement psiElement = element = comment instanceof PsiDocCommentBase ? ((PsiDocCommentBase)comment).getOwner() : comment.getParent();
            if (element == null) {
                return;
            }
        }
        PopupUpdateProcessor updateProcessor = new PopupUpdateProcessor(project){

            public void updatePopup(Object lookupIteObject) {
                if (lookupIteObject == null) {
                    return;
                }
                if (lookupIteObject instanceof PsiElement) {
                    DocumentationManager.this.doShowJavaDocInfo((PsiElement)lookupIteObject, false, this, originalElement, closeCallback);
                    return;
                }
                DocumentationProvider documentationProvider = DocumentationManager.getProviderFromElement((PsiElement)file);
                PsiElement element = documentationProvider.getDocumentationElementForLookupItem(PsiManager.getInstance((Project)DocumentationManager.this.myProject), lookupIteObject, originalElement);
                if (element == null) {
                    return;
                }
                if (DocumentationManager.this.myEditor != null) {
                    PsiFile file2 = element.getContainingFile();
                    if (file2 != null) {
                        Editor editor = DocumentationManager.this.myEditor;
                        DocumentationManager.this.showJavaDocInfo(DocumentationManager.this.myEditor, file2, false);
                        DocumentationManager.this.myEditor = editor;
                    }
                } else {
                    DocumentationManager.this.doShowJavaDocInfo(element, false, this, originalElement, closeCallback);
                }
            }
        };
        this.doShowJavaDocInfo(element, requestFocus, updateProcessor, originalElement, closeCallback);
    }

    public PsiElement findTargetElement(Editor editor, PsiFile file) {
        return this.findTargetElement(editor, file, DocumentationManager.getContextElement(editor, file));
    }

    private static PsiElement getContextElement(Editor editor, PsiFile file) {
        return file != null ? file.findElementAt(editor.getCaretModel().getOffset()) : null;
    }

    private void doShowJavaDocInfo(@NotNull PsiElement element, boolean requestFocus, PopupUpdateProcessor updateProcessor, PsiElement originalElement, @Nullable Runnable closeCallback) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/documentation/DocumentationManager", "doShowJavaDocInfo"));
        }
        Project project = this.getProject(element);
        if (!project.isOpen()) {
            return;
        }
        DocumentationManager.storeOriginalElement(project, originalElement, element);
        this.myPreviouslyFocused = WindowManagerEx.getInstanceEx().getFocusedComponent(project);
        JBPopup _oldHint = this.getDocInfoHint();
        if (PreviewManager.SERVICE.preview(this.myProject, DocumentationPreviewPanelProvider.ID, Couple.of((Object)element, (Object)originalElement), requestFocus) != null) {
            return;
        }
        if (this.myToolWindow == null && PropertiesComponent.getInstance().isTrueValue(SHOW_DOCUMENTATION_IN_TOOL_WINDOW)) {
            this.createToolWindow(element, originalElement);
        } else if (this.myToolWindow != null) {
            Content content = this.myToolWindow.getContentManager().getSelectedContent();
            if (content != null) {
                DocumentationComponent component = (DocumentationComponent)content.getComponent();
                boolean sameElement = element.getManager().areElementsEquivalent(component.getElement(), element);
                if (sameElement) {
                    boolean focus;
                    JComponent preferredFocusableComponent = content.getPreferredFocusableComponent();
                    boolean bl = focus = requestFocus || CommandProcessor.getInstance().getCurrentCommand() != null;
                    if (preferredFocusableComponent != null && focus) {
                        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)preferredFocusableComponent, true);
                    }
                }
                if (!sameElement || !component.isUpToDate()) {
                    content.setDisplayName(DocumentationManager.getTitle(element, true));
                    this.fetchDocInfo(this.getDefaultCollector(element, originalElement), component, true);
                }
            }
            if (!this.myToolWindow.isVisible()) {
                this.myToolWindow.show(null);
            }
        } else if (_oldHint != null && _oldHint.isVisible() && _oldHint instanceof AbstractPopup) {
            DocumentationComponent oldComponent = (DocumentationComponent)((AbstractPopup)_oldHint).getComponent();
            this.fetchDocInfo(this.getDefaultCollector(element, originalElement), oldComponent);
        } else {
            this.showInPopup(element, requestFocus, updateProcessor, originalElement, closeCallback);
        }
    }

    private void showInPopup(final @NotNull PsiElement element, boolean requestFocus, PopupUpdateProcessor updateProcessor, final PsiElement originalElement, final @Nullable Runnable closeCallback) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/documentation/DocumentationManager", "showInPopup"));
        }
        final DocumentationComponent component = new DocumentationComponent(this);
        component.setNavigateCallback(new Consumer<PsiElement>(){

            public void consume(PsiElement psiElement) {
                AbstractPopup jbPopup = (AbstractPopup)DocumentationManager.this.getDocInfoHint();
                if (jbPopup != null) {
                    String title = DocumentationManager.getTitle(psiElement, false);
                    jbPopup.setCaption(title);
                }
            }
        });
        Processor<JBPopup> pinCallback = new Processor<JBPopup>(){

            public boolean process(JBPopup popup) {
                DocumentationManager.this.createToolWindow(element, originalElement);
                DocumentationManager.this.myToolWindow.setAutoHide(false);
                popup.cancel();
                return false;
            }
        };
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DocumentationManager.this.createToolWindow(element, originalElement);
                JBPopup hint = DocumentationManager.this.getDocInfoHint();
                if (hint != null && hint.isVisible()) {
                    hint.cancel();
                }
            }
        };
        List actions = ContainerUtil.newSmartList();
        AnAction quickDocAction = ActionManagerEx.getInstanceEx().getAction("QuickJavaDoc");
        for (Shortcut shortcut : quickDocAction.getShortcutSet().getShortcuts()) {
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            actions.add(Pair.create((Object)actionListener, (Object)((KeyboardShortcut)shortcut).getFirstKeyStroke()));
        }
        boolean hasLookup = LookupManager.getActiveLookup(this.myEditor) != null;
        JBPopup hint = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)component, (JComponent)component).setProject(element.getProject()).addListener((JBPopupListener)updateProcessor).addUserData((Object)updateProcessor).setKeyboardActions(actions).setDimensionServiceKey(this.myProject, JAVADOC_LOCATION_AND_SIZE, false).setResizable(true).setMovable(true).setRequestFocus(requestFocus).setCancelOnClickOutside(!hasLookup).setTitle(DocumentationManager.getTitle(element, false)).setCouldPin((Processor)pinCallback).setModalContext(false).setCancelCallback((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                DocumentationManager.this.myCloseOnSneeze = false;
                if (closeCallback != null) {
                    closeCallback.run();
                }
                if (DocumentationManager.this.fromQuickSearch()) {
                    ((ChooseByNameBase.JPanelProvider)DocumentationManager.this.myPreviouslyFocused.getParent()).unregisterHint();
                }
                Disposer.dispose((Disposable)component);
                DocumentationManager.this.myEditor = null;
                DocumentationManager.this.myPreviouslyFocused = null;
                return Boolean.TRUE;
            }
        }).setKeyEventHandler((BooleanFunction)new BooleanFunction<KeyEvent>(){

            public boolean fun(KeyEvent e) {
                if (DocumentationManager.this.myCloseOnSneeze) {
                    DocumentationManager.this.closeDocHint();
                }
                if (AbstractPopup.isCloseRequest(e) && DocumentationManager.this.getDocInfoHint() != null) {
                    DocumentationManager.this.closeDocHint();
                    return true;
                }
                return false;
            }
        }).createPopup();
        component.setHint(hint);
        if (this.myEditor == null) {
            LookupEx lookup = LookupManager.getInstance(this.myProject).getActiveLookup();
            this.myEditor = lookup != null ? lookup.getEditor() : null;
        }
        this.fetchDocInfo(this.getDefaultCollector(element, originalElement), component);
        this.myDocInfoHintRef = new WeakReference<JBPopup>(hint);
        if (this.fromQuickSearch() && this.myPreviouslyFocused != null) {
            ((ChooseByNameBase.JPanelProvider)this.myPreviouslyFocused.getParent()).registerHint(hint);
        }
    }

    static String getTitle(@NotNull PsiElement element, boolean _short) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/documentation/DocumentationManager", "getTitle"));
        }
        String title = SymbolPresentationUtil.getSymbolPresentableText(element);
        return _short ? (title != null ? title : element.getText()) : CodeInsightBundle.message((String)"javadoc.info.title", (Object[])new Object[]{title != null ? title : element.getText()});
    }

    public static void storeOriginalElement(Project project, PsiElement originalElement, PsiElement element) {
        if (element == null) {
            return;
        }
        try {
            element.putUserData(ORIGINAL_ELEMENT_KEY, (Object)SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(originalElement));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Nullable
    public PsiElement findTargetElement(@NotNull Editor editor, @Nullable PsiFile file, PsiElement contextElement) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/documentation/DocumentationManager", "findTargetElement"));
        }
        return this.findTargetElement(editor, editor.getCaretModel().getOffset(), file, contextElement);
    }

    @Nullable
    public PsiElement findTargetElement(Editor editor, int offset, @Nullable PsiFile file, PsiElement contextElement) {
        try {
            return this.findTargetElementUnsafe(editor, offset, file, contextElement);
        }
        catch (IndexNotReadyException inre) {
            LOG.warn("Index not ready");
            LOG.debug((Throwable)inre);
            return null;
        }
    }

    @Nullable
    private PsiElement findTargetElementUnsafe(Editor editor, int offset, @Nullable PsiFile file, PsiElement contextElement) {
        PsiReference ref;
        PsiElement adjusted;
        DocumentationProvider documentationProvider;
        TargetElementUtilBase util = TargetElementUtilBase.getInstance();
        PsiElement element = this.assertSameProject(this.getElementFromLookup(editor, file));
        if (element == null && file != null && (documentationProvider = DocumentationManager.getProviderFromElement((PsiElement)file)) instanceof DocumentationProviderEx) {
            element = this.assertSameProject(((DocumentationProviderEx)documentationProvider).getCustomDocumentationElement(editor, file, contextElement));
        }
        if (element == null && ((element = this.assertSameProject(util.findTargetElement(editor, ourFlagsForTargetElements, offset))) != null || contextElement != null) && (adjusted = this.assertSameProject(util.adjustElement(editor, ourFlagsForTargetElements, element, contextElement))) != null) {
            element = adjusted;
        }
        if (element == null && (ref = TargetElementUtilBase.findReference(editor, offset)) != null) {
            element = this.assertSameProject(util.adjustReference(ref));
            if (ref instanceof PsiPolyVariantReference) {
                element = this.assertSameProject(ref.getElement());
            }
        }
        DocumentationManager.storeOriginalElement(this.myProject, contextElement, element);
        return element;
    }

    @Nullable
    public PsiElement getElementFromLookup(Editor editor, @Nullable PsiFile file) {
        LookupElement item;
        LookupEx activeLookup = LookupManager.getInstance(this.myProject).getActiveLookup();
        if (activeLookup != null && (item = activeLookup.getCurrentItem()) != null) {
            PsiElement targetElement;
            int offset = editor.getCaretModel().getOffset();
            if (offset > 0 && offset == editor.getDocument().getTextLength()) {
                --offset;
            }
            PsiReference ref = TargetElementUtilBase.findReference(editor, offset);
            PsiElement contextElement = file == null ? null : file.findElementAt(offset);
            PsiElement psiElement = targetElement = ref != null ? ref.getElement() : contextElement;
            if (targetElement != null) {
                PsiUtilCore.ensureValid((PsiElement)targetElement);
            }
            DocumentationProvider documentationProvider = DocumentationManager.getProviderFromElement((PsiElement)file);
            PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
            return documentationProvider.getDocumentationElementForLookupItem(psiManager, item.getObject(), targetElement);
        }
        return null;
    }

    private boolean fromQuickSearch() {
        return this.myPreviouslyFocused != null && this.myPreviouslyFocused.getParent() instanceof ChooseByNameBase.JPanelProvider;
    }

    private DocumentationCollector getDefaultCollector(@NotNull PsiElement element, @Nullable PsiElement originalElement) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/documentation/DocumentationManager", "getDefaultCollector"));
        }
        return new DefaultDocumentationCollector(element, originalElement);
    }

    @Nullable
    public JBPopup getDocInfoHint() {
        if (this.myDocInfoHintRef == null) {
            return null;
        }
        JBPopup hint = (JBPopup)this.myDocInfoHintRef.get();
        if (hint == null || !hint.isVisible() && !ApplicationManager.getApplication().isUnitTestMode()) {
            this.myDocInfoHintRef = null;
            return null;
        }
        return hint;
    }

    public void fetchDocInfo(DocumentationCollector provider, DocumentationComponent component) {
        this.doFetchDocInfo(component, provider, true, false);
    }

    public void fetchDocInfo(DocumentationCollector provider, DocumentationComponent component, boolean clearHistory) {
        this.doFetchDocInfo(component, provider, true, clearHistory);
    }

    public void fetchDocInfo(PsiElement element, DocumentationComponent component) {
        this.doFetchDocInfo(component, this.getDefaultCollector(element, null), true, false);
    }

    public ActionCallback queueFetchDocInfo(DocumentationCollector provider, DocumentationComponent component, boolean clearHistory) {
        return this.doFetchDocInfo(component, provider, false, clearHistory);
    }

    public ActionCallback queueFetchDocInfo(PsiElement element, DocumentationComponent component) {
        return this.queueFetchDocInfo(this.getDefaultCollector(element, null), component, false);
    }

    private ActionCallback doFetchDocInfo(final DocumentationComponent component, final DocumentationCollector provider, boolean cancelRequests, final boolean clearHistory) {
        ActionCallback callback;
        this.myLastAction = callback = new ActionCallback();
        boolean wasEmpty = component.isEmpty();
        component.startWait();
        if (cancelRequests) {
            this.myUpdateDocAlarm.cancelAllRequests();
        }
        if (wasEmpty) {
            component.setText(CodeInsightBundle.message((String)"javadoc.fetching.progress", (Object[])new Object[0]), null, clearHistory);
            AbstractPopup jbPopup = (AbstractPopup)this.getDocInfoHint();
            if (jbPopup != null) {
                jbPopup.setDimensionServiceKey(null);
            }
        }
        this.myUpdateDocAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                if (DocumentationManager.this.myProject.isDisposed()) {
                    return;
                }
                final Throwable[] ex = new Throwable[1];
                String text = null;
                try {
                    text = provider.getDocumentation();
                }
                catch (Throwable e) {
                    LOG.info(e);
                    ex[0] = e;
                }
                if (ex[0] != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String message = ex[0] instanceof IndexNotReadyException ? "Documentation is not available until indices are built." : CodeInsightBundle.message((String)"javadoc.external.fetch.error.message", (Object[])new Object[0]);
                            component.setText(message, null, true);
                            callback.setDone();
                        }
                    });
                    return;
                }
                final PsiElement element = (PsiElement)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiElement>(){

                    @Nullable
                    public PsiElement compute() {
                        return provider.getElement();
                    }
                });
                if (element == null) {
                    return;
                }
                final String documentationText = text;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PsiDocumentManager.getInstance((Project)DocumentationManager.this.myProject).commitAllDocuments();
                        if (!element.isValid()) {
                            callback.setDone();
                            return;
                        }
                        if (documentationText == null) {
                            component.setText(CodeInsightBundle.message((String)"no.documentation.found", (Object[])new Object[0]), element, true);
                        } else if (documentationText.length() == 0) {
                            component.setText(component.getText(), element, true, clearHistory);
                        } else {
                            component.setData(element, documentationText, clearHistory, provider.getEffectiveExternalUrl());
                        }
                        AbstractPopup jbPopup = (AbstractPopup)DocumentationManager.this.getDocInfoHint();
                        if (jbPopup == null) {
                            callback.setDone();
                            return;
                        }
                        jbPopup.setDimensionServiceKey(DocumentationManager.JAVADOC_LOCATION_AND_SIZE);
                        jbPopup.setCaption(DocumentationManager.getTitle(element, false));
                        callback.setDone();
                    }
                });
            }
        }, 10);
        return callback;
    }

    @NotNull
    public static DocumentationProvider getProviderFromElement(PsiElement element) {
        DocumentationProvider documentationProvider = DocumentationManager.getProviderFromElement(element, null);
        if (documentationProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/documentation/DocumentationManager", "getProviderFromElement"));
        }
        return documentationProvider;
    }

    @NotNull
    public static DocumentationProvider getProviderFromElement(@Nullable PsiElement element, @Nullable PsiElement originalElement) {
        if (element != null && !element.isValid()) {
            element = null;
        }
        if (originalElement != null && !originalElement.isValid()) {
            originalElement = null;
        }
        if (originalElement == null) {
            originalElement = DocumentationManager.getOriginalElement(element);
        }
        PsiFile containingFile = originalElement != null ? originalElement.getContainingFile() : (element != null ? element.getContainingFile() : null);
        LinkedHashSet<DocumentationProvider> result = new LinkedHashSet<DocumentationProvider>();
        Language containingFileLanguage = containingFile != null ? containingFile.getLanguage() : null;
        DocumentationProvider originalProvider = containingFile != null ? LanguageDocumentation.INSTANCE.forLanguage(containingFileLanguage) : null;
        Language elementLanguage = element != null ? element.getLanguage() : null;
        DocumentationProvider elementProvider = element == null || elementLanguage.is(containingFileLanguage) ? null : LanguageDocumentation.INSTANCE.forLanguage(elementLanguage);
        result.add(elementProvider);
        result.add(originalProvider);
        if (containingFile != null) {
            Language baseLanguage = containingFile.getViewProvider().getBaseLanguage();
            if (!baseLanguage.is(containingFileLanguage)) {
                result.add(LanguageDocumentation.INSTANCE.forLanguage(baseLanguage));
            }
        } else if (element instanceof PsiDirectory) {
            HashSet<Language> langs = new HashSet<Language>();
            for (PsiFile file : ((PsiDirectory)element).getFiles()) {
                Language baseLanguage = file.getViewProvider().getBaseLanguage();
                if (langs.contains(baseLanguage)) continue;
                langs.add(baseLanguage);
                result.add(LanguageDocumentation.INSTANCE.forLanguage(baseLanguage));
            }
        }
        DocumentationProvider documentationProvider = CompositeDocumentationProvider.wrapProviders(result);
        if (documentationProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/documentation/DocumentationManager", "getProviderFromElement"));
        }
        return documentationProvider;
    }

    @Nullable
    public static PsiElement getOriginalElement(PsiElement element) {
        SmartPsiElementPointer originalElementPointer = element != null ? (SmartPsiElementPointer)element.getUserData(ORIGINAL_ELEMENT_KEY) : null;
        return originalElementPointer != null ? originalElementPointer.getElement() : null;
    }

    void navigateByLink(DocumentationComponent component, final String url) {
        component.setCursor(Cursor.getPredefinedCursor(3));
        final PsiElement psiElement = component.getElement();
        if (psiElement == null) {
            return;
        }
        PsiManager manager = PsiManager.getInstance((Project)this.getProject(psiElement));
        if (url.startsWith("open")) {
            PsiFile containingFile = psiElement.getContainingFile();
            OrderEntry libraryEntry = null;
            if (containingFile != null) {
                VirtualFile virtualFile = containingFile.getVirtualFile();
                libraryEntry = LibraryUtil.findLibraryEntry((VirtualFile)virtualFile, (Project)this.myProject);
            } else if (psiElement instanceof PsiDirectoryContainer) {
                PsiDirectory directory;
                VirtualFile virtualFile;
                PsiDirectory[] directories;
                PsiDirectory[] arr$ = directories = ((PsiDirectoryContainer)psiElement).getDirectories();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && (libraryEntry = LibraryUtil.findLibraryEntry((VirtualFile)(virtualFile = (directory = arr$[i$]).getVirtualFile()), (Project)this.myProject)) == null; ++i$) {
                }
            }
            if (libraryEntry != null) {
                ProjectSettingsService.getInstance(this.myProject).openLibraryOrSdkSettings(libraryEntry);
            }
        } else if (url.startsWith("psi_element://")) {
            String refText = url.substring("psi_element://".length());
            DocumentationProvider provider = DocumentationManager.getProviderFromElement(psiElement);
            PsiElement targetElement = provider.getDocumentationElementForLink(manager, refText, psiElement);
            if (targetElement == null) {
                DocumentationProvider documentationProvider;
                DocumentationProvider[] arr$ = (DocumentationProvider[])Extensions.getExtensions((ExtensionPointName)DocumentationProvider.EP_NAME);
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && (targetElement = (documentationProvider = arr$[i$]).getDocumentationElementForLink(manager, refText, psiElement)) == null; ++i$) {
                }
            }
            if (targetElement == null) {
                Language language;
                DocumentationProvider documentationProvider;
                Iterator i$ = Language.getRegisteredLanguages().iterator();
                while (i$.hasNext() && ((documentationProvider = LanguageDocumentation.INSTANCE.forLanguage(language = (Language)i$.next())) == null || (targetElement = documentationProvider.getDocumentationElementForLink(manager, refText, psiElement)) == null)) {
                }
            }
            if (targetElement != null) {
                this.fetchDocInfo(this.getDefaultCollector(targetElement, null), component);
            }
        } else {
            DocumentationProvider provider = DocumentationManager.getProviderFromElement(psiElement);
            boolean processed = false;
            if (provider instanceof CompositeDocumentationProvider) {
                for (DocumentationProvider p : ((CompositeDocumentationProvider)provider).getAllProviders()) {
                    if (!(p instanceof ExternalDocumentationHandler)) continue;
                    final ExternalDocumentationHandler externalHandler = (ExternalDocumentationHandler)p;
                    if (externalHandler.canFetchDocumentationLink(url)) {
                        this.fetchDocInfo(new DocumentationCollector(){

                            @Override
                            public String getDocumentation() throws Exception {
                                return externalHandler.fetchExternalDocumentation(url, psiElement);
                            }

                            @Override
                            public PsiElement getElement() {
                                return psiElement;
                            }

                            @Override
                            @Nullable
                            public String getEffectiveExternalUrl() {
                                return url;
                            }
                        }, component);
                        processed = true;
                        continue;
                    }
                    if (!externalHandler.handleExternalLink(manager, url, psiElement)) continue;
                    processed = true;
                    break;
                }
            }
            if (!processed) {
                this.fetchDocInfo(new DocumentationCollector(){

                    @Override
                    public String getDocumentation() throws Exception {
                        if (url.startsWith("doc_element://")) {
                            List urls = (List)ApplicationManager.getApplication().runReadAction((Computable)new NullableComputable<List<String>>(){

                                public List<String> compute() {
                                    DocumentationProvider provider = DocumentationManager.getProviderFromElement(psiElement);
                                    return provider.getUrlFor(psiElement, DocumentationManager.getOriginalElement(psiElement));
                                }
                            });
                            String url1 = urls != null && !urls.isEmpty() ? (String)urls.get(0) : url;
                            BrowserUtil.browse((String)url1);
                        } else {
                            BrowserUtil.browse((String)url);
                        }
                        return "";
                    }

                    @Override
                    public PsiElement getElement() {
                        return psiElement;
                    }

                    @Override
                    @Nullable
                    public String getEffectiveExternalUrl() {
                        return url;
                    }
                }, component);
            }
        }
        component.setCursor(Cursor.getPredefinedCursor(0));
    }

    void showHint(JBPopup hint) {
        Component focusOwner = IdeFocusManager.getInstance((Project)this.myProject).getFocusOwner();
        DataContext dataContext = DataManager.getInstance().getDataContext(focusOwner);
        PopupPositionManager.positionPopupInBestPosition(hint, this.myEditor, dataContext);
    }

    public void requestFocus() {
        if (this.fromQuickSearch()) {
            this.myPreviouslyFocused.getParent().requestFocus();
        }
    }

    public Project getProject(@Nullable PsiElement element) {
        this.assertSameProject(element);
        return this.myProject;
    }

    private PsiElement assertSameProject(@Nullable PsiElement element) {
        if (element != null && element.isValid() && this.myProject != element.getProject()) {
            throw new AssertionError((Object)(this.myProject + "!=" + element.getProject() + "; element=" + element));
        }
        return element;
    }

    public static void createHyperlink(StringBuilder buffer, String refText, String label, boolean plainLink) {
        DocumentationManagerUtil.createHyperlink(buffer, refText, label, plainLink);
    }

    @Override
    public String getShowInToolWindowProperty() {
        return SHOW_DOCUMENTATION_IN_TOOL_WINDOW;
    }

    @Override
    public String getAutoUpdateEnabledProperty() {
        return DOCUMENTATION_AUTO_UPDATE_ENABLED;
    }

    @Override
    protected void doUpdateComponent(PsiElement element, PsiElement originalElement, DocumentationComponent component) {
        this.fetchDocInfo(this.getDefaultCollector(element, originalElement), component);
    }

    @Override
    protected void doUpdateComponent(Editor editor, PsiFile psiFile) {
        this.showJavaDocInfo(editor, psiFile, false, null);
    }

    @Override
    protected void doUpdateComponent(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/documentation/DocumentationManager", "doUpdateComponent"));
        }
        this.showJavaDocInfo(element, element, null);
    }

    @Override
    protected String getTitle(PsiElement element) {
        return DocumentationManager.getTitle(element, true);
    }

    @Nullable
    public Image getElementImage(@NotNull PsiElement element, @NotNull String imageSpec) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/documentation/DocumentationManager", "getElementImage"));
        }
        if (imageSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imageSpec", "com/intellij/codeInsight/documentation/DocumentationManager", "getElementImage"));
        }
        DocumentationProvider provider = DocumentationManager.getProviderFromElement(element);
        if (provider instanceof CompositeDocumentationProvider) {
            for (DocumentationProvider p : ((CompositeDocumentationProvider)provider).getAllProviders()) {
                Image image;
                if (!(p instanceof DocumentationProviderEx) || (image = ((DocumentationProviderEx)p).getLocalImageForElement(element, imageSpec)) == null) continue;
                return image;
            }
        }
        return null;
    }

    public ActionCallback getLastAction() {
        return this.myLastAction;
    }

    private class DefaultDocumentationCollector
    implements DocumentationCollector {
        private final PsiElement myElement;
        private final PsiElement myOriginalElement;
        private String myEffectiveUrl;

        public DefaultDocumentationCollector(PsiElement element, PsiElement originalElement) {
            this.myElement = element;
            this.myOriginalElement = originalElement;
        }

        @Override
        @Nullable
        public String getDocumentation() throws Exception {
            List urls;
            final DocumentationProvider provider = (DocumentationProvider)ApplicationManager.getApplication().runReadAction((Computable)new Computable<DocumentationProvider>(){

                public DocumentationProvider compute() {
                    return DocumentationManager.getProviderFromElement(DefaultDocumentationCollector.this.myElement, DefaultDocumentationCollector.this.myOriginalElement);
                }
            });
            if (provider instanceof ExternalDocumentationProvider && (urls = (List)ApplicationManager.getApplication().runReadAction((Computable)new NullableComputable<List<String>>(){

                public List<String> compute() {
                    PsiElement originalElement;
                    SmartPsiElementPointer originalElementPtr = (SmartPsiElementPointer)DefaultDocumentationCollector.this.myElement.getUserData(ORIGINAL_ELEMENT_KEY);
                    PsiElement psiElement = originalElement = originalElementPtr != null ? originalElementPtr.getElement() : null;
                    if (((ExternalDocumentationProvider)provider).hasDocumentationFor(DefaultDocumentationCollector.this.myElement, originalElement)) {
                        return provider.getUrlFor(DefaultDocumentationCollector.this.myElement, originalElement);
                    }
                    return null;
                }
            })) != null) {
                for (String url : urls) {
                    String doc = ((ExternalDocumentationProvider)provider).fetchExternalDocumentation(DocumentationManager.this.myProject, this.myElement, Collections.singletonList(url));
                    if (doc == null) continue;
                    this.myEffectiveUrl = url;
                    return doc;
                }
            }
            return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                @Nullable
                public String compute() {
                    SmartPsiElementPointer originalElement = (SmartPsiElementPointer)DefaultDocumentationCollector.this.myElement.getUserData(ORIGINAL_ELEMENT_KEY);
                    return provider.generateDoc(DefaultDocumentationCollector.this.myElement, originalElement != null ? originalElement.getElement() : null);
                }
            });
        }

        @Override
        @Nullable
        public PsiElement getElement() {
            return this.myElement.isValid() ? this.myElement : null;
        }

        @Override
        @Nullable
        public String getEffectiveExternalUrl() {
            return this.myEffectiveUrl;
        }
    }

    private static interface DocumentationCollector {
        @Nullable
        public String getDocumentation() throws Exception;

        @Nullable
        public PsiElement getElement();

        @Nullable
        public String getEffectiveExternalUrl();
    }
}

