/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.ArrayElementDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.util.IncorrectOperationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.Value;

public class ArrayElementDescriptorImpl
extends ValueDescriptorImpl
implements ArrayElementDescriptor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.impl.watch.ArrayElementDescriptorImpl");
    private final int myIndex;
    private final ArrayReference myArray;

    public ArrayElementDescriptorImpl(Project project, ArrayReference array, int index) {
        super(project);
        this.myArray = array;
        this.myIndex = index;
        this.setLvalue(true);
    }

    @Override
    public int getIndex() {
        return this.myIndex;
    }

    @Override
    public ArrayReference getArray() {
        return this.myArray;
    }

    @Override
    public String getName() {
        return String.valueOf(this.myIndex);
    }

    @Override
    public String calcValueName() {
        return "[" + this.getName() + "]";
    }

    @Override
    public Value calcValue(EvaluationContextImpl evaluationContext) throws EvaluateException {
        return ArrayElementDescriptorImpl.getArrayElement(this.myArray, this.myIndex);
    }

    public static Value getArrayElement(ArrayReference reference, int idx) throws EvaluateException {
        try {
            return reference.getValue(idx);
        }
        catch (ObjectCollectedException e) {
            throw EvaluateExceptionUtil.ARRAY_WAS_COLLECTED;
        }
    }

    @Override
    public PsiExpression getDescriptorEvaluation(DebuggerContext context) throws EvaluateException {
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory();
        try {
            return elementFactory.createExpressionFromText("this[" + this.myIndex + "]", null);
        }
        catch (IncorrectOperationException e) {
            throw new EvaluateException(e.getMessage(), (Throwable)e);
        }
    }
}

