/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.util;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionEngine;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.compiler.options.ValidationConfiguration;
import com.intellij.lang.ExternalLanguageAnnotators;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.Validator;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.compiler.options.ExcludesConfiguration;
import com.intellij.openapi.compiler.util.InspectionValidator;
import com.intellij.openapi.compiler.util.PsiElementsValidityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionValidatorWrapper
implements Validator {
    private final InspectionValidator myValidator;
    private final PsiManager myPsiManager;
    private final CompilerManager myCompilerManager;
    private final InspectionManager myInspectionManager;
    private final InspectionProjectProfileManager myProfileManager;
    private final PsiDocumentManager myPsiDocumentManager;
    private static final ThreadLocal<Boolean> ourCompilationThreads = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    public InspectionValidatorWrapper(CompilerManager compilerManager, InspectionManager inspectionManager, InspectionProjectProfileManager profileManager, PsiDocumentManager psiDocumentManager, PsiManager psiManager, InspectionValidator validator) {
        this.myCompilerManager = compilerManager;
        this.myInspectionManager = inspectionManager;
        this.myProfileManager = profileManager;
        this.myPsiDocumentManager = psiDocumentManager;
        this.myPsiManager = psiManager;
        this.myValidator = validator;
    }

    public static boolean isCompilationThread() {
        return ourCompilationThreads.get();
    }

    private static List<ProblemDescriptor> runInspectionOnFile(@NotNull PsiFile file, @NotNull LocalInspectionTool inspectionTool) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/compiler/util/InspectionValidatorWrapper", "runInspectionOnFile"));
        }
        if (inspectionTool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionTool", "com/intellij/openapi/compiler/util/InspectionValidatorWrapper", "runInspectionOnFile"));
        }
        InspectionManager inspectionManager = InspectionManager.getInstance((Project)file.getProject());
        GlobalInspectionContext context = inspectionManager.createNewGlobalContext(false);
        return InspectionEngine.runInspectionOnFile(file, new LocalInspectionToolWrapper(inspectionTool), context);
    }

    @NotNull
    public FileProcessingCompiler.ProcessingItem[] getProcessingItems(final CompileContext context) {
        Project project = context.getProject();
        if (project.isDefault() || !ValidationConfiguration.shouldValidate((Compiler)this, context)) {
            if (FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/compiler/util/InspectionValidatorWrapper", "getProcessingItems"));
            }
            return FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY;
        }
        final ExcludesConfiguration excludesConfiguration = ValidationConfiguration.getExcludedEntriesConfiguration(project);
        List items = (List)DumbService.getInstance((Project)project).runReadActionInSmartMode((Computable)new Computable<List<FileProcessingCompiler.ProcessingItem>>(){

            public List<FileProcessingCompiler.ProcessingItem> compute() {
                CompileScope compileScope = context.getCompileScope();
                if (!InspectionValidatorWrapper.this.myValidator.isAvailableOnScope(compileScope)) {
                    return null;
                }
                final ArrayList<FileProcessingCompiler.ProcessingItem> items = new ArrayList<FileProcessingCompiler.ProcessingItem>();
                Processor<VirtualFile> processor = new Processor<VirtualFile>(){

                    public boolean process(VirtualFile file) {
                        PsiFile psiFile;
                        if (!file.isValid()) {
                            return true;
                        }
                        if (InspectionValidatorWrapper.this.myCompilerManager.isExcludedFromCompilation(file) || excludesConfiguration.isExcluded(file)) {
                            return true;
                        }
                        Module module = context.getModuleByFile(file);
                        if (module != null && (psiFile = InspectionValidatorWrapper.this.myPsiManager.findFile(file)) != null) {
                            items.add(new MyValidatorProcessingItem(psiFile));
                        }
                        return true;
                    }
                };
                ContainerUtil.process((Iterable)InspectionValidatorWrapper.this.myValidator.getFilesToProcess(InspectionValidatorWrapper.this.myPsiManager.getProject(), context), (Processor)processor);
                return items;
            }
        });
        if (items == null) {
            if (FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/compiler/util/InspectionValidatorWrapper", "getProcessingItems"));
            }
            return FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY;
        }
        FileProcessingCompiler.ProcessingItem[] processingItemArray = items.toArray(new FileProcessingCompiler.ProcessingItem[items.size()]);
        if (processingItemArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/compiler/util/InspectionValidatorWrapper", "getProcessingItems"));
        }
        return processingItemArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileProcessingCompiler.ProcessingItem[] process(CompileContext context, FileProcessingCompiler.ProcessingItem[] items) {
        context.getProgressIndicator().setText(this.myValidator.getProgressIndicatorText());
        ArrayList<MyValidatorProcessingItem> processedItems = new ArrayList<MyValidatorProcessingItem>();
        ArrayList<LocalInspectionTool> inspections = new ArrayList<LocalInspectionTool>();
        for (Class aClass : this.myValidator.getInspectionToolClasses(context)) {
            try {
                inspections.add((LocalInspectionTool)aClass.newInstance());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
        for (int i = 0; i < items.length; ++i) {
            MyValidatorProcessingItem item = (MyValidatorProcessingItem)items[i];
            context.getProgressIndicator().checkCanceled();
            context.getProgressIndicator().setFraction((double)i / (double)items.length);
            try {
                ourCompilationThreads.set(Boolean.TRUE);
                if (!this.checkFile(inspections, item.getPsiFile(), context)) continue;
                processedItems.add(item);
                continue;
            }
            finally {
                ourCompilationThreads.set(Boolean.FALSE);
            }
        }
        return processedItems.toArray(new FileProcessingCompiler.ProcessingItem[processedItems.size()]);
    }

    private boolean checkFile(List<LocalInspectionTool> inspections, final PsiFile file, CompileContext context) {
        boolean hasErrors = false;
        if (!this.checkUnderReadAction(file, context, new Computable<Map<ProblemDescriptor, HighlightDisplayLevel>>(){

            public Map<ProblemDescriptor, HighlightDisplayLevel> compute() {
                return InspectionValidatorWrapper.this.myValidator.checkAdditionally(file);
            }
        })) {
            hasErrors = true;
        }
        if (!this.checkUnderReadAction(file, context, new Computable<Map<ProblemDescriptor, HighlightDisplayLevel>>(){

            public Map<ProblemDescriptor, HighlightDisplayLevel> compute() {
                if (file instanceof XmlFile) {
                    return InspectionValidatorWrapper.this.runXmlFileSchemaValidation((XmlFile)file);
                }
                return Collections.emptyMap();
            }
        })) {
            hasErrors = true;
        }
        final InspectionProfile inspectionProfile = this.myProfileManager.getInspectionProfile();
        for (final LocalInspectionTool inspectionTool : inspections) {
            if (this.checkUnderReadAction(file, context, new Computable<Map<ProblemDescriptor, HighlightDisplayLevel>>(){

                public Map<ProblemDescriptor, HighlightDisplayLevel> compute() {
                    if (InspectionValidatorWrapper.getHighlightDisplayLevel(inspectionTool, inspectionProfile, (PsiElement)file) != HighlightDisplayLevel.DO_NOT_SHOW) {
                        return InspectionValidatorWrapper.runInspectionTool(file, inspectionTool, InspectionValidatorWrapper.getHighlightDisplayLevel(inspectionTool, inspectionProfile, (PsiElement)file));
                    }
                    return Collections.emptyMap();
                }
            })) continue;
            hasErrors = true;
        }
        return !hasErrors;
    }

    private boolean checkUnderReadAction(final PsiFile file, final CompileContext context, final Computable<Map<ProblemDescriptor, HighlightDisplayLevel>> runnable) {
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                if (!file.isValid()) {
                    return false;
                }
                Document document = InspectionValidatorWrapper.this.myPsiDocumentManager.getCachedDocument(file);
                if (document != null && InspectionValidatorWrapper.this.myPsiDocumentManager.isUncommited(document)) {
                    String url = file.getViewProvider().getVirtualFile().getUrl();
                    context.addMessage(CompilerMessageCategory.WARNING, CompilerBundle.message((String)"warning.text.file.has.been.changed", (Object[])new Object[0]), url, -1, -1);
                    return false;
                }
                if (InspectionValidatorWrapper.this.reportProblems(context, (Map)runnable.compute())) {
                    return false;
                }
                return true;
            }
        });
    }

    private boolean reportProblems(CompileContext context, Map<ProblemDescriptor, HighlightDisplayLevel> problemsMap) {
        if (problemsMap.isEmpty()) {
            return false;
        }
        boolean errorsReported = false;
        for (Map.Entry<ProblemDescriptor, HighlightDisplayLevel> entry : problemsMap.entrySet()) {
            VirtualFile virtualFile;
            ProblemDescriptor problemDescriptor = entry.getKey();
            PsiElement element = problemDescriptor.getPsiElement();
            PsiFile psiFile = element.getContainingFile();
            if (psiFile == null || (virtualFile = psiFile.getVirtualFile()) == null) continue;
            CompilerMessageCategory category = this.myValidator.getCategoryByHighlightDisplayLevel(entry.getValue(), virtualFile, context);
            Document document = this.myPsiDocumentManager.getDocument(psiFile);
            int offset = problemDescriptor.getStartElement().getTextOffset();
            assert (document != null);
            int line = document.getLineNumber(offset);
            int column = offset - document.getLineStartOffset(line);
            context.addMessage(category, problemDescriptor.getDescriptionTemplate(), virtualFile.getUrl(), line + 1, column + 1);
            if (CompilerMessageCategory.ERROR != category) continue;
            errorsReported = true;
        }
        return errorsReported;
    }

    private static Map<ProblemDescriptor, HighlightDisplayLevel> runInspectionTool(PsiFile file, LocalInspectionTool inspectionTool, HighlightDisplayLevel level) {
        LinkedHashMap problemsMap = new LinkedHashMap();
        for (ProblemDescriptor descriptor : InspectionValidatorWrapper.runInspectionOnFile(file, inspectionTool)) {
            problemsMap.put(descriptor, level);
        }
        return problemsMap;
    }

    private static HighlightDisplayLevel getHighlightDisplayLevel(LocalInspectionTool inspectionTool, InspectionProfile inspectionProfile, PsiElement file) {
        HighlightDisplayKey key = HighlightDisplayKey.find((String)inspectionTool.getShortName());
        return inspectionProfile.isToolEnabled(key, file) ? inspectionProfile.getErrorLevel(key, file) : HighlightDisplayLevel.DO_NOT_SHOW;
    }

    private Map<ProblemDescriptor, HighlightDisplayLevel> runXmlFileSchemaValidation(@NotNull XmlFile xmlFile) {
        if (xmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "com/intellij/openapi/compiler/util/InspectionValidatorWrapper", "runXmlFileSchemaValidation"));
        }
        AnnotationHolderImpl holder = new AnnotationHolderImpl(new AnnotationSession((PsiFile)xmlFile));
        List annotators = ExternalLanguageAnnotators.allForFile((Language)StdLanguages.XML, (PsiFile)xmlFile);
        for (ExternalAnnotator annotator : annotators) {
            Object result;
            Object initial = annotator.collectInformation((PsiFile)xmlFile);
            if (initial == null || (result = annotator.doAnnotate(initial)) == null) continue;
            annotator.apply((PsiFile)xmlFile, result, (AnnotationHolder)holder);
        }
        if (!holder.hasAnnotations()) {
            return Collections.emptyMap();
        }
        LinkedHashMap problemsMap = new LinkedHashMap();
        Iterator i$ = holder.iterator();
        while (i$.hasNext()) {
            PsiElement endElement;
            Annotation annotation = (Annotation)i$.next();
            HighlightInfo info = HighlightInfo.fromAnnotation(annotation);
            if (info.getSeverity() == HighlightSeverity.INFORMATION) continue;
            PsiElement startElement = xmlFile.findElementAt(info.startOffset);
            PsiElement psiElement = endElement = info.startOffset == info.endOffset ? startElement : xmlFile.findElementAt(info.endOffset - 1);
            if (startElement == null || endElement == null) continue;
            ProblemDescriptor descriptor = this.myInspectionManager.createProblemDescriptor(startElement, endElement, info.getDescription(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, new LocalQuickFix[0]);
            HighlightDisplayLevel level = info.getSeverity() == HighlightSeverity.ERROR ? HighlightDisplayLevel.ERROR : HighlightDisplayLevel.WARNING;
            problemsMap.put(descriptor, level);
        }
        return problemsMap;
    }

    @NotNull
    public String getDescription() {
        String string = this.myValidator.getDescription();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/compiler/util/InspectionValidatorWrapper", "getDescription"));
        }
        return string;
    }

    public boolean validateConfiguration(CompileScope scope) {
        return true;
    }

    public ValidityState createValidityState(DataInput in) throws IOException {
        return PsiElementsValidityState.load(in);
    }

    private class MyValidatorProcessingItem
    implements FileProcessingCompiler.ProcessingItem {
        private final VirtualFile myVirtualFile;
        private final PsiFile myPsiFile;
        private PsiElementsValidityState myValidityState;

        public MyValidatorProcessingItem(PsiFile psiFile) {
            if (psiFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/openapi/compiler/util/InspectionValidatorWrapper$MyValidatorProcessingItem", "<init>"));
            }
            this.myPsiFile = psiFile;
            this.myVirtualFile = psiFile.getVirtualFile();
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.myVirtualFile;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/compiler/util/InspectionValidatorWrapper$MyValidatorProcessingItem", "getFile"));
            }
            return virtualFile;
        }

        @Nullable
        public ValidityState getValidityState() {
            if (this.myValidityState == null) {
                this.myValidityState = this.computeValidityState();
            }
            return this.myValidityState;
        }

        private PsiElementsValidityState computeValidityState() {
            PsiElementsValidityState state = new PsiElementsValidityState();
            for (PsiElement psiElement : InspectionValidatorWrapper.this.myValidator.getDependencies(this.myPsiFile)) {
                state.addDependency(psiElement);
            }
            return state;
        }

        public PsiFile getPsiFile() {
            return this.myPsiFile;
        }
    }
}

