/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.action.ExternalSystemNodeAction;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractExternalEntityData;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefreshExternalProjectAction
extends ExternalSystemNodeAction<AbstractExternalEntityData>
implements DumbAware {
    public RefreshExternalProjectAction() {
        super(AbstractExternalEntityData.class);
        this.getTemplatePresentation().setText(ExternalSystemBundle.message((String)"action.refresh.project.text", (Object[])new Object[]{"external"}));
        this.getTemplatePresentation().setDescription(ExternalSystemBundle.message((String)"action.refresh.project.description", (Object[])new Object[]{"external"}));
    }

    @Override
    protected boolean isEnabled(AnActionEvent e) {
        if (!super.isEnabled(e)) {
            return false;
        }
        List selectedNodes = (List)ExternalSystemDataKeys.SELECTED_NODES.getData(e.getDataContext());
        if (selectedNodes == null || selectedNodes.size() != 1) {
            return false;
        }
        Object externalData = ((ExternalSystemNode)selectedNodes.get(0)).getData();
        return externalData instanceof ProjectData || externalData instanceof ModuleData;
    }

    @Override
    public void perform(final @NotNull Project project, @NotNull ProjectSystemId projectSystemId, @NotNull AbstractExternalEntityData externalEntityData, @NotNull AnActionEvent e) {
        ExternalConfigPathAware externalConfigPathAware;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/action/RefreshExternalProjectAction", "perform"));
        }
        if (projectSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSystemId", "com/intellij/openapi/externalSystem/action/RefreshExternalProjectAction", "perform"));
        }
        if (externalEntityData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalEntityData", "com/intellij/openapi/externalSystem/action/RefreshExternalProjectAction", "perform"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/externalSystem/action/RefreshExternalProjectAction", "perform"));
        }
        List selectedNodes = (List)ExternalSystemDataKeys.SELECTED_NODES.getData(e.getDataContext());
        ExternalSystemNode externalSystemNode = (ExternalSystemNode)ContainerUtil.getFirstItem((List)selectedNodes);
        assert (externalSystemNode != null);
        ExternalConfigPathAware externalConfigPathAware2 = externalConfigPathAware = externalSystemNode.getData() instanceof ExternalConfigPathAware ? (ExternalConfigPathAware)externalSystemNode.getData() : null;
        assert (externalConfigPathAware != null);
        FileDocumentManager.getInstance().saveAllDocuments();
        final ProjectDataManager projectDataManager = (ProjectDataManager)ServiceManager.getService(ProjectDataManager.class);
        ExternalSystemUtil.refreshProject(project, projectSystemId, externalConfigPathAware.getLinkedExternalProjectPath(), new ExternalProjectRefreshCallback(){

            @Override
            public void onSuccess(final @Nullable DataNode<ProjectData> externalProject) {
                if (externalProject == null) {
                    return;
                }
                ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

                    public void execute() {
                        ProjectRootManagerEx.getInstanceEx((Project)project).mergeRootsChangesDuring(new Runnable(){

                            @Override
                            public void run() {
                                projectDataManager.importData(externalProject.getKey(), Collections.singleton(externalProject), project, true);
                            }
                        });
                    }
                });
            }

            @Override
            public void onFailure(@NotNull String errorMessage, @Nullable String errorDetails) {
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/openapi/externalSystem/action/RefreshExternalProjectAction$1", "onFailure"));
                }
            }
        }, false, ProgressExecutionMode.IN_BACKGROUND_ASYNC);
    }
}

