/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.impl.ui.ActionsTree;
import com.intellij.openapi.keymap.impl.ui.ChooseActionsDialog;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuickListPanel {
    private JPanel myPanel;
    private final JBList myActionsList;
    private JTextField myDisplayName;
    private JTextField myDescription;
    private JPanel myListPanel;
    private final QuickList[] myAllQuickLists;

    public QuickListPanel(@NotNull QuickList origin, @NotNull QuickList[] allQuickLists) {
        String[] ids;
        if (origin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "com/intellij/openapi/keymap/impl/ui/QuickListPanel", "<init>"));
        }
        if (allQuickLists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allQuickLists", "com/intellij/openapi/keymap/impl/ui/QuickListPanel", "<init>"));
        }
        this.myAllQuickLists = allQuickLists;
        this.$$$setupUI$$$();
        this.myActionsList = new JBList(new DefaultListModel());
        this.myActionsList.setCellRenderer((ListCellRenderer)new MyListCellRenderer());
        this.myActionsList.getEmptyText().setText(KeyMapBundle.message((String)"no.actions", (Object[])new Object[0]));
        this.myActionsList.setEnabled(true);
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                QuickListPanel.this.excludeSelectionAction();
                return true;
            }
        }.installOn((Component)this.myActionsList);
        this.myListPanel.add((Component)ToolbarDecorator.createDecorator((JList)this.myActionsList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                QuickListPanel.this.includeSelectedAction();
            }
        }).addExtraAction(new AnActionButton("Add Separator", AllIcons.General.SeparatorH){

            public void actionPerformed(@Nullable AnActionEvent e) {
                QuickListPanel.this.addSeparator();
            }
        }).setButtonComparator(new String[]{"Add", "Add Separator", "Remove", "Up", "Down"}).createPanel(), "Center");
        this.myDisplayName.setText(origin.getName());
        this.myDescription.setText(origin.getDescription());
        for (String id : ids = origin.getActionIds()) {
            this.includeActionId(id);
        }
    }

    public void addNameListener(DocumentAdapter adapter) {
        this.myDisplayName.getDocument().addDocumentListener((DocumentListener)adapter);
    }

    public void addDescriptionListener(DocumentAdapter adapter) {
        this.myDescription.getDocument().addDocumentListener((DocumentListener)adapter);
    }

    private void excludeSelectionAction() {
        int[] ids = this.myActionsList.getSelectedIndices();
        for (int i = ids.length - 1; i >= 0; --i) {
            ((DefaultListModel)this.myActionsList.getModel()).remove(ids[i]);
        }
    }

    private void includeSelectedAction() {
        ChooseActionsDialog dlg = new ChooseActionsDialog((Component)this.myActionsList, KeymapManager.getInstance().getActiveKeymap(), this.myAllQuickLists);
        if (dlg.showAndGet()) {
            String[] ids;
            for (String id : ids = dlg.getTreeSelectedActionIds()) {
                this.includeActionId(id);
            }
            DefaultListModel listModel = (DefaultListModel)this.myActionsList.getModel();
            int size = listModel.getSize();
            ListSelectionModel selectionModel = this.myActionsList.getSelectionModel();
            if (size > 0) {
                selectionModel.removeIndexInterval(0, size - 1);
            }
            for (String id1 : ids) {
                int idx = listModel.lastIndexOf(id1);
                if (idx < 0) continue;
                selectionModel.addSelectionInterval(idx, idx);
            }
        }
    }

    private void addSeparator() {
        ((DefaultListModel)this.myActionsList.getModel()).addElement("QuickList.$Separator$");
    }

    public JList getActionsList() {
        return this.myActionsList;
    }

    public String getDescription() {
        return this.myDescription.getText();
    }

    public String getDisplayName() {
        return this.myDisplayName.getText();
    }

    private void includeActionId(String id) {
        DefaultListModel model = (DefaultListModel)this.myActionsList.getModel();
        if (!"QuickList.$Separator$".equals(id) && model.contains(id)) {
            return;
        }
        model.addElement(id);
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/KeyMapBundle").getString("quick.list.panel.display.name.label"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDescription = jTextField2 = new JTextField();
        jPanel3.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myDisplayName = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/KeyMapBundle").getString("quick.list.panel.description.label"));
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myListPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static class MyListCellRenderer
    extends DefaultListCellRenderer {
        private MyListCellRenderer() {
        }

        @Override
        @NotNull
        public Component getListCellRendererComponent(@NotNull JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/keymap/impl/ui/QuickListPanel$MyListCellRenderer", "getListCellRendererComponent"));
            }
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Icon icon = null;
            String actionId = (String)value;
            if ("QuickList.$Separator$".equals(actionId)) {
                this.setText("-------------");
            } else {
                Icon actionIcon;
                AnAction action = ActionManager.getInstance().getAction(actionId);
                this.setText(action != null ? action.getTemplatePresentation().getText() : actionId);
                if (action != null && (actionIcon = action.getTemplatePresentation().getIcon()) != null) {
                    icon = actionIcon;
                }
                if (actionId.startsWith("QuickList.")) {
                    icon = AllIcons.Actions.QuickList;
                }
                this.setIcon(ActionsTree.getEvenIcon(icon));
            }
            MyListCellRenderer myListCellRenderer = this;
            if (myListCellRenderer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/ui/QuickListPanel$MyListCellRenderer", "getListCellRendererComponent"));
            }
            return myListCellRenderer;
        }
    }
}

