/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.actionSystem.ex.CheckboxAction;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffAction;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffContext;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesComparator;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeList;
import com.intellij.openapi.vcs.changes.ui.RemoteStatusChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.tree.DefaultTreeModel;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesBrowser
extends JPanel
implements TypeSafeDataProvider {
    private static final Logger LOG = Logger.getInstance(ChangesBrowser.class);
    private boolean myDataIsDirty;
    protected final ChangesTreeList<Change> myViewer;
    protected ChangeList mySelectedChangeList;
    protected Collection<Change> myChangesToDisplay;
    protected final Project myProject;
    private final boolean myCapableOfExcludingChanges;
    protected final JPanel myHeaderPanel;
    private JComponent myBottomPanel;
    private DefaultActionGroup myToolBarGroup;
    private String myToggleActionTitle = VcsBundle.message((String)"commit.dialog.include.action.name", (Object[])new Object[0]);
    private List<AnAction> myAdditionalDiffActions;
    private JComponent myDiffBottomComponent;
    public static DataKey<ChangesBrowser> DATA_KEY = DataKey.create((String)"com.intellij.openapi.vcs.changes.ui.ChangesBrowser");
    private ShowDiffAction myDiffAction;
    private final VirtualFile myToSelect;

    public void setChangesToDisplay(List<Change> changes) {
        this.myChangesToDisplay = changes;
        this.myViewer.setChangesToDisplay(changes);
    }

    public void setDecorator(ChangeNodeDecorator decorator) {
        this.myViewer.setChangeDecorator(decorator);
    }

    public ChangesBrowser(Project project, List<? extends ChangeList> changeLists, List<Change> changes, ChangeList initialListSelection, boolean capableOfExcludingChanges, boolean highlightProblems, @Nullable Runnable inclusionListener, MyUseCase useCase, @Nullable VirtualFile toSelect) {
        super(new BorderLayout());
        this.setFocusable(false);
        this.myDataIsDirty = false;
        this.myProject = project;
        this.myCapableOfExcludingChanges = capableOfExcludingChanges;
        this.myToSelect = toSelect;
        RemoteStatusChangeNodeDecorator decorator = MyUseCase.LOCAL_CHANGES.equals((Object)useCase) ? RemoteRevisionsCache.getInstance(this.myProject).getChangesNodeDecorator() : null;
        this.myViewer = new ChangesTreeList<Change>(this.myProject, changes, capableOfExcludingChanges, highlightProblems, inclusionListener, (ChangeNodeDecorator)decorator){

            @Override
            protected DefaultTreeModel buildTreeModel(List<Change> changes, ChangeNodeDecorator changeNodeDecorator) {
                TreeModelBuilder builder = new TreeModelBuilder(this.myProject, false);
                return builder.buildModel(changes, changeNodeDecorator);
            }

            @Override
            protected List<Change> getSelectedObjects(ChangesBrowserNode<Change> node) {
                return node.getAllChangesUnder();
            }

            @Override
            @Nullable
            protected Change getLeadSelectedObject(ChangesBrowserNode node) {
                Object o = node.getUserObject();
                if (o instanceof Change) {
                    return (Change)o;
                }
                return null;
            }
        };
        this.myViewer.setDoubleClickHandler(this.getDoubleClickHandler());
        this.setInitialSelection(changeLists, changes, initialListSelection);
        this.rebuildList();
        this.add(this.myViewer, "Center");
        this.myHeaderPanel = new JPanel(new BorderLayout());
        this.myHeaderPanel.add((Component)this.createToolbar(), "Center");
        this.add((Component)this.myHeaderPanel, "North");
        this.myBottomPanel = new JPanel(new BorderLayout());
        this.add((Component)this.myBottomPanel, "South");
        this.myViewer.installPopupHandler((ActionGroup)this.myToolBarGroup);
    }

    @NotNull
    protected Runnable getDoubleClickHandler() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ChangesBrowser.this.showDiff();
            }
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesBrowser", "getDoubleClickHandler"));
        }
        return runnable;
    }

    protected void setInitialSelection(List<? extends ChangeList> changeLists, List<Change> changes, ChangeList initialListSelection) {
        this.mySelectedChangeList = initialListSelection;
    }

    public void dispose() {
    }

    public void addToolbarAction(AnAction action) {
        this.myToolBarGroup.add(action);
    }

    public void addToolbarActions(ActionGroup group) {
        this.myToolBarGroup.addSeparator();
        this.myToolBarGroup.add((AnAction)group);
    }

    public JComponent getDiffBottomComponent() {
        return this.myDiffBottomComponent;
    }

    public void setDiffBottomComponent(JComponent diffBottomComponent) {
        this.myDiffBottomComponent = diffBottomComponent;
    }

    public List<AnAction> getAdditionalDiffActions() {
        return this.myAdditionalDiffActions;
    }

    public void setAdditionalDiffActions(List<AnAction> additionalDiffActions) {
        this.myAdditionalDiffActions = additionalDiffActions;
    }

    public void setToggleActionTitle(String toggleActionTitle) {
        this.myToggleActionTitle = toggleActionTitle;
    }

    public JPanel getHeaderPanel() {
        return this.myHeaderPanel;
    }

    public ChangesTreeList<Change> getViewer() {
        return this.myViewer;
    }

    public void calcData(DataKey key, DataSink sink) {
        if (key == VcsDataKeys.CHANGES) {
            List<Change> list = this.myViewer.getSelectedChanges();
            if (list.isEmpty()) {
                list = this.myViewer.getChanges();
            }
            sink.put(VcsDataKeys.CHANGES, (Object)list.toArray(new Change[list.size()]));
        } else if (key == VcsDataKeys.CHANGE_LISTS) {
            sink.put(VcsDataKeys.CHANGE_LISTS, (Object)this.getSelectedChangeLists());
        } else if (key == VcsDataKeys.CHANGE_LEAD_SELECTION) {
            Change[] changeArray;
            Change highestSelection = this.myViewer.getHighestLeadSelection();
            if (highestSelection == null) {
                changeArray = new Change[]{};
            } else {
                Change[] changeArray2 = new Change[1];
                changeArray = changeArray2;
                changeArray2[0] = highestSelection;
            }
            sink.put(VcsDataKeys.CHANGE_LEAD_SELECTION, (Object)changeArray);
        } else if (key == CommonDataKeys.VIRTUAL_FILE_ARRAY) {
            sink.put(CommonDataKeys.VIRTUAL_FILE_ARRAY, (Object)this.getSelectedFiles());
        } else if (key == CommonDataKeys.NAVIGATABLE_ARRAY) {
            sink.put(CommonDataKeys.NAVIGATABLE_ARRAY, (Object)ChangesUtil.getNavigatableArray((Project)this.myProject, (VirtualFile[])this.getSelectedFiles()));
        } else if (VcsDataKeys.IO_FILE_ARRAY.equals(key)) {
            sink.put(VcsDataKeys.IO_FILE_ARRAY, (Object)this.getSelectedIoFiles());
        } else if (key == DATA_KEY) {
            sink.put(DATA_KEY, (Object)this);
        } else if (VcsDataKeys.SELECTED_CHANGES_IN_DETAILS.equals(key)) {
            List<Change> selectedChanges = this.getSelectedChanges();
            sink.put(VcsDataKeys.SELECTED_CHANGES_IN_DETAILS, (Object)selectedChanges.toArray(new Change[selectedChanges.size()]));
        }
    }

    public void select(List<Change> changes) {
        this.myViewer.select(changes);
    }

    public JComponent getBottomPanel() {
        return this.myBottomPanel;
    }

    protected void showDiffForChanges(Change[] changesArray, int indexInSelection) {
        ShowDiffContext context = new ShowDiffContext(ChangesBrowser.isInFrame() ? DiffDialogHints.FRAME : DiffDialogHints.MODAL);
        if (this.myAdditionalDiffActions == null) {
            context.addActions(this.createDiffActions());
        } else {
            context.addActions(this.myAdditionalDiffActions);
        }
        if (this.myDiffBottomComponent != null) {
            context.putChainContext(DiffUserDataKeysEx.BOTTOM_PANEL, this.myDiffBottomComponent);
        }
        this.updateDiffContext(context);
        ShowDiffAction.showDiffForChange(this.myProject, Arrays.asList(changesArray), indexInSelection, context);
    }

    protected void updateDiffContext(@NotNull ShowDiffContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/ui/ChangesBrowser", "updateDiffContext"));
        }
    }

    private void showDiff() {
        Change leadSelection = this.myViewer.getLeadSelection();
        List<Change> changes = this.myViewer.getSelectedChanges();
        if (changes.size() < 2) {
            changes = this.myViewer.getChanges();
        }
        Change[] changesArray = changes.toArray(new Change[changes.size()]);
        if (leadSelection != null) {
            int indexInSelection = changes.indexOf(leadSelection);
            if (indexInSelection == -1) {
                this.showDiffForChanges(new Change[]{leadSelection}, 0);
            } else {
                this.showDiffForChanges(changesArray, indexInSelection);
            }
        } else {
            this.showDiffForChanges(changesArray, 0);
        }
        this.afterDiffRefresh();
    }

    protected void afterDiffRefresh() {
    }

    private static boolean isInFrame() {
        return ModalityState.current().equals(ModalityState.NON_MODAL);
    }

    protected List<AnAction> createDiffActions() {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        if (this.myCapableOfExcludingChanges) {
            actions.add((AnAction)new ToggleChangeAction());
        }
        return actions;
    }

    public void rebuildList() {
        this.myViewer.setChangesToDisplay(this.getCurrentDisplayedChanges(), this.myToSelect);
    }

    public void setAlwayExpandList(boolean value) {
        this.myViewer.setAlwaysExpandList(value);
    }

    private JComponent createToolbar() {
        DefaultActionGroup toolbarGroups = new DefaultActionGroup();
        this.myToolBarGroup = new DefaultActionGroup();
        toolbarGroups.add((AnAction)this.myToolBarGroup);
        this.buildToolBar(this.myToolBarGroup);
        toolbarGroups.addSeparator();
        DefaultActionGroup treeActionsGroup = new DefaultActionGroup();
        toolbarGroups.add((AnAction)treeActionsGroup);
        for (AnAction action : this.myViewer.getTreeActions()) {
            treeActionsGroup.add(action);
        }
        return ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)toolbarGroups, true).getComponent();
    }

    protected void buildToolBar(DefaultActionGroup toolBarGroup) {
        this.myDiffAction = new ShowDiffAction(){

            @Override
            public void update(AnActionEvent e) {
                Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
                e.getPresentation().setEnabled(3.canShowDiff(ChangesBrowser.this.myProject, changes));
            }

            @Override
            public void actionPerformed(AnActionEvent e) {
                ChangesBrowser.this.showDiff();
            }
        };
        this.myDiffAction.registerCustomShortcutSet(CommonShortcuts.getDiff(), this.myViewer);
        toolBarGroup.add((AnAction)this.myDiffAction);
    }

    public List<Change> getCurrentDisplayedChanges() {
        List<Change> list = this.myChangesToDisplay != null ? new ArrayList<Change>(this.myChangesToDisplay) : (this.mySelectedChangeList != null ? new ArrayList<Change>(this.mySelectedChangeList.getChanges()) : Collections.emptyList());
        return this.sortChanges(list);
    }

    protected List<Change> sortChanges(List<Change> list) {
        List sortedList;
        try {
            sortedList = ContainerUtil.sorted(list, (Comparator)ChangesComparator.getInstance(this.myViewer.isShowFlatten()));
        }
        catch (IllegalArgumentException e) {
            sortedList = ContainerUtil.newArrayList(list);
            LOG.error("Couldn't sort these changes: " + list, (Throwable)e);
        }
        return sortedList;
    }

    public ChangeList getSelectedChangeList() {
        return this.mySelectedChangeList;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myViewer.getPreferredFocusedComponent();
    }

    private ChangeList[] getSelectedChangeLists() {
        if (this.mySelectedChangeList != null) {
            return new ChangeList[]{this.mySelectedChangeList};
        }
        return null;
    }

    private File[] getSelectedIoFiles() {
        List<Change> changes = this.myViewer.getSelectedChanges();
        ArrayList<File> files = new ArrayList<File>();
        for (Change change : changes) {
            ContentRevision afterRevision = change.getAfterRevision();
            if (afterRevision == null) continue;
            FilePath file = afterRevision.getFile();
            File ioFile = file.getIOFile();
            files.add(ioFile);
        }
        return files.toArray(new File[files.size()]);
    }

    public List<Change> getSelectedChanges() {
        return this.myViewer.getSelectedChanges();
    }

    private VirtualFile[] getSelectedFiles() {
        List<Change> changes = this.myViewer.getSelectedChanges();
        return ChangesUtil.getFilesFromChanges(changes);
    }

    public ShowDiffAction getDiffAction() {
        return this.myDiffAction;
    }

    public boolean isDataIsDirty() {
        return this.myDataIsDirty;
    }

    public void setDataIsDirty(boolean dataIsDirty) {
        this.myDataIsDirty = dataIsDirty;
    }

    public void setSelectionMode(@JdkConstants.ListSelectionMode int mode) {
        this.myViewer.setSelectionMode(mode);
    }

    public static enum MyUseCase {
        LOCAL_CHANGES,
        COMMITTED_CHANGES;

    }

    private class ToggleChangeAction
    extends CheckboxAction {
        public ToggleChangeAction() {
            super(ChangesBrowser.this.myToggleActionTitle);
        }

        public boolean isSelected(AnActionEvent e) {
            Change change = (Change)e.getData(VcsDataKeys.CURRENT_CHANGE);
            if (change == null) {
                return false;
            }
            return ChangesBrowser.this.myViewer.isIncluded(change);
        }

        public void setSelected(AnActionEvent e, boolean state) {
            Change change = (Change)e.getData(VcsDataKeys.CURRENT_CHANGE);
            if (change == null) {
                return;
            }
            if (state) {
                ChangesBrowser.this.myViewer.includeChange(change);
            } else {
                ChangesBrowser.this.myViewer.excludeChange(change);
            }
        }
    }
}

