/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.undo.GlobalUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.ChooseFileEncodingAction;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingUtil;
import com.intellij.openapi.vfs.encoding.IncompatibleEncodingDialog;
import com.intellij.util.Function;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeFileEncodingAction
extends AnAction
implements DumbAware {
    private final boolean allowDirectories;

    public ChangeFileEncodingAction() {
        this(false);
    }

    public ChangeFileEncodingAction(boolean allowDirectories) {
        this.allowDirectories = allowDirectories;
    }

    private boolean checkEnabled(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vfs/encoding/ChangeFileEncodingAction", "checkEnabled"));
        }
        if (this.allowDirectories && virtualFile.isDirectory()) {
            return true;
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        Document document = documentManager.getDocument(virtualFile);
        if (document == null) {
            return false;
        }
        return EncodingUtil.checkCanConvert(virtualFile) == null || EncodingUtil.checkCanReload((VirtualFile)virtualFile).second == null;
    }

    public void update(AnActionEvent e) {
        VirtualFile myFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        boolean enabled = myFile != null && this.checkEnabled(myFile);
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(myFile != null);
    }

    public final void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        ListPopup popup = this.createPopup(dataContext);
        if (popup != null) {
            popup.showInBestPositionFor(dataContext);
        }
    }

    @Nullable
    public ListPopup createPopup(@NotNull DataContext dataContext) {
        byte[] bytes;
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/vfs/encoding/ChangeFileEncodingAction", "createPopup"));
        }
        VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (virtualFile == null) {
            return null;
        }
        boolean enabled = this.checkEnabled(virtualFile);
        if (!enabled) {
            return null;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        Document document = documentManager.getDocument(virtualFile);
        if (!this.allowDirectories && virtualFile.isDirectory() || document == null && !virtualFile.isDirectory()) {
            return null;
        }
        try {
            bytes = virtualFile.isDirectory() ? null : virtualFile.contentsToByteArray();
        }
        catch (IOException e) {
            return null;
        }
        DefaultActionGroup group = this.createActionGroup(virtualFile, editor, document, bytes, null);
        return JBPopupFactory.getInstance().createActionGroupPopup(this.getTemplatePresentation().getText(), (ActionGroup)group, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
    }

    public DefaultActionGroup createActionGroup(final @NotNull VirtualFile myFile, final Editor editor, final Document document, final byte[] bytes, final @Nullable String clearItemText) {
        if (myFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myFile", "com/intellij/openapi/vfs/encoding/ChangeFileEncodingAction", "createActionGroup"));
        }
        final String text = document == null ? null : document.getText();
        return new ChooseFileEncodingAction(myFile){

            @Override
            public void update(AnActionEvent e) {
            }

            @NotNull
            protected DefaultActionGroup createPopupActionGroup(JComponent button) {
                DefaultActionGroup defaultActionGroup = this.createCharsetsActionGroup(clearItemText, null, new Function<Charset, String>(){

                    public String fun(Charset charset) {
                        boolean enabled;
                        assert (myFile.isDirectory() || text != null) : charset;
                        EncodingUtil.Magic8 safeToReload = myFile.isDirectory() ? EncodingUtil.Magic8.ABSOLUTELY : EncodingUtil.isSafeToReloadIn(myFile, text, bytes, charset);
                        boolean bl = enabled = safeToReload != EncodingUtil.Magic8.NO_WAY;
                        if (!enabled) {
                            EncodingUtil.Magic8 safeToConvert = myFile.isDirectory() ? EncodingUtil.Magic8.ABSOLUTELY : EncodingUtil.isSafeToConvertTo(myFile, text, bytes, charset);
                            enabled = safeToConvert != EncodingUtil.Magic8.NO_WAY;
                        }
                        return enabled ? "Change encoding to '" + charset.displayName() + "'" : null;
                    }
                });
                if (defaultActionGroup == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/encoding/ChangeFileEncodingAction$1", "createPopupActionGroup"));
                }
                return defaultActionGroup;
            }

            @Override
            protected void chosen(@Nullable VirtualFile virtualFile, @NotNull Charset charset) {
                if (charset == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/vfs/encoding/ChangeFileEncodingAction$1", "chosen"));
                }
                if (virtualFile != null) {
                    ChangeFileEncodingAction.this.chosen(document, editor, virtualFile, bytes, charset);
                }
            }
        }.createPopupActionGroup(null);
    }

    protected boolean chosen(final Document document, final Editor editor, final @NotNull VirtualFile virtualFile, byte[] bytes, final @NotNull Charset charset) {
        Runnable redo;
        Runnable undo;
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vfs/encoding/ChangeFileEncodingAction", "chosen"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/vfs/encoding/ChangeFileEncodingAction", "chosen"));
        }
        String text = document.getText();
        EncodingUtil.Magic8 isSafeToConvert = EncodingUtil.isSafeToConvertTo(virtualFile, text, bytes, charset);
        EncodingUtil.Magic8 isSafeToReload = EncodingUtil.isSafeToReloadIn(virtualFile, text, bytes, charset);
        final Project project = ProjectLocator.getInstance().guessProjectForFile(virtualFile);
        final Charset oldCharset = virtualFile.getCharset();
        if (isSafeToConvert == EncodingUtil.Magic8.ABSOLUTELY && isSafeToReload == EncodingUtil.Magic8.ABSOLUTELY) {
            undo = new Runnable(){

                @Override
                public void run() {
                    EncodingManager.getInstance().setEncoding(virtualFile, oldCharset);
                }
            };
            redo = new Runnable(){

                @Override
                public void run() {
                    EncodingManager.getInstance().setEncoding(virtualFile, charset);
                }
            };
        } else {
            IncompatibleEncodingDialog dialog = new IncompatibleEncodingDialog(virtualFile, charset, isSafeToReload, isSafeToConvert);
            dialog.show();
            if (dialog.getExitCode() == 10) {
                undo = new Runnable(){

                    @Override
                    public void run() {
                        EncodingUtil.reloadIn(virtualFile, oldCharset);
                    }
                };
                redo = new Runnable(){

                    @Override
                    public void run() {
                        EncodingUtil.reloadIn(virtualFile, charset);
                    }
                };
            } else if (dialog.getExitCode() == 20) {
                undo = new Runnable(){

                    @Override
                    public void run() {
                        EncodingUtil.saveIn(document, editor, virtualFile, oldCharset);
                    }
                };
                redo = new Runnable(){

                    @Override
                    public void run() {
                        EncodingUtil.saveIn(document, editor, virtualFile, charset);
                    }
                };
            } else {
                return false;
            }
        }
        GlobalUndoableAction action = new GlobalUndoableAction(new VirtualFile[]{virtualFile}){

            public void undo() {
                Application application = ApplicationManager.getApplication();
                application.invokeLater(undo, ModalityState.NON_MODAL, (project == null ? application : project).getDisposed());
            }

            public void redo() {
                Application application = ApplicationManager.getApplication();
                application.invokeLater(redo, ModalityState.NON_MODAL, (project == null ? application : project).getDisposed());
            }
        };
        redo.run();
        CommandProcessor.getInstance().executeCommand(project, new Runnable((UndoableAction)action){
            final /* synthetic */ UndoableAction val$action;
            {
                this.val$action = undoableAction;
            }

            @Override
            public void run() {
                UndoManager undoManager = project == null ? UndoManager.getGlobalInstance() : UndoManager.getInstance((Project)project);
                undoManager.undoableActionPerformed(this.val$action);
            }
        }, "Change encoding for '" + virtualFile.getName() + "'", null, UndoConfirmationPolicy.REQUEST_CONFIRMATION);
        return true;
    }
}

