/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.header;

import com.intellij.profile.codeInspection.ui.header.SaveInputComponentValidator;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.UIUtil;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ValidatedTextField
extends JBTextField {
    private static final String LABEL_CARD = "label";
    private static final String NO_LABEL_CARD = "no_label";
    private final SaveInputComponentValidator myInputValidator;
    private final JPanel myHintPanel;
    private boolean myIgnoreFocus;

    public ValidatedTextField(SaveInputComponentValidator inputValidator) {
        this.myInputValidator = inputValidator;
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                Color color;
                boolean isValid = ValidatedTextField.this.myInputValidator.checkValid(ValidatedTextField.this.getText());
                Color color2 = color = isValid ? UIUtil.getTextAreaForeground() : JBColor.RED;
                if (!color.equals(ValidatedTextField.this.getForeground())) {
                    ValidatedTextField.this.setForeground(color);
                }
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!ValidatedTextField.this.myIgnoreFocus) {
                    ValidatedTextField.this.checkAndApply();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 || e.getKeyCode() == 27) {
                    e.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ValidatedTextField.this.checkAndApply();
                    e.consume();
                } else if (e.getKeyCode() == 27) {
                    ValidatedTextField.this.myIgnoreFocus = true;
                    ValidatedTextField.this.myInputValidator.cancel();
                    e.consume();
                }
            }
        });
        this.myHintPanel = new JPanel();
        final CardLayout cardLayout = new CardLayout();
        this.myHintPanel.setLayout(cardLayout);
        JLabel hintLabel = new JLabel("Save: Enter, Cancel: Esc");
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)hintLabel);
        hintLabel.setForeground(UIUtil.getLabelDisabledForeground());
        this.myHintPanel.add((Component)hintLabel, LABEL_CARD);
        this.myHintPanel.add((Component)new JPanel(), NO_LABEL_CARD);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                cardLayout.show(ValidatedTextField.this.myHintPanel, ValidatedTextField.LABEL_CARD);
                ValidatedTextField.this.myIgnoreFocus = false;
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                cardLayout.show(ValidatedTextField.this.myHintPanel, ValidatedTextField.NO_LABEL_CARD);
            }
        });
        cardLayout.show(this.myHintPanel, NO_LABEL_CARD);
    }

    public JPanel getHintLabel() {
        return this.myHintPanel;
    }

    private void checkAndApply() {
        String text = this.getText();
        if (text == null) {
            text = "";
        }
        if (this.myInputValidator.checkValid(text)) {
            this.myInputValidator.doSave(text);
        }
    }
}

