/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.alignment.AlignmentStrategy;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.StdTokenSets;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SimpleJavaBlock
extends AbstractJavaBlock {
    private final Map<IElementType, Wrap> myReservedWrap = ContainerUtil.newHashMap();
    private int myStartOffset = -1;
    private int myCurrentOffset;
    private Indent myCurrentIndent;
    private ASTNode myCurrentChild;

    public SimpleJavaBlock(ASTNode node, Wrap wrap, AlignmentStrategy alignment, Indent indent, CommonCodeStyleSettings settings, JavaCodeStyleSettings javaSettings) {
        super(node, wrap, alignment, indent, settings, javaSettings);
    }

    @Override
    protected List<Block> buildChildren() {
        this.myCurrentChild = this.myNode.getFirstChildNode();
        this.myCurrentOffset = this.myStartOffset;
        if (this.myCurrentOffset == -1) {
            this.myCurrentOffset = this.myCurrentChild != null ? this.myCurrentChild.getTextRange().getStartOffset() : 0;
        }
        ArrayList<Block> result = new ArrayList<Block>();
        this.myCurrentIndent = null;
        this.processHeadCommentsAndWhiteSpaces(result);
        this.calculateReservedAlignments();
        Wrap childWrap = this.createChildWrap();
        this.processRemainingChildren(result, childWrap);
        return result;
    }

    private void calculateReservedAlignments() {
        this.myReservedAlignment = this.createChildAlignment();
        IElementType nodeType = this.myNode.getElementType();
        if (nodeType == JavaElementType.CONDITIONAL_EXPRESSION && this.mySettings.ALIGN_MULTILINE_TERNARY_OPERATION) {
            this.myReservedAlignment2 = this.myReservedAlignment != null ? Alignment.createChildAlignment((Alignment)this.myReservedAlignment) : Alignment.createAlignment();
        }
    }

    private void processRemainingChildren(List<Block> result, Wrap childWrap) {
        while (this.myCurrentChild != null) {
            if (SimpleJavaBlock.isNotEmptyNode(this.myCurrentChild)) {
                ASTNode astNode = this.myCurrentChild;
                AlignmentStrategy alignmentStrategyToUse = AlignmentStrategy.wrap(this.chooseAlignment(this.myReservedAlignment, this.myReservedAlignment2, this.myCurrentChild), new IElementType[0]);
                if (this.myNode.getElementType() == JavaElementType.FIELD || this.myNode.getElementType() == JavaElementType.DECLARATION_STATEMENT || this.myNode.getElementType() == JavaElementType.LOCAL_VARIABLE) {
                    alignmentStrategyToUse = this.myAlignmentStrategy;
                }
                this.myCurrentChild = this.processChild(result, astNode, alignmentStrategyToUse, childWrap, this.myCurrentIndent, this.myCurrentOffset);
                if (astNode != this.myCurrentChild && this.myCurrentChild != null) {
                    this.myCurrentOffset = this.myCurrentChild.getTextRange().getStartOffset();
                }
                if (this.myCurrentIndent != null && !(this.myNode.getPsi() instanceof PsiFile) && this.myCurrentChild != null && this.myCurrentChild.getElementType() != JavaElementType.MODIFIER_LIST) {
                    this.myCurrentIndent = Indent.getContinuationIndent((boolean)this.myIndentSettings.USE_RELATIVE_INDENTS);
                }
            }
            if (this.myCurrentChild == null) continue;
            this.myCurrentOffset += this.myCurrentChild.getTextLength();
            this.myCurrentChild = this.myCurrentChild.getTreeNext();
        }
    }

    private void processHeadCommentsAndWhiteSpaces(@NotNull List<Block> result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/formatter/java/SimpleJavaBlock", "processHeadCommentsAndWhiteSpaces"));
        }
        while (this.myCurrentChild != null) {
            if (StdTokenSets.COMMENT_BIT_SET.contains(this.myCurrentChild.getElementType()) || this.myCurrentChild.getElementType() == JavaDocElementType.DOC_COMMENT) {
                Block commentBlock = SimpleJavaBlock.createJavaBlock(this.myCurrentChild, this.mySettings, this.myJavaSettings, Indent.getNoneIndent(), null, AlignmentStrategy.getNullStrategy());
                result.add(commentBlock);
                this.myCurrentIndent = Indent.getNoneIndent();
            } else if (!FormatterUtil.containsWhiteSpacesOnly(this.myCurrentChild)) break;
            this.myCurrentOffset += this.myCurrentChild.getTextLength();
            this.myCurrentChild = this.myCurrentChild.getTreeNext();
        }
    }

    private static boolean isNotEmptyNode(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/formatter/java/SimpleJavaBlock", "isNotEmptyNode"));
        }
        return !FormatterUtil.containsWhiteSpacesOnly(child) && child.getTextLength() > 0;
    }

    @Override
    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myStartOffset == -1 ? super.getTextRange() : new TextRange(this.myStartOffset, this.myStartOffset + this.myNode.getTextLength());
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/SimpleJavaBlock", "getTextRange"));
        }
        return textRange;
    }

    @Override
    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        if (this.myNode.getElementType() == JavaElementType.CONDITIONAL_EXPRESSION && this.mySettings.ALIGN_MULTILINE_TERNARY_OPERATION) {
            Alignment usedAlignment = this.getUsedAlignment(newChildIndex);
            if (usedAlignment != null) {
                ChildAttributes childAttributes = new ChildAttributes(null, usedAlignment);
                if (childAttributes == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/SimpleJavaBlock", "getChildAttributes"));
                }
                return childAttributes;
            }
            ChildAttributes childAttributes = super.getChildAttributes(newChildIndex);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/SimpleJavaBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        if (this.myNode.getElementType() == JavaElementType.SWITCH_LABEL_STATEMENT) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNormalIndent(), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/SimpleJavaBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        ChildAttributes childAttributes = super.getChildAttributes(newChildIndex);
        if (childAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/SimpleJavaBlock", "getChildAttributes"));
        }
        return childAttributes;
    }

    @Override
    public Wrap getReservedWrap(IElementType elementType) {
        return this.myReservedWrap.get(elementType);
    }

    @Override
    public void setReservedWrap(Wrap reservedWrap, IElementType operationType) {
        this.myReservedWrap.put(operationType, reservedWrap);
    }

    public void setStartOffset(int startOffset) {
        this.myStartOffset = startOffset;
    }
}

