/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.NotNullComputable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThreadLocalCachedByteArray;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.CompressionUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.ByteSequenceDataExternalizer;
import com.intellij.util.indexing.ContentHashesSupport;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DebugAssertions;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexStorage;
import com.intellij.util.indexing.MapDiffUpdateData;
import com.intellij.util.indexing.MemoryIndexStorage;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.UpdateData;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.ValueContainerImpl;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import gnu.trove.THashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MapReduceIndex<Key, Value, Input>
implements UpdatableIndex<Key, Value, Input> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.indexing.MapReduceIndex");
    private static final int NULL_MAPPING = 0;
    @Nullable
    private final ID<Key, Value> myIndexId;
    private final DataIndexer<Key, Value, Input> myIndexer;
    @NotNull
    protected final IndexStorage<Key, Value> myStorage;
    private final boolean myHasSnapshotMapping;
    private final DataExternalizer<Value> myValueExternalizer;
    private final DataExternalizer<Collection<Key>> mySnapshotIndexExternalizer;
    private final boolean myIsPsiBackedIndex;
    private PersistentHashMap<Integer, Collection<Key>> myInputsIndex;
    private PersistentHashMap<Integer, ByteSequence> myContents;
    private PersistentHashMap<Integer, Integer> myInputsSnapshotMapping;
    private PersistentHashMap<Integer, String> myIndexingTrace;
    private final ReentrantReadWriteLock myLock;
    private Factory<PersistentHashMap<Integer, Collection<Key>>> myInputsIndexFactory;
    private final LowMemoryWatcher myLowMemoryFlusher;
    private static final boolean doReadSavedPersistentData = SystemProperties.getBooleanProperty((String)"idea.read.saved.persistent.index", (boolean)true);
    private static final ThreadLocalCachedByteArray ourSpareByteArray = new ThreadLocalCachedByteArray();
    private static final Key<Integer> ourSavedContentHashIdKey = Key.create((String)"saved.content.hash.id");
    private static final Key<Integer> ourSavedUncommittedHashIdKey = Key.create((String)"saved.uncommitted.hash.id");
    private final UpdateData.RemovedOrUpdatedKeyProcessor<Key> myRemoveStaleKeyOperation;
    private final UpdateData.AddedKeyProcessor<Key, Value> myAddedKeyProcessor;

    public MapReduceIndex(@Nullable ID<Key, Value> indexId, DataIndexer<Key, Value, Input> indexer, @NotNull IndexStorage<Key, Value> storage) throws IOException {
        if (storage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/intellij/util/indexing/MapReduceIndex", "<init>"));
        }
        this(indexId, indexer, storage, null, null, false);
    }

    public MapReduceIndex(@Nullable ID<Key, Value> indexId, DataIndexer<Key, Value, Input> indexer, @NotNull IndexStorage<Key, Value> storage, DataExternalizer<Collection<Key>> snapshotIndexExternalizer, DataExternalizer<Value> valueDataExternalizer, boolean psiBasedIndex) throws IOException {
        if (storage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/intellij/util/indexing/MapReduceIndex", "<init>"));
        }
        this.myLock = new ReentrantReadWriteLock();
        this.myLowMemoryFlusher = LowMemoryWatcher.register((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    MapReduceIndex.this.flush();
                }
                catch (StorageException e) {
                    LOG.info((Throwable)e);
                    FileBasedIndex.getInstance().requestRebuild(MapReduceIndex.this.myIndexId);
                }
            }
        });
        this.myRemoveStaleKeyOperation = new UpdateData.RemovedOrUpdatedKeyProcessor<Key>(){

            @Override
            public void process(Key key, int inputId) throws StorageException {
                MapReduceIndex.this.myStorage.removeAllValues(key, inputId);
            }
        };
        this.myAddedKeyProcessor = new UpdateData.AddedKeyProcessor<Key, Value>(){

            @Override
            public void process(Key key, Value value, int inputId) throws StorageException {
                MapReduceIndex.this.myStorage.addValue(key, inputId, value);
            }
        };
        this.myIndexId = indexId;
        this.myIndexer = indexer;
        this.myStorage = storage;
        this.myHasSnapshotMapping = snapshotIndexExternalizer != null;
        this.mySnapshotIndexExternalizer = snapshotIndexExternalizer;
        this.myValueExternalizer = valueDataExternalizer;
        this.myContents = this.createContentsIndex();
        this.myIsPsiBackedIndex = psiBasedIndex;
    }

    private PersistentHashMap<Integer, ByteSequence> createContentsIndex() throws IOException {
        File saved;
        File file = saved = this.myHasSnapshotMapping && this.myIndexId != null ? new File(IndexInfrastructure.getPersistentIndexRootDir(this.myIndexId), "values") : null;
        if (saved != null) {
            try {
                return new PersistentHashMap(saved, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)ByteSequenceDataExternalizer.INSTANCE);
            }
            catch (IOException ex) {
                IOUtil.deleteAllFilesStartingWith((File)saved);
                throw ex;
            }
        }
        return null;
    }

    @NotNull
    public IndexStorage<Key, Value> getStorage() {
        IndexStorage<Key, Value> indexStorage = this.myStorage;
        if (indexStorage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/MapReduceIndex", "getStorage"));
        }
        return indexStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws StorageException {
        try {
            this.getWriteLock().lock();
            this.myStorage.clear();
            if (this.myInputsIndex != null) {
                MapReduceIndex.cleanMapping(this.myInputsIndex);
                this.myInputsIndex = this.createInputsIndex();
            }
            if (this.myInputsSnapshotMapping != null) {
                MapReduceIndex.cleanMapping(this.myInputsSnapshotMapping);
                this.myInputsSnapshotMapping = this.createInputSnapshotMapping();
            }
            if (this.myIndexingTrace != null) {
                MapReduceIndex.cleanMapping(this.myIndexingTrace);
                this.myIndexingTrace = this.createIndexingTrace();
            }
            if (this.myContents != null) {
                MapReduceIndex.cleanMapping(this.myContents);
                this.myContents = this.createContentsIndex();
            }
        }
        catch (StorageException e) {
            LOG.error((Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    private PersistentHashMap<Integer, Integer> createInputSnapshotMapping() throws IOException {
        assert (this.myIndexId != null);
        File fileIdToHashIdFile = new File(IndexInfrastructure.getIndexRootDir(this.myIndexId), "fileIdToHashId");
        try {
            return new PersistentHashMap<Integer, Integer>(fileIdToHashIdFile, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)EnumeratorIntegerDescriptor.INSTANCE, 4096){

                protected boolean wantNonnegativeIntegralValues() {
                    return true;
                }
            };
        }
        catch (IOException ex) {
            IOUtil.deleteAllFilesStartingWith((File)fileIdToHashIdFile);
            throw ex;
        }
    }

    private PersistentHashMap<Integer, String> createIndexingTrace() throws IOException {
        assert (this.myIndexId != null);
        File mapFile = new File(IndexInfrastructure.getIndexRootDir(this.myIndexId), "indextrace");
        try {
            return new PersistentHashMap(mapFile, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new DataExternalizer<String>(){

                public void save(@NotNull DataOutput out, String value) throws IOException {
                    if (out == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/util/indexing/MapReduceIndex$3", "save"));
                    }
                    out.write((byte[])CompressionUtil.compressCharSequence(value, Charset.defaultCharset()));
                }

                public String read(@NotNull DataInput in) throws IOException {
                    if (in == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/util/indexing/MapReduceIndex$3", "read"));
                    }
                    byte[] b = new byte[((InputStream)((Object)in)).available()];
                    in.readFully(b);
                    return (String)CompressionUtil.uncompressCharSequence(b, Charset.defaultCharset());
                }
            }, 4096);
        }
        catch (IOException ex) {
            IOUtil.deleteAllFilesStartingWith((File)mapFile);
            throw ex;
        }
    }

    private static void cleanMapping(@NotNull PersistentHashMap<?, ?> index) {
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/util/indexing/MapReduceIndex", "cleanMapping"));
        }
        File baseFile = index.getBaseFile();
        try {
            index.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        IOUtil.deleteAllFilesStartingWith((File)baseFile);
    }

    @Override
    public void flush() throws StorageException {
        try {
            this.getReadLock().lock();
            MapReduceIndex.doForce(this.myInputsIndex);
            MapReduceIndex.doForce(this.myInputsSnapshotMapping);
            MapReduceIndex.doForce(this.myIndexingTrace);
            MapReduceIndex.doForce(this.myContents);
            this.myStorage.flush();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof StorageException || cause instanceof IOException) {
                throw new StorageException(cause);
            }
            throw e;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    private static void doForce(PersistentHashMap<?, ?> inputsIndex) {
        if (inputsIndex != null && inputsIndex.isDirty()) {
            inputsIndex.force();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this.myLowMemoryFlusher.stop();
        Lock lock = this.getWriteLock();
        try {
            lock.lock();
            try {
                this.myStorage.close();
            }
            finally {
                MapReduceIndex.doClose(this.myInputsIndex);
                MapReduceIndex.doClose(this.myInputsSnapshotMapping);
                MapReduceIndex.doClose(this.myIndexingTrace);
                MapReduceIndex.doClose(this.myContents);
            }
        }
        catch (StorageException e) {
            LOG.error((Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    private static void doClose(PersistentHashMap<?, ?> index) {
        if (index != null) {
            try {
                index.close();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    @NotNull
    public final Lock getReadLock() {
        ReentrantReadWriteLock.ReadLock readLock = this.myLock.readLock();
        if (readLock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/MapReduceIndex", "getReadLock"));
        }
        return readLock;
    }

    @Override
    @NotNull
    public final Lock getWriteLock() {
        ReentrantReadWriteLock.WriteLock writeLock = this.myLock.writeLock();
        if (writeLock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/MapReduceIndex", "getWriteLock"));
        }
        return writeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processAllKeys(@NotNull Processor<Key> processor, @NotNull GlobalSearchScope scope, IdFilter idFilter) throws StorageException {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/indexing/MapReduceIndex", "processAllKeys"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/util/indexing/MapReduceIndex", "processAllKeys"));
        }
        Lock lock = this.getReadLock();
        try {
            lock.lock();
            boolean bl = this.myStorage.processKeys(processor, scope, idFilter);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ValueContainer<Value> getData(@NotNull Key key) throws StorageException {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/indexing/MapReduceIndex", "getData"));
        }
        Lock lock = this.getReadLock();
        lock.lock();
        ValueContainerImpl.ourDebugIndexInfo.set(this.myIndexId);
        ValueContainer<Value> valueContainer = this.myStorage.read(key);
        ValueContainer<Value> valueContainer2 = valueContainer;
        if (valueContainer2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/MapReduceIndex", "getData"));
        }
        return valueContainer2;
        finally {
            ValueContainerImpl.ourDebugIndexInfo.set(null);
            lock.unlock();
        }
    }

    public void setInputIdToDataKeysIndex(Factory<PersistentHashMap<Integer, Collection<Key>>> factory) throws IOException {
        this.myInputsIndexFactory = factory;
        if (this.myHasSnapshotMapping) {
            this.myInputsSnapshotMapping = this.createInputSnapshotMapping();
        }
        this.myInputsIndex = this.createInputsIndex();
        if (DebugAssertions.EXTRA_SANITY_CHECKS && this.myHasSnapshotMapping && this.myIndexId != null) {
            this.myIndexingTrace = this.createIndexingTrace();
        }
    }

    @Nullable
    private PersistentHashMap<Integer, Collection<Key>> createInputsIndex() throws IOException {
        Factory<PersistentHashMap<Integer, Collection<Key>>> factory = this.myInputsIndexFactory;
        if (factory != null) {
            try {
                return (PersistentHashMap)factory.create();
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    @NotNull
    public final Computable<Boolean> update(final int inputId, @Nullable Input content) {
        weProcessPhysicalContent = content == null || content instanceof UserDataHolder != false && (Boolean)FileBasedIndexImpl.ourPhysicalContentKey.get((UserDataHolder)content, (Object)Boolean.FALSE) != false;
        data = null;
        havePersistentData = false;
        hashId = null;
        skippedReadingPersistentDataButMayHaveIt = false;
        if (this.myContents != null && weProcessPhysicalContent && content != null) {
            try {
                fileContent = (FileContent)content;
                hashId = this.getHashOfContent(fileContent);
                if (MapReduceIndex.doReadSavedPersistentData) {
                    if (!this.myContents.isBusyReading() || DebugAssertions.EXTRA_SANITY_CHECKS) {
                        bytes = (ByteSequence)this.myContents.get((Object)hashId);
                        if (bytes != null) {
                            data = this.deserializeSavedPersistentData(bytes);
                            havePersistentData = true;
                            if (DebugAssertions.EXTRA_SANITY_CHECKS && !(sameValueForSavedIndexedResultAndCurrentOne = (contentData = this.myIndexer.map(content)).equals(data))) {
                                DebugAssertions.error("Unexpected difference in indexing of %s by index %s, file type %s, charset %s\ndiff %s\nprevious indexed info %s", new Object[]{fileContent.getFile(), this.myIndexId, fileContent.getFileType().getName(), ((FileContentImpl)fileContent).getCharset(), this.buildDiff(data, contentData), this.myIndexingTrace.get((Object)hashId)});
                            }
                        }
                    } else {
                        skippedReadingPersistentDataButMayHaveIt = true;
                    }
                } else {
                    havePersistentData = this.myContents.containsMapping((Object)hashId);
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (data == null) {
            v0 = data = content != null ? this.myIndexer.map(content) : Collections.emptyMap();
        }
        if (hashId != null && !havePersistentData) {
            saved = this.savePersistentData(data, hashId, skippedReadingPersistentDataButMayHaveIt);
            if (DebugAssertions.EXTRA_SANITY_CHECKS && saved) {
                fileContent = (FileContent)content;
                try {
                    this.myIndexingTrace.put((Object)hashId, (Object)(((FileContentImpl)fileContent).getCharset() + "," + fileContent.getFileType().getName() + "," + fileContent.getFile().getPath() + "," + ExceptionUtil.getThrowableText((Throwable)new Throwable())));
                }
                catch (IOException ex) {
                    MapReduceIndex.LOG.error((Throwable)ex);
                }
            }
        }
        ProgressManager.checkCanceled();
        optimizedUpdateData = null;
        if (this.myHasSnapshotMapping) {
            try {
                keysForGivenInputId = new NotNullComputable<Collection<Key>>(){

                    @NotNull
                    public Collection<Key> compute() {
                        List list;
                        try {
                            ByteSequence byteSequence;
                            Integer currentHashId = (Integer)MapReduceIndex.this.myInputsSnapshotMapping.get((Object)inputId);
                            Collection<Object> currentKeys = currentHashId != null ? ((byteSequence = (ByteSequence)MapReduceIndex.this.myContents.get((Object)currentHashId)) != null ? MapReduceIndex.this.deserializeSavedPersistentData(byteSequence).keySet() : Collections.emptyList()) : Collections.emptyList();
                            list = currentKeys;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        if (list == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/MapReduceIndex$4", "compute"));
                        }
                        return list;
                    }
                };
                if (weProcessPhysicalContent) {
                    savedInputId = content instanceof FileContent != false ? this.getHashOfContent((FileContent)content) : 0;
                    oldKeysGetter /* !! */  = keysForGivenInputId;
                    if (!MapDiffUpdateData.ourDiffUpdateEnabled) ** GOTO lbl55
                    newValue = data;
                    optimizedUpdateData = new MapDiffUpdateData<Key, Value>(this.myIndexId){

                        @Override
                        protected Map<Key, Value> getNewValue() {
                            return newValue;
                        }

                        @Override
                        protected Map<Key, Value> getCurrentValue() throws IOException {
                            ByteSequence byteSequence;
                            Integer currentHashId = (Integer)MapReduceIndex.this.myInputsSnapshotMapping.get((Object)inputId);
                            Map currentValue = currentHashId != null ? ((byteSequence = (ByteSequence)MapReduceIndex.this.myContents.get((Object)currentHashId)) != null ? MapReduceIndex.this.deserializeSavedPersistentData(byteSequence) : Collections.emptyMap()) : Collections.emptyMap();
                            return currentValue;
                        }

                        @Override
                        public void save(int inputId2) throws IOException {
                            MapReduceIndex.this.myInputsSnapshotMapping.put((Object)inputId2, (Object)savedInputId);
                        }
                    };
                }
                oldKeysGetter /* !! */  = new NotNullComputable<Collection<Key>>((NotNullComputable)keysForGivenInputId){
                    final /* synthetic */ NotNullComputable val$keysForGivenInputId;
                    {
                        this.val$keysForGivenInputId = notNullComputable;
                    }

                    @NotNull
                    public Collection<Key> compute() {
                        Collection oldKeys;
                        block5: {
                            Collection collection;
                            try {
                                oldKeys = (Collection)MapReduceIndex.this.myInputsIndex.get((Object)inputId);
                                if (oldKeys != null) break block5;
                                collection = (Collection)this.val$keysForGivenInputId.compute();
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                            if (collection == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/MapReduceIndex$6", "compute"));
                            }
                            return collection;
                        }
                        Collection collection = oldKeys;
                        if (collection == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/MapReduceIndex$6", "compute"));
                        }
                        return collection;
                    }
                };
                savedInputId = 0;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        } else {
            oldKeysGetter /* !! */  = new NotNullComputable<Collection<Key>>(){

                @NotNull
                public Collection<Key> compute() {
                    Collection<Object> collection;
                    try {
                        Collection oldKeys = (Collection)MapReduceIndex.this.myInputsIndex.get((Object)inputId);
                        collection = oldKeys == null ? Collections.emptyList() : oldKeys;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    if (collection == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/MapReduceIndex$7", "compute"));
                    }
                    return collection;
                }
            };
            savedInputId = inputId;
        }
lbl55:
        // 4 sources

        updateData = optimizedUpdateData != null ? optimizedUpdateData : new SimpleUpdateData(this.myIndexId, savedInputId, data, oldKeysGetter /* !! */ );
        v1 = new Computable<Boolean>(){

            public Boolean compute() {
                final Ref exRef = new Ref(null);
                ProgressManager.getInstance().executeNonCancelableSection(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MapReduceIndex.this.updateWithMap(inputId, updateData);
                        }
                        catch (StorageException ex) {
                            exRef.set((Object)ex);
                        }
                    }
                });
                if (exRef.get() != null) {
                    LOG.info((Throwable)exRef.get());
                    FileBasedIndex.getInstance().requestRebuild(MapReduceIndex.this.myIndexId);
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        };
        if (v1 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/util/indexing/MapReduceIndex", "update"}));
        }
        return v1;
    }

    private StringBuilder buildDiff(Map<Key, Value> data, Map<Key, Value> contentData) {
        Value value;
        StringBuilder moreInfo = new StringBuilder();
        if (contentData.size() != data.size()) {
            moreInfo.append("Indexer has different number of elements, previously ").append(data.size()).append(" after ").append(contentData.size()).append("\n");
        } else {
            moreInfo.append("total ").append(contentData.size()).append(" entries\n");
        }
        for (Map.Entry<Key, Value> keyValueEntry : contentData.entrySet()) {
            if (!data.containsKey(keyValueEntry.getKey())) {
                moreInfo.append("Previous data doesn't contain:").append(keyValueEntry.getKey()).append(" with value ").append(keyValueEntry.getValue()).append("\n");
                continue;
            }
            value = data.get(keyValueEntry.getKey());
            if (Comparing.equal(keyValueEntry.getValue(), value)) continue;
            moreInfo.append("Previous data has different value for key:").append(keyValueEntry.getKey()).append(", new value ").append(keyValueEntry.getValue()).append(", oldValue:").append(value).append("\n");
        }
        for (Map.Entry<Key, Value> keyValueEntry : data.entrySet()) {
            if (!contentData.containsKey(keyValueEntry.getKey())) {
                moreInfo.append("New data doesn't contain:").append(keyValueEntry.getKey()).append(" with value ").append(keyValueEntry.getValue()).append("\n");
                continue;
            }
            value = contentData.get(keyValueEntry.getKey());
            if (Comparing.equal(keyValueEntry.getValue(), value)) continue;
            moreInfo.append("New data has different value for key:").append(keyValueEntry.getKey()).append(" new value ").append(value).append(", oldValue:").append(keyValueEntry.getValue()).append("\n");
        }
        return moreInfo;
    }

    private Map<Key, Value> deserializeSavedPersistentData(ByteSequence bytes) throws IOException {
        DataInputStream stream = new DataInputStream((InputStream)new UnsyncByteArrayInputStream(bytes.getBytes(), bytes.getOffset(), bytes.getLength()));
        int pairs = DataInputOutputUtil.readINT((DataInput)stream);
        if (pairs == 0) {
            return Collections.emptyMap();
        }
        THashMap result = new THashMap(pairs);
        while (stream.available() > 0) {
            Object value = this.myValueExternalizer.read((DataInput)stream);
            Collection keys = (Collection)this.mySnapshotIndexExternalizer.read((DataInput)stream);
            for (Object k : keys) {
                result.put(k, value);
            }
        }
        return result;
    }

    private Integer getHashOfContent(FileContent content) throws IOException {
        Integer previouslyCalculatedContentHashId;
        if (this.myIsPsiBackedIndex && this.myHasSnapshotMapping && content instanceof FileContentImpl) {
            PsiDocumentManager psiDocumentManager;
            Document document;
            Integer previouslyCalculatedUncommittedHashId = (Integer)content.getUserData(ourSavedUncommittedHashIdKey);
            if (previouslyCalculatedUncommittedHashId == null && (document = FileDocumentManager.getInstance().getCachedDocument(content.getFile())) != null && (psiDocumentManager = PsiDocumentManager.getInstance((Project)content.getProject())).isUncommited(document)) {
                PsiFile file = psiDocumentManager.getCachedPsiFile(document);
                Charset charset = ((FileContentImpl)content).getCharset();
                if (file != null) {
                    previouslyCalculatedUncommittedHashId = ContentHashesSupport.calcContentHashIdWithFileType(file.getText().getBytes(charset), charset, content.getFileType());
                    content.putUserData(ourSavedUncommittedHashIdKey, (Object)previouslyCalculatedUncommittedHashId);
                }
            }
            if (previouslyCalculatedUncommittedHashId != null) {
                return previouslyCalculatedUncommittedHashId;
            }
        }
        if ((previouslyCalculatedContentHashId = (Integer)content.getUserData(ourSavedContentHashIdKey)) == null) {
            byte[] hash;
            byte[] byArray = hash = content instanceof FileContentImpl ? ((FileContentImpl)content).getHash() : null;
            if (hash == null) {
                Charset charset = content instanceof FileContentImpl ? ((FileContentImpl)content).getCharset() : null;
                previouslyCalculatedContentHashId = ContentHashesSupport.calcContentHashIdWithFileType(content.getContent(), charset, content.getFileType());
            } else {
                previouslyCalculatedContentHashId = ContentHashesSupport.enumerateHash(hash);
            }
            content.putUserData(ourSavedContentHashIdKey, (Object)previouslyCalculatedContentHashId);
        }
        return previouslyCalculatedContentHashId;
    }

    private boolean savePersistentData(Map<Key, Value> data, int id, boolean delayedReading) {
        try {
            if (delayedReading && this.myContents.containsMapping((Object)id)) {
                return false;
            }
            BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream(ourSpareByteArray.getBuffer(4 * data.size()));
            DataOutputStream stream = new DataOutputStream((OutputStream)out);
            int size = data.size();
            DataInputOutputUtil.writeINT((DataOutput)stream, (int)size);
            if (size > 0) {
                THashMap values = new THashMap();
                List keysForNullValue = null;
                for (Map.Entry<Key, Value> e : data.entrySet()) {
                    List keys;
                    Value value = e.getValue();
                    List list = keys = value != null ? (List)values.get(value) : keysForNullValue;
                    if (keys == null) {
                        if (value != null) {
                            keys = new SmartList();
                            values.put(value, (Object)keys);
                        } else {
                            keys = keysForNullValue = new SmartList();
                        }
                    }
                    keys.add(e.getKey());
                }
                if (keysForNullValue != null) {
                    this.myValueExternalizer.save((DataOutput)stream, null);
                    this.mySnapshotIndexExternalizer.save((DataOutput)stream, keysForNullValue);
                }
                for (Map.Entry<Object, Object> value : values.keySet()) {
                    this.myValueExternalizer.save((DataOutput)stream, value);
                    this.mySnapshotIndexExternalizer.save((DataOutput)stream, values.get(value));
                }
            }
            this.myContents.put((Object)id, (Object)new ByteSequence(out.getInternalBuffer(), 0, out.size()));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateWithMap(int inputId, @NotNull UpdateData<Key, Value> updateData) throws StorageException {
        if (updateData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateData", "com/intellij/util/indexing/MapReduceIndex", "updateWithMap"));
        }
        this.getWriteLock().lock();
        try {
            try {
                ValueContainerImpl.ourDebugIndexInfo.set(this.myIndexId);
                updateData.iterateRemovedOrUpdatedKeys(inputId, this.myRemoveStaleKeyOperation);
            }
            catch (Exception e) {
                throw new StorageException(e);
            }
            finally {
                ValueContainerImpl.ourDebugIndexInfo.set(null);
            }
            updateData.iterateAddedKeys(inputId, this.myAddedKeyProcessor);
            try {
                updateData.save(inputId);
            }
            catch (IOException e) {
                throw new StorageException(e);
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    public class SimpleUpdateData
    extends UpdateData<Key, Value> {
        private final int savedInputId;
        @NotNull
        private final Map<Key, Value> newData;
        @NotNull
        private final NotNullComputable<Collection<Key>> oldKeysGetter;

        public SimpleUpdateData(ID<Key, Value> indexId, @NotNull int id, @NotNull Map<Key, Value> data, NotNullComputable<Collection<Key>> getter) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/util/indexing/MapReduceIndex$SimpleUpdateData", "<init>"));
            }
            if (getter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "getter", "com/intellij/util/indexing/MapReduceIndex$SimpleUpdateData", "<init>"));
            }
            super(indexId);
            this.savedInputId = id;
            this.newData = data;
            this.oldKeysGetter = getter;
        }

        @Override
        public void iterateRemovedOrUpdatedKeys(int inputId, UpdateData.RemovedOrUpdatedKeyProcessor<Key> consumer) throws StorageException {
            MapDiffUpdateData.iterateRemovedKeys((Collection)this.oldKeysGetter.compute(), inputId, consumer);
        }

        @Override
        public void iterateAddedKeys(int inputId, UpdateData.AddedKeyProcessor<Key, Value> consumer) throws StorageException {
            MapDiffUpdateData.iterateAddedKeyAndValues(inputId, consumer, this.newData);
        }

        @Override
        public void save(int inputId) throws IOException {
            if (MapReduceIndex.this.myHasSnapshotMapping && !((MemoryIndexStorage)MapReduceIndex.this.getStorage()).isBufferingEnabled()) {
                MapReduceIndex.this.myInputsSnapshotMapping.put((Object)inputId, (Object)this.savedInputId);
            } else if (MapReduceIndex.this.myInputsIndex != null) {
                Set newKeys = this.newData.keySet();
                if (newKeys.size() > 0) {
                    MapReduceIndex.this.myInputsIndex.put((Object)inputId, newKeys);
                } else {
                    MapReduceIndex.this.myInputsIndex.remove((Object)inputId);
                }
            }
        }

        @NotNull
        public Map<Key, Value> getNewData() {
            Map map = this.newData;
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/MapReduceIndex$SimpleUpdateData", "getNewData"));
            }
            return map;
        }
    }
}

