/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils;

import gnu.trove.TIntObjectHashMap;
import java.util.AbstractList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class IntIntMultiMap {
    private static final int[] EMPTY = new int[0];
    private final TIntObjectHashMap<int[]> myKeyToArrayMap = new TIntObjectHashMap();

    public void putValue(int key, int value) {
        int[] values = (int[])this.myKeyToArrayMap.get(key);
        if (values == null) {
            int[] newValues = new int[]{value};
            this.myKeyToArrayMap.put(key, (Object)newValues);
        } else {
            int[] newValues = new int[values.length + 1];
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == value) {
                    return;
                }
                newValues[i] = values[i];
            }
            newValues[newValues.length - 1] = value;
            this.myKeyToArrayMap.put(key, (Object)newValues);
        }
    }

    public void remove(int key, int value) {
        int removeIndex = -1;
        int[] values = (int[])this.myKeyToArrayMap.get(key);
        if (values == null) {
            return;
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != value) continue;
            removeIndex = i;
            break;
        }
        if (removeIndex == -1) {
            return;
        }
        if (values.length == 1) {
            this.myKeyToArrayMap.remove(key);
            return;
        }
        int[] newValues = new int[values.length - 1];
        for (int i = 0; i < newValues.length; ++i) {
            newValues[i] = i >= removeIndex ? values[i + 1] : values[i];
        }
        this.myKeyToArrayMap.put(key, (Object)newValues);
    }

    @NotNull
    public Collection<Integer> get(int key) {
        final int[] asArray = this.getAsArray(key);
        AbstractList<Integer> abstractList = new AbstractList<Integer>(){

            @Override
            @NotNull
            public Integer get(int index) {
                Integer n = asArray[index];
                if (n == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/utils/IntIntMultiMap$1", "get"));
                }
                return n;
            }

            @Override
            public int size() {
                return asArray.length;
            }
        };
        if (abstractList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/utils/IntIntMultiMap", "get"));
        }
        return abstractList;
    }

    @NotNull
    public int[] getAsArray(int key) {
        int[] result = (int[])this.myKeyToArrayMap.get(key);
        if (result == null) {
            if (EMPTY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/utils/IntIntMultiMap", "getAsArray"));
            }
            return EMPTY;
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/utils/IntIntMultiMap", "getAsArray"));
        }
        return result;
    }

    public boolean isEmpty() {
        return this.myKeyToArrayMap.isEmpty();
    }

    public boolean containsKey(int key) {
        return this.myKeyToArrayMap.containsKey(key);
    }

    @NotNull
    public int[] keys() {
        int[] nArray = this.myKeyToArrayMap.keys();
        if (nArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/utils/IntIntMultiMap", "keys"));
        }
        return nArray;
    }

    public void clear() {
        this.myKeyToArrayMap.clear();
    }
}

