/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import org.jetbrains.annotations.NotNull;

public final class VcsRefImpl
implements VcsRef {
    @NotNull
    private final Hash myCommitHash;
    @NotNull
    private final String myName;
    @NotNull
    private final VcsRefType myType;
    @NotNull
    private final VirtualFile myRoot;

    public VcsRefImpl(@NotNull Hash commitHash, @NotNull String name, @NotNull VcsRefType type, @NotNull VirtualFile root) {
        if (commitHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitHash", "com/intellij/vcs/log/impl/VcsRefImpl", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/vcs/log/impl/VcsRefImpl", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/vcs/log/impl/VcsRefImpl", "<init>"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/impl/VcsRefImpl", "<init>"));
        }
        this.myCommitHash = commitHash;
        this.myName = name;
        this.myType = type;
        this.myRoot = root;
    }

    @NotNull
    public VcsRefType getType() {
        VcsRefType vcsRefType = this.myType;
        if (vcsRefType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsRefImpl", "getType"));
        }
        return vcsRefType;
    }

    @NotNull
    public Hash getCommitHash() {
        Hash hash = this.myCommitHash;
        if (hash == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsRefImpl", "getCommitHash"));
        }
        return hash;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsRefImpl", "getName"));
        }
        return string;
    }

    @NotNull
    public VirtualFile getRoot() {
        VirtualFile virtualFile = this.myRoot;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsRefImpl", "getRoot"));
        }
        return virtualFile;
    }

    public String toString() {
        return String.format("%s:%s(%s|%s)", this.myRoot.getName(), this.myName, this.myCommitHash, this.myType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsRefImpl ref = (VcsRefImpl)o;
        if (!this.myCommitHash.equals(ref.myCommitHash)) {
            return false;
        }
        if (!this.myName.equals(ref.myName)) {
            return false;
        }
        if (!this.myRoot.equals(ref.myRoot)) {
            return false;
        }
        return this.myType == ref.myType;
    }

    public int hashCode() {
        int result = this.myCommitHash.hashCode();
        result = 31 * result + this.myName.hashCode();
        result = 31 * result + this.myRoot.hashCode();
        result = 31 * result + this.myType.hashCode();
        return result;
    }
}

