/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.Vm;

public abstract class ContextDependentAsyncResultConsumer<T>
implements Consumer<T> {
    protected final SuspendContext context;

    public ContextDependentAsyncResultConsumer(@NotNull SuspendContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/debugger/ContextDependentAsyncResultConsumer", "<init>"));
        }
        this.context = context;
    }

    public final void consume(T result) {
        Object vm = this.context.getValueManager().getVm();
        if (vm.getAttachStateManager().isAttached() && !vm.getSuspendContextManager().isContextObsolete(this.context)) {
            this.consume(result, (Vm)vm);
        }
    }

    protected abstract void consume(T var1, @NotNull Vm var2);
}

