/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.ide.XmlRpcServer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.net.NetUtils;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.Map;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.CustomPortServerManager;
import org.jetbrains.ide.PooledThreadExecutor;
import org.jetbrains.io.ChannelRegistrar;
import org.jetbrains.io.DelegatingHttpRequestHandler;
import org.jetbrains.io.DelegatingHttpRequestHandlerBase;
import org.jetbrains.io.NettyUtil;
import org.jetbrains.io.PortUnificationServerHandler;
import org.jetbrains.io.SubServer;

public class BuiltInServer
implements Disposable {
    static final Logger LOG = Logger.getInstance(BuiltInServer.class);
    private final ChannelRegistrar channelRegistrar = new ChannelRegistrar();

    public boolean isRunning() {
        return !this.channelRegistrar.isEmpty();
    }

    public void start(int port) {
        this.start(1, port, 1, false);
    }

    public int start(int workerCount, int firstPort, int portsCount, boolean tryAnyPort) {
        if (this.isRunning()) {
            throw new IllegalStateException("server already started");
        }
        NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup(workerCount, (Executor)PooledThreadExecutor.INSTANCE);
        ServerBootstrap bootstrap = BuiltInServer.createServerBootstrap((EventLoopGroup)eventLoopGroup, this.channelRegistrar, null);
        int port = this.bind(firstPort, portsCount, tryAnyPort, bootstrap);
        this.bindCustomPorts(firstPort, port, eventLoopGroup);
        return port;
    }

    @NotNull
    static ServerBootstrap createServerBootstrap(@NotNull EventLoopGroup eventLoopGroup, final @NotNull ChannelRegistrar channelRegistrar, @Nullable Map<String, Object> xmlRpcHandlers) {
        if (eventLoopGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventLoopGroup", "org/jetbrains/io/BuiltInServer", "createServerBootstrap"));
        }
        if (channelRegistrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channelRegistrar", "org/jetbrains/io/BuiltInServer", "createServerBootstrap"));
        }
        ServerBootstrap bootstrap = NettyUtil.nioServerBootstrap(eventLoopGroup);
        if (xmlRpcHandlers == null) {
            final PortUnificationServerHandler portUnificationServerHandler = new PortUnificationServerHandler();
            bootstrap.childHandler((ChannelHandler)new ChannelInitializer(){

                protected void initChannel(Channel channel) throws Exception {
                    channel.pipeline().addLast(new ChannelHandler[]{channelRegistrar, portUnificationServerHandler});
                }
            });
        } else {
            final XmlRpcDelegatingHttpRequestHandler handler = new XmlRpcDelegatingHttpRequestHandler(xmlRpcHandlers);
            bootstrap.childHandler((ChannelHandler)new ChannelInitializer(){

                protected void initChannel(Channel channel) throws Exception {
                    channel.pipeline().addLast(new ChannelHandler[]{channelRegistrar});
                    NettyUtil.addHttpServerCodec(channel.pipeline());
                    channel.pipeline().addLast(new ChannelHandler[]{handler});
                }
            });
        }
        ServerBootstrap serverBootstrap = bootstrap;
        if (serverBootstrap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/BuiltInServer", "createServerBootstrap"));
        }
        return serverBootstrap;
    }

    private void bindCustomPorts(int firstPort, int port, NioEventLoopGroup eventLoopGroup) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        for (CustomPortServerManager customPortServerManager : (CustomPortServerManager[])CustomPortServerManager.EP_NAME.getExtensions()) {
            try {
                int customPortServerManagerPort = customPortServerManager.getPort();
                SubServer subServer = new SubServer(customPortServerManager, (EventLoopGroup)eventLoopGroup);
                Disposer.register((Disposable)this, (Disposable)subServer);
                if (!customPortServerManager.isAvailableExternally() && (customPortServerManagerPort == firstPort || customPortServerManagerPort == port)) continue;
                subServer.bind(customPortServerManagerPort);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int bind(int firstPort, int portsCount, boolean tryAnyPort, ServerBootstrap bootstrap) {
        InetAddress loopbackAddress = NetUtils.getLoopbackAddress();
        for (int i = 0; i < portsCount; ++i) {
            ChannelFuture future;
            int port = firstPort + i;
            if (!(SystemInfo.isLinux || SystemInfo.isWindows && !SystemInfo.isWinVistaOrNewer)) {
                try {
                    ServerSocket serverSocket = new ServerSocket();
                    try {
                        serverSocket.bind(new InetSocketAddress(port), 1);
                    }
                    finally {
                        serverSocket.close();
                    }
                }
                catch (IOException ignored) {
                    continue;
                }
            }
            if ((future = bootstrap.bind(loopbackAddress, port).awaitUninterruptibly()).isSuccess()) {
                this.channelRegistrar.add(future.channel());
                return port;
            }
            if (tryAnyPort || i != portsCount - 1) continue;
            LOG.error(future.cause());
            return -1;
        }
        LOG.info("We cannot bind to our default range, so, try to bind to any free port");
        ChannelFuture future = bootstrap.bind(loopbackAddress, 0).awaitUninterruptibly();
        if (future.isSuccess()) {
            this.channelRegistrar.add(future.channel());
            return ((InetSocketAddress)future.channel().localAddress()).getPort();
        }
        LOG.error(future.cause());
        return -1;
    }

    public void dispose() {
        this.channelRegistrar.close();
        LOG.info("web server stopped");
    }

    public static void replaceDefaultHandler(@NotNull ChannelHandlerContext context, @NotNull ChannelHandler channelHandler) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/io/BuiltInServer", "replaceDefaultHandler"));
        }
        if (channelHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channelHandler", "org/jetbrains/io/BuiltInServer", "replaceDefaultHandler"));
        }
        context.pipeline().replace(DelegatingHttpRequestHandler.class, "replacedDefaultHandler", channelHandler);
    }

    @ChannelHandler.Sharable
    private static final class XmlRpcDelegatingHttpRequestHandler
    extends DelegatingHttpRequestHandlerBase {
        private final Map<String, Object> handlers;

        public XmlRpcDelegatingHttpRequestHandler(Map<String, Object> handlers) {
            this.handlers = handlers;
        }

        @Override
        protected boolean process(@NotNull ChannelHandlerContext context, @NotNull FullHttpRequest request, @NotNull QueryStringDecoder urlDecoder) throws IOException {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/io/BuiltInServer$XmlRpcDelegatingHttpRequestHandler", "process"));
            }
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/io/BuiltInServer$XmlRpcDelegatingHttpRequestHandler", "process"));
            }
            if (urlDecoder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlDecoder", "org/jetbrains/io/BuiltInServer$XmlRpcDelegatingHttpRequestHandler", "process"));
            }
            if (this.handlers.isEmpty()) {
                return false;
            }
            return request.method() == HttpMethod.POST && XmlRpcServer.SERVICE.getInstance().process(urlDecoder.path(), request, context, this.handlers);
        }
    }
}

