/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.rpc;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.rpc.RequestCallback;

public abstract class MessageManagerBase {
    protected volatile boolean closed;

    protected final boolean rejectIfClosed(RequestCallback<?> callback) {
        if (this.closed) {
            callback.onError(Promise.createError((String)"Connection closed"));
            return true;
        }
        return false;
    }

    public final void closed() {
        this.closed = true;
    }

    protected static void rejectCallback(@NotNull RequestCallback<?> callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "org/jetbrains/rpc/MessageManagerBase", "rejectCallback"));
        }
        callback.onError(Promise.createError((String)"Connection closed"));
    }
}

