/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.vmtrace;

import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.perflib.vmtrace.MethodInfo;
import com.android.tools.perflib.vmtrace.ThreadInfo;
import java.util.concurrent.TimeUnit;

public abstract class TimeSelector {
    private static final TimeSelector sInclusiveThreadTimeSelector = new TimeSelector(){

        @Override
        public long get(MethodInfo info, ThreadInfo thread, TimeUnit unit) {
            return info.getProfileData().getInclusiveTime(thread, ClockType.THREAD, unit);
        }
    };
    private static final TimeSelector sInclusiveGlobalTimeSelector = new TimeSelector(){

        @Override
        public long get(MethodInfo info, ThreadInfo thread, TimeUnit unit) {
            return info.getProfileData().getInclusiveTime(thread, ClockType.GLOBAL, unit);
        }
    };
    private static final TimeSelector sExclusiveThreadTimeSelector = new TimeSelector(){

        @Override
        public long get(MethodInfo info, ThreadInfo thread, TimeUnit unit) {
            return info.getProfileData().getExclusiveTime(thread, ClockType.THREAD, unit);
        }
    };
    private static final TimeSelector sExclusiveGlobalTimeSelector = new TimeSelector(){

        @Override
        public long get(MethodInfo info, ThreadInfo thread, TimeUnit unit) {
            return info.getProfileData().getExclusiveTime(thread, ClockType.GLOBAL, unit);
        }
    };

    public abstract long get(MethodInfo var1, ThreadInfo var2, TimeUnit var3);

    public static TimeSelector create(ClockType type, boolean useInclusiveTime) {
        switch (type) {
            case THREAD: {
                return useInclusiveTime ? sInclusiveThreadTimeSelector : sExclusiveThreadTimeSelector;
            }
            case GLOBAL: {
                return useInclusiveTime ? sInclusiveGlobalTimeSelector : sExclusiveGlobalTimeSelector;
            }
        }
        throw new IllegalArgumentException();
    }
}

