/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.jackrabbit.value;

import hidden.org.apache.jackrabbit.value.BaseValue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;

public class BinaryValue
extends BaseValue {
    public static final int TYPE = 2;
    private byte[] streamData = null;
    private String text = null;

    public BinaryValue(String text) {
        super(2);
        this.text = text;
    }

    public BinaryValue(InputStream stream) {
        super(2);
        this.stream = stream;
    }

    public BinaryValue(byte[] data) {
        super(2);
        this.streamData = data;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BinaryValue) {
            BinaryValue other = (BinaryValue)obj;
            if (this.text == other.text && this.stream == other.stream && this.streamData == other.streamData) {
                return true;
            }
            if (this.stream != null) {
                return this.stream.equals(other.stream);
            }
            if (this.streamData != null) {
                return this.streamData.equals(other.streamData);
            }
            return this.text.equals(other.text);
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public String getInternalString() throws ValueFormatException, RepositoryException {
        if (this.streamData != null) {
            try {
                this.text = new String(this.streamData, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RepositoryException("UTF-8 not supported on this platform", (Throwable)e);
            }
            this.streamData = null;
        } else if (this.stream != null) {
            try {
                int read;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buffer = new byte[8192];
                while ((read = this.stream.read(buffer)) > 0) {
                    out.write(buffer, 0, read);
                }
                byte[] data = out.toByteArray();
                this.text = new String(data, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RepositoryException("UTF-8 not supported on this platform", (Throwable)e);
            }
            catch (IOException e) {
                throw new RepositoryException("conversion from stream to string failed", (Throwable)e);
            }
            finally {
                try {
                    if (this.stream != null) {
                        this.stream.close();
                    }
                }
                catch (IOException e) {}
            }
            this.stream = null;
        }
        if (this.text != null) {
            return this.text;
        }
        throw new ValueFormatException("empty value");
    }

    public InputStream getStream() throws IllegalStateException, RepositoryException {
        this.setStreamConsumed();
        if (this.streamData != null) {
            this.stream = new ByteArrayInputStream(this.streamData);
            this.streamData = null;
        } else if (this.text != null) {
            try {
                this.stream = new ByteArrayInputStream(this.text.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RepositoryException("UTF-8 not supported on this platform", (Throwable)e);
            }
            this.text = null;
        }
        return super.getStream();
    }
}

