/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.keyFMap;

import com.intellij.openapi.util.Key;
import com.intellij.util.ArrayUtil;
import com.intellij.util.keyFMap.ArrayBackedFMap;
import com.intellij.util.keyFMap.KeyFMap;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import org.jetbrains.annotations.NotNull;

class MapBackedFMap
extends TIntObjectHashMap<Object>
implements KeyFMap {
    private MapBackedFMap(@NotNull MapBackedFMap oldMap, final int exclude) {
        if (oldMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldMap", "com/intellij/util/keyFMap/MapBackedFMap", "<init>"));
        }
        super(oldMap.size());
        oldMap.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<Object>(){

            public boolean execute(int key, Object val) {
                if (key != exclude) {
                    MapBackedFMap.this.put(key, val);
                }
                assert (key >= 0) : key;
                return true;
            }
        });
        assert (this.size() > 8);
    }

    MapBackedFMap(@NotNull int[] keys, int newKey, @NotNull Object[] values, @NotNull Object newValue) {
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "com/intellij/util/keyFMap/MapBackedFMap", "<init>"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/util/keyFMap/MapBackedFMap", "<init>"));
        }
        if (newValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newValue", "com/intellij/util/keyFMap/MapBackedFMap", "<init>"));
        }
        super(keys.length + 1);
        for (int i = 0; i < keys.length; ++i) {
            int key = keys[i];
            Object value = values[i];
            this.put(key, value);
            assert (key >= 0) : key;
        }
        this.put(newKey, newValue);
        assert (newKey >= 0) : newKey;
        assert (this.size() > 8);
    }

    @Override
    @NotNull
    public <V> KeyFMap plus(@NotNull Key<V> key, @NotNull V value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/keyFMap/MapBackedFMap", "plus"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/keyFMap/MapBackedFMap", "plus"));
        }
        int keyCode = key.hashCode();
        assert (keyCode >= 0) : key;
        Object oldValue = this.get(keyCode);
        if (value == oldValue) {
            MapBackedFMap mapBackedFMap = this;
            if (mapBackedFMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/keyFMap/MapBackedFMap", "plus"));
            }
            return mapBackedFMap;
        }
        MapBackedFMap newMap = new MapBackedFMap(this, -1);
        newMap.put(keyCode, value);
        MapBackedFMap mapBackedFMap = newMap;
        if (mapBackedFMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/keyFMap/MapBackedFMap", "plus"));
        }
        return mapBackedFMap;
    }

    @Override
    @NotNull
    public KeyFMap minus(@NotNull Key<?> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/keyFMap/MapBackedFMap", "minus"));
        }
        int oldSize = this.size();
        int keyCode = key.hashCode();
        if (!this.containsKey(keyCode)) {
            MapBackedFMap mapBackedFMap = this;
            if (mapBackedFMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/keyFMap/MapBackedFMap", "minus"));
            }
            return mapBackedFMap;
        }
        if (oldSize == 9) {
            int[] keys = this.keys();
            Object[] values = this.getValues();
            int i = ArrayUtil.indexOf(keys, keyCode);
            keys = ArrayUtil.remove(keys, i);
            values = ArrayUtil.remove(values, i);
            ArrayBackedFMap arrayBackedFMap = new ArrayBackedFMap(keys, values);
            if (arrayBackedFMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/keyFMap/MapBackedFMap", "minus"));
            }
            return arrayBackedFMap;
        }
        MapBackedFMap mapBackedFMap = new MapBackedFMap(this, keyCode);
        if (mapBackedFMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/keyFMap/MapBackedFMap", "minus"));
        }
        return mapBackedFMap;
    }

    @Override
    public <V> V get(@NotNull Key<V> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/keyFMap/MapBackedFMap", "get"));
        }
        return (V)this.get(key.hashCode());
    }

    @Override
    public String toString() {
        final StringBuilder s = new StringBuilder();
        this.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<Object>(){

            public boolean execute(int key, Object value) {
                s.append(s.length() == 0 ? "" : ", ").append(Key.getKeyByIndex(key)).append(" -> ").append(value);
                return true;
            }
        });
        return "[" + s.toString() + "]";
    }
}

