/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service;

import com.android.tools.idea.gradle.AndroidProjectKeys;
import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.IdeaGradleProject;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.util.Facets;
import com.google.common.collect.Maps;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GradleProjectDataService
implements ProjectDataService<IdeaGradleProject, Void> {
    private static final Logger LOG = Logger.getInstance(GradleProjectDataService.class);

    @NotNull
    public Key<IdeaGradleProject> getTargetDataKey() {
        Key<IdeaGradleProject> key = AndroidProjectKeys.IDE_GRADLE_PROJECT;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/service/GradleProjectDataService", "getTargetDataKey"));
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<IdeaGradleProject>> toImport, @NotNull Project project, boolean synchronous) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/android/tools/idea/gradle/service/GradleProjectDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/GradleProjectDataService", "importData"));
        }
        if (!toImport.isEmpty()) {
            try {
                GradleProjectDataService.doImport(toImport, project);
            }
            catch (Throwable e) {
                LOG.error(String.format("Failed to set up modules in project '%1$s'", project.getName()), e);
                GradleSyncState.getInstance(project).syncFailed(e.getMessage());
            }
        }
    }

    private static void doImport(final Collection<DataNode<IdeaGradleProject>> toImport, final Project project) throws Throwable {
        RunResult result = new WriteCommandAction.Simple(project, new PsiFile[0]){

            protected void run() throws Throwable {
                if (!project.isDisposed()) {
                    ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
                    Map gradleProjectsByName = GradleProjectDataService.indexByModuleName(toImport);
                    for (Module module : moduleManager.getModules()) {
                        IdeaGradleProject gradleProject = (IdeaGradleProject)gradleProjectsByName.get(module.getName());
                        if (gradleProject == null) {
                            Facets.removeAllFacetsOfType(module, AndroidGradleFacet.TYPE_ID);
                            continue;
                        }
                        GradleProjectDataService.customizeModule(module, gradleProject);
                    }
                }
            }
        }.execute();
        Throwable error = result.getThrowable();
        if (error != null) {
            throw error;
        }
    }

    @NotNull
    private static Map<String, IdeaGradleProject> indexByModuleName(@NotNull Collection<DataNode<IdeaGradleProject>> dataNodes) {
        if (dataNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataNodes", "com/android/tools/idea/gradle/service/GradleProjectDataService", "indexByModuleName"));
        }
        HashMap gradleProjectsByModuleName = Maps.newHashMap();
        for (DataNode<IdeaGradleProject> d : dataNodes) {
            IdeaGradleProject gradleProject = (IdeaGradleProject)d.getData();
            gradleProjectsByModuleName.put(gradleProject.getModuleName(), gradleProject);
        }
        HashMap hashMap = gradleProjectsByModuleName;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/service/GradleProjectDataService", "indexByModuleName"));
        }
        return hashMap;
    }

    private static void customizeModule(@NotNull Module module, @NotNull IdeaGradleProject gradleProject) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/service/GradleProjectDataService", "customizeModule"));
        }
        if (gradleProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleProject", "com/android/tools/idea/gradle/service/GradleProjectDataService", "customizeModule"));
        }
        AndroidGradleFacet androidGradleFacet = GradleProjectDataService.setAndGetAndroidGradleFacet(module);
        androidGradleFacet.setGradleProject(gradleProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static AndroidGradleFacet setAndGetAndroidGradleFacet(Module module) {
        AndroidGradleFacet facet = AndroidGradleFacet.getInstance(module);
        if (facet != null) {
            AndroidGradleFacet androidGradleFacet = facet;
            if (androidGradleFacet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/service/GradleProjectDataService", "setAndGetAndroidGradleFacet"));
            }
            return androidGradleFacet;
        }
        FacetManager facetManager = FacetManager.getInstance((Module)module);
        ModifiableFacetModel model = facetManager.createModifiableModel();
        try {
            facet = (AndroidGradleFacet)facetManager.createFacet((FacetType)AndroidGradleFacet.getFacetType(), "Android-Gradle", null);
            model.addFacet((Facet)facet);
        }
        finally {
            model.commit();
        }
        AndroidGradleFacet androidGradleFacet = facet;
        if (androidGradleFacet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/service/GradleProjectDataService", "setAndGetAndroidGradleFacet"));
        }
        return androidGradleFacet;
    }

    public void removeData(@NotNull Collection<? extends Void> toRemove, @NotNull Project project, boolean synchronous) {
        if (toRemove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRemove", "com/android/tools/idea/gradle/service/GradleProjectDataService", "removeData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/GradleProjectDataService", "removeData"));
        }
    }
}

