/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.conversion;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.InheritedJdkOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import gnu.trove.THashMap;
import java.util.Arrays;
import java.util.Map;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.ConversionException;
import org.jetbrains.idea.eclipse.config.EclipseModuleManagerImpl;
import org.jetbrains.idea.eclipse.conversion.EJavadocUtil;
import org.jetbrains.idea.eclipse.conversion.EPathUtil;
import org.jetbrains.idea.eclipse.conversion.EclipseClasspathReader;

public class EclipseClasspathWriter {
    public static final Logger LOG = Logger.getInstance(EclipseClasspathWriter.class);
    private final Map<String, Element> myOldEntries = new THashMap();

    @NotNull
    public Element writeClasspath(@Nullable Element oldRoot, @NotNull ModuleRootModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/idea/eclipse/conversion/EclipseClasspathWriter", "writeClasspath"));
        }
        Element classpathElement = new Element("classpath");
        if (oldRoot != null) {
            for (Element oldChild : oldRoot.getChildren("classpathentry")) {
                String oldKind = oldChild.getAttributeValue("kind");
                String oldPath = oldChild.getAttributeValue("path");
                this.myOldEntries.put(oldKind + EclipseClasspathWriter.getJREKey(oldPath), oldChild);
            }
        }
        for (OrderEntry orderEntry : model.getOrderEntries()) {
            this.createClasspathEntry(orderEntry, classpathElement, model);
        }
        String outputPath = "bin";
        String compilerOutputUrl = ((CompilerModuleExtension)model.getModuleExtension(CompilerModuleExtension.class)).getCompilerOutputUrl();
        EclipseModuleManagerImpl eclipseModuleManager = EclipseModuleManagerImpl.getInstance(model.getModule());
        String linkedPath = eclipseModuleManager.getEclipseLinkedVarPath(compilerOutputUrl);
        if (linkedPath != null) {
            outputPath = linkedPath;
        } else {
            VirtualFile contentRoot = EPathUtil.getContentRoot(model);
            VirtualFile output = ((CompilerModuleExtension)model.getModuleExtension(CompilerModuleExtension.class)).getCompilerOutputPath();
            if (contentRoot != null && output != null && VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)output, (boolean)false)) {
                outputPath = EPathUtil.collapse2EclipsePath(output.getUrl(), model);
            } else if (output == null && compilerOutputUrl != null) {
                outputPath = EPathUtil.collapse2EclipsePath(compilerOutputUrl, model);
            }
        }
        for (String support : eclipseModuleManager.getUsedCons()) {
            this.addOrderEntry("con", support, classpathElement, eclipseModuleManager.getSrcPlace(support));
        }
        EclipseClasspathWriter.setAttributeIfAbsent(this.addOrderEntry("output", outputPath, classpathElement), "path", "bin");
        Element element = classpathElement;
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/eclipse/conversion/EclipseClasspathWriter", "writeClasspath"));
        }
        return element;
    }

    private void createClasspathEntry(@NotNull OrderEntry entry, @NotNull Element classpathRoot, @NotNull ModuleRootModel model) throws ConversionException {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/idea/eclipse/conversion/EclipseClasspathWriter", "createClasspathEntry"));
        }
        if (classpathRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classpathRoot", "org/jetbrains/idea/eclipse/conversion/EclipseClasspathWriter", "createClasspathEntry"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/idea/eclipse/conversion/EclipseClasspathWriter", "createClasspathEntry"));
        }
        EclipseModuleManagerImpl eclipseModuleManager = EclipseModuleManagerImpl.getInstance(entry.getOwnerModule());
        if (entry instanceof ModuleSourceOrderEntry) {
            boolean shouldPlaceSeparately = eclipseModuleManager.isExpectedModuleSourcePlace(Arrays.binarySearch(model.getOrderEntries(), entry));
            for (ContentEntry contentEntry : model.getContentEntries()) {
                VirtualFile contentRoot = contentEntry.getFile();
                for (SourceFolder sourceFolder : contentEntry.getSourceFolders()) {
                    String linkedPath;
                    String srcUrl = sourceFolder.getUrl();
                    String relativePath = EPathUtil.collapse2EclipsePath(srcUrl, model);
                    if (!Comparing.equal((Object)contentRoot, (Object)EPathUtil.getContentRoot(model)) && (linkedPath = EclipseModuleManagerImpl.getInstance(entry.getOwnerModule()).getEclipseLinkedSrcVariablePath(srcUrl)) != null) {
                        relativePath = linkedPath;
                    }
                    int index = eclipseModuleManager.getSrcPlace(srcUrl);
                    this.addOrderEntry("src", relativePath, classpathRoot, shouldPlaceSeparately && index != -1 ? index : -1);
                }
            }
        } else if (entry instanceof ModuleOrderEntry) {
            Element orderEntry = this.addOrderEntry("src", '/' + ((ModuleOrderEntry)entry).getModuleName(), classpathRoot);
            EclipseClasspathWriter.setAttributeIfAbsent(orderEntry, "combineaccessrules", "false");
            EclipseClasspathWriter.setExported(orderEntry, (ExportableOrderEntry)entry);
        } else if (entry instanceof LibraryOrderEntry) {
            LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)entry;
            String libraryName = libraryOrderEntry.getLibraryName();
            if (libraryOrderEntry.isModuleLevel()) {
                String[] files = libraryOrderEntry.getRootUrls(OrderRootType.CLASSES);
                if (files.length > 0) {
                    if (libraryName != null && libraryName.contains("junit") && Comparing.strEqual((String)files[0], (String)EclipseClasspathReader.getJunitClsUrl(libraryName.contains("4")))) {
                        Element orderEntry = this.addOrderEntry("con", "org.eclipse.jdt.junit.JUNIT_CONTAINER/" + libraryName.substring("junit".length()), classpathRoot);
                        EclipseClasspathWriter.setExported(orderEntry, (ExportableOrderEntry)libraryOrderEntry);
                    } else {
                        String srcRelativePath;
                        Element orderEntry;
                        boolean newVarLibrary = false;
                        boolean link = false;
                        String eclipseVariablePath = eclipseModuleManager.getEclipseVariablePath(files[0]);
                        if (eclipseVariablePath == null) {
                            eclipseVariablePath = eclipseModuleManager.getEclipseLinkedVarPath(files[0]);
                            boolean bl = link = eclipseVariablePath != null;
                        }
                        if (eclipseVariablePath == null && !eclipseModuleManager.isEclipseLibUrl(files[0])) {
                            newVarLibrary = true;
                            eclipseVariablePath = EPathUtil.collapse2EclipseVariabledPath(libraryOrderEntry, OrderRootType.CLASSES);
                        }
                        if (eclipseVariablePath != null) {
                            orderEntry = this.addOrderEntry(link ? "lib" : "var", eclipseVariablePath, classpathRoot);
                        } else {
                            LOG.assertTrue(!StringUtil.isEmptyOrSpaces((String)files[0]), (Object)("Library: " + libraryName));
                            orderEntry = this.addOrderEntry("lib", EPathUtil.collapse2EclipsePath(files[0], model), classpathRoot);
                        }
                        String eclipseSrcVariablePath = null;
                        boolean addSrcRoots = true;
                        String[] srcFiles = libraryOrderEntry.getRootUrls(OrderRootType.SOURCES);
                        if (srcFiles.length == 0) {
                            srcRelativePath = null;
                        } else {
                            String srcFile = srcFiles[0];
                            srcRelativePath = EPathUtil.collapse2EclipsePath(srcFile, model);
                            if (eclipseVariablePath != null) {
                                eclipseSrcVariablePath = eclipseModuleManager.getEclipseSrcVariablePath(srcFile);
                                if (eclipseSrcVariablePath == null) {
                                    eclipseSrcVariablePath = eclipseModuleManager.getEclipseLinkedSrcVariablePath(srcFile);
                                }
                                if (eclipseSrcVariablePath == null) {
                                    eclipseSrcVariablePath = EPathUtil.collapse2EclipseVariabledPath(libraryOrderEntry, OrderRootType.SOURCES);
                                    if (eclipseSrcVariablePath != null) {
                                        eclipseSrcVariablePath = "/" + eclipseSrcVariablePath;
                                    } else if (newVarLibrary) {
                                        orderEntry.detach();
                                        orderEntry = this.addOrderEntry("lib", EPathUtil.collapse2EclipsePath(files[0], model), classpathRoot);
                                    } else {
                                        LOG.info("Added root " + srcRelativePath + " (in existing var library) can't be replaced with any variable; src roots placed in .eml only");
                                        addSrcRoots = false;
                                    }
                                }
                            }
                        }
                        EclipseClasspathWriter.setOrRemoveAttribute(orderEntry, "sourcepath", addSrcRoots ? (eclipseSrcVariablePath != null ? eclipseSrcVariablePath : srcRelativePath) : null);
                        EJavadocUtil.setupJavadocAttributes(orderEntry, libraryOrderEntry, model);
                        EclipseClasspathWriter.setExported(orderEntry, (ExportableOrderEntry)libraryOrderEntry);
                    }
                }
            } else {
                Element orderEntry = eclipseModuleManager.getUnknownCons().contains(libraryName) ? this.addOrderEntry("con", libraryName, classpathRoot) : (Comparing.strEqual((String)libraryName, (String)"ECLIPSE") ? this.addOrderEntry("con", "org.eclipse.pde.core.requiredPlugins", classpathRoot) : this.addOrderEntry("con", "org.eclipse.jdt.USER_LIBRARY/" + libraryName, classpathRoot));
                EclipseClasspathWriter.setExported(orderEntry, (ExportableOrderEntry)libraryOrderEntry);
            }
        } else if (entry instanceof JdkOrderEntry) {
            if (entry instanceof InheritedJdkOrderEntry) {
                if (!EclipseModuleManagerImpl.getInstance(entry.getOwnerModule()).isForceConfigureJDK()) {
                    this.addOrderEntry("con", "org.eclipse.jdt.launching.JRE_CONTAINER", classpathRoot);
                }
            } else {
                String jdkLink;
                Sdk jdk = ((JdkOrderEntry)entry).getJdk();
                if (jdk == null) {
                    jdkLink = "org.eclipse.jdt.launching.JRE_CONTAINER";
                } else {
                    jdkLink = "org.eclipse.jdt.launching.JRE_CONTAINER";
                    if (jdk.getSdkType() instanceof JavaSdkType) {
                        jdkLink = jdkLink + "/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType";
                    }
                    jdkLink = jdkLink + '/' + jdk.getName();
                }
                this.addOrderEntry("con", jdkLink, classpathRoot);
            }
        } else {
            throw new ConversionException("Unknown EclipseProjectModel.ClasspathEntry: " + entry.getClass());
        }
    }

    private Element addOrderEntry(String kind, String path, Element classpathRoot) {
        return this.addOrderEntry(kind, path, classpathRoot, -1);
    }

    private Element addOrderEntry(@NotNull String kind, String path, Element classpathRoot, int index) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/idea/eclipse/conversion/EclipseClasspathWriter", "addOrderEntry"));
        }
        Element element = this.myOldEntries.get(kind + EclipseClasspathWriter.getJREKey(path));
        if (element != null) {
            Element clonedElement = element.clone();
            if (index == -1 || index >= classpathRoot.getContentSize()) {
                classpathRoot.addContent(clonedElement);
            } else {
                classpathRoot.addContent(index, (Content)clonedElement);
            }
            return clonedElement;
        }
        Element orderEntry = new Element("classpathentry");
        orderEntry.setAttribute("kind", kind);
        if (path != null) {
            orderEntry.setAttribute("path", path);
        }
        if (index == -1 || index >= classpathRoot.getContentSize()) {
            classpathRoot.addContent(orderEntry);
        } else {
            classpathRoot.addContent(index, (Content)orderEntry);
        }
        return orderEntry;
    }

    private static String getJREKey(String path) {
        return path.startsWith("org.eclipse.jdt.launching.JRE_CONTAINER") ? "org.eclipse.jdt.launching.JRE_CONTAINER" : path;
    }

    private static void setExported(Element orderEntry, ExportableOrderEntry dependency) {
        EclipseClasspathWriter.setOrRemoveAttribute(orderEntry, "exported", dependency.isExported() ? "true" : null);
    }

    private static void setOrRemoveAttribute(@NotNull Element element, @NotNull String name, @Nullable String value) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/eclipse/conversion/EclipseClasspathWriter", "setOrRemoveAttribute"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/idea/eclipse/conversion/EclipseClasspathWriter", "setOrRemoveAttribute"));
        }
        if (value == null) {
            element.removeAttribute(name);
        } else {
            element.setAttribute(name, value);
        }
    }

    private static void setAttributeIfAbsent(@NotNull Element element, String name, String value) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/eclipse/conversion/EclipseClasspathWriter", "setAttributeIfAbsent"));
        }
        if (element.getAttribute(name) == null) {
            element.setAttribute(name, value);
        }
    }
}

