/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.UIBundle;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileChooserDescriptor
implements Cloneable {
    private final boolean myChooseFiles;
    private final boolean myChooseFolders;
    private final boolean myChooseJars;
    private final boolean myChooseJarsAsFiles;
    private final boolean myChooseJarContents;
    private final boolean myChooseMultiple;
    private String myTitle;
    private String myDescription;
    private boolean myHideIgnored;
    private final List<VirtualFile> myRoots;
    private boolean myShowFileSystemRoots;
    private boolean myTreeRootVisible;
    private boolean myShowHiddenFiles;
    private Condition<VirtualFile> myFileFilter;
    private final Map<String, Object> myUserData;

    public FileChooserDescriptor(boolean chooseFiles, boolean chooseFolders, boolean chooseJars, boolean chooseJarsAsFiles, boolean chooseJarContents, boolean chooseMultiple) {
        this.myTitle = UIBundle.message((String)"file.chooser.default.title", (Object[])new Object[0]);
        this.myHideIgnored = true;
        this.myRoots = new ArrayList<VirtualFile>();
        this.myShowFileSystemRoots = true;
        this.myTreeRootVisible = false;
        this.myShowHiddenFiles = false;
        this.myFileFilter = null;
        this.myUserData = new HashMap<String, Object>();
        this.myChooseFiles = chooseFiles;
        this.myChooseFolders = chooseFolders;
        this.myChooseJars = chooseJars;
        this.myChooseJarsAsFiles = chooseJarsAsFiles;
        this.myChooseJarContents = chooseJarContents;
        this.myChooseMultiple = chooseMultiple;
    }

    public FileChooserDescriptor(@NotNull FileChooserDescriptor d) {
        if (d == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d", "com/intellij/openapi/fileChooser/FileChooserDescriptor", "<init>"));
        }
        this(d.isChooseFiles(), d.isChooseFolders(), d.isChooseJars(), d.isChooseJarsAsFiles(), d.isChooseJarContents(), d.isChooseMultiple());
        this.withTitle(d.getTitle());
        this.withDescription(d.getDescription());
        this.withHideIgnored(d.isHideIgnored());
        this.withRoots(d.getRoots());
        this.withShowFileSystemRoots(d.isShowFileSystemRoots());
        this.withTreeRootVisible(d.isTreeRootVisible());
        this.withShowHiddenFiles(d.isShowHiddenFiles());
    }

    public boolean isChooseFiles() {
        return this.myChooseFiles;
    }

    public boolean isChooseFolders() {
        return this.myChooseFolders;
    }

    public boolean isChooseJars() {
        return this.myChooseJars;
    }

    public boolean isChooseJarsAsFiles() {
        return this.myChooseJarsAsFiles;
    }

    public boolean isChooseJarContents() {
        return this.myChooseJarContents;
    }

    public boolean isChooseMultiple() {
        return this.myChooseMultiple;
    }

    public boolean getChooseMultiple() {
        return this.isChooseMultiple();
    }

    public String getTitle() {
        return this.myTitle;
    }

    public void setTitle(@Nls(capitalization=Nls.Capitalization.Title) String title) {
        this.withTitle(title);
    }

    public FileChooserDescriptor withTitle(@Nls(capitalization=Nls.Capitalization.Title) String title) {
        this.myTitle = title;
        return this;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(String description) {
        this.withDescription(description);
    }

    public FileChooserDescriptor withDescription(String description) {
        this.myDescription = description;
        return this;
    }

    public boolean isHideIgnored() {
        return this.myHideIgnored;
    }

    public void setHideIgnored(boolean hideIgnored) {
        this.withHideIgnored(hideIgnored);
    }

    public FileChooserDescriptor withHideIgnored(boolean hideIgnored) {
        this.myHideIgnored = hideIgnored;
        return this;
    }

    public List<VirtualFile> getRoots() {
        return Collections.unmodifiableList(this.myRoots);
    }

    public void setRoots(VirtualFile ... roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/openapi/fileChooser/FileChooserDescriptor", "setRoots"));
        }
        this.withRoots(roots);
    }

    public void setRoots(@NotNull List<VirtualFile> roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/openapi/fileChooser/FileChooserDescriptor", "setRoots"));
        }
        this.withRoots(roots);
    }

    public FileChooserDescriptor withRoots(VirtualFile ... roots) {
        return this.withRoots(Arrays.asList(roots));
    }

    public FileChooserDescriptor withRoots(@NotNull List<VirtualFile> roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/openapi/fileChooser/FileChooserDescriptor", "withRoots"));
        }
        this.myRoots.clear();
        this.myRoots.addAll(roots);
        return this;
    }

    public boolean isShowFileSystemRoots() {
        return this.myShowFileSystemRoots;
    }

    public void setShowFileSystemRoots(boolean showFileSystemRoots) {
        this.withShowFileSystemRoots(showFileSystemRoots);
    }

    public FileChooserDescriptor withShowFileSystemRoots(boolean showFileSystemRoots) {
        this.myShowFileSystemRoots = showFileSystemRoots;
        return this;
    }

    public boolean isTreeRootVisible() {
        return this.myTreeRootVisible;
    }

    public FileChooserDescriptor withTreeRootVisible(boolean isTreeRootVisible) {
        this.myTreeRootVisible = isTreeRootVisible;
        return this;
    }

    public FileChooserDescriptor setIsTreeRootVisible(boolean treeRootVisible) {
        return this.withTreeRootVisible(treeRootVisible);
    }

    public boolean isShowHiddenFiles() {
        return this.myShowHiddenFiles;
    }

    public FileChooserDescriptor withShowHiddenFiles(boolean showHiddenFiles) {
        this.myShowHiddenFiles = showHiddenFiles;
        return this;
    }

    public FileChooserDescriptor withFileFilter(@Nullable Condition<VirtualFile> filter) {
        this.myFileFilter = filter;
        return this;
    }

    public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
        if (file.is(VFileProperty.SYMLINK) && file.getCanonicalPath() == null) {
            return false;
        }
        if (!file.isDirectory()) {
            if (FileElement.isArchive(file) ? !this.myChooseJars && !this.myChooseJarContents : !this.myChooseFiles) {
                return false;
            }
            if (this.myFileFilter != null && !this.myFileFilter.value((Object)file)) {
                return false;
            }
        }
        if (this.isHideIgnored() && FileTypeManager.getInstance().isFileIgnored(file)) {
            return false;
        }
        return showHiddenFiles || !FileElement.isFileHidden(file);
    }

    public boolean isFileSelectable(VirtualFile file) {
        if (file == null) {
            return false;
        }
        if (file.is(VFileProperty.SYMLINK) && file.getCanonicalPath() == null) {
            return false;
        }
        if (file.isDirectory() && this.myChooseFolders) {
            return true;
        }
        if (this.acceptAsJarFile(file)) {
            return true;
        }
        if (this.acceptAsGeneralFile(file)) {
            return true;
        }
        return this.myFileFilter != null && !file.isDirectory() && this.myFileFilter.value((Object)file);
    }

    public Icon getIcon(VirtualFile file) {
        if (file.isDirectory()) {
            return FileChooserDescriptor.dressIcon(file, PlatformIcons.DIRECTORY_CLOSED_ICON);
        }
        return IconUtil.getIcon(file, 2, null);
    }

    protected static Icon dressIcon(VirtualFile file, Icon baseIcon) {
        return file.isValid() && file.is(VFileProperty.SYMLINK) ? new LayeredIcon(baseIcon, PlatformIcons.SYMLINK_ICON) : baseIcon;
    }

    public String getName(VirtualFile file) {
        return file.getPath();
    }

    @Nullable
    public String getComment(VirtualFile file) {
        return null;
    }

    public void validateSelectedFiles(VirtualFile[] files) throws Exception {
    }

    private boolean acceptAsGeneralFile(VirtualFile file) {
        if (FileElement.isArchive(file)) {
            return false;
        }
        return !file.isDirectory() && this.myChooseFiles;
    }

    private boolean acceptAsJarFile(VirtualFile file) {
        return this.myChooseJars && FileElement.isArchive(file);
    }

    @Nullable
    public final VirtualFile getFileToSelect(VirtualFile file) {
        boolean isJar;
        if (file.isDirectory() && (this.myChooseFolders || this.isFileSelectable(file))) {
            return file;
        }
        boolean bl = isJar = file.getFileType() == FileTypes.ARCHIVE;
        if (!isJar) {
            return this.acceptAsGeneralFile(file) ? file : null;
        }
        if (this.myChooseJarsAsFiles) {
            return file;
        }
        if (!this.acceptAsJarFile(file)) {
            return null;
        }
        String path = file.getPath();
        return JarFileSystem.getInstance().findFileByPath(path + "!/");
    }

    public final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public Object getUserData(String dataId) {
        return this.myUserData.get(dataId);
    }

    @Nullable
    public <T> T getUserData(@NotNull DataKey<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/fileChooser/FileChooserDescriptor", "getUserData"));
        }
        Object t = this.myUserData.get(key.getName());
        return (T)t;
    }

    public <T> void putUserData(@NotNull DataKey<T> key, @Nullable T data) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/fileChooser/FileChooserDescriptor", "putUserData"));
        }
        this.myUserData.put(key.getName(), data);
    }

    public String toString() {
        return "FileChooserDescriptor [" + this.myTitle + "]";
    }
}

