/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class LearningProxy<T, E extends Throwable> {
    private static final Map<String, Object> ourDefaultValues = new HashMap<String, Object>();
    private final Set<MethodDescriptor> myTrackedMethods = new HashSet<MethodDescriptor>();
    private final InvocationHandler myLearn = new InvocationHandler(){

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            LearningProxy.this.myTrackedMethods.add(new MethodDescriptor(method));
            Class<?> returnType = method.getReturnType();
            if (returnType.isPrimitive()) {
                return ourDefaultValues.get(returnType.getName());
            }
            return null;
        }
    };

    protected abstract void onBefore() throws E;

    protected abstract void onAfter() throws E;

    public <T> T create(Class<T> clazz, final T t) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new InvocationHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                MethodDescriptor current = new MethodDescriptor(method);
                if (LearningProxy.this.myTrackedMethods.contains(current)) {
                    try {
                        LearningProxy.this.onBefore();
                        method.setAccessible(true);
                        Object object = method.invoke(t, args);
                        return object;
                    }
                    finally {
                        LearningProxy.this.onAfter();
                    }
                }
                return method.invoke(t, args);
            }
        });
    }

    public <T> T learn(Class<T> clazz) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, this.myLearn);
    }

    static {
        ourDefaultValues.put("byte", new Byte(0));
        ourDefaultValues.put("char", new Character('m'));
        ourDefaultValues.put("double", new Double(1.0));
        ourDefaultValues.put("float", new Float(1.0f));
        ourDefaultValues.put("int", new Integer(0));
        ourDefaultValues.put("long", new Long(0L));
        ourDefaultValues.put("short", new Short(0));
        ourDefaultValues.put("boolean", Boolean.FALSE);
        ourDefaultValues.put("void", null);
    }

    private static class MethodDescriptor {
        @NotNull
        private final String myMethodName;
        @NotNull
        private final List<String> myParameters;

        private MethodDescriptor(Method method) {
            this.myMethodName = method.getName();
            Class<?>[] types = method.getParameterTypes();
            this.myParameters = new ArrayList<String>(types.length);
            for (Class<?> type : types) {
                this.myParameters.add(type.getName());
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodDescriptor that = (MethodDescriptor)o;
            if (!this.myMethodName.equals(that.myMethodName)) {
                return false;
            }
            return ((Object)this.myParameters).equals(that.myParameters);
        }

        public int hashCode() {
            int result = this.myMethodName.hashCode();
            result = 31 * result + ((Object)this.myParameters).hashCode();
            return result;
        }
    }
}

